VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.MDIForm mdiMain 
   AutoShowChildren=   0   'False
   BackColor       =   &H8000000C&
   Caption         =   "AD9956 Evaluation Software"
   ClientHeight    =   7095
   ClientLeft      =   60
   ClientTop       =   630
   ClientWidth     =   10485
   Icon            =   "mdiMain.frx":0000
   LinkTopic       =   "MDIForm1"
   WindowState     =   2  'Maximized
   Begin MSComDlg.CommonDialog cdgFileOpenSave 
      Left            =   1200
      Top             =   720
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Timer tmrPollEvalBd 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   120
      Top             =   720
   End
   Begin MSComctlLib.Toolbar tlbMainToolBar 
      Align           =   1  'Align Top
      Height          =   570
      Left            =   0
      TabIndex        =   1
      Top             =   0
      Width           =   10485
      _ExtentX        =   18494
      _ExtentY        =   1005
      ButtonWidth     =   1640
      ButtonHeight    =   953
      Wrappable       =   0   'False
      Appearance      =   1
      Style           =   1
      ImageList       =   "imlToolBarImages"
      _Version        =   393216
      BeginProperty Buttons {66833FE8-8583-11D1-B16A-00C0F0283628} 
         NumButtons      =   8
         BeginProperty Button1 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Caption         =   "Load Setup"
            Key             =   "Load"
            Description     =   "Loads a setup file."
            Object.ToolTipText     =   "Loads a setup file."
            ImageIndex      =   1
         EndProperty
         BeginProperty Button2 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Caption         =   "Save Setup"
            Key             =   "Save"
            Description     =   "Save current configuration to a setup file."
            Object.ToolTipText     =   "Saves the current configuration to a setup file."
            ImageIndex      =   2
         EndProperty
         BeginProperty Button3 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Caption         =   "Sep1"
            Key             =   "Sep1"
            Style           =   3
         EndProperty
         BeginProperty Button4 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Caption         =   "Control"
            Key             =   "Control"
            Description     =   "Shows the control window."
            Object.ToolTipText     =   "Shows the control window."
            ImageIndex      =   3
         EndProperty
         BeginProperty Button5 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Caption         =   "Profile"
            Key             =   "Profile"
            Description     =   "Shows the Profile Window."
            Object.ToolTipText     =   "Shows the Profile Window"
            ImageIndex      =   4
         EndProperty
         BeginProperty Button6 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Caption         =   "Lin Sweep"
            Key             =   "Linear Sweep"
            Description     =   "Shows the Linear Sweep Setup Window."
            Object.ToolTipText     =   "Shows the Linear Sweep Setup Window."
            ImageIndex      =   5
         EndProperty
         BeginProperty Button7 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Caption         =   "Sep2"
            Key             =   "Sep2"
            Style           =   3
         EndProperty
         BeginProperty Button8 {66833FEA-8583-11D1-B16A-00C0F0283628} 
            Caption         =   "Help"
            Key             =   "Help"
            Object.ToolTipText     =   "Displays the help."
            ImageIndex      =   7
         EndProperty
      EndProperty
   End
   Begin MSComctlLib.ImageList imlToolBarImages 
      Left            =   600
      Top             =   720
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   393216
      BeginProperty Images {2C247F25-8591-11D1-B16A-00C0F0283628} 
         NumListImages   =   7
         BeginProperty ListImage1 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":0442
            Key             =   "Open"
         EndProperty
         BeginProperty ListImage2 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":0554
            Key             =   "Save"
         EndProperty
         BeginProperty ListImage3 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":0666
            Key             =   "Control"
         EndProperty
         BeginProperty ListImage4 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":0778
            Key             =   "Profile"
         EndProperty
         BeginProperty ListImage5 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":08D2
            Key             =   "LinearSweep"
         EndProperty
         BeginProperty ListImage6 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":0A2C
            Key             =   "Window"
         EndProperty
         BeginProperty ListImage7 {2C247F27-8591-11D1-B16A-00C0F0283628} 
            Picture         =   "mdiMain.frx":0B3E
            Key             =   "Help"
         EndProperty
      EndProperty
   End
   Begin VB.Timer tmrLoadFlash 
      Interval        =   300
      Left            =   120
      Top             =   1200
   End
   Begin VB.PictureBox pbxStatus 
      Align           =   2  'Align Bottom
      AutoRedraw      =   -1  'True
      BorderStyle     =   0  'None
      Height          =   315
      Left            =   0
      ScaleHeight     =   315
      ScaleWidth      =   10485
      TabIndex        =   0
      Top             =   6780
      Visible         =   0   'False
      Width           =   10485
      Begin VB.Label lblDUTStatus 
         Alignment       =   2  'Center
         Caption         =   "Slave"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   240
         Index           =   1
         Left            =   3600
         TabIndex        =   5
         Top             =   45
         Width           =   735
      End
      Begin VB.Label lblDUTStatus 
         Alignment       =   2  'Center
         Caption         =   "Master"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000008&
         Height          =   240
         Index           =   0
         Left            =   2760
         TabIndex        =   4
         Top             =   45
         Width           =   735
      End
      Begin VB.Image imgResizeHandle 
         Height          =   240
         Left            =   10080
         MousePointer    =   8  'Size NW SE
         Picture         =   "mdiMain.frx":0C5E
         Top             =   0
         Width           =   240
      End
      Begin VB.Label lblPCIOStatusDisplay 
         Alignment       =   2  'Center
         BackColor       =   &H000000FF&
         Caption         =   " Not Connected! "
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H0000FFFF&
         Height          =   240
         Left            =   1080
         TabIndex        =   3
         Top             =   45
         Visible         =   0   'False
         Width           =   1545
      End
      Begin VB.Label lblPCIOStatus 
         AutoSize        =   -1  'True
         Caption         =   "USB Status:"
         Height          =   195
         Left            =   120
         TabIndex        =   2
         Top             =   60
         Visible         =   0   'False
         Width           =   870
      End
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileLoadSetup 
         Caption         =   "Load Setup..."
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuFileSaveSetup 
         Caption         =   "Save Setup..."
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuFileDumpToSetupFile 
         Caption         =   "Dump to Setup File..."
      End
      Begin VB.Menu mnuFileSep0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
         Shortcut        =   ^Q
      End
   End
   Begin VB.Menu mnuPCIO 
      Caption         =   "P&C I/O"
      Begin VB.Menu mnuPCIOFindEvalBd 
         Caption         =   "Find Evaluation Board..."
         Shortcut        =   ^F
      End
      Begin VB.Menu mnuPCIOSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuPCIOSelectLPTPort 
         Caption         =   "Select LPT Port..."
      End
   End
   Begin VB.Menu mnuTools 
      Caption         =   "&Tools"
      Begin VB.Menu mnuToolsOptions 
         Caption         =   "Options..."
         Shortcut        =   ^T
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "&View"
      Begin VB.Menu mnuViewControlWindow 
         Caption         =   "Control Window"
      End
      Begin VB.Menu mnuViewCpnClkDrvWindow 
         Caption         =   "Clock Driver Control , Phase - Frequency Detector && Charge Pump Window"
      End
      Begin VB.Menu mnuViewDUTSignals 
         Caption         =   "DUT Signals Toolbox"
      End
      Begin VB.Menu mnuViewIOInterface 
         Caption         =   "IO Interface Toolbox"
      End
      Begin VB.Menu mnuViewProfilewindow 
         Caption         =   "Profile Window"
      End
      Begin VB.Menu mnuViewLinearSweep 
         Caption         =   "Linear Sweep Setup"
      End
      Begin VB.Menu mnuViewSep0 
         Caption         =   "-"
      End
      Begin VB.Menu mnuViewTestRegWindow 
         Caption         =   "Test Register Window"
      End
      Begin VB.Menu mnuViewDebugWindow 
         Caption         =   "Debug Window"
      End
      Begin VB.Menu mnuViewDDEServer 
         Caption         =   "DDE Server"
      End
      Begin VB.Menu mnuViewSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuView800x600 
         Caption         =   "800 x 600"
      End
      Begin VB.Menu mnuView640x480 
         Caption         =   "640 x 480"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpContents 
         Caption         =   "Contents..."
      End
      Begin VB.Menu mnuHelpSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "About"
      End
   End
   Begin VB.Menu mnuToolBarPopup 
      Caption         =   "ToolBarPopup"
      Visible         =   0   'False
      Begin VB.Menu mnuToolBarPopupButtonsOnly 
         Caption         =   "Button Text Off"
      End
   End
End
Attribute VB_Name = "mdiMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Public WithEvents AD9956BD As clsAD9956EvBd
Attribute AD9956BD.VB_VarHelpID = -1
Private ToolBarMenuText As Collection
Private FlashCntr As Integer
Private mDeviceConnected As Boolean
Private ttbBubbleNotify As clsTTBalloon
Private LeftX As Single
Private TopY As Single
Private UsingResizeIcon As Boolean

Private Sub AD9956BD_AfterRegUpdate(ByVal DUT As selDUTs_9956, ByVal RegMap As rmv9956_RegMap, ByVal RegMapLoc As RMA9956, ByVal Value As String)
'    Dim sCurVal As String
'
'    If RegMap = rm9956_NewRegMapVals Then
'        sCurVal = AD9956BD.GetRegMapValue(DUT, rm9956_CurRegMapVals, RegMapLoc)
'
'        'Check to see if anything changed
'        Select Case RegMapLoc
'            Case 0, 1:
'            Case 2:
'            Case 2, 3, 4, 5:
'            Case 6 To &HD:
'        End Select
'
'    End If
End Sub

Private Sub AD9956BD_AfterReset(ByVal DUT As selDUTs_9956)
'    Debug.Print "AfterReset"
    If IsLoaded("frmDebug") Then
        frmDebug.ResetForm
    End If
    frmControl.RefreshControls
    frmCP_ClkDrv_Ctrl.RefreshControls
    frmProfiles.RefreshControls
    frmLinSweepSetup.RefreshControls
    frmIOInterface.RefreshControls
    If IsLoaded("frmTestRegister") Then
        frmTestRegister.Refresh
    End If
End Sub

Private Sub AD9956BD_BeforeReset(ByVal DUT As selDUTs_9956)
'    Debug.Print "BeforeReset"
End Sub


Private Sub imgResizeHandle_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
  If Button = vbLeftButton Then
    LeftX = X
    TopY = Y
    UsingResizeIcon = True
  End If
End Sub

Private Sub imgResizeHandle_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
  On Error Resume Next
  If Button = vbLeftButton Then
    imgResizeHandle.Left = imgResizeHandle.Left + X - LeftX
    imgResizeHandle.TOp = imgResizeHandle.TOp + Y - TopY
    Me.Width = imgResizeHandle.Left + imgResizeHandle.Width + (imgResizeHandle.Width / 2)
    Me.Height = imgResizeHandle.Container.TOp + imgResizeHandle.TOp + imgResizeHandle.Height + (imgResizeHandle.Height / 2) + 570 'tlbMainToolBar.Height
    imgResizeHandle.Refresh
  End If
End Sub

Private Sub imgResizeHandle_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton And UsingResizeIcon Then
        UsingResizeIcon = False
    End If
End Sub

Private Sub lbIOStatus_Click()

End Sub

Private Sub MDIForm_Load()
    'Setup the Eval Board reference
    Set AD9956BD = New clsAD9956EvBd
    
    'Create a new balloon form and set it up
    Set ttbBubbleNotify = New clsTTBalloon 'Create a new bubble notify form
    Set ttbBubbleNotify.Control = lblPCIOStatusDisplay
    ttbBubbleNotify.Title = "Evaluation Board Disconnected!"
    ttbBubbleNotify.ToolTipText = "The AD9956 Evaluation Board that you were using is no longer connected to the computer!" & vbCrLf
    ttbBubbleNotify.Icon = ttbImportantWXP
    
    'Setup the title bar
    mdiMain.Caption = AppTitle
    frmSplash.Show
    
    Set ToolBarMenuText = New Collection
        
    For cntr = 1 To tlbMainToolBar.Buttons.Count
        'Add the text to the collection
        ToolBarMenuText.Add tlbMainToolBar.Buttons(cntr).Caption, tlbMainToolBar.Buttons(cntr).Key
    Next cntr
    
    pbxStatus_Paint
End Sub

Private Sub MDIForm_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    ExitGracefully
End Sub


Private Sub MDIForm_Resize()
    Dim sX As Single
    Dim sY As Single
    'Update the status bar
    'pbxStatus_Paint
    Select Case mdiMain.WindowState
        Case vbNormal:
            If imgResizeHandle.Visible = False Then
                imgResizeHandle.Visible = True
            End If
            'Position the resize handle to the right hand corner
            If UsingResizeIcon = False Then
                sX = mdiMain.Width - imgResizeHandle.Width - Screen.TwipsPerPixelX * 7
                sY = imgResizeHandle.Container.Height - imgResizeHandle.Height + Screen.TwipsPerPixelY * 1
                imgResizeHandle.Move sX, sY
            End If
        Case vbMaximized:
            imgResizeHandle.Visible = False
        Case vbMinimized:
    End Select
'    If mdiMain.WindowState = vbNormal Then
'        If IsLoaded("frmBubbleNotify") Then
'            'Calculate the x position for the bubble help box
'            BubbleHelpX = mdiMain.Left + lblPCIOStatusDisplay.Left + (lblPCIOStatusDisplay.Width / 2)
'            BubbleHelpY = mdiMain.Top + mdiMain.Height - pbxStatus.Height + lblPCIOStatusDisplay.Top
'            'Show the bubble form
'            frmBubbleNotify.MoveBubble BubbleHelpX, BubbleHelpY
'        End If
'    End If
End Sub

Private Sub mnuFileDumpToSetupFile_Click()
    'Setup an error handler
    On Error GoTo ErrorHandler
    
    'Setup the common dialog for opening files
    cdgFileOpenSave.flags = cdlOFNHideReadOnly + cdlOFNLongNames + cdlOFNNoChangeDir
    cdgFileOpenSave.DialogTitle = "Dump Current Settings to a Setup File"
    cdgFileOpenSave.CancelError = True
    cdgFileOpenSave.Filter = "Setup Files (*.stp)|*.stp|Text (*.txt)|*.txt"
    cdgFileOpenSave.FilterIndex = 0
    cdgFileOpenSave.InitDir = App.path
    
    'Show the open dialog
    cdgFileOpenSave.ShowSave
    
    'Write the current setup to a file
    SaveSetup cdgFileOpenSave.Filename, True
    
    'Exit the subroutine before the errorhandler
    Exit Sub

'Define an error handler
ErrorHandler:
    'Check for the cancel button hit error
    If Err.Number = cdlCancel Then
        'Exit the subroutine if the cancel button was hit
        Exit Sub
    End If
End Sub

Private Sub mnuFileExit_Click()
    ExitGracefully
End Sub

Private Sub mnuFileLoadSetup_Click()
    'Setup an error handler
    On Error GoTo ErrorHandler
    
    'Setup the common dialog for opening files
    cdgFileOpenSave.flags = cdlOFNFileMustExist + cdlOFNHideReadOnly + cdlOFNLongNames + cdlOFNNoChangeDir
    cdgFileOpenSave.DialogTitle = "Load Setup File"
    cdgFileOpenSave.CancelError = True
    cdgFileOpenSave.Filter = "Setup Files (*.stp)|*.stp|Text (*.txt)|*.txt"
    cdgFileOpenSave.FilterIndex = 0
    cdgFileOpenSave.InitDir = App.path

    'Show the open dialog
    cdgFileOpenSave.ShowOpen
    
    'Load the current setup file in to the program and DUT
    LoadSetup cdgFileOpenSave.Filename
    
    'Exit the subroutine before the errorhandler
    Exit Sub

'Define an error handler
ErrorHandler:
    'Check for the cancel button hit error
    If Err.Number = cdlCancel Then
        'Exit the subroutine if the cancel button was hit
        Exit Sub
    End If
End Sub

Private Sub mnuFileSaveSetup_Click()
    'Setup an error handler
    On Error GoTo ErrorHandler
    
    'Setup the common dialog for opening files
    cdgFileOpenSave.flags = cdlOFNHideReadOnly + cdlOFNLongNames + cdlOFNNoChangeDir
    cdgFileOpenSave.DialogTitle = "Save Setup File"
    cdgFileOpenSave.CancelError = True
    cdgFileOpenSave.Filter = "Setup Files (*.stp)|*.stp|Text (*.txt)|*.txt"
    cdgFileOpenSave.FilterIndex = 0
    cdgFileOpenSave.InitDir = App.path
    
    'Show the open dialog
    cdgFileOpenSave.ShowSave
    
    'Write the current setup to a file
    SaveSetup cdgFileOpenSave.Filename
    
    'Exit the subroutine before the errorhandler
    Exit Sub

'Define an error handler
ErrorHandler:
    'Check for the cancel button hit error
    If Err.Number = cdlCancel Then
        'Exit the subroutine if the cancel button was hit
        Exit Sub
    End If
End Sub

Private Sub mnuHelpAbout_Click()
    frmAbout.Show
End Sub


Private Sub mnuHelpContents_Click()
    'Setup the help file path
    If FileExists(App.path & "\" & "AD9956HELP.HLP") Then
        mdiMain.mnuHelpContents.Enabled = True
        cdgFileOpenSave.HelpFile = App.path & "\" & "AD9956HELP.HLP"
        cdgFileOpenSave.HelpContext = 9999
        cdgFileOpenSave.HelpCommand = cdlHelpContext
        cdgFileOpenSave.ShowHelp
    Else
        mdiMain.mnuHelpContents.Enabled = False
    End If
End Sub

Private Sub mnuPCIOFindEvalBd_Click()
    'Detect the evalboard
    DetectEvalBoard
End Sub

Private Sub mnuPCIOSelectLPTPort_Click()
    If EvBd.PCInterface = 0 Then
        frmUSBSelect.ShowDialog "Select USB Device", "Select a USB Evaluation Board to use."
    Else
        frmLPTSelect.LPTSelectDialog "Select a LPT Port", "Select the LPT Port that you want to use.", True
    End If
End Sub

Private Sub mnuView640x480_Click()
    mdiMain.WindowState = vbNormal
    mdiMain.Move 0, 0, 640 * Screen.TwipsPerPixelX, 480 * Screen.TwipsPerPixelY
End Sub

Private Sub mnuView800x600_Click()
    mdiMain.WindowState = vbNormal
    mdiMain.Move 0, 0, 800 * Screen.TwipsPerPixelX, 600 * Screen.TwipsPerPixelY
End Sub

Private Sub mnuViewControlWindow_Click()
    With frmControl
        'Make the window visible
        .Visible = True
        'If minimized then restore the window
        If .WindowState = vbMinimized Then
            .WindowState = vbNormal
        End If
        'Move the window to the foreground
        .ZOrder
    End With
    'Check the menu item
    mnuViewControlWindow.Checked = True
End Sub

Private Sub mnuViewCpnClkDrvWindow_Click()
    With frmCP_ClkDrv_Ctrl
        'Make the window visible
        .Visible = True
        'If minimized then restore the window
        If .WindowState = vbMinimized Then
            .WindowState = vbNormal
        End If
        'Move the window to the foreground
        .ZOrder
    End With
    'Check the menu item
    mnuViewCpnClkDrvWindow.Checked = True
    frmControl.IsUpdating = True
    frmControl.chkCP_Clk_Drv_Ctrl.Value = 1
    frmControl.IsUpdating = False
End Sub

Private Sub mnuViewDDEServer_Click()
    If IsLoaded("frmDDEServ") Then
        With frmDDEServ
            'Make the window visible
            .Visible = True
            'If minimized then restore the window
            If .WindowState = vbMinimized Then
                .WindowState = vbNormal
            End If
            'Move the window to the foreground
            .ZOrder
        End With
    Else
        Load frmDDEServ
        frmDDEServ.Show
    End If
    'Check the menu item
    mnuViewControlWindow.Checked = True
End Sub

Private Sub mnuViewDebugWindow_Click()
    If IsLoaded("frmDebug") = False Then
        Load frmDebug
    End If
        
    With frmDebug
        'Make the window visible
        .Visible = True
        'If minimized then restore the window
        If .WindowState = vbMinimized Then
            .WindowState = vbNormal
        End If
        'Move the window to the foreground
        .ZOrder
    End With
    'Check the menu item
    mnuViewDebugWindow.Checked = True
End Sub

Private Sub mnuViewDUTSignals_Click()
    With frmDUTSignals
        'Make the window visible
        .Visible = True
        'If minimized then restore the window
        If .WindowState = vbMinimized Then
            .WindowState = vbNormal
        End If
        'Move the window to the foreground
        .ZOrder
    End With
    'Check the menu item
    mnuViewDUTSignals.Checked = True
    frmControl.IsUpdating = True
    frmControl.chkDutSignals.Value = 1
    frmControl.IsUpdating = False
End Sub

Private Sub mnuViewIOInterface_Click()
    With frmIOInterface
        'Make the window visible
        .Visible = True
        'If minimized then restore the window
        If .WindowState = vbMinimized Then
            .WindowState = vbNormal
        End If
        'Move the window to the foreground
        .ZOrder
    End With
    'Check the menu item
    mnuViewIOInterface.Checked = True
    frmControl.IsUpdating = True
    frmControl.chkIOInterfaceWnd.Value = 1
    frmControl.IsUpdating = False
End Sub

Private Sub mnuViewLinearSweep_Click()
    With frmLinSweepSetup
        'Make the window visible
        .Visible = True
        'If minimized then restore the window
        If .WindowState = vbMinimized Then
            .WindowState = vbNormal
        End If
        'Move the window to the foreground
        .ZOrder
    End With
    'Check the menu item
    mnuViewLinearSweep.Checked = True
    'Unpress the tool button
    frmProfiles.IsUpdating = True
    frmProfiles.chkLinSwpSetup.Value = 1
    frmProfiles.IsUpdating = False
End Sub

Private Sub mnuViewProfilewindow_Click()
    With frmProfiles
        'Make the window visible
        .Visible = True
        'If minimized then restore the window
        If .WindowState = vbMinimized Then
            .WindowState = vbNormal
        End If
        'Move the window to the foreground
        .ZOrder
    End With
    'Check the menu item
    mnuViewProfilewindow.Checked = True
End Sub

Private Sub mnuToolBarPopupButtonsOnly_Click()
    Dim cntr As Integer
    
    'Show toolbar text
    If mnuToolBarPopupButtonsOnly.Checked Then
        mnuToolBarPopupButtonsOnly.Checked = False
    Else
        mnuToolBarPopupButtonsOnly.Checked = True
    End If
    
    If mnuToolBarPopupButtonsOnly.Checked Then
        'Loop through all toolbar buttons and remove the text
        For cntr = 1 To tlbMainToolBar.Buttons.Count
            'Add the text to the collection
            tlbMainToolBar.Buttons(cntr).Caption = ""
        Next cntr
    Else
        'Loop through all toolbar buttons and remove the text
        For cntr = 1 To tlbMainToolBar.Buttons.Count
            'Add the text to the collection
            tlbMainToolBar.Buttons(cntr).Caption = ToolBarMenuText(cntr)
        Next cntr
    End If
    
End Sub


Private Sub mnuViewTestRegWindow_Click()
    If IsLoaded("frmTestRegister") Then
        With frmTestRegister
            'Make the window visible
            .Visible = True
            'If minimized then restore the window
            If .WindowState = vbMinimized Then
                .WindowState = vbNormal
            End If
            'Move the window to the foreground
            .ZOrder
        End With
    Else
        Load frmTestRegister
        frmTestRegister.Show
    End If
    'Check the menu item
    mnuViewControlWindow.Checked = True

End Sub

Private Sub pbxStatus_Paint()
    vbDrawSimpleBorder lblDUTStatus(0), pbxStatus, 0
    vbDrawSimpleBorder lblDUTStatus(1), pbxStatus, 0
    vbDrawSimpleBorder lblPCIOStatusDisplay, pbxStatus, 0
End Sub

Private Sub tlbMainToolBar_ButtonClick(ByVal Button As MSComctlLib.Button)
    Select Case Button.Index
        Case 1:
            'Simulate using the File\LoadSetup menu
            mnuFileLoadSetup_Click
        Case 2:
            'Simulate using the File\SaveStup menu
            mnuFileSaveSetup_Click
        Case 3:
            'This is a spacer so have fun trying to click on it
            MsgBox "Button3"
        Case 4:
            With frmControl
                'Make the window visible
                .Visible = True
                'If minimized then restore the window
                If .WindowState = vbMinimized Then
                    .WindowState = vbNormal
                End If
                'Move the window to the foreground
                .ZOrder
            End With
            'Check the menu item
            mnuViewControlWindow.Checked = True
        Case 5:
            With frmProfiles
                'Make the window visible
                .Visible = True
                'If minimized then restore the window
                If .WindowState = vbMinimized Then
                    .WindowState = vbNormal
                End If
                'Move the window to the foreground
                .ZOrder
            End With
            'Check the menu item
            mnuViewProfilewindow.Checked = True
        Case 6:
            With frmLinSweepSetup
                'Make the window visible
                .Visible = True
                'If minimized then restore the window
                If .WindowState = vbMinimized Then
                    .WindowState = vbNormal
                End If
                'Move the window to the foreground
                .ZOrder
            End With
            'Check the menu item
            mnuViewLinearSweep.Checked = True
            'Unpress the tool button
            frmProfiles.IsUpdating = True
            frmProfiles.chkLinSwpSetup.Value = 1
            frmProfiles.IsUpdating = False
        Case 8:
            'Show the help
            mnuHelpContents_Click
    End Select
End Sub

Private Sub tlbMainToolBar_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 2 Then
        PopupMenu mnuToolBarPopup
    End If
End Sub

Private Sub tmrLoadFlash_Timer()
    Dim RegCntr As Integer
    Dim DutCntr As Integer
    Dim sTemp0 As String
    Dim sTemp1 As String
    Dim sTemp2 As String
    Dim sTemp3 As String
    Dim sTemp4 As String
    Dim sTemp5 As String
    Dim sTemp6 As String
    Dim sTemp7 As String
    
    
    If FlashCntr = 0 Then
        For DutCntr = 1 To 2
            'Flash On
            For RegCntr = 0 To &HE
                With EvBd
                    sTemp0 = .GetRegMapValue(DutCntr, rm9956_NewRegMapVals, RegCntr)
                    sTemp1 = .GetRegMapValue(DutCntr, rm9956_CurRegMapVals, RegCntr)
                    If sTemp0 <> sTemp1 Then 'If the Registers arent the same then
                        Select Case RegCntr
                            Case 0:
                                'Test the IOInterface window bits
                                If Mid(sTemp0, 17, 2) <> Mid(sTemp1, 17, 2) Then
                                    If IsLoaded("frmIOInterface") Then
                                        frmIOInterface.cmdLoad.BackColor = FlashColorOn
                                    End If
                                End If
                                'Test the Charge Pump & Clock Driver Control Window Bits
                                If Mid(sTemp0, 27, 1) <> Mid(sTemp1, 27, 1) Then
                                    If IsLoaded("frmCP_ClkDrv_Ctrl") Then
                                        frmCP_ClkDrv_Ctrl.cmdLoad.BackColor = FlashColorOn
                                    End If
                                End If
                                'Test the Control Window
                                sTemp4 = Mid(sTemp0, 8, 9) & Mid(sTemp0, 20, 7) & Mid(sTemp0, 28, 5)
                                sTemp5 = Mid(sTemp1, 8, 9) & Mid(sTemp1, 20, 7) & Mid(sTemp1, 28, 5)
                                If sTemp4 <> sTemp5 Then
                                    If IsLoaded("frmControl") Then
                                        frmControl.cmdLoad.BackColor = FlashColorOn
                                    End If
                                End If
                            Case 1:
                                'Test the Charge Pump & Clock Driver Control Window Bits
                                sTemp2 = Mid(sTemp0, 8, 9) & Mid(sTemp0, 20, 4) & Mid(sTemp0, 26, 8) & Right(sTemp0, 6)
                                sTemp3 = Mid(sTemp1, 8, 9) & Mid(sTemp1, 20, 4) & Mid(sTemp1, 26, 8) & Right(sTemp1, 6)
                                If sTemp2 <> sTemp3 Then
                                    If IsLoaded("frmCP_ClkDrv_Ctrl") Then
                                        frmCP_ClkDrv_Ctrl.cmdLoad.BackColor = FlashColorOn
                                    End If
                                End If
                                
                                'Test the Control Window
                                sTemp4 = Mid(sTemp0, 1, 3) & Mid(sTemp0, 7, 1) & Mid(sTemp0, 17, 3) & Mid(sTemp0, 24, 1) & Mid(sTemp0, 33, 2)
                                sTemp5 = Mid(sTemp1, 1, 3) & Mid(sTemp1, 7, 1) & Mid(sTemp1, 17, 3) & Mid(sTemp1, 24, 1) & Mid(sTemp1, 33, 2)
                                If sTemp4 <> sTemp5 Then
                                    If IsLoaded("frmControl") Then
                                        frmControl.cmdLoad.BackColor = FlashColorOn
                                    End If
                                End If
                            Case 2 To 5:
                                If IsLoaded("frmLinSweepSetup") Then
                                    frmLinSweepSetup.cmdLoad.BackColor = FlashColorOn
                                End If
                            Case 6 To &HD
                                If IsLoaded("frmProfiles") Then
                                    frmProfiles.cmdLoad.BackColor = FlashColorOn
                                End If
                            Case &HE
                                If IsLoaded("frmTestRegister") Then
                                    frmTestRegister.cmdLoad.BackColor = FlashColorOn
                                End If
                        End Select
                    End If
                End With
            Next RegCntr
        Next DutCntr
        FlashCntr = 1
    Else
        'Flash Off
        If IsLoaded("frmLinSweepSetup") Then
            frmLinSweepSetup.cmdLoad.BackColor = FlashColorOff
        End If
        If IsLoaded("frmProfiles") Then
            frmProfiles.cmdLoad.BackColor = FlashColorOff
        End If
        If IsLoaded("frmIOInterface") Then
            frmIOInterface.cmdLoad.BackColor = FlashColorOff
        End If
        If IsLoaded("frmCP_ClkDrv_Ctrl") Then
            frmCP_ClkDrv_Ctrl.cmdLoad.BackColor = FlashColorOff
        End If
        If IsLoaded("frmControl") Then
            frmControl.cmdLoad.BackColor = FlashColorOff
        End If
        If IsLoaded("frmTestRegister") Then
            frmTestRegister.cmdLoad.BackColor = FlashColorOff
        End If
        FlashCntr = 0
    End If
    
End Sub

Private Sub tmrPollEvalBd_Timer()
    Dim cntr As Integer
    
    Dim BubbleHelpX As Single
    Dim BubbleHelpY As Single
    
    If EvBd.PCInterface = 0 Then
        If clsEZUSBDev01.IsConnected Then
            'It is connected now update displays only if they haven't been updated
            If mDeviceConnected = False Then
                'Flag that the device was connected
                mDeviceConnected = True
                'This is where you put the code for a "device connected" event
                lblPCIOStatusDisplay.Caption = " Connected "
                lblPCIOStatusDisplay.ForeColor = StatForeColorOk
                lblPCIOStatusDisplay.BackColor = StatBackColorOk
                lblPCIOStatusDisplay.Refresh

                'Update all forms to reflect the change
                Enable_GUI_IO mDeviceConnected
'Hide and unload the bubble help
'                frmBubbleNotify.Hide
'                Unload frmBubbleNotify
                'Play the sound if a soundcard is installed and the sound file is pressent on the system
                If SoundCardInstalled And FileExists(App.path & "\" & "EvbdCnct.WAV") Then
                    sndWAVPlay (App.path & "\" & "EvbdCnct.WAV")
                End If
                'Hide and unload the bubble help
                ttbBubbleNotify.HideballoonForm
            End If
        Else
            'It is not connected now update displays only if they haven't been updated
            If mDeviceConnected = True Then
                'Flag that the device is not connected
                mDeviceConnected = False
                'This is where you put the code for a "device connected" event
                lblPCIOStatusDisplay.Caption = " Not Connected! "
                lblPCIOStatusDisplay.ForeColor = StatForeColorNoOk
                lblPCIOStatusDisplay.BackColor = StatBackColorNoOk
                lblPCIOStatusDisplay.Refresh

                'Update all forms to reflect the change
                Enable_GUI_IO mDeviceConnected

'                'Calculate the x position for the bubble help box
'                BubbleHelpX = mdiMain.Left + lblPCIOStatusDisplay.Left + (lblPCIOStatusDisplay.Width / 2)
'                BubbleHelpY = mdiMain.Top + mdiMain.Height - pbxStatus.Height + lblPCIOStatusDisplay.Top
'                'Show the bubble form
'                frmBubbleNotify.ShowBubbleMessage BubbleHelpX, BubbleHelpY, "Evaluation Board Disconnected!", "The AD9956 Evaluation Board that you were using is no longer connected to the computer!", 3, mdiMain.hWnd
                ttbBubbleNotify.ShowballoonForm
                'Play the sound if a soundcard is installed and the sound file is pressent on the system
                If SoundCardInstalled And FileExists(App.path & "\" & "EvbdDcnct.WAV") Then
                    sndWAVPlay (App.path & "\" & "EvbdDcnct.WAV")
                End If
            End If
        End If
        
        'If the usbselect dialog is visible then update its list
'        If frmUSBSelect.Visible Then
'            frmUSBSelect.RefreshDeviceList
'        End If
        
        If IsLoaded("frmTestRegister") Then
            frmTestRegister.EnableIO mDeviceConnected
        End If
        If IsLoaded("frmDebug") Then
            frmDebug.Enabled = mDeviceConnected
        End If

    End If

End Sub

'Returns a single bit value from the register map
'Errors - Returns -5 if invalid bit num is used
Private Function GetBitValueFromBinStr(ByVal BinStr As String, ByVal BitNum As Integer) As Integer
    Dim BitValue As String
    Dim BinStrLen As Integer
    
    BinStrLen = Len(BinStr)
    
    If Len(BinStr) > BitNum Then
        'Return the bit value
        BitValue = Mid(BinStr, BinStrLen - BitNum, 1)
        
        'Return the value that was retrieved
        If BitValue = "1" Then
            GetRegMapBitValue = abvHigh
        Else
            GetRegMapBitValue = abvLow
        End If
    Else
        GetBitValueFromBinStr = -5
    End If
End Function

