VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmLinSweepSetup 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Linear Sweep Setup"
   ClientHeight    =   3615
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4815
   Icon            =   "frmLinSweepSetup.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   3615
   ScaleWidth      =   4815
   Begin VB.Frame fraLoad 
      BorderStyle     =   0  'None
      Caption         =   "Frame1"
      Height          =   855
      Left            =   2040
      TabIndex        =   1
      Top             =   2520
      Width           =   2535
      Begin VB.CheckBox chkLoadDUT2 
         Caption         =   "Load Slave"
         Height          =   255
         Left            =   0
         TabIndex        =   4
         Top             =   0
         Width           =   1215
      End
      Begin VB.CommandButton cmdLoad 
         Caption         =   "LOAD"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   0
         Style           =   1  'Graphical
         TabIndex        =   3
         Top             =   360
         Width           =   1215
      End
      Begin VB.CommandButton cmdRead 
         Caption         =   "READ"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   1320
         Style           =   1  'Graphical
         TabIndex        =   2
         Top             =   360
         Width           =   1215
      End
   End
   Begin VB.Frame fraDUTSettings 
      BorderStyle     =   0  'None
      Caption         =   "DUT Settings"
      Height          =   1935
      Index           =   1
      Left            =   240
      TabIndex        =   5
      Top             =   480
      Width           =   4335
      Begin VB.Frame fraRisingDeltaFreq 
         Height          =   975
         Index           =   0
         Left            =   0
         TabIndex        =   6
         Top             =   0
         Width           =   4335
         Begin VB.TextBox txtRDFTW 
            Alignment       =   1  'Right Justify
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Index           =   0
            Left            =   1920
            MaxLength       =   15
            TabIndex        =   8
            Tag             =   "0"
            Text            =   "0.000000000"
            ToolTipText     =   "Double click for edit dialog."
            Top             =   240
            Width           =   1815
         End
         Begin VB.TextBox txtRSRR 
            Alignment       =   1  'Right Justify
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Index           =   0
            Left            =   2280
            TabIndex        =   7
            Tag             =   "0"
            Text            =   "0.000"
            Top             =   600
            Width           =   1455
         End
         Begin VB.Label lblRRUnits 
            AutoSize        =   -1  'True
            Caption         =   "s"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   240
            Index           =   2
            Left            =   3960
            TabIndex        =   32
            Top             =   600
            Width           =   105
         End
         Begin VB.Label lblRDF 
            BackStyle       =   0  'Transparent
            Caption         =   "Rising Delta Frequency:"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   12
            Top             =   240
            Width           =   1815
         End
         Begin VB.Label lblOFMhz 
            BackStyle       =   0  'Transparent
            Caption         =   "MHz"
            Height          =   255
            Index           =   0
            Left            =   3840
            TabIndex        =   11
            Top             =   240
            Width           =   375
         End
         Begin VB.Label lblRisingRampRate 
            Caption         =   "Ramp Up Step Interval:"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   10
            Top             =   600
            Width           =   1695
         End
         Begin VB.Label lblRRUnits 
            AutoSize        =   -1  'True
            Caption         =   "m"
            BeginProperty Font 
               Name            =   "Symbol"
               Size            =   9.75
               Charset         =   2
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   240
            Index           =   0
            Left            =   3840
            TabIndex        =   9
            Top             =   600
            Width           =   105
         End
      End
      Begin VB.Frame fraFallingDeltaFrequency 
         Height          =   975
         Index           =   0
         Left            =   0
         TabIndex        =   13
         Top             =   960
         Width           =   4335
         Begin VB.TextBox txtFSRR 
            Alignment       =   1  'Right Justify
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Index           =   0
            Left            =   2280
            TabIndex        =   18
            Tag             =   "0"
            Text            =   "0.000"
            Top             =   600
            Width           =   1455
         End
         Begin VB.TextBox txtFDFTW 
            Alignment       =   1  'Right Justify
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Index           =   0
            Left            =   1920
            MaxLength       =   15
            TabIndex        =   14
            Tag             =   "0"
            Text            =   "0.000000000"
            ToolTipText     =   "Double click for edit dialog."
            Top             =   240
            Width           =   1815
         End
         Begin VB.Label lblRRUnits 
            AutoSize        =   -1  'True
            Caption         =   "s"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   240
            Index           =   4
            Left            =   3960
            TabIndex        =   34
            Top             =   600
            Width           =   105
         End
         Begin VB.Label lblRRUnits 
            AutoSize        =   -1  'True
            Caption         =   "m"
            BeginProperty Font 
               Name            =   "Symbol"
               Size            =   9.75
               Charset         =   2
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   240
            Index           =   3
            Left            =   3840
            TabIndex        =   33
            Top             =   600
            Width           =   105
         End
         Begin VB.Label lblFallingRampRate 
            Caption         =   "Ramp Down Step Interval:"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   17
            Top             =   600
            Width           =   2055
         End
         Begin VB.Label lblFDF 
            BackStyle       =   0  'Transparent
            Caption         =   "Falling Delta Frequency:"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   16
            Top             =   240
            Width           =   1815
         End
         Begin VB.Label lblOFMhz 
            BackStyle       =   0  'Transparent
            Caption         =   "MHz"
            Height          =   255
            Index           =   1
            Left            =   3840
            TabIndex        =   15
            Top             =   240
            Width           =   375
         End
      End
   End
   Begin VB.Frame fraDUTSettings 
      BorderStyle     =   0  'None
      Caption         =   "DUT Settings"
      Height          =   2055
      Index           =   2
      Left            =   240
      TabIndex        =   19
      Top             =   480
      Width           =   4335
      Begin VB.Frame fraRisingDeltaFreq 
         Height          =   975
         Index           =   1
         Left            =   0
         TabIndex        =   20
         Top             =   0
         Width           =   4335
         Begin VB.TextBox txtRSRR 
            Alignment       =   1  'Right Justify
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Index           =   1
            Left            =   2280
            TabIndex        =   22
            Tag             =   "0"
            Text            =   "0.000"
            Top             =   600
            Width           =   1455
         End
         Begin VB.TextBox txtRDFTW 
            Alignment       =   1  'Right Justify
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Index           =   1
            Left            =   1920
            MaxLength       =   15
            TabIndex        =   21
            Tag             =   "0"
            Text            =   "0.000000000"
            ToolTipText     =   "Double click for edit dialog."
            Top             =   240
            Width           =   1815
         End
         Begin VB.Label lblRRUnits 
            AutoSize        =   -1  'True
            Caption         =   "m"
            BeginProperty Font 
               Name            =   "Symbol"
               Size            =   9.75
               Charset         =   2
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   240
            Index           =   5
            Left            =   3840
            TabIndex        =   36
            Top             =   600
            Width           =   105
         End
         Begin VB.Label lblRRUnits 
            AutoSize        =   -1  'True
            Caption         =   "s"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   240
            Index           =   1
            Left            =   3960
            TabIndex        =   35
            Top             =   600
            Width           =   105
         End
         Begin VB.Label lblRisingRampRate 
            Caption         =   "Ramp Up Rate:"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   25
            Top             =   600
            Width           =   1695
         End
         Begin VB.Label lblOFMhz 
            BackStyle       =   0  'Transparent
            Caption         =   "MHz"
            Height          =   255
            Index           =   2
            Left            =   3840
            TabIndex        =   24
            Top             =   240
            Width           =   375
         End
         Begin VB.Label lblRDF 
            BackStyle       =   0  'Transparent
            Caption         =   "Rising Delta Frequency:"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   23
            Top             =   240
            Width           =   1815
         End
      End
      Begin VB.Frame fraFallingDeltaFrequency 
         Height          =   975
         Index           =   1
         Left            =   0
         TabIndex        =   26
         Top             =   960
         Width           =   4335
         Begin VB.TextBox txtFDFTW 
            Alignment       =   1  'Right Justify
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Index           =   1
            Left            =   1920
            MaxLength       =   15
            TabIndex        =   28
            Tag             =   "0"
            Text            =   "0.000000000"
            ToolTipText     =   "Double click for edit dialog."
            Top             =   240
            Width           =   1815
         End
         Begin VB.TextBox txtFSRR 
            Alignment       =   1  'Right Justify
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   285
            Index           =   1
            Left            =   2280
            TabIndex        =   27
            Tag             =   "0"
            Text            =   "0.000"
            Top             =   600
            Width           =   1455
         End
         Begin VB.Label lblRRUnits 
            AutoSize        =   -1  'True
            Caption         =   "m"
            BeginProperty Font 
               Name            =   "Symbol"
               Size            =   9.75
               Charset         =   2
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   240
            Index           =   7
            Left            =   3840
            TabIndex        =   38
            Top             =   600
            Width           =   105
         End
         Begin VB.Label lblRRUnits 
            AutoSize        =   -1  'True
            Caption         =   "s"
            BeginProperty Font 
               Name            =   "MS Sans Serif"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   240
            Index           =   6
            Left            =   3960
            TabIndex        =   37
            Top             =   600
            Width           =   105
         End
         Begin VB.Label lblOFMhz 
            BackStyle       =   0  'Transparent
            Caption         =   "MHz"
            Height          =   255
            Index           =   3
            Left            =   3840
            TabIndex        =   31
            Top             =   240
            Width           =   375
         End
         Begin VB.Label lblFDF 
            BackStyle       =   0  'Transparent
            Caption         =   "Falling Delta Frequency:"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   30
            Top             =   240
            Width           =   1815
         End
         Begin VB.Label lblFallingRampRate 
            Caption         =   "Ramp Down Rate:"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   29
            Top             =   600
            Width           =   1695
         End
      End
   End
   Begin MSComctlLib.TabStrip tspDUTSel 
      Height          =   3375
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4575
      _ExtentX        =   8070
      _ExtentY        =   5953
      MultiRow        =   -1  'True
      HotTracking     =   -1  'True
      _Version        =   393216
      BeginProperty Tabs {1EFB6598-857C-11D1-B16A-00C0F0283628} 
         NumTabs         =   2
         BeginProperty Tab1 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "Master"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "Slave"
            ImageVarType    =   2
         EndProperty
      EndProperty
   End
End
Attribute VB_Name = "frmLinSweepSetup"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Public IsUpdating As Boolean
Dim OldSelTab As Integer

Private Sub cmdLoad_Click()
    Dim DutCntr As Integer
    Dim RegIndex As Integer
    
    'Set the mouse pointer to indicate that the software is busy
    Screen.MousePointer = 11
    
    If chkLoadDUT2.Value = 1 Then
        For RegIndex = &H2 To &H5
            'Load the new register value into the DUT
            EvBd.SerialLoad sd9956_Both, RegIndex, EvBd.GetRegMapValue(sd9956_DUT1, rm9956_NewRegMapVals, RegIndex)
            EvBd.SetRegMapValue sd9956_DUT2, rm9956_NewRegMapVals, RegIndex, EvBd.GetRegMapValue(sd9956_DUT1, rm9956_NewRegMapVals, RegIndex)
        Next RegIndex
    Else
        For DutCntr = 1 To 2
            For RegIndex = &H2 To &H5
                'Load the new register value into the DUT
                EvBd.SerialLoad DutCntr, RegIndex, EvBd.GetRegMapValue(DutCntr, rm9956_NewRegMapVals, RegIndex)
            Next RegIndex
        Next DutCntr
    End If
    
    'Stop the flashing
    cmdLoad.BackColor = FlashColorOff

    'Set the mouse pointer back to default
    Screen.MousePointer = 0
End Sub

Private Sub cmdRead_Click()
    Dim DutCntr As Integer
    Dim RegCntr As Integer
    Dim sBinStr As String
    Dim DecVal As Variant
    
    'Set the mouse pointer to indicate that the software is busy
    Screen.MousePointer = 11
    
    If EvBd.PCInterface <> -1 Then
        For DutCntr = 0 To 1
            sBinStr = EvBd.SerialRead(DutCntr + 1, RMA9956_RDFTW)
            DecVal = cbaseBinS2Dec(sBinStr)
            txtRDFTW(DutCntr).Tag = CStr(DecVal)
            'Update the regmap values
            EvBd.SetRegMapValue DutCntr + 1, rm9956_NewRegMapVals, RMA9956_RDFTW, sBinStr
            EvBd.SetRegMapValue DutCntr + 1, rm9956_CurRegMapVals, RMA9956_RDFTW, sBinStr
            
            sBinStr = EvBd.SerialRead(DutCntr + 1, RMA9956_FDFTW)
            DecVal = cbaseBinS2Dec(sBinStr)
            txtFDFTW(DutCntr).Tag = CStr(DecVal)
            'Update the regmap values
            EvBd.SetRegMapValue DutCntr + 1, rm9956_NewRegMapVals, RMA9956_FDFTW, sBinStr
            EvBd.SetRegMapValue DutCntr + 1, rm9956_CurRegMapVals, RMA9956_FDFTW, sBinStr
            
            sBinStr = EvBd.SerialRead(DutCntr + 1, RMA9956_RSRR)
            DecVal = cbaseBinS2Dec(sBinStr)
            txtRSRR(DutCntr).Tag = CStr(DecVal)
            'Update the regmap values
            EvBd.SetRegMapValue DutCntr + 1, rm9956_NewRegMapVals, RMA9956_RSRR, sBinStr
            EvBd.SetRegMapValue DutCntr + 1, rm9956_CurRegMapVals, RMA9956_RSRR, sBinStr
            
            sBinStr = EvBd.SerialRead(DutCntr + 1, RMA9956_FSRR)
            DecVal = cbaseBinS2Dec(sBinStr)
            txtFSRR(DutCntr).Tag = CStr(DecVal)
            'Update the regmap values
            EvBd.SetRegMapValue DutCntr + 1, rm9956_NewRegMapVals, RMA9956_FSRR, sBinStr
            EvBd.SetRegMapValue DutCntr + 1, rm9956_CurRegMapVals, RMA9956_FSRR, sBinStr
        Next DutCntr
    
        'Stop the flashing
        cmdLoad.BackColor = FlashColorOff
        
        'Refresh the displays
        RefreshDisplays
    End If

    'Set the mouse pointer back to default
    Screen.MousePointer = 0
End Sub

Private Sub Form_Activate()
    'Check the menu used to show the window
    mdiMain.mnuViewLinearSweep.Checked = True
End Sub

Private Sub Form_Load()
    'OldTab
    OldSelTab = 1
    
    RefreshDisplays
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    'Do not allow the user to close the window instead
    'just hide it.
    If UnloadMode = vbFormControlMenu Then
        Cancel = 1
    End If
    Me.Hide
    'Uncheck the menu used to show the window
    mdiMain.mnuViewLinearSweep.Checked = False
    'Unpress the tool button
    frmProfiles.IsUpdating = True
    frmProfiles.chkLinSwpSetup.Value = 0
    frmProfiles.IsUpdating = False
End Sub

Private Sub tspDUTSel_Click()
    If tspDUTSel.SelectedItem.Index = OldSelTab Then
        'Exit the subroutine the tab is allready selected
        Exit Sub
    Else
        ' Otherwise, hide old frame, show new.
        fraDutSettings(tspDUTSel.SelectedItem.Index).Visible = True
        fraDutSettings(OldSelTab).Visible = False
        ' Set mintCurFrame to new value.
        OldSelTab = tspDUTSel.SelectedItem.Index
    End If
End Sub

Private Sub txtFDFTW_DblClick(Index As Integer)
    'Do a detailed edit of the textbox
    frmEditOutFreq.ShowEditDialog txtFDFTW(Index), "Falling Delta Frequency", CDbl(frmControl.txtSysClkTxt(Index).Text), DFTWBits
    
    'Update the register map
    EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_FDFTW, cbaseDec2Bin(txtFDFTW(Index).Tag, 24)

    If cmdLoad.Enabled = True Then
        'Give the load button the focus
        cmdLoad.SetFocus
    End If
End Sub

Private Sub txtFDFTW_GotFocus(Index As Integer)
    'Select all of the text
    SelectAllTxt txtFDFTW(Index)
End Sub

Private Sub txtFDFTW_KeyPress(Index As Integer, KeyAscii As Integer)
    Dim cncl As Boolean
    Dim DecSepPos As Integer

    'Filter out all keys but the ones that are needed
    KeyAscii = NumericKeysFilter(KeyAscii)
    KeyAscii = PlusMinusKeysFilter(KeyAscii)
    Select Case KeyAscii
        Case 69, 101: 'Alpha key
            KeyAscii = 0
        Case iDecSep 'Decimal Seperator
            If InStr(1, txtFDFTW(Index).Text, sDecSep) And InStr(1, txtFDFTW(Index).SelText, sDecSep) = 0 Then
                KeyAscii = 0
            End If
        Case 13: 'Enter key hit
            KeyAscii = 0
            'Validate the text box
'            txtOutpuFreqVal_Validate Cncl
            txtFDFTW_Validate Index, cncl
        Case Else 'Only a passable key was pressed
            'Get the position of the decimal seperator
            DecSepPos = InStr(1, txtFDFTW(Index).Text, sDecSep)
            
            If txtFDFTW(Index).SelStart < DecSepPos And DecSepPos < 4 Then
                If IsPrintable(KeyAscii) Then
                    If DecSepPos < 4 Then
                        txtFDFTW(Index).MaxLength = Len(txtFDFTW(Index).Text) + 1
                    End If
                Else
                End If
            End If

    End Select
End Sub

Private Sub txtFDFTW_Validate(Index As Integer, Cancel As Boolean)
    Dim OutFreqval As Double
    Dim DecSepPos As Integer
    Dim SysClk As Double
    Dim TWDecVal As Variant
    
    TWDecVal = CDec(0)
    
    'Get the system clock
    SysClk = frmControl.txtSysClkTxt(Index)
    
    'If it is a null string then enter 0 as the default
    If Not IsNumeric(txtFDFTW(Index).Text) Then
        txtFDFTW(Index).Text = FormatOutFreq(0, DFTWBits)
    End If
    
    'Format the string properly
    If IsNumeric(txtFDFTW(Index).Text) Then
        
        'Convert it to a double
        OutFreqval = Abs(CDbl(txtFDFTW(Index).Text))
        
        If OutFreqval >= CDbl(SysClk) Then  ' CDbl(frmMain.txtExtClockFreq.Text)
            'MsgBox "The DDS output frequency should not exceed  the system clock.", vbApplicationModal + vbExclamation + vbOKOnly, "Output Frequency to High!!!"
            'OutFreqval = CDbl(EditOutFreqSysClk) * 0.4
            OutFreqval = DecTW2CarrierFreq((2 ^ DFTWBits) - 1, SysClk, DFTWBits)
        End If
        
        'Calculate the decimal tuning word
        TWDecVal = CalculateDecTuningWord(OutFreqval, SysClk, DFTWBits)
        txtFDFTW(Index).Tag = TWDecVal
        'Convert it to a double
        OutFreqval = CDbl(DecTW2CarrierFreq(TWDecVal, SysClk, DFTWBits))
        
        'Format and display the output frequency
        txtFDFTW(Index).Text = FormatOutFreq(OutFreqval, DFTWBits, SysClk)
        
        'Update the register map
        EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_FDFTW, cbaseDec2Bin(txtFDFTW(Index).Tag, 24)
    End If

    If cmdLoad.Enabled = True Then
        'Give the load button the focus
        cmdLoad.SetFocus
    End If
End Sub

Private Sub txtFSRR_DblClick(Index As Integer)
    'Show the edit dialog box
    frmEditFreqRampRate.ShowEditDialog txtFSRR(Index), "Edit Falling Ramp Rate Value", CDbl(frmControl.txtSysClkTxt(Index).Text)
    
    'Update the register map
    EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_FSRR, cbaseDec2Bin(txtFSRR(Index).Tag, 16)

    If cmdLoad.Enabled = True Then
        'Give the load button the focus
        cmdLoad.SetFocus
    End If
End Sub

Private Sub txtFSRR_GotFocus(Index As Integer)
    'Select all of the text in the textbox
    SelectAllTxt txtFSRR(Index)
End Sub

Private Sub txtFSRR_KeyPress(Index As Integer, KeyAscii As Integer)
    Dim cncl As Boolean
    Dim DecSepPos As Integer

    'Filter out all keys but the ones that are needed
    KeyAscii = NumericKeysFilter(KeyAscii)
    KeyAscii = PlusMinusKeysFilter(KeyAscii)
    Select Case KeyAscii
        Case 69, 101: 'Alpha key
            KeyAscii = 0
        Case iDecSep 'Decimal Seperator
            If InStr(1, txtFSRR(Index).Text, sDecSep) And InStr(1, txtFSRR(Index).SelText, sDecSep) = 0 Then
                KeyAscii = 0
            End If
        Case 13: 'Enter key hit
            KeyAscii = 0
            'Validate the text box
'            txtOutpuFreqVal_Validate Cncl
            txtFSRR_Validate Index, cncl
        Case Else 'Only a passable key was pressed
            'Get the position of the decimal seperator
            DecSepPos = InStr(1, txtFSRR(Index).Text, sDecSep)
            
            If txtFSRR(Index).SelStart < DecSepPos And DecSepPos < 4 Then
                If IsPrintable(KeyAscii) Then
                    'Adjust the maximum length
                    Select Case DecSepPos
                        Case 2:
                            txtFSRR(Index).MaxLength = 7
                        Case 3:
                            txtFSRR(Index).MaxLength = 6
                        Case Else:
                            txtFSRR(Index).MaxLength = 5
                    End Select
                Else
                    Select Case DecSepPos
                        Case 2:
                            txtFSRR(Index).MaxLength = 7
                        Case 3:
                            txtFSRR(Index).MaxLength = 6
                        Case Else
                            txtFSRR(Index).MaxLength = 5
                    End Select
                End If
            End If
    End Select
End Sub

Private Sub txtFSRR_Validate(Index As Integer, Cancel As Boolean)
    Dim RampRateTime As Double
    Dim sRampRateTime As String
    Dim DecVal As Long
    Dim MaxRRT As Double
    Dim MinRRT As Double
    Dim SysClk As Double
    
    'Setup a system clock variable
    SysClk = CDbl(frmControl.txtSysClkTxt(Index).Text)
    
    'Calculate the max and min values
    MaxRRT = CalculateRRTime(65535, SysClk)
    MinRRT = CalculateRRTime(0, SysClk)
    
    'If it is a null string then enter 0 as the default
    If Not IsNumeric(txtFSRR(Index).Text) Then
        txtFSRR(Index).Text = Format(0, "0.00000")
    End If
    
    If txtFSRR(Index).Text > MaxRRT Then
        MsgBox "The vaid range for the Rising Delta Frequency Ramp Rate Time is " & FormatRRT(CDbl(MaxRRT)) & "ns to " & MinRRT & "ns ." & vbCrLf & "The value entered will be clipped!", vbApplicationModal + vbInformation + vbOKOnly, "Maximum Ramp Rate Time Exceeded!!!"
        txtFSRR(Index).Text = MaxRRT
'
'        Cancel = True
'        Exit Sub
    End If
            
    'Get the matching RRW value
    'DecVal = GetMatchingRRW(txtFSRR(index).Text)
    DecVal = CalculateRRWord(txtFSRR(Index).Text, SysClk)
    
    txtFSRR(Index).Tag = DecVal
    
    'Get the closest actual output value that the part can do
    txtFSRR(Index).Text = CalculateRRTime(DecVal, SysClk)
    
    'Format the text for display
    txtFSRR(Index).Text = FormatRRT(CDbl(txtFSRR(Index).Text))
    
    'Update the register map
    EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_FSRR, cbaseDec2Bin(txtFSRR(Index).Tag, 16)

    If cmdLoad.Enabled = True Then
        'Give the load button the focus
        cmdLoad.SetFocus
    End If
End Sub

Private Sub txtRDFTW_DblClick(Index As Integer)
    'Do a detailed edit of the textbox
    frmEditOutFreq.ShowEditDialog txtRDFTW(Index), "Rising Delta Frequency", CDbl(frmControl.txtSysClkTxt(Index).Text), DFTWBits
    
    'Update the register map
    EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_RDFTW, cbaseDec2Bin(txtRDFTW(Index).Tag, 24)

    If cmdLoad.Enabled = True Then
        'Give the load button the focus
        cmdLoad.SetFocus
    End If
End Sub

Private Sub txtRDFTW_GotFocus(Index As Integer)
    SelectAllTxt txtRDFTW(Index)
End Sub

Private Sub txtRDFTW_KeyPress(Index As Integer, KeyAscii As Integer)
    Dim cncl As Boolean
    Dim DecSepPos As Integer
    Dim SysClk As Double
    
    'Get the system clock
    SysClk = frmControl.txtSysClkTxt(Index)

    'Filter out all keys but the ones that are needed
    KeyAscii = NumericKeysFilter(KeyAscii)
    KeyAscii = PlusMinusKeysFilter(KeyAscii)
    Select Case KeyAscii
        Case 69, 101: 'Alpha key
            KeyAscii = 0
        Case iDecSep 'Decimal Seperator
            If InStr(1, txtRDFTW(Index).Text, sDecSep) And InStr(1, txtRDFTW(Index).SelText, sDecSep) = 0 Then
                KeyAscii = 0
            End If
        Case 13: 'Enter key hit
            KeyAscii = 0
            'Validate the text box
'            txtOutpuFreqVal_Validate Cncl
            txtRDFTW_Validate Index, cncl
        Case Else 'Only a passable key was pressed
            'Get the position of the decimal seperator
            DecSepPos = InStr(1, txtRDFTW(Index).Text, sDecSep)
            
            If txtRDFTW(Index).SelStart < DecSepPos And DecSepPos < 4 Then
                If IsPrintable(KeyAscii) Then
                    If DecSepPos < 4 Then
                        txtRDFTW(Index).MaxLength = Len(FormatOutFreq(0, DFTWBits, SysClk)) + 1
                    End If
                Else
                End If
            End If
    End Select
End Sub

Private Sub txtRDFTW_Validate(Index As Integer, Cancel As Boolean)
    Dim OutFreqval As Double
    Dim DecSepPos As Integer
    Dim SysClk As Double
    Dim TWDecVal As Variant
    
    TWDecVal = CDec(0)
    
    'Get the system clock
    SysClk = frmControl.txtSysClkTxt(Index)
    
    'If it is a null string then enter 0 as the default
    If Not IsNumeric(txtRDFTW(Index).Text) Then
        txtRDFTW(Index).Text = FormatOutFreq(0, DFTWBits)
    End If
    
    'Convert it to a double
    OutFreqval = Abs(CDbl(txtRDFTW(Index).Text))
    
    If OutFreqval >= CDbl(SysClk) Then  ' CDbl(frmMain.txtExtClockFreq.Text)
        'MsgBox "The DDS output frequency should not exceed  the system clock.", vbApplicationModal + vbExclamation + vbOKOnly, "Output Frequency to High!!!"
'        MsgBox "The DDS output frequency can not exceed the system clock.", vbApplicationModal + vbInformation + vbOKOnly, "Output Frequency to High!!!"
        'OutFreqval = CDbl(EditOutFreqSysClk) * 0.4
        OutFreqval = DecTW2CarrierFreq((2 ^ DFTWBits) - 1, SysClk, DFTWBits)
    End If
    
    'Calculate the decimal tuning word
    TWDecVal = CalculateDecTuningWord(OutFreqval, SysClk, DFTWBits)
    txtRDFTW(Index).Tag = TWDecVal
    'Convert it to a double
    OutFreqval = CDbl(DecTW2CarrierFreq(TWDecVal, SysClk, DFTWBits))
    
    'Format and display the output frequency
    txtRDFTW(Index).Text = FormatOutFreq(OutFreqval, DFTWBits, SysClk)
    
    'Update the register map
    EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_RDFTW, cbaseDec2Bin(txtRDFTW(Index).Tag, 24)

    If cmdLoad.Enabled = True Then
        'Give the load button the focus
        cmdLoad.SetFocus
    End If
End Sub

Private Sub txtRSRR_DblClick(Index As Integer)
    'Show the edit dialog box
    frmEditFreqRampRate.ShowEditDialog txtRSRR(Index), "Edit Rising Ramp Rate Value", CDbl(frmControl.txtSysClkTxt(Index).Text)
    
    'Update the register map
    EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_RSRR, cbaseDec2Bin(txtRSRR(Index).Tag, 16)

    If cmdLoad.Enabled = True Then
        'Give the load button the focus
        cmdLoad.SetFocus
    End If
End Sub

Private Sub txtRSRR_GotFocus(Index As Integer)
    'Select all of the text in the textbox
    SelectAllTxt txtRSRR(Index)
End Sub

Private Sub txtRSRR_KeyPress(Index As Integer, KeyAscii As Integer)
    Dim cncl As Boolean
    Dim DecSepPos As Integer

    'Filter out all keys but the ones that are needed
    KeyAscii = NumericKeysFilter(KeyAscii)
    KeyAscii = PlusMinusKeysFilter(KeyAscii)
    Select Case KeyAscii
        Case 69, 101: 'Alpha key
            KeyAscii = 0
        Case iDecSep 'Decimal Seperator
            If InStr(1, txtRSRR(Index).Text, sDecSep) And InStr(1, txtRSRR(Index).SelText, sDecSep) = 0 Then
                KeyAscii = 0
            End If
        Case 13: 'Enter key hit
            KeyAscii = 0
            'Validate the text box
'            txtOutpuFreqVal_Validate Cncl
            txtRSRR_Validate Index, cncl
        Case Else 'Only a passable key was pressed
            'Get the position of the decimal seperator
            DecSepPos = InStr(1, txtRSRR(Index).Text, sDecSep)
            
            If txtRSRR(Index).SelStart < DecSepPos And DecSepPos < 4 Then
                If IsPrintable(KeyAscii) Then
                    'Adjust the maximum length
                    Select Case DecSepPos
                        Case 2:
                            txtRSRR(Index).MaxLength = 7
                        Case 3:
                            txtRSRR(Index).MaxLength = 6
                        Case Else:
                            txtRSRR(Index).MaxLength = 5
                    End Select
                Else
                    Select Case DecSepPos
                        Case 2:
                            txtRSRR(Index).MaxLength = 7
                        Case 3:
                            txtRSRR(Index).MaxLength = 6
                        Case Else
                            txtRSRR(Index).MaxLength = 5
                    End Select
                End If
            End If

    End Select
End Sub

Private Sub txtRSRR_Validate(Index As Integer, Cancel As Boolean)
    Dim RampRateTime As Double
    Dim sRampRateTime As String
    Dim DecVal As Long
    Dim MaxRRT As Double
    Dim MinRRT As Double
    Dim SysClk As Double
    
    'Setup a system clock variable
    SysClk = CDbl(frmControl.txtSysClkTxt(Index).Text)
    
    'Calculate the max and min values
    MaxRRT = CalculateRRTime(65535, SysClk)
    MinRRT = CalculateRRTime(0, SysClk)
    
    'If it is a null string then enter 0 as the default
    If Not IsNumeric(txtRSRR(Index).Text) Then
        txtRSRR(Index).Text = Format(0, "0.00000")
    End If
    
    If txtRSRR(Index).Text > MaxRRT Then
        MsgBox "The vaid range for the Delta Frequency Ramp Rate Time is " & FormatRRT(CDbl(MaxRRT)) & "ns to " & MinRRT & "ns ." & vbCrLf & "The value entered will be clipped!", vbApplicationModal + vbInformation + vbOKOnly, "Maximum Ramp Rate Time Exceeded!!!"
        txtRSRR(Index).Text = MaxRRT
'
'        Cancel = True
'        Exit Sub
    End If
            
    'Get the matching RRW value
    'DecVal = GetMatchingRRW(txtRSRR(index).Text)
    DecVal = CalculateRRWord(txtRSRR(Index).Text, SysClk)
    txtRSRR(Index).Tag = DecVal
    
    'Get the closest actual output value that the part can do
    txtRSRR(Index).Text = CalculateRRTime(DecVal, SysClk)
    
    'Format the text for display
    txtRSRR(Index).Text = FormatRRT(CDbl(txtRSRR(Index).Text))
    
    'Update the register map
    EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_RSRR, cbaseDec2Bin(txtRSRR(Index).Tag, 16)

    If cmdLoad.Enabled = True Then
        'Give the load button the focus
        cmdLoad.SetFocus
    End If
End Sub

Public Sub RefreshControls()
    Dim DutCntr As Integer
    Dim RegCntr As Integer
    Dim sBinStr As String
    Dim DecVal As Variant
    
    For DutCntr = 0 To 1
        sBinStr = EvBd.GetRegMapValue(DutCntr + 1, rm9956_NewRegMapVals, RMA9956_RDFTW)
        DecVal = cbaseBinS2Dec(sBinStr)
        txtRDFTW(DutCntr).Tag = CStr(DecVal)
        
        sBinStr = EvBd.GetRegMapValue(DutCntr + 1, rm9956_NewRegMapVals, RMA9956_FDFTW)
        DecVal = cbaseBinS2Dec(sBinStr)
        txtFDFTW(DutCntr).Tag = CStr(DecVal)
        
        sBinStr = EvBd.GetRegMapValue(DutCntr + 1, rm9956_NewRegMapVals, RMA9956_RSRR)
        DecVal = cbaseBinS2Dec(sBinStr)
        txtRSRR(DutCntr).Tag = CStr(DecVal)
        
        sBinStr = EvBd.GetRegMapValue(DutCntr + 1, rm9956_NewRegMapVals, RMA9956_FSRR)
        DecVal = cbaseBinS2Dec(sBinStr)
        txtFSRR(DutCntr).Tag = CStr(DecVal)
    Next DutCntr
    
    'Refresh the displays
    RefreshDisplays
End Sub

Public Sub RefreshDisplays()
    Dim DutCntr As Integer
    Dim DecVal As Variant
    Dim dValue As Double
    Dim SysClk As Double
    
    
    For DutCntr = 0 To 1
        'First get the system clock value for the dut
        SysClk = CDbl(frmControl.txtSysClkTxt(DutCntr))
        
        DecVal = txtRDFTW(DutCntr).Tag
        'Convert it to a double
        dValue = CDbl(DecTW2CarrierFreq(DecVal, SysClk, DFTWBits))
        'Format and display the output frequency
        txtRDFTW(DutCntr).Text = FormatOutFreq(dValue, DFTWBits, SysClk)
    
        DecVal = txtFDFTW(DutCntr).Tag
        'Convert it to a double
        dValue = CDbl(DecTW2CarrierFreq(DecVal, SysClk, DFTWBits))
        'Format and display the output frequency
        txtFDFTW(DutCntr).Text = FormatOutFreq(dValue, DFTWBits, SysClk)
    
        DecVal = txtRSRR(DutCntr).Tag
        'Calculate the ramp rate time
        dValue = CalculateRRTime(DecVal, SysClk)
        'Format and display the output frequency
        txtRSRR(DutCntr).Text = FormatRRT(dValue)
    
        DecVal = txtFSRR(DutCntr).Tag
        'Calculate the ramp rate time
        dValue = CalculateRRTime(DecVal, SysClk)
        'Format and display the output frequency
        txtFSRR(DutCntr).Text = FormatRRT(dValue)
    Next DutCntr
End Sub
Public Sub EnableIO(ByVal bVal As Boolean)
    Me.cmdLoad.Enabled = bVal
    Me.cmdRead.Enabled = bVal
End Sub

