VERSION 5.00
Begin VB.Form frmEditFreqRampRate 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Edit Frequency Ramp Rate"
   ClientHeight    =   2415
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4335
   Icon            =   "frmEditFreqRampRate.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2415
   ScaleWidth      =   4335
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton OKButton 
      Caption         =   "OK"
      Height          =   375
      Left            =   3000
      TabIndex        =   11
      Top             =   120
      Width           =   1215
   End
   Begin VB.CommandButton CancelButton 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3000
      TabIndex        =   10
      Top             =   600
      Width           =   1215
   End
   Begin VB.Frame fraRampRate 
      Caption         =   "Ramp Rate Register Values"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   120
      TabIndex        =   2
      Top             =   960
      Width           =   2775
      Begin VB.TextBox txtDec 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   240
         MaxLength       =   5
         MultiLine       =   -1  'True
         TabIndex        =   6
         Text            =   "frmEditFreqRampRate.frx":000C
         Top             =   360
         Width           =   735
      End
      Begin VB.TextBox txtHex 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   1560
         MaxLength       =   4
         MultiLine       =   -1  'True
         TabIndex        =   5
         Text            =   "frmEditFreqRampRate.frx":0014
         Top             =   360
         Width           =   615
      End
      Begin VB.TextBox txtBin 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   0
         Left            =   1200
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   4
         Text            =   "frmEditFreqRampRate.frx":001B
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtBin 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   1
         Left            =   240
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   3
         Text            =   "frmEditFreqRampRate.frx":0024
         Top             =   840
         Width           =   975
      End
      Begin VB.Label lblDec 
         Caption         =   "Dec"
         Height          =   255
         Left            =   1080
         TabIndex        =   9
         Top             =   360
         Width           =   375
      End
      Begin VB.Label lblTWBin 
         BackStyle       =   0  'Transparent
         Caption         =   "Bin"
         Height          =   255
         Left            =   2280
         TabIndex        =   8
         Top             =   840
         Width           =   375
      End
      Begin VB.Label lblHex 
         BackStyle       =   0  'Transparent
         Caption         =   "Hex"
         Height          =   255
         Index           =   1
         Left            =   2280
         TabIndex        =   7
         Top             =   360
         Width           =   375
      End
   End
   Begin VB.TextBox txtRampRateTime 
      Alignment       =   1  'Right Justify
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   360
      MaxLength       =   7
      MultiLine       =   -1  'True
      TabIndex        =   1
      Text            =   "frmEditFreqRampRate.frx":002D
      Top             =   360
      Width           =   1935
   End
   Begin VB.VScrollBar vscRampRateTime 
      Height          =   435
      Left            =   150
      Max             =   -1
      Min             =   1
      TabIndex        =   0
      Top             =   360
      Width           =   200
   End
   Begin VB.Label lblMhz 
      Caption         =   "s"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2580
      TabIndex        =   12
      Top             =   360
      Width           =   255
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "m"
      BeginProperty Font 
         Name            =   "Symbol"
         Size            =   12
         Charset         =   2
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2280
      TabIndex        =   16
      Top             =   360
      Width           =   255
   End
   Begin VB.Label lblDTime 
      Caption         =   "t:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1560
      TabIndex        =   15
      Top             =   120
      Width           =   195
   End
   Begin VB.Label lbDelta 
      Caption         =   "D"
      BeginProperty Font 
         Name            =   "Symbol"
         Size            =   8.25
         Charset         =   2
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1380
      TabIndex        =   14
      Top             =   120
      Width           =   135
   End
   Begin VB.Label Label1 
      Caption         =   "Ramp Rate"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   360
      TabIndex        =   13
      Top             =   120
      Width           =   975
   End
   Begin VB.Shape shpOKHilight 
      BorderWidth     =   3
      Height          =   375
      Left            =   3000
      Top             =   120
      Width           =   1215
   End
End
Attribute VB_Name = "frmEditFreqRampRate"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private CancelHit As Boolean
Private OldValue As String
Private EditTbox As TextBox
Private OKHit As Boolean

Public Sub ShowEditDialog(ByRef Tbox As TextBox, ByVal Title As String, ByVal SysClk As Double)
'    Dim OldOutputVal As String
'    Dim TWDecVal As Variant
    Dim OldLeft As Single
    Dim OldTop As Single
    Dim DecVal As Variant
    
    'Set the sysclk value for internal functions
    EditDialogSysClk9956 = SysClk
    
    'Set the title of the dialog
    Me.Caption = Title
    
    'Store the value to be edited
    Set EditTbox = Tbox
    
    'Setup the textbox to the initial value
    txtRampRateTime.Text = Tbox.Text
    
    'Show the window off the screen so that it isn't seen yet
    Call SetWindowPos(Me.hWnd, hWnd_NOTOPMOST, -500, -500, 0, 0, SWP_NOSIZE + SWP_SHOWWINDOW + SWP_NOACTIVATE)
    
    'Get the decimal value from the textbox
    If Tbox.Tag = "" Or Not IsNumeric(Tbox.Tag) Then
        DecVal = 0
        txtRampRateTime.Text = FormatRRT(0)
    Else
        DecVal = Tbox.Tag
    End If
    txtDec.Text = Format(DecVal, "00000")
    
    'Update the other textboxes
    UpdateVals (DecVal)
    
    'Set the focus to the output text box
    txtRampRateTime.SetFocus
    Me.Visible = False
    
    'Move the form back
    Me.Top = OldTop
    Me.Left = OldLeft
    
    'Show as modal and wait for the user to input a value
    Me.Show 1
    
    If OKHit = True Then
        'Ok was hit
        Tbox.Tag = txtDec.Text 'OutputFreqVal
        Tbox.Text = txtRampRateTime.Text
    End If
    
    'Unload the dialog
    Unload Me

End Sub

Private Sub CancelButton_Click()
    'Cancel was hit
    OKHit = False
    'Hide the form
    Me.Hide
End Sub

Private Sub Form_Unload(Cancel As Integer)
    OKHit = False
    'Release the pointer to the textbox being edited
    Set EditTbox = Nothing
End Sub

Private Sub OKButton_Click()
    'Ok button hit
    OKHit = True
    
    'Hide the form
    Me.Hide
End Sub


Private Sub OKButton_GotFocus()
    shpOKHilight.Visible = False
End Sub

Private Sub OKButton_LostFocus()
    shpOKHilight.Visible = True
End Sub

Private Sub txtBin_GotFocus(Index As Integer)
    'Select all of the text in the textbox
    SelectAllTxt txtBin(Index)
End Sub

Private Sub txtBin_KeyPress(Index As Integer, KeyAscii As Integer)
    Dim cncl As Boolean
    
    'Filter out all keys but for the 0 and 1 keys
    KeyAscii = BinKeysFilter(KeyAscii)
    
    Select Case KeyAscii
        Case 13:
            KeyAscii = 0
            txtBin_Validate Index, cncl
    End Select
End Sub

Private Sub txtBin_Validate(Index As Integer, Cancel As Boolean)
    Dim BinVal As Variant
    Dim sBinVal As String
    
    'Fill any missing digits in with Zeros
    txtBin(Index).Text = String(8 - Len(txtBin(Index).Text), "0") & txtBin(Index).Text
        
        
    'If something non numeric is entered then zero the control
    If Not IsNumeric(txtBin(Index).Text) Then
        txtBin(Index).Text = Format(0, "00000000")
    End If
    
    'Get the value of the textbox
    BinVal = cbaseBinS2Dec(txtBin(1).Text & txtBin(0).Text)
    
'    If TWBinVal <= (2 ^ 32) - 1 Then
'        'Display the new value
'        txtTW(Index).Text = Format(TWBinVal, "0000000000")
'    Else
'        MsgBox "The decimal value of the Tunning Word should not exceed 4294967295"
'        TWBinVal = 0
'        txtTW(Index).Text = Format(TWBinVal, "0000000000")
'        Cancel = True
'    End If
'
    'Record the proper output frequency value
    'OutputFreqVal = DecTW2CarrierFreq(TWDecVal, TWBits, CLng(frmMain.txtIntClockFreq.Text))
    
    'Update the other textboxes
    UpdateVals (BinVal)
        
    'Set the focus to the ok button
    OKButton.SetFocus
End Sub

Private Sub txtDec_GotFocus()
    'Select all of the text in the textbox
    SelectAllTxt txtDec
End Sub

Private Sub txtDec_KeyPress(KeyAscii As Integer)
    Dim cncl As Boolean
    'Filter out keys that arn't needed
    KeyAscii = iNumericKeysFilter(KeyAscii)
    
    Select Case KeyAscii
'        Case 46:
'            KeyAscii = 0
        Case 13:
            KeyAscii = 0
            txtDec_Validate cncl
    End Select
End Sub

Private Sub txtDec_Validate(Cancel As Boolean)
    Dim DecVal As Long
    
    'If something non numeric is entered then zero the control
    If Not IsNumeric(txtDec.Text) Then
        txtDec.Text = Format(0, "00000")
    End If
    
    'Get the value of the textbox
    DecVal = CLng(txtDec.Text)
    
    If DecVal <= (2 ^ 16) - 1 Then
        'Display the new value
        txtDec.Text = Format(DecVal, "00000")
    Else
        MsgBox "The decimal value of the Delta Frequency Ramp Rate Word should not exceed 65535"
        DecVal = 0
        txtDec.Text = Format(DecVal, "00000")
        Cancel = True
    End If
    
    'Record the proper output frequency value
    'OutputFreqVal = DecTW2CarrierFreq(TWDecVal, TWBits, CLng(frmMain.txtIntClockFreq.Text))
    
    'Update the other textboxes
    UpdateVals (DecVal)
        
    'Set the focus to the ok button
    OKButton.SetFocus
End Sub

Private Sub txtHex_GotFocus()
    'Select all of the text in the textbox
    SelectAllTxt txtHex
End Sub

Private Sub txtHex_KeyPress(KeyAscii As Integer)
    Dim cncl As Boolean
        
    'Filter out all unwanted keys
    KeyAscii = HexKeysFilter(KeyAscii)
    
    If KeyAscii = 13 Then
        'Throw the key away
        KeyAscii = 0
        
        '
        txtHex_Validate cncl
    End If
End Sub

Private Sub txtHex_Validate(Cancel As Boolean)
    Dim HexVal As Variant
        
    HexVal = CDec(0)
    'If something non numeric is entered then zero the control
'    If Not IsNumeric(txtTWHex.Text) Then
'        txtTWHex.Text = cbaseHex(0, 8)
'    End If
    
    'Get the decimal value of the hex text box
    HexVal = cbaseHexStr2Dec(txtHex.Text)
    
    If HexVal <= (2 ^ 16) - 1 Then
        'Display the new value
        txtHex.Text = cbaseHex(HexVal, 4)
    Else
        MsgBox "The hex value of the Tunning Word should not exceed FFFF"
        HexVal = 0
        txtHex.Text = cbaseHex(HexVal, 4)
        Cancel = True
    End If
    
    'Update the other textboxes
    UpdateVals (HexVal)
        
    'Set the focus to the ok button
    OKButton.SetFocus
End Sub

Private Sub txtRampRateTime_GotFocus()
    'Select all of the text in the textbox
    SelectAllTxt txtRampRateTime
End Sub

Private Sub txtRampRateTime_KeyPress(KeyAscii As Integer)
    Dim cncl As Boolean
    Dim DecSepPos As Integer

    'Filter out all keys but the ones that are needed
    KeyAscii = NumericKeysFilter(KeyAscii)
    KeyAscii = PlusMinusKeysFilter(KeyAscii)
    Select Case KeyAscii
        Case 69, 101: 'Alpha key
            KeyAscii = 0
        Case iDecSep 'Decimal Seperator
            If InStr(1, txtRampRateTime.Text, sDecSep) And InStr(1, txtRampRateTime.SelText, sDecSep) = 0 Then
                KeyAscii = 0
            End If
        Case 13: 'Enter key hit
            KeyAscii = 0
            'Validate the text box
'            txtOutpuFreqVal_Validate Cncl
            txtRampRateTime_Validate cncl
        Case Else 'Only a passable key was pressed
            'Get the position of the decimal seperator
            DecSepPos = InStr(1, txtRampRateTime.Text, sDecSep)
            
            If txtRampRateTime.SelStart < DecSepPos And DecSepPos < 4 Then
                If IsPrintable(KeyAscii) Then
                    'Adjust the maximum length
                    Select Case DecSepPos
                        Case 2:
                            txtRampRateTime.MaxLength = 7
                        Case 3:
                            txtRampRateTime.MaxLength = 6
                        Case Else:
                            txtRampRateTime.MaxLength = 5
                    End Select
                Else
                    Select Case DecSepPos
                        Case 2:
                            txtRampRateTime.MaxLength = 7
                        Case 3:
                            txtRampRateTime.MaxLength = 6
                        Case Else
                            txtRampRateTime.MaxLength = 5
                    End Select
                End If
            End If

    End Select
End Sub

Private Sub UpdateVals(ByVal Value As Variant)
    Dim BinVal As String
    Dim RampRateTime As Variant
        
    'Output frequency textbox
    If Not (ActiveControl Is txtRampRateTime) Then
        'Update this box because it is not currently active
        RampRateTime = CalculateRRTime(Value)
        
        txtRampRateTime.Text = FormatRRT(RampRateTime)
'        If RampRateTime >= 100 Then
'            txtRampRateTime.Text = Format(RampRateTime, "000.0000")
'        ElseIf RampRateTime >= 10 Then
'            txtRampRateTime.Text = Format(RampRateTime, "00.0000")
'        Else
'            txtRampRateTime.Text = Format(RampRateTime, "0.0000")
'        End If
        
    End If
    
    'Decimal value textbox
    If Not (ActiveControl Is txtDec) Then
        txtDec.Text = Format(Value, "00000")
    End If
    
    'Hex textbox
    If Not (ActiveControl Is txtHex) Then
        'Update this box because it is not currently active
        txtHex.Text = cbaseHex(Value, 4)
        txtHex.Refresh
    End If
    
    'Generate a binary string representing the tunning word
    BinVal = cbaseDec2Bin(Value, 16)
    
    'Binary TextBoxes
    If Not (ActiveControl Is txtBin(0)) Then
        txtBin(0).Text = Right(BinVal, 8)
    End If
    
    If Not (ActiveControl Is txtBin(1)) Then
        txtBin(1).Text = Left(BinVal, 8)
    End If
    
End Sub
Public Function GetClosestRRTime(ByVal RRstr As String) As String
    Dim LowVal As String
    Dim HiVal As String
    Dim Dummy As Long
    Dim HiDiff As Double
    Dim LowDiff As Double
    Dim RetDecVal As Long
    
    'Calculate the tunning word value for the input string
    Dummy = CalculateRRWord(RRstr)
    
    'If they have entered a time larger than the maximum then clip the value
    If Dummy > 65535 Then
        Dummy = 65535
    End If
'
'    'Calculate the next availiable output frequency
    GetClosestRRTime = CalculateRRTime(Dummy)
    
'    If IsRRTimeValid(RRstr, cDecVal) Then
'        GetClosestRRTime = RRstr
'    Else
'        GetClosestRRTime = RRstr
'    End If
    
End Function

Private Sub txtRampRateTime_Validate(Cancel As Boolean)
    Dim RampRateTime As Double
    Dim sRampRateTime As String
    Dim DecVal As Long
    Dim MaxRRT As Double
    Dim MinRRT As Double
    
    'Calculate the max and min values
    MaxRRT = CalculateRRTime(65535)
    MinRRT = CalculateRRTime(0)
    
    'If it is a null string then enter 0 as the default
    If txtRampRateTime.Text = "" Then
        txtRampRateTime.Text = Format(0, "0.00000")
    End If
    
    'Format the string properly
    If IsNumeric(txtRampRateTime.Text) Then
        If txtRampRateTime.Text > MaxRRT Then
            MsgBox "The vaid range for the Delta Frequency Ramp Rate Time is " & FormatRRT(CDbl(MaxRRT)) & "ns to " & MinRRT & "ns ." & vbCrLf & "The value entered will be clipped!", vbApplicationModal + vbExclamation + vbOKOnly, "Maximum Ramp Rate Time Exceeded!!!"
            txtRampRateTime.Text = MaxRRT
        End If
                
        'Get the matching RRW value
        'DecVal = GetMatchingRRW(txtRampRateTime.Text)
        DecVal = CalculateRRWord(txtRampRateTime.Text)
        
        'Get the closest actual output value that the part can do
        txtRampRateTime.Text = CalculateRRTime(DecVal)
        
        'Format the text for display
        txtRampRateTime.Text = FormatRRT(CDbl(txtRampRateTime.Text))
        
        'Update the other textboxes
        UpdateVals (DecVal)
        
        'Set the focus to the ok button
        OKButton.SetFocus
    End If
End Sub

Private Sub vscRampRateTime_Change()
    Dim MinIncVal As Variant
    Dim NewVal As Double
    
    'Adjust the value and refresh all controls
    NewVal = txtDec.Text + vscRampRateTime.Value
    If NewVal >= 0 And NewVal <= 65535 Then
        'Update the new values
        UpdateVals NewVal
    End If
    vscRampRateTime.Value = 0
End Sub
''Calculate the RampRate time
'Public Function CalculateRRTime(ByVal RRWord As Long) As Double
'    'Calculate the ramp rate time
'    CalculateRRTime = CDbl(8 * RRWord / CDbl(frmControl.txtIntClockFreq.Text))
'End Function
''Calculate the RampRate word
'Public Function CalculateRRWord(ByVal RRTime As String) As Long
'    'Calculate the ramp rate word to be programmed into the AD9858
''    CalculateRRWord = DecFix((CDbl(RRTime) * CDbl(frmControl.txtIntClockFreq.Text)) / 8)
'    CalculateRRWord = CLng(RRTime * frmControl.txtIntClockFreq.Text / 8)
'End Function
'
''Checks to see if the Ramp Rate Time passed is a valid time
'Public Function IsRRTimeValid(ByVal RRT As String, DecVal As Long) As Boolean
'    Dim cntr As Long
'    Dim RRW As Long
'    Dim sRRT As String
'    'Calculate the Ramp Rate word that goes with the Ramp Rate Time
'    RRW = CalculateRRWord(RRT)
'    RRW = RRW - 4
'
'    'Loop through a few Ramp Rate words
'    For cntr = RRW To RRW + 8
'        'Calcuate the RampRateTime
'        sRRT = FormatRRT(CalculateRRTime(cntr))
'        'If the passed time and the calculated time equal then the time is valid
'        If sRRT = FormatRRT(RRT) Then
'            IsRRTimeValid = True
'            'Return the Decimal Value that goes with the time value
'            DecVal = cntr
'            Exit For
'        Else
'            IsRRTimeValid = False
'            'Return the Decimal Value that goes with the time value
'            DecVal = RRW
'        End If
'    Next cntr
'End Function
'Checks to see if the Ramp Rate Time passed is a valid time
Public Function GetMatchingRRW(ByVal RRT As String) As Long
    Dim cntr As Long
    Dim RRW As Long
    Dim StartWord As Long
    Dim sRRT As String
    'Calculate the Ramp Rate word that goes with the Ramp Rate Time
    RRW = CalculateRRWord(RRT)
    StartWord = RRW - 4
    
    'Loop through a few Ramp Rate words
    For cntr = StartWord To RRW + 8
        'Calcuate the RampRateTime
        sRRT = FormatRRT(CalculateRRTime(cntr))
        'If the passed time and the calculated time equal then the time is valid
        If sRRT = FormatRRT(RRT) Then
            'Return the Decimal Value that goes with the time value
            GetMatchingRRW = cntr
            Exit For
        Else
            'Return the Decimal Value that goes with the time value
            GetMatchingRRW = RRW
        End If
    Next cntr
End Function
'Formats the Ramp Rate Time for display in a textbox
'Public Function FormatRRT(ByVal RampRateTime As Double) As String
'    If RampRateTime >= 100 Then
'        FormatRRT = Format(RampRateTime, "000.000")
'    ElseIf RampRateTime >= 10 Then
'        FormatRRT = Format(RampRateTime, "00.000")
'    Else
'        FormatRRT = Format(RampRateTime, "0.000")
'    End If
'End Function
