VERSION 5.00
Begin VB.Form frmDUTSignals 
   BorderStyle     =   3  'Fixed Dialog
   ClientHeight    =   4095
   ClientLeft      =   45
   ClientTop       =   45
   ClientWidth     =   2655
   ControlBox      =   0   'False
   Icon            =   "frmDUTSignals.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4095
   ScaleWidth      =   2655
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdPLLLockSlave 
      Caption         =   "Slave - PLL Lock Out"
      DownPicture     =   "frmDUTSignals.frx":0442
      Height          =   615
      Left            =   120
      Picture         =   "frmDUTSignals.frx":0524
      Style           =   1  'Graphical
      TabIndex        =   19
      ToolTipText     =   "Enables readback of the PLL Lock pin or routes the Masters Sync Clock into the pin."
      Top             =   2280
      UseMaskColor    =   -1  'True
      Visible         =   0   'False
      Width           =   2415
   End
   Begin VB.Frame fraFUDMode 
      Caption         =   "Enable Auto I/O Update"
      Height          =   975
      Left            =   120
      TabIndex        =   16
      Top             =   3000
      Width           =   2415
      Begin VB.CheckBox chkAutoFUDDUT2 
         Caption         =   "Slave - Auto I/O Update"
         Height          =   255
         Left            =   120
         TabIndex        =   18
         ToolTipText     =   "Automatically strobes the I/O update pin after data is loaded into the DUT by clicking the load button."
         Top             =   600
         Width           =   2055
      End
      Begin VB.CheckBox chkAutoFUDDUT1 
         Caption         =   "Master - Auto I/O Update"
         Height          =   375
         Left            =   120
         TabIndex        =   17
         ToolTipText     =   "Automatically strobes the I/O update pin after data is loaded into the DUT by clicking the load button."
         Top             =   240
         Width           =   2175
      End
   End
   Begin VB.CommandButton cmdIOReset 
      Caption         =   "I/O Reset"
      Height          =   435
      Index           =   1
      Left            =   1560
      Style           =   1  'Graphical
      TabIndex        =   6
      Top             =   1740
      Width           =   975
   End
   Begin VB.CommandButton cmdFUD 
      Caption         =   "I/O Update"
      Height          =   435
      Index           =   1
      Left            =   1560
      Style           =   1  'Graphical
      TabIndex        =   7
      Top             =   1200
      Width           =   975
   End
   Begin VB.CheckBox chkLock 
      DownPicture     =   "frmDUTSignals.frx":0606
      Height          =   435
      Index           =   2
      Left            =   1080
      Picture         =   "frmDUTSignals.frx":0750
      Style           =   1  'Graphical
      TabIndex        =   12
      ToolTipText     =   "Makes both DUTS recieve an I/O Reset at the same time."
      Top             =   1740
      Width           =   495
   End
   Begin VB.CheckBox chkLock 
      DownPicture     =   "frmDUTSignals.frx":089A
      Height          =   435
      Index           =   1
      Left            =   1080
      Picture         =   "frmDUTSignals.frx":09E4
      Style           =   1  'Graphical
      TabIndex        =   11
      ToolTipText     =   "Makes both Master and Slave  recieve an I/O Update at the same time, when either button is pressed."
      Top             =   1200
      Width           =   495
   End
   Begin VB.CommandButton cmdReset 
      Caption         =   "Reset"
      Height          =   435
      Index           =   1
      Left            =   1560
      Style           =   1  'Graphical
      TabIndex        =   8
      Top             =   660
      Width           =   975
   End
   Begin VB.CheckBox chkLock 
      DownPicture     =   "frmDUTSignals.frx":0B2E
      Height          =   435
      Index           =   0
      Left            =   1080
      Picture         =   "frmDUTSignals.frx":0C78
      Style           =   1  'Graphical
      TabIndex        =   10
      ToolTipText     =   "Makes both DUTS reset at the same time."
      Top             =   660
      Width           =   495
   End
   Begin VB.PictureBox pbxTitleBar 
      BackColor       =   &H80000002&
      BorderStyle     =   0  'None
      Height          =   255
      Left            =   0
      ScaleHeight     =   255
      ScaleWidth      =   2775
      TabIndex        =   4
      Top             =   0
      Width           =   2775
      Begin VB.Image imgShade 
         Height          =   240
         Left            =   2160
         Picture         =   "frmDUTSignals.frx":0DC2
         Tag             =   "0"
         Top             =   0
         Width           =   240
      End
      Begin VB.Image imgFormCloseButton 
         Height          =   240
         Left            =   2400
         Picture         =   "frmDUTSignals.frx":0F0C
         Tag             =   "0"
         Top             =   0
         Width           =   240
      End
      Begin VB.Label lblCaption 
         BackStyle       =   0  'Transparent
         Caption         =   "DUT Signals"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H80000009&
         Height          =   195
         Left            =   75
         TabIndex        =   5
         Top             =   30
         Width           =   1215
      End
   End
   Begin VB.CommandButton cmdIOReset 
      Caption         =   "I/O Reset"
      Height          =   435
      Index           =   0
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   2
      Top             =   1740
      Width           =   975
   End
   Begin VB.CommandButton cmdFUD 
      Caption         =   "I/O Update"
      Height          =   435
      Index           =   0
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   1
      Top             =   1200
      Width           =   975
   End
   Begin VB.CommandButton cmdReset 
      Caption         =   "Reset"
      Height          =   435
      Index           =   0
      Left            =   120
      Style           =   1  'Graphical
      TabIndex        =   0
      Top             =   660
      Width           =   975
   End
   Begin VB.Image imgLED 
      Height          =   180
      Index           =   0
      Left            =   1080
      Picture         =   "frmDUTSignals.frx":1056
      Top             =   4560
      Width           =   180
   End
   Begin VB.Image imgLED 
      Height          =   180
      Index           =   1
      Left            =   1320
      Picture         =   "frmDUTSignals.frx":1138
      Top             =   4560
      Width           =   180
   End
   Begin VB.Label lblLocked 
      BackColor       =   &H00FF8080&
      Height          =   495
      Index           =   2
      Left            =   90
      TabIndex        =   15
      Top             =   1710
      Visible         =   0   'False
      Width           =   2475
   End
   Begin VB.Label lblLocked 
      BackColor       =   &H00FF8080&
      Height          =   495
      Index           =   1
      Left            =   90
      TabIndex        =   14
      Top             =   1170
      Visible         =   0   'False
      Width           =   2475
   End
   Begin VB.Label lblLocked 
      BackColor       =   &H00FF8080&
      Height          =   495
      Index           =   0
      Left            =   90
      TabIndex        =   13
      Top             =   630
      Visible         =   0   'False
      Width           =   2475
   End
   Begin VB.Image imgFormCloseBtnBfr 
      Height          =   240
      Index           =   1
      Left            =   1320
      Picture         =   "frmDUTSignals.frx":121A
      Top             =   4200
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.Image imgFormCloseBtnBfr 
      Height          =   240
      Index           =   0
      Left            =   1080
      Picture         =   "frmDUTSignals.frx":1364
      Top             =   4200
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.Image imgShadeBfr 
      Height          =   240
      Index           =   3
      Left            =   480
      Picture         =   "frmDUTSignals.frx":14AE
      Top             =   4440
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.Image imgShadeBfr 
      Height          =   240
      Index           =   2
      Left            =   120
      Picture         =   "frmDUTSignals.frx":15F8
      Top             =   4440
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.Image imgShadeBfr 
      Height          =   240
      Index           =   1
      Left            =   480
      Picture         =   "frmDUTSignals.frx":1742
      Top             =   4200
      Width           =   240
   End
   Begin VB.Image imgShadeBfr 
      Height          =   240
      Index           =   0
      Left            =   120
      Picture         =   "frmDUTSignals.frx":188C
      Top             =   4200
      Visible         =   0   'False
      Width           =   240
   End
   Begin VB.Label lblDUT2Signals 
      Alignment       =   2  'Center
      Caption         =   "Slave"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1440
      TabIndex        =   9
      Top             =   360
      Width           =   975
   End
   Begin VB.Label lblDUT1Signals 
      Alignment       =   2  'Center
      Caption         =   "Master"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   360
      Width           =   975
   End
End
Attribute VB_Name = "frmDUTSignals"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private IsUpdating As Boolean
Public Sub RefreshControls()
    'Set the IsUpdating flag
    IsUpdating = True
    
    'Update the controls
    chkAutoFUDDUT1.Value = Abs(CInt(EvBd.AutoIOUpdate_DUT1))
    chkAutoFUDDUT2.Value = Abs(CInt(EvBd.AutoIOUpdate_DUT2))

    'Clear the IsUpdating flag
    IsUpdating = False
End Sub

Private Sub chkAutoFUDDUT1_Click()
    'If the form isn't being updated then set the bit in the registermap
    If Not IsUpdating Then
        EvBd.AutoIOUpdate_DUT1 = CBool(chkAutoFUDDUT1.Value)
        If IsLoaded("frmDebug") Then
            frmDebug.RefreshControls
        End If
    End If
End Sub

Private Sub chkAutoFUDDUT2_Click()
    'If the form isn't being updated then set the bit in the registermap
    If Not IsUpdating Then
        EvBd.AutoIOUpdate_DUT2 = CBool(chkAutoFUDDUT2.Value)
        If IsLoaded("frmDebug") Then
            frmDebug.RefreshControls
        End If
    End If
End Sub

Private Sub chkLock_Click(Index As Integer)
    lblLocked(Index).Visible = CBool(chkLock(Index).Value)
End Sub

Private Sub cmdIOUpdate_Click(Index As Integer)
    If chkLock(1).Value = 1 Then
        'FUD both Duts if clicked if buttons are locked
        EvBd.IOUpdate_DUT1 = abvLow
        EvBd.IOUpdate_DUT2 = abvLow
        EvBd.WriteEvbBuffVal evb56_Buff0_PortD
        EvBd.IOUpdate_DUT1 = abvHigh
        EvBd.IOUpdate_DUT2 = abvHigh
        EvBd.WriteEvbBuffVal evb56_Buff0_PortD
        EvBd.IOUpdate_DUT1 = abvLow
        EvBd.IOUpdate_DUT2 = abvLow
        EvBd.WriteEvbBuffVal evb56_Buff0_PortD
    Else
        If Index = 0 Then
            'FUD Dut 1 if clicked
            EvBd.IOUpdate_DUT1 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff0_PortD
            EvBd.IOUpdate_DUT1 = abvHigh
            EvBd.WriteEvbBuffVal evb56_Buff0_PortD
            EvBd.IOUpdate_DUT1 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff0_PortD
        Else
            'FUD Dut 2 if clicked
            EvBd.IOUpdate_DUT2 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff0_PortD
            EvBd.IOUpdate_DUT2 = abvHigh
            EvBd.WriteEvbBuffVal evb56_Buff0_PortD
            EvBd.IOUpdate_DUT2 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff0_PortD
        End If
    End If
End Sub

Private Sub cmdFUD_Click(Index As Integer)
    If chkLock(1).Value Then
        'If the buttons are locked then do both duts
        EvBd.IOUpdate_DUT1 = abvLow
        EvBd.IOUpdate_DUT2 = abvLow
        EvBd.WriteEvbBuffVal evb56_Buff0_PortD
        
        EvBd.IOUpdate_DUT1 = abvHigh
        EvBd.IOUpdate_DUT2 = abvHigh
        EvBd.WriteEvbBuffVal evb56_Buff0_PortD
    
        EvBd.IOUpdate_DUT1 = abvLow
        EvBd.IOUpdate_DUT2 = abvLow
        EvBd.WriteEvbBuffVal evb56_Buff0_PortD
    Else
        'Otherwize do the appropriate one
        If Index = 0 Then
            EvBd.IOUpdate_DUT1 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff0_PortD
            EvBd.IOUpdate_DUT1 = abvHigh
            EvBd.WriteEvbBuffVal evb56_Buff0_PortD
            EvBd.IOUpdate_DUT1 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff0_PortD
        Else
            EvBd.IOUpdate_DUT2 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff0_PortD
            EvBd.IOUpdate_DUT2 = abvHigh
            EvBd.WriteEvbBuffVal evb56_Buff0_PortD
            EvBd.IOUpdate_DUT2 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff0_PortD
        End If
    End If
End Sub

Private Sub cmdIOReset_Click(Index As Integer)
    If chkLock(2).Value Then
        'If the buttons are locked then do both duts
        EvBd.SyncIO_DUT1 = abvLow
        EvBd.SyncIO_DUT2 = abvLow
        EvBd.WriteEvbBuffVal evb56_Buff1_PortA
        
        EvBd.SyncIO_DUT1 = abvHigh
        EvBd.SyncIO_DUT2 = abvHigh
        EvBd.WriteEvbBuffVal evb56_Buff1_PortA
    
        EvBd.SyncIO_DUT1 = abvLow
        EvBd.SyncIO_DUT2 = abvLow
        EvBd.WriteEvbBuffVal evb56_Buff1_PortA
    Else
        'Otherwize do the appropriate one
        If Index = 0 Then
            EvBd.SyncIO_DUT1 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
            EvBd.SyncIO_DUT1 = abvHigh
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
            EvBd.SyncIO_DUT1 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
        Else
            EvBd.SyncIO_DUT2 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
            EvBd.SyncIO_DUT2 = abvHigh
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
            EvBd.SyncIO_DUT2 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
        End If
    End If

    'Refresh the control windows controls
    frmControl.RefreshControls
End Sub

Private Sub cmdReset_Click(Index As Integer)
    If chkLock(0).Value = 1 Then
        EvBd.ResetDUT 0
    Else
        EvBd.ResetDUT Index + 1
    End If
End Sub

Private Sub Form_Activate()
    'Set back color of title bar to the system color for
    'an active titlebar
    pbxTitleBar.BackColor = &H80000002 'Active Titlebar
    lblCaption.ForeColor = &H80000009 'Active TitlebarText
    'Check the menu used to show the window
    mdiMain.mnuViewDUTSignals.Checked = True
End Sub

Private Sub Form_Deactivate()
    'Set back color of title bar to the system color for
    'an inactive titlebar
    pbxTitleBar.BackColor = &H80000003 'Inactive Titlebar
    lblCaption.ForeColor = &H80000013  'Inactive TitlebarText
End Sub

Private Sub Form_Load()
    'Make this form modeless
    Call MakeFormModeless(Me, mdiMain.hWnd)
    RefreshControls
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    'Do not allow the user to close the window instead
    'just hide it.
    If UnloadMode = vbFormControlMenu Then
        Cancel = 1
    End If
    Me.Hide
        
    mdiMain.mnuViewDUTSignals.Checked = False

    frmControl.IsUpdating = True
    frmControl.chkDutSignals.Value = 0
    frmControl.IsUpdating = False
End Sub

Private Sub imgFormCloseButton_Click()
    Me.Hide
    
    'Uncheck the ViewDUTSignals menu
    mdiMain.mnuViewDUTSignals.Checked = False

    'Update the check box on the control window
    frmControl.IsUpdating = True
    frmControl.chkDutSignals.Value = 0
    frmControl.IsUpdating = False
End Sub

Private Sub imgFormCloseButton_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then
        'Show the pressed state
        imgFormCloseButton.Tag = 1
        imgFormCloseButton.Picture = imgFormCloseBtnBfr(1).Picture
    End If
End Sub

Private Sub imgFormCloseButton_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then
        'Show the pressed state
        imgFormCloseButton.Tag = 1
        imgFormCloseButton.Picture = imgFormCloseBtnBfr(1).Picture
    Else
        'Show the unpressed state
        imgFormCloseButton.Tag = 0
        imgFormCloseButton.Picture = imgFormCloseBtnBfr(0).Picture
    End If
End Sub

Private Sub imgFormCloseButton_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then
        'Show the unpressed state
        imgFormCloseButton.Tag = 0
        imgFormCloseButton.Picture = imgFormCloseBtnBfr(0).Picture
    End If
End Sub

Private Sub imgShade_Click()
    'Check the form state if
    If imgShade.Tag = "0" Or imgShade.Tag = "2" Then
        imgShade.Tag = "1"
        imgShade.Picture = imgShadeBfr(1).Picture
        Me.Height = 345
    Else
        imgShade.Tag = "0"
        imgShade.Picture = imgShadeBfr(0).Picture
        Me.Height = 4185
    End If
End Sub

Private Sub imgShade_DblClick()
    imgShade_Click
End Sub

Private Sub imgShade_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then
        'Select the proper button pressed picture
        If imgShade.Tag = "0" Then
            imgShade.Tag = "2"
        Else
            imgShade.Tag = "3"
        End If
        'Draw the picture
        imgShade.Picture = imgShadeBfr(imgShade.Tag).Picture
    End If
End Sub

Private Sub imgShade_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 1 Then
        'Select the proper button pressed picture
        If imgShade.Tag = "2" Then
            imgShade.Tag = "0"
        Else
            imgShade.Tag = "1"
        End If
        'Draw the picture
        imgShade.Picture = imgShadeBfr(imgShade.Tag).Picture
    End If
End Sub

Private Sub lblCaption_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    pbxTitleBar_MouseDown Button, Shift, X, Y
End Sub

Private Sub pbxTitleBar_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    'Move the form based on the user clicking
    If Button = 1 Then
        ReleaseCapture
        SendMessage Me.hWnd, &HA1, 2, 0&
    End If
End Sub
Private Sub cmdPLLLockSlave_Click()
    Dim sCaptions(0 To 1) As String
    sCaptions(0) = "Slave - PLL Lock Out"
    sCaptions(1) = "Slave  - Sync Enable"
    
    If cmdPLLLockSlave.Caption = sCaptions(0) Then
        cmdPLLLockSlave.Tag = "1"
        cmdPLLLockSlave.Caption = sCaptions(CInt(cmdPLLLockSlave.Tag))
        cmdPLLLockSlave.Picture = imgLED(CInt(cmdPLLLockSlave.Tag)).Picture
        
        'Set the pin value
        EvBd.PLLLock_SyncEnableBar = abvLow
        'If using the USB interface then go ahead and update the pin
        If EvBd.PCInterface = 0 Then
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
        End If
    Else
        cmdPLLLockSlave.Tag = "0"
        cmdPLLLockSlave.Caption = sCaptions(CInt(cmdPLLLockSlave.Tag))
        cmdPLLLockSlave.Picture = imgLED(CInt(cmdPLLLockSlave.Tag)).Picture
    
        'Set the pin value
        EvBd.PLLLock_SyncEnableBar = abvHigh
        'If using the USB interface then go ahead and update the pin
        If EvBd.PCInterface = 0 Then
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
        End If
    End If
End Sub

Public Sub EnableIO(ByVal bVal As Boolean)
'    Me.cmdLoad.Enabled = bVal
'    Me.cmdRead.Enabled = bVal

    cmdReset(0).Enabled = bVal
    cmdReset(1).Enabled = bVal
    cmdFUD(0).Enabled = bVal
    cmdFUD(1).Enabled = bVal
    cmdIOReset(0).Enabled = bVal
    cmdIOReset(1).Enabled = bVal
    cmdPLLLockSlave.Enabled = bVal
End Sub

