VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmCP_ClkDrv_Ctrl 
   BorderStyle     =   1  'Fixed Single
   Caption         =   " Clock Driver Control , Phase - Frequency Detector & Charge Pump"
   ClientHeight    =   5775
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7935
   Icon            =   "frmCP_ClkDrv_Ctrl.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   5775
   ScaleWidth      =   7935
   Begin VB.Frame fraLoad 
      BorderStyle     =   0  'None
      Caption         =   "Frame1"
      Height          =   855
      Left            =   5160
      TabIndex        =   0
      Top             =   4690
      Width           =   2535
      Begin VB.CommandButton cmdRead 
         Caption         =   "READ"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   1320
         Style           =   1  'Graphical
         TabIndex        =   58
         Top             =   360
         Width           =   1215
      End
      Begin VB.CheckBox chkLoadDUT2 
         Caption         =   "Load Slave"
         Height          =   255
         Left            =   0
         TabIndex        =   2
         Top             =   20
         Width           =   1215
      End
      Begin VB.CommandButton cmdLoad 
         Caption         =   "LOAD"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   495
         Left            =   0
         Style           =   1  'Graphical
         TabIndex        =   1
         Top             =   360
         Width           =   1215
      End
   End
   Begin VB.Frame fraDutSettings 
      BorderStyle     =   0  'None
      Height          =   4935
      Index           =   1
      Left            =   240
      TabIndex        =   4
      Top             =   600
      Width           =   7455
      Begin VB.Frame fraClockDriver 
         Caption         =   "(CML) Clock Driver"
         Height          =   4455
         Index           =   0
         Left            =   0
         TabIndex        =   13
         Top             =   0
         Width           =   2535
         Begin VB.CheckBox chkSlewRateControl 
            Caption         =   "Disable Default Surge Current"
            Height          =   375
            Index           =   0
            Left            =   120
            TabIndex        =   70
            Top             =   2520
            Width           =   2295
         End
         Begin VB.CheckBox chkInternalRsetSelect 
            Caption         =   "Use Internal Rset"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   69
            Top             =   2160
            Width           =   2265
         End
         Begin VB.ComboBox cmbClkDriverFEC 
            Height          =   315
            Index           =   0
            ItemData        =   "frmCP_ClkDrv_Ctrl.frx":014A
            Left            =   120
            List            =   "frmCP_ClkDrv_Ctrl.frx":0166
            Style           =   2  'Dropdown List
            TabIndex        =   21
            Top             =   3960
            Width           =   2295
         End
         Begin VB.ComboBox cmbClkDriverREC 
            Height          =   315
            Index           =   0
            ItemData        =   "frmCP_ClkDrv_Ctrl.frx":01B2
            Left            =   120
            List            =   "frmCP_ClkDrv_Ctrl.frx":01CE
            Style           =   2  'Dropdown List
            TabIndex        =   20
            Top             =   3240
            Width           =   2295
         End
         Begin VB.Frame fraClkDrvInputSel 
            Caption         =   "Input Select"
            Height          =   1335
            Index           =   0
            Left            =   120
            TabIndex        =   15
            Top             =   720
            Width           =   2295
            Begin VB.OptionButton optClkDrvInputSel3 
               Appearance      =   0  'Flat
               Caption         =   "OSC Input"
               ForeColor       =   &H80000008&
               Height          =   195
               Index           =   0
               Left            =   120
               TabIndex        =   19
               Tag             =   "11"
               Top             =   840
               Width           =   1575
            End
            Begin VB.OptionButton optClkDrvInputSel2 
               Appearance      =   0  'Flat
               Caption         =   "RF Divider Output"
               ForeColor       =   &H80000008&
               Height          =   195
               Index           =   0
               Left            =   120
               TabIndex        =   18
               Tag             =   "10"
               Top             =   600
               Value           =   -1  'True
               Width           =   1575
            End
            Begin VB.OptionButton optClkDrvInputSel1 
               Appearance      =   0  'Flat
               Caption         =   "RF Divider Input"
               ForeColor       =   &H80000008&
               Height          =   195
               Index           =   0
               Left            =   120
               TabIndex        =   17
               Tag             =   "01"
               Top             =   360
               Width           =   1575
            End
            Begin VB.OptionButton optClkDrvInputSel0 
               Appearance      =   0  'Flat
               Caption         =   "Unused"
               ForeColor       =   &H80000008&
               Height          =   195
               Index           =   0
               Left            =   120
               TabIndex        =   16
               Tag             =   "00"
               Top             =   1080
               Visible         =   0   'False
               Width           =   1575
            End
         End
         Begin VB.CheckBox chkClockDriverPwrDwn 
            Caption         =   "Clock Driver Power Down"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   14
            Top             =   360
            Value           =   1  'Checked
            Width           =   2175
         End
         Begin VB.Label lblClkDriverFEC 
            Caption         =   "Added Falling Surge Current:"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   23
            Top             =   3720
            Width           =   2295
         End
         Begin VB.Label lblClkDriverREC 
            Caption         =   "Added Rising Surge Current:"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   22
            Top             =   3000
            Width           =   2175
         End
      End
      Begin VB.Frame fraChargePump 
         Caption         =   "Phase - Frequency Detector / Charge Pump"
         Height          =   4095
         Index           =   0
         Left            =   2640
         TabIndex        =   5
         Top             =   0
         Width           =   4815
         Begin VB.Frame fraPLL 
            Caption         =   "Pll Lock Detect Ctrl"
            Height          =   1815
            Index           =   0
            Left            =   2880
            TabIndex        =   59
            Top             =   2160
            Width           =   1815
            Begin VB.Frame fraPllLockMode 
               Caption         =   "PLL Lock Mode"
               Height          =   855
               Index           =   0
               Left            =   120
               TabIndex        =   61
               Top             =   840
               Width           =   1575
               Begin VB.OptionButton optPllLockMode1 
                  Appearance      =   0  'Flat
                  Caption         =   "Phase Polarity"
                  ForeColor       =   &H80000008&
                  Height          =   255
                  Index           =   0
                  Left            =   120
                  TabIndex        =   63
                  Tag             =   "1"
                  Top             =   480
                  Width           =   1335
               End
               Begin VB.OptionButton optPllLockMode0 
                  Appearance      =   0  'Flat
                  Caption         =   "Lock Detect"
                  ForeColor       =   &H80000008&
                  Height          =   255
                  Index           =   0
                  Left            =   120
                  TabIndex        =   62
                  Tag             =   "0"
                  Top             =   240
                  Value           =   -1  'True
                  Width           =   1335
               End
            End
            Begin VB.CheckBox chkPllLockDetect 
               Caption         =   "PLL Lock Detect Enable"
               Height          =   375
               Index           =   0
               Left            =   120
               TabIndex        =   60
               Top             =   360
               Width           =   1575
            End
         End
         Begin VB.Frame fraChargPumpCurrent 
            Caption         =   "Charge Pump Current"
            Height          =   1695
            Index           =   1
            Left            =   120
            TabIndex        =   54
            Top             =   1200
            Width           =   2655
            Begin VB.TextBox txtCPRsetVal 
               Alignment       =   1  'Right Justify
               Height          =   285
               Index           =   0
               Left            =   1080
               MaxLength       =   9
               TabIndex        =   75
               Tag             =   "0.500161"
               Text            =   "3090"
               Top             =   360
               Width           =   975
            End
            Begin MSComctlLib.Slider sldChrgPumpCurrent 
               Height          =   495
               Index           =   0
               Left            =   120
               TabIndex        =   55
               Top             =   720
               Width           =   2415
               _ExtentX        =   4260
               _ExtentY        =   873
               _Version        =   393216
               MouseIcon       =   "frmCP_ClkDrv_Ctrl.frx":021A
               LargeChange     =   1
               Max             =   7
               SelStart        =   7
               Value           =   7
               TextPosition    =   1
            End
            Begin VB.Label lblCPRSetValue 
               Caption         =   "RSet Value:"
               Height          =   255
               Index           =   0
               Left            =   120
               TabIndex        =   77
               Top             =   360
               Width           =   975
            End
            Begin VB.Label lblohms 
               Alignment       =   2  'Center
               Caption         =   "W"
               BeginProperty Font 
                  Name            =   "Symbol"
                  Size            =   9.75
                  Charset         =   2
                  Weight          =   400
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   255
               Index           =   0
               Left            =   2040
               TabIndex        =   76
               Top             =   360
               Width           =   255
            End
            Begin VB.Label lblCpCurrent 
               Alignment       =   2  'Center
               BackColor       =   &H80000005&
               BorderStyle     =   1  'Fixed Single
               Caption         =   "4.013 mA"
               Height          =   255
               Index           =   0
               Left            =   720
               TabIndex        =   73
               Top             =   1320
               Width           =   1095
            End
            Begin VB.Label lblCPCSMin 
               Alignment       =   2  'Center
               BackStyle       =   0  'Transparent
               Caption         =   "Min"
               Height          =   255
               Index           =   0
               Left            =   120
               TabIndex        =   57
               Top             =   1200
               Width           =   375
            End
            Begin VB.Label lblCPCSMax 
               Alignment       =   2  'Center
               BackStyle       =   0  'Transparent
               Caption         =   "Max"
               Height          =   255
               Index           =   0
               Left            =   2160
               TabIndex        =   56
               Top             =   1200
               Width           =   375
            End
         End
         Begin VB.Frame fraCP_Polarity 
            Caption         =   "Charge Pump Polarity"
            Height          =   975
            Index           =   0
            Left            =   120
            TabIndex        =   24
            Top             =   3000
            Width           =   2655
            Begin VB.OptionButton optCPPolGndRef 
               Appearance      =   0  'Flat
               Caption         =   "Supply Referenced VCO"
               ForeColor       =   &H80000008&
               Height          =   195
               Index           =   0
               Left            =   120
               TabIndex        =   26
               Tag             =   "1"
               Top             =   600
               Width           =   2415
            End
            Begin VB.OptionButton optCPPolSupplyRef 
               Appearance      =   0  'Flat
               Caption         =   "GND Referenced VCO"
               ForeColor       =   &H80000008&
               Height          =   195
               Index           =   0
               Left            =   120
               TabIndex        =   25
               Tag             =   "0"
               Top             =   360
               Value           =   -1  'True
               Width           =   2415
            End
         End
         Begin VB.ComboBox cmbDivKControl 
            Height          =   315
            Index           =   0
            ItemData        =   "frmCP_ClkDrv_Ctrl.frx":0F24
            Left            =   3240
            List            =   "frmCP_ClkDrv_Ctrl.frx":0F58
            Style           =   2  'Dropdown List
            TabIndex        =   10
            Top             =   1680
            Width           =   1095
         End
         Begin VB.ComboBox cmbDivMControl 
            Height          =   315
            Index           =   0
            ItemData        =   "frmCP_ClkDrv_Ctrl.frx":0F9A
            Left            =   3240
            List            =   "frmCP_ClkDrv_Ctrl.frx":0FCE
            Style           =   2  'Dropdown List
            TabIndex        =   9
            Top             =   960
            Width           =   1095
         End
         Begin VB.CheckBox chkXtalEnable 
            Caption         =   "Enable Crystal Oscillator"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   8
            Top             =   840
            Width           =   2295
         End
         Begin VB.CheckBox chkChrgPmpQuikPwrdwn 
            Caption         =   "Charge Pump Quick Powerdown"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   7
            Top             =   600
            Width           =   2655
         End
         Begin VB.CheckBox chkCPFullPwrDwn 
            Caption         =   "Charge Pump Full Powerdown"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   6
            Top             =   360
            Width           =   2655
         End
         Begin VB.Label lblDivKControl 
            Caption         =   "Divider M:"
            Height          =   255
            Index           =   0
            Left            =   3240
            TabIndex        =   12
            Top             =   1440
            Width           =   735
         End
         Begin VB.Label lblDivMControl 
            Caption         =   "Divider N:"
            Height          =   255
            Index           =   0
            Left            =   3240
            TabIndex        =   11
            Top             =   720
            Width           =   855
         End
      End
   End
   Begin VB.Frame fraDutSettings 
      BorderStyle     =   0  'None
      Height          =   4935
      Index           =   2
      Left            =   240
      TabIndex        =   27
      Top             =   600
      Width           =   7455
      Begin VB.Frame fraChargePump 
         Caption         =   "Phase - Frequency Detector / Charge Pump"
         Height          =   4095
         Index           =   1
         Left            =   2640
         TabIndex        =   39
         Top             =   0
         Width           =   4815
         Begin VB.Frame fraPLL 
            Caption         =   "Pll Lock Detect Ctrl"
            Height          =   1815
            Index           =   1
            Left            =   2880
            TabIndex        =   64
            Top             =   2160
            Width           =   1815
            Begin VB.CheckBox chkPllLockDetect 
               Caption         =   "PLL Lock Detect Enable"
               Height          =   375
               Index           =   1
               Left            =   120
               TabIndex        =   68
               Top             =   360
               Width           =   1575
            End
            Begin VB.Frame fraPllLockMode 
               Caption         =   "PLL Lock Mode"
               Height          =   855
               Index           =   1
               Left            =   120
               TabIndex        =   65
               Top             =   840
               Width           =   1575
               Begin VB.OptionButton optPllLockMode0 
                  Appearance      =   0  'Flat
                  Caption         =   "Lock Detect"
                  ForeColor       =   &H80000008&
                  Height          =   255
                  Index           =   1
                  Left            =   120
                  TabIndex        =   67
                  Tag             =   "0"
                  Top             =   240
                  Value           =   -1  'True
                  Width           =   1335
               End
               Begin VB.OptionButton optPllLockMode1 
                  Appearance      =   0  'Flat
                  Caption         =   "Phase Polarity"
                  ForeColor       =   &H80000008&
                  Height          =   255
                  Index           =   1
                  Left            =   120
                  TabIndex        =   66
                  Tag             =   "1"
                  Top             =   480
                  Width           =   1335
               End
            End
         End
         Begin VB.Frame fraChargPumpCurrent 
            Caption         =   "Charge Pump Current"
            Height          =   1695
            Index           =   0
            Left            =   120
            TabIndex        =   50
            Top             =   1200
            Width           =   2655
            Begin VB.TextBox txtCPRsetVal 
               Alignment       =   1  'Right Justify
               Height          =   285
               Index           =   1
               Left            =   1080
               MaxLength       =   9
               TabIndex        =   78
               Tag             =   "0.500161"
               Text            =   "3090"
               Top             =   360
               Width           =   975
            End
            Begin MSComctlLib.Slider sldChrgPumpCurrent 
               Height          =   495
               Index           =   1
               Left            =   120
               TabIndex        =   51
               Top             =   720
               Width           =   2415
               _ExtentX        =   4260
               _ExtentY        =   873
               _Version        =   393216
               MouseIcon       =   "frmCP_ClkDrv_Ctrl.frx":1010
               LargeChange     =   1
               Max             =   7
               SelStart        =   7
               Value           =   7
            End
            Begin VB.Label lblohms 
               Alignment       =   2  'Center
               Caption         =   "W"
               BeginProperty Font 
                  Name            =   "Symbol"
                  Size            =   9.75
                  Charset         =   2
                  Weight          =   400
                  Underline       =   0   'False
                  Italic          =   0   'False
                  Strikethrough   =   0   'False
               EndProperty
               Height          =   255
               Index           =   1
               Left            =   2040
               TabIndex        =   80
               Top             =   360
               Width           =   255
            End
            Begin VB.Label lblCPRSetValue 
               Caption         =   "RSet Value:"
               Height          =   255
               Index           =   1
               Left            =   120
               TabIndex        =   79
               Top             =   360
               Width           =   975
            End
            Begin VB.Label lblCpCurrent 
               Alignment       =   2  'Center
               BackColor       =   &H80000005&
               BorderStyle     =   1  'Fixed Single
               Caption         =   "4.013 mA"
               Height          =   255
               Index           =   1
               Left            =   720
               TabIndex        =   74
               Top             =   1320
               Width           =   1095
            End
            Begin VB.Label lblCPCSMax 
               Alignment       =   2  'Center
               BackStyle       =   0  'Transparent
               Caption         =   "Max"
               Height          =   255
               Index           =   1
               Left            =   2160
               TabIndex        =   53
               Top             =   1200
               Width           =   375
            End
            Begin VB.Label lblCPCSMin 
               Alignment       =   2  'Center
               BackStyle       =   0  'Transparent
               Caption         =   "Min"
               Height          =   255
               Index           =   1
               Left            =   120
               TabIndex        =   52
               Top             =   1200
               Width           =   375
            End
         End
         Begin VB.CheckBox chkCPFullPwrDwn 
            Caption         =   "Charge Pump Full Powerdown"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   47
            Top             =   360
            Width           =   2655
         End
         Begin VB.CheckBox chkChrgPmpQuikPwrdwn 
            Caption         =   "Charge Pump Quick Powerdown"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   46
            Top             =   600
            Width           =   2655
         End
         Begin VB.CheckBox chkXtalEnable 
            Caption         =   "Enable Crystal Oscillator"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   45
            Top             =   840
            Width           =   2295
         End
         Begin VB.ComboBox cmbDivMControl 
            Height          =   315
            Index           =   1
            ItemData        =   "frmCP_ClkDrv_Ctrl.frx":1D1A
            Left            =   3240
            List            =   "frmCP_ClkDrv_Ctrl.frx":1D4E
            Style           =   2  'Dropdown List
            TabIndex        =   44
            Top             =   960
            Width           =   1095
         End
         Begin VB.ComboBox cmbDivKControl 
            Height          =   315
            Index           =   1
            ItemData        =   "frmCP_ClkDrv_Ctrl.frx":1D90
            Left            =   3240
            List            =   "frmCP_ClkDrv_Ctrl.frx":1DC4
            Style           =   2  'Dropdown List
            TabIndex        =   43
            Top             =   1680
            Width           =   1095
         End
         Begin VB.Frame fraCP_Polarity 
            Caption         =   "Charge Pump Polarity"
            Height          =   975
            Index           =   1
            Left            =   120
            TabIndex        =   40
            Top             =   3000
            Width           =   2655
            Begin VB.OptionButton optCPPolSupplyRef 
               Appearance      =   0  'Flat
               Caption         =   "GND Referenced VCO"
               ForeColor       =   &H80000008&
               Height          =   195
               Index           =   1
               Left            =   120
               TabIndex        =   42
               Tag             =   "0"
               Top             =   360
               Value           =   -1  'True
               Width           =   2415
            End
            Begin VB.OptionButton optCPPolGndRef 
               Appearance      =   0  'Flat
               Caption         =   "Supply Referenced VCO"
               ForeColor       =   &H80000008&
               Height          =   195
               Index           =   1
               Left            =   120
               TabIndex        =   41
               Tag             =   "1"
               Top             =   600
               Width           =   2415
            End
         End
         Begin VB.Label lblDivMControl 
            Caption         =   "Divider N:"
            Height          =   255
            Index           =   1
            Left            =   3240
            TabIndex        =   49
            Top             =   720
            Width           =   855
         End
         Begin VB.Label lblDivKControl 
            Caption         =   "Divider M:"
            Height          =   255
            Index           =   1
            Left            =   3240
            TabIndex        =   48
            Top             =   1440
            Width           =   735
         End
      End
      Begin VB.Frame fraClockDriver 
         Caption         =   "(CML) Clock Driver"
         Height          =   4455
         Index           =   1
         Left            =   0
         TabIndex        =   28
         Top             =   0
         Width           =   2535
         Begin VB.CheckBox chkInternalRsetSelect 
            Caption         =   "Use Internal Rset"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   72
            Top             =   2160
            Width           =   2265
         End
         Begin VB.CheckBox chkSlewRateControl 
            Caption         =   "Disable Default Surge Current"
            Height          =   375
            Index           =   1
            Left            =   120
            TabIndex        =   71
            Top             =   2520
            Width           =   2295
         End
         Begin VB.CheckBox chkClockDriverPwrDwn 
            Caption         =   "Clock Driver Power Down"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   36
            Top             =   360
            Value           =   1  'Checked
            Width           =   2175
         End
         Begin VB.Frame fraClkDrvInputSel 
            Caption         =   "Input Select"
            Height          =   1335
            Index           =   1
            Left            =   120
            TabIndex        =   31
            Top             =   720
            Width           =   2295
            Begin VB.OptionButton optClkDrvInputSel0 
               Appearance      =   0  'Flat
               Caption         =   "Unused"
               ForeColor       =   &H80000008&
               Height          =   195
               Index           =   1
               Left            =   120
               TabIndex        =   35
               Tag             =   "00"
               Top             =   1080
               Width           =   1575
            End
            Begin VB.OptionButton optClkDrvInputSel1 
               Appearance      =   0  'Flat
               Caption         =   "RF Divider Input"
               ForeColor       =   &H80000008&
               Height          =   195
               Index           =   1
               Left            =   120
               TabIndex        =   34
               Tag             =   "01"
               Top             =   360
               Width           =   1575
            End
            Begin VB.OptionButton optClkDrvInputSel2 
               Appearance      =   0  'Flat
               Caption         =   "RF Divider Output"
               ForeColor       =   &H80000008&
               Height          =   195
               Index           =   1
               Left            =   120
               TabIndex        =   33
               Tag             =   "10"
               Top             =   600
               Value           =   -1  'True
               Width           =   1575
            End
            Begin VB.OptionButton optClkDrvInputSel3 
               Appearance      =   0  'Flat
               Caption         =   "OSC Input"
               ForeColor       =   &H80000008&
               Height          =   195
               Index           =   1
               Left            =   120
               TabIndex        =   32
               Tag             =   "11"
               Top             =   840
               Width           =   1575
            End
         End
         Begin VB.ComboBox cmbClkDriverREC 
            Height          =   315
            Index           =   1
            ItemData        =   "frmCP_ClkDrv_Ctrl.frx":1E06
            Left            =   120
            List            =   "frmCP_ClkDrv_Ctrl.frx":1E22
            Style           =   2  'Dropdown List
            TabIndex        =   30
            Top             =   3240
            Width           =   2295
         End
         Begin VB.ComboBox cmbClkDriverFEC 
            Height          =   315
            Index           =   1
            ItemData        =   "frmCP_ClkDrv_Ctrl.frx":1E6E
            Left            =   120
            List            =   "frmCP_ClkDrv_Ctrl.frx":1E8A
            Style           =   2  'Dropdown List
            TabIndex        =   29
            Top             =   3960
            Width           =   2295
         End
         Begin VB.Label lblClkDriverREC 
            Caption         =   "Added Rising Surge Current:"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   38
            Top             =   3000
            Width           =   2295
         End
         Begin VB.Label lblClkDriverFEC 
            Caption         =   "Added Falling Surge Current:"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   37
            Top             =   3720
            Width           =   2295
         End
      End
   End
   Begin MSComctlLib.TabStrip tspDUTSel 
      Height          =   5535
      Left            =   120
      TabIndex        =   3
      Top             =   120
      Width           =   7695
      _ExtentX        =   13573
      _ExtentY        =   9763
      MultiRow        =   -1  'True
      HotTracking     =   -1  'True
      _Version        =   393216
      BeginProperty Tabs {1EFB6598-857C-11D1-B16A-00C0F0283628} 
         NumTabs         =   2
         BeginProperty Tab1 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "Master"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "Slave"
            ImageVarType    =   2
         EndProperty
      EndProperty
   End
End
Attribute VB_Name = "frmCP_ClkDrv_Ctrl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim OldSelTab As Integer
Public IsUpdating As Boolean

Private Sub chkChrgPmpQuikPwrdwn_Click(Index As Integer)
    If IsUpdating = False Then
        'Update the RegisterMap
        EvBd.SetRegMapBitValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 3, chkChrgPmpQuikPwrdwn(Index).Value
    End If
End Sub

Private Sub chkClockDriverPwrDwn_Click(Index As Integer)
    If IsUpdating = False Then
        EvBd.SetRegMapBitValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 20, chkClockDriverPwrDwn(Index).Value
    End If
End Sub

Private Sub chkCPFullPwrDwn_Click(Index As Integer)
    If IsUpdating = False Then
        'Update the RegisterMap
        EvBd.SetRegMapBitValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 4, chkCPFullPwrDwn(Index).Value
    End If
End Sub

Private Sub chkInternalRsetSelect_Click(Index As Integer)
    If IsUpdating = False Then
        'Update the RegisterMap
        EvBd.SetRegMapBitValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 32, chkInternalRsetSelect(Index).Value
    End If
End Sub

Private Sub chkLoadDUT2_Click()
    If chkLoadDUT2.Value = 1 Then
        'Disable the tabs so that the user can't select DUT2's tab
        tspDUTSel.Enabled = False
        'Make sure that the control window is checked too
        If frmControl.chkLoadDUT2.Value = 0 Then
            frmControl.chkLoadDUT2.Value = 1
        End If
    Else
        tspDUTSel.Enabled = True
        frmCP_ClkDrv_Ctrl.RefreshControls
        'Make sure that the control window is checked too
        If frmControl.chkLoadDUT2.Value = 1 Then
            frmControl.chkLoadDUT2.Value = 0
        End If
    End If
End Sub


Private Sub chkSlewRateControl_Click(Index As Integer)
    If IsUpdating = False Then
        'Update the RegisterMap
        EvBd.SetRegMapBitValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 17, chkSlewRateControl(Index).Value
    End If
End Sub

Private Sub chkXtalEnable_Click(Index As Integer)
    If IsUpdating = False Then
        'Update the RegisterMap
        EvBd.SetRegMapBitValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR1, 5, chkXtalEnable(Index).Value
    End If
End Sub

Private Sub cmbClkDriverFEC_Click(Index As Integer)
    Dim sCFR2 As String
    Dim sLP As String
    Dim sRP As String
    Dim sNewVal As String

    'Only update the regmap value if the UI isn't updating
    If IsUpdating = False Then
        'Get the current regmap value
        sCFR2 = EvBd.GetRegMapValue(Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2)
        sLP = Left(sCFR2, 11)
        sRP = Right(sCFR2, 26)
        'Format the value as a binary string
        sNewVal = cbaseDec2Bin(cmbClkDriverFEC(Index).ListIndex, 3)
        EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, sLP & sNewVal & sRP
    End If
End Sub

Private Sub cmbClkDriverREC_Click(Index As Integer)
    Dim sCFR2 As String
    Dim sLP As String
    Dim sRP As String
    Dim sNewVal As String

    'Only update the regmap value if the UI isn't updating
    If IsUpdating = False Then
        'Get the current regmap value
        sCFR2 = EvBd.GetRegMapValue(Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2)
        sLP = Left(sCFR2, 8)
        sRP = Right(sCFR2, 29)
        'Format the value as a binary string
        sNewVal = sLP & cbaseDec2Bin(cmbClkDriverREC(Index).ListIndex, 3) & sRP
        EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, sNewVal
    End If
End Sub

Private Sub cmbDivKControl_Click(Index As Integer)
    Dim sCFR2 As String
    Dim sLP As String
    Dim sRP As String
    Dim sNewVal As String

    'Only update the regmap value if the UI isn't updating
    If IsUpdating = False Then
        'Get the current regmap value
        sCFR2 = EvBd.GetRegMapValue(Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2)
        sLP = Left(sCFR2, 28)
        sRP = Right(sCFR2, 8)
        'Format the value as a binary string
        sNewVal = sLP & cbaseDec2Bin(cmbDivKControl(Index).ListIndex, 4) & sRP
        EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, sNewVal
    End If
End Sub

Private Sub cmbDivMControl_Click(Index As Integer)
    Dim sCFR2 As String
    Dim sLP As String
    Dim sRP As String
    Dim sNewVal As String

    'Only update the regmap value if the UI isn't updating
    If IsUpdating = False Then
        'Get the current regmap value
        sCFR2 = EvBd.GetRegMapValue(Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2)
        sLP = Left(sCFR2, 24)
        sRP = Right(sCFR2, 12)
        'Format the value as a binary string
        sNewVal = cbaseDec2Bin(cmbDivMControl(Index).ListIndex, 4)
        EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, sLP & sNewVal & sRP
    End If
End Sub

Private Sub cmdLoad_Click()
    'Set the mouse pointer to indicate that the software is busy
    Screen.MousePointer = 11
    
    frmControl.LoadControlRegs

    'Turn off the flashing load button
    cmdLoad.BackColor = FlashColorOff

    'Set the mouse pointer back to default
    Screen.MousePointer = 0
End Sub

Private Sub cmdRead_Click()
    frmControl.ReadControlRegs

    'Turn off the flashing load button
    cmdLoad.BackColor = FlashColorOff
End Sub

Private Sub Form_Activate()
    'Check the menu used to show the window
    mdiMain.mnuViewCpnClkDrvWindow.Checked = True
End Sub

Private Sub Form_Load()
    'Initialize the tab selection variable
    OldSelTab = 1
    
    'Refresh the controls
    RefreshControls
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    'Do not allow the user to close the window instead
    'just hide it.
    If UnloadMode = vbFormControlMenu Then
        Cancel = 1
    End If
    Me.Hide
    'Check the menu used to show the window
    mdiMain.mnuViewCpnClkDrvWindow.Checked = False
    
    frmControl.IsUpdating = True
    frmControl.chkCP_Clk_Drv_Ctrl.Value = 0
    frmControl.IsUpdating = False
End Sub

Private Sub optClkDrvInputSel0_Click(Index As Integer)
    Dim sCFR2 As String
    Dim sLP As String
    Dim sRP As String
    Dim sNewVal As String

    'Only update the regmap value if the UI isn't updating
    If IsUpdating = False Then
        'Get the current regmap value
        sCFR2 = EvBd.GetRegMapValue(Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2)
        sLP = Left(sCFR2, 20)
        sRP = Right(sCFR2, 18)
        sNewVal = CStr(optClkDrvInputSel0(Index).Tag)
        EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, sLP & sNewVal & sRP
    End If
End Sub

Private Sub optClkDrvInputSel1_Click(Index As Integer)
    Dim sCFR2 As String
    Dim sLP As String
    Dim sRP As String
    Dim sNewVal As String

    'Only update the regmap value if the UI isn't updating
    If IsUpdating = False Then
        'Get the current regmap value
        sCFR2 = EvBd.GetRegMapValue(Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2)
        sLP = Left(sCFR2, 20)
        sRP = Right(sCFR2, 18)
        sNewVal = CStr(optClkDrvInputSel1(Index).Tag)
        EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, sLP & sNewVal & sRP
    End If
End Sub

Private Sub optClkDrvInputSel2_Click(Index As Integer)
    Dim sCFR2 As String
    Dim sLP As String
    Dim sRP As String
    Dim sNewVal As String

    'Only update the regmap value if the UI isn't updating
    If IsUpdating = False Then
        'Get the current regmap value
        sCFR2 = EvBd.GetRegMapValue(Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2)
        sLP = Left(sCFR2, 20)
        sRP = Right(sCFR2, 18)
        sNewVal = CStr(optClkDrvInputSel2(Index).Tag)
        EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, sLP & sNewVal & sRP
    End If
End Sub

Private Sub optClkDrvInputSel3_Click(Index As Integer)
    Dim sCFR2 As String
    Dim sLP As String
    Dim sRP As String
    Dim sNewVal As String

    'Only update the regmap value if the UI isn't updating
    If IsUpdating = False Then
        'Get the current regmap value
        sCFR2 = EvBd.GetRegMapValue(Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2)
        sLP = Left(sCFR2, 20)
        sRP = Right(sCFR2, 18)
        sNewVal = CStr(optClkDrvInputSel3(Index).Tag)
        EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, sLP & sNewVal & sRP
    End If
End Sub

Private Sub optCPPolGndRef_Click(Index As Integer)
    If IsUpdating = False Then
        'Update the RegisterMap
        EvBd.SetRegMapBitValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 5, CLng(optCPPolGndRef(Index).Tag)
    End If
End Sub

Private Sub optCPPolSupplyRef_Click(Index As Integer)
    If IsUpdating = False Then
        'Update the RegisterMap
        EvBd.SetRegMapBitValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 5, CLng(optCPPolSupplyRef(Index).Tag)
    End If
End Sub

Private Sub sldChrgPumpCurrent_Change(Index As Integer)
    'Update the charge pump current label
    lblCpCurrent(Index).Caption = Format((sldChrgPumpCurrent(Index).Value + 1) * (CDbl(txtCPRsetVal(Index).Tag)), "0.000") & " mA"
End Sub

Private Sub sldChrgPumpCurrent_Scroll(Index As Integer)
    Dim sCFR2 As String
    Dim sLP As String
    Dim sRP As String
    Dim sNewVal As String

    'Only update the regmap value if the UI isn't updating
    If IsUpdating = False Then
        'Calculate the chargepump current
        lblCpCurrent(Index).Caption = Format((sldChrgPumpCurrent(Index).Value + 1) * (CDbl(txtCPRsetVal(Index).Tag)), "0.000") & " mA"
        sldChrgPumpCurrent(Index).Text = lblCpCurrent(Index).Caption
        
        'Get the current regmap value
        sCFR2 = EvBd.GetRegMapValue(Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2)
        sLP = Left(sCFR2, 37)
'        sRP = Right(sCFR2, 18)
        sNewVal = cbaseDec2Bin(sldChrgPumpCurrent(Index).Value, 3)
        EvBd.SetRegMapValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, sLP & sNewVal & sRP
    End If
End Sub

Private Sub tspDUTSel_Click()
    If tspDUTSel.SelectedItem.Index = OldSelTab Then
        'Exit the subroutine the tab is allready selected
        Exit Sub
    Else
        ' Otherwise, hide old frame, show new.
        fraDutSettings(tspDUTSel.SelectedItem.Index).Visible = True
        fraDutSettings(OldSelTab).Visible = False
        ' Set mintCurFrame to new value.
        OldSelTab = tspDUTSel.SelectedItem.Index
    End If
End Sub

Public Sub RefreshControls()
    Dim cntr As Integer
    Dim cntr2 As Integer
    Dim sCFR1 As String
    Dim sCFR2 As String
    Dim TmpVal As Variant
    
    'Set the is updating flag
    IsUpdating = True
    
    For cntr = 0 To 1
        'Get the current register map values
        sCFR1 = EvBd.GetRegMapValue(cntr + 1, rm9956_NewRegMapVals, RMA9956_CFR1)
        sCFR2 = EvBd.GetRegMapValue(cntr + 1, rm9956_NewRegMapVals, RMA9956_CFR2)
        
        chkCPFullPwrDwn(cntr).Value = EvBd.GetRegMapBitValue(cntr + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 4)
        chkChrgPmpQuikPwrdwn(cntr).Value = EvBd.GetRegMapBitValue(cntr + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 3)
        chkXtalEnable(cntr).Value = EvBd.GetRegMapBitValue(cntr + 1, rm9956_NewRegMapVals, RMA9956_CFR1, 5)
        cmbDivMControl(cntr).ListIndex = cbaseBinS2Dec(Mid(sCFR2, 25, 4))
        cmbDivKControl(cntr).ListIndex = cbaseBinS2Dec(Mid(sCFR2, 29, 4))
        sldChrgPumpCurrent(cntr).Value = cbaseBinS2Dec(Mid(sCFR2, 38, 3))
        chkInternalRsetSelect(cntr).Value = EvBd.GetRegMapBitValue(cntr + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 32)
        chkSlewRateControl(cntr).Value = EvBd.GetRegMapBitValue(cntr + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 17)
        
        'Recalculate the charge pump current out
        txtCPRsetVal_Change cntr
        
        If EvBd.GetRegMapBitValue(cntr + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 5) = abvLow Then
            optCPPolSupplyRef(cntr).Value = True
        Else
            optCPPolGndRef(cntr).Value = True
        End If
        
        chkPllLockDetect(cntr).Value = EvBd.GetRegMapBitValue(cntr + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 25)
        If EvBd.GetRegMapBitValue(cntr + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 24) = abvLow Then
            optPllLockMode0(cntr).Value = True
        Else
            optPllLockMode1(cntr).Value = True
        End If
        
        chkClockDriverPwrDwn(cntr).Value = EvBd.GetRegMapBitValue(cntr + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 20)
        
        TmpVal = cbaseBinS2Dec(Mid(sCFR2, 21, 2))
        Select Case TmpVal
            Case 0:
                optClkDrvInputSel0(cntr).Value = True
            Case 1:
                optClkDrvInputSel1(cntr).Value = True
            Case 2:
                optClkDrvInputSel2(cntr).Value = True
            Case 3:
                optClkDrvInputSel3(cntr).Value = True
        End Select
        
        cmbClkDriverREC(cntr).ListIndex = cbaseBinS2Dec(Mid(sCFR2, 9, 3))
        cmbClkDriverFEC(cntr).ListIndex = cbaseBinS2Dec(Mid(sCFR2, 12, 3))
    Next cntr
    
    IsUpdating = False
End Sub
Private Sub chkPllLockDetect_Click(Index As Integer)
    'Only update the regmap value if the UI isn't updating
    If IsUpdating = False Then
        EvBd.SetRegMapBitValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 25, chkPllLockDetect(Index).Value
    End If
End Sub

Private Sub optPllLockMode0_Click(Index As Integer)
    If IsUpdating = False Then
        'Update the RegisterMap
        EvBd.SetRegMapBitValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 24, CLng(optPllLockMode0(Index).Tag)
    End If
End Sub

Private Sub optPllLockMode1_Click(Index As Integer)
    If IsUpdating = False Then
        'Update the RegisterMap
        EvBd.SetRegMapBitValue Index + 1, rm9956_NewRegMapVals, RMA9956_CFR2, 24, CLng(optPllLockMode1(Index).Tag)
    End If
End Sub

Public Sub EnableIO(ByVal bVal As Boolean)
    Me.cmdLoad.Enabled = bVal
    Me.cmdRead.Enabled = bVal
End Sub

Private Sub txtCPRsetVal_Change(Index As Integer)
    If IsNumeric(txtCPRsetVal(Index).Text) Then
        If CDbl(txtCPRsetVal(Index).Text) <> 0 Then
            'Calculate the cp output current and store it in the tag property
            txtCPRsetVal(Index).Tag = 1.55 / CDbl(txtCPRsetVal(Index).Text) * 1000
            
            'Calculate the chargepump current and update the display
            'lblCpCurrent(Index).Caption = Format(sldChrgPumpCurrent(Index).Value + 1 * CDbl(txtCPRsetVal(Index).Tag), "0.000") & " mA"
            lblCpCurrent(Index).Caption = Format((sldChrgPumpCurrent(Index).Value + 1) * (CDbl(txtCPRsetVal(Index).Tag)), "0.000") & " mA"
        End If
    End If
End Sub

Private Sub txtCPRsetVal_Validate(Index As Integer, Cancel As Boolean)
    If IsNumeric(txtCPRsetVal(Index).Text) Then
        If CDbl(txtCPRsetVal(Index).Text) <> 0 Then
        Else
            MsgBox "Enter a Charge Pump Rset Value!", vbCritical + vbApplicationModal + vbOKOnly, "Invalid Charge Pump Rset Value"
            Cancel = True
        End If
    Else
        MsgBox "Enter a Charge Pump Rset Value!", vbCritical + vbApplicationModal + vbOKOnly, "Invalid Charge Pump Rset Value"
        Cancel = True
    End If
End Sub
