VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsEZUSB"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Private Declare Function CreateFile Lib "kernel32" Alias "CreateFileA" (ByVal lpFileName As String, ByVal dwDesiredAccess As Long, ByVal dwShareMode As Long, lpSecurityAttributes As Any, ByVal dwCreationDisposition As Long, ByVal dwFlagsAndAttributes As Long, ByVal hTemplateFile As Long) As Long
Private Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long
Private Declare Function GetSystemDirectory Lib "kernel32.dll" Alias "GetSystemDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long

Private Declare Function DeviceIoControl Lib "kernel32" _
(ByVal hDevice As Long, ByVal dwIoControlCode As Long, _
lpInBuffer As Any, ByVal nInBufferSize As Long, lpOutBuffer As Any, _
ByVal nOutBufferSize As Long, lpBytesReturned As Long, _
ByVal lpOverlapped As Long) As Long

Private Declare Function GetLastError Lib "kernel32" () As Long

Private Const GENERIC_READ = &H80000000
Private Const GENERIC_WRITE = &H40000000
Private Const FILE_SHARE_READ = &H1
Private Const FILE_SHARE_WRITE = &H2
Private Const OPEN_EXISTING = 3

Private Const METHOD_BUFFERED = 0
Private Const METHOD_IN_DIRECT = 1
Private Const METHOD_OUT_DIRECT = 2

Private Const MAX_USB_DEV_NUMBER = 9

Public Enum EZUSB_ReadOrWrite
    ezWrite = 3
    ezRead = 5
End Enum

Private Type SECURITY_ATTRIBUTES
    nLength As Long
    lpSecurityDescriptor As Long
    bInheritHandle As Boolean
End Type

Private Const Ezusb_IOCTL_INDEX = &H800

Private Const IOCTL_Ezusb_GET_PIPE_INFO = _
    &H220000 + METHOD_BUFFERED + (Ezusb_IOCTL_INDEX + 0) * 4

Private Const IOCTL_Ezusb_GET_DEVICE_DESCRIPTOR = _
    &H220000 + METHOD_BUFFERED + (Ezusb_IOCTL_INDEX + 1) * 4

Private Const IOCTL_EZUSB_BULK_READ = _
    &H220000 + METHOD_OUT_DIRECT + (Ezusb_IOCTL_INDEX + 19) * 4

Private Const IOCTL_EZUSB_BULK_WRITE = _
    &H220000 + METHOD_IN_DIRECT + (Ezusb_IOCTL_INDEX + 20) * 4

'Added by Shane Lambeth
'Private Const IOCTL_EZUSB_VENDOR_REQUEST = _
'    &H220000 + METHOD_IN_DIRECT + (Ezusb_IOCTL_INDEX + 5) * 4

Private Const IOCTL_EZUSB_VENDOR_OR_CLASS_REQUEST = _
    &H220000 + METHOD_IN_DIRECT + (Ezusb_IOCTL_INDEX + 22) * 4

Private Const IOCTL_Ezusb_GET_STRING_DESCRIPTOR = _
    &H220000 + METHOD_BUFFERED + (Ezusb_IOCTL_INDEX + 17) * 4

'End Added by Shane Lambeth

'Used by IsWinNT
Private Type OSVERSIONINFO
        dwOSVersionInfoSize As Long 'Set to 148
        dwMajorVersion As Long
        dwMinorVersion As Long
        dwBuildNumber As Long
        dwPlatformId As Long
        szCSDVersion As String * 128      '  Maintenance string for PSS usage
End Type

Private Const VER_PLATFORM_WIN32_NT = 2
Private Const VER_PLATFORM_WIN32_WINDOWS = 1
Private Const VER_PLATFORM_WIN32s = 0
Private Declare Function GetVersionEx Lib "kernel32" Alias "GetVersionExA" (ByRef lpVersionInformation As OSVERSIONINFO) As Long
'End Used by IsWinNT

'Gets windows directory
Private Declare Function GetWindowsDirectory Lib "kernel32" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long

'local variable(s) to hold property value(s)
Private mvarDeviceCount As Integer 'local copy
'local variable(s) to hold property value(s)
Private mvarVendorID As Long 'local copy
Private mvarProductID As Long 'local copy
Private mvarDeviceList() As String
'local variable(s) to hold property value(s)
Private mvarDriverName As String 'local copy
Private DevSelected As Boolean

'Defualt values for properties
Const mdef_VendorID = &H456
Const mdef_ProductID = &H0
Const mdef_DriverName = ""
Const mdef_DeviceCount = 0
Const mdef_VerboseIO = False
'local variable(s) to hold property value(s)
Private mvarUSBDriverIsInstalled As Boolean 'local copy
'local variable(s) to hold property value(s)
Private mvarVerboseIO As Boolean 'local copy
Private mvarUSBDevPrefix As String


Public Property Let VerboseIO(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.VerboseIO = 5
    mvarVerboseIO = vData
End Property


Public Property Get VerboseIO() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.VerboseIO
    VerboseIO = mvarVerboseIO
End Property



Public Property Let USBDriverIsInstalled(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.USBDriverIsInstalled = 5
    mvarUSBDriverIsInstalled = vData
End Property


Public Property Get USBDriverIsInstalled() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.USBDriverIsInstalled
    USBDriverIsInstalled = mvarUSBDriverIsInstalled
End Property


'Gets the driver name for the indexed device
'returns an empty string if index is invalid
Public Function GetDriverName(ByVal Index As Integer) As String
    If Index < mvarDeviceCount Then
        'Return the requested value
        GetDriverName = mvarDeviceList(Index)
    Else
        'Return an empty string
        GetDriverName = ""
    End If
End Function

'Gets the currently selected index
Public Function GetDeviceIndex(ByVal sDrvrName As String) As Integer
    Dim cntr As Integer
    GetDeviceIndex = -1
    
    For cntr = 0 To mvarDeviceCount - 1
        If mvarDeviceList(cntr) = sDrvrName Then
            'Return the index the device was found at
            GetDeviceIndex = cntr
            'Exit the function
            Exit Function
        End If
    Next cntr
End Function


Public Sub VendorRequest(ByVal Request As Byte, ByVal Value As Integer, ByVal Index As Integer, ByVal bDir As Byte, Data() As Byte, DataLen As Long)
Dim hDriver As Long     ' handle to device driver

Dim lBytesReturned

Dim myRequest As VENDOR_OR_CLASS_REQUEST_CONTROL

Dim buf(7) As Byte

    hDriver = CreateFile(mvarDriverName, (GENERIC_READ Or GENERIC_WRITE), (FILE_SHARE_READ Or FILE_SHARE_WRITE), ByVal 0, OPEN_EXISTING, 0&, 0)

    With myRequest
        .bRequest = Request ' EEProm Load
        ' next two values need to be unsigned shorts
        If Value > 32767 Then
            .uiValue = CInt(Value - &H10000)
        Else
            .uiValue = Value
        End If

        If Index > 32767 Then
            .uiIndex = CInt(Index - &H10000)
        Else
            .uiIndex = Index
        End If
        
        .bDirection = bDir ' 0 = OUT, 1 = IN
        .bRecepient = 0
        .bRequestType = 2
        .bRequestTypeReservedBits = 0
    End With
    
    result = DeviceIoControl(hDriver, _
                            IOCTL_EZUSB_VENDOR_OR_CLASS_REQUEST, _
                            myRequest, _
                            Len(myRequest), _
                            Data(0), _
                            DataLen, _
                            DataLen, _
                            0)

   If result = 0 Then

      ' do some error handling routine
   End If

   CloseHandle (hDriver)
End Sub

Public Function OpenDriver(ByVal sDriverName As String) As Long
    
    ' get handle to EZ-USB driver
    '
    '   IN  sDriverName     symbolic link name assigned during enumeration
    '
    '   returns:            driver handle
    '
    '   called by:          BulkXFer
    '                       GetPipeInfo
    
    Dim result As Long
    Dim DrvrName As String
    
    DrvrName = "\\.\" & sDriverName
    
    result = CreateFile(DrvrName, (GENERIC_READ Or GENERIC_WRITE), (FILE_SHARE_READ Or FILE_SHARE_WRITE), ByVal 0, OPEN_EXISTING, 0&, 0)
    
    If result < 0 Then
        
        result = GetLastError()
    
    End If
    
    OpenDriver = result
End Function

Private Function GetPipeInfo(pi As EZUSB_InterfaceInformationType, Optional optDrvrName, Optional lDriverHandle) As Long

    '   retrieves information about available pipes
    '
    'Inputs
    'optDrvrName - Symbolic name of the device to use, if not supplied the function
    '              uses the internal mvarDriverName variable.
    'lDriverHandle - Driver handle to a previously opened instance of a driver
    '                If this parameter is passed, the handle will be left
    '                open for the user to close later.
    '   OUT pi          holds information about pipes after successful return
    '
    '   returns:        1 = successful call
    '                   0 = unsuccessful call
    
    Dim result As Long
    Dim hDriverHandle As Long
    Dim lBytesReturned As Long
    
    If Not (IsMissing(optDrvrName)) Then
        hDriverHandle = OpenDriver(optDrvrName)
    Else
        'If the user provided a handle then use it
        If Not (IsMissing(lDriverHandle)) Then
            'Use the supplied handle
            hDriverHandle = CLng(lDriverHandle)
        Else
            ' get a handle to the requested driver
            hDriverHandle = OpenDriver(mvarDriverName)
        End If
    End If
'    hDriverHandle = OpenDriver(mvarDriverName)
    
    GetPipeInfo = 0
    
    'See if we were able to open a handle to the driver
    If hDriverHandle > 0 Then
        'Get the pipe information
        result = DeviceIoControl(hDriverHandle, IOCTL_Ezusb_GET_PIPE_INFO, pi, Len(pi), pi, Len(pi), lBytesReturned, 0)
        
        'Close the driver handle if the user supplied only a drivername
        If IsMissing(lDriverHandle) Then
            'Use the supplied handle
            CloseHandle (hDriverHandle)
        End If
    
    End If
    
    GetPipeInfo = result

End Function

Public Function BulkXfer(ByVal Pipe As EZUSB_ReadOrWrite, XferBuff() As Byte, XferBuffLen As Long, Optional optDrvrName) As Long

    '   transfers a block of bytes to or from EZ-USB device using Bulk Transfer
    '
    '   IN  strDriver   symbolic link name assigned to device driver, e.g. "Ezusb-0"
    '   IN  pipe        numeric pipe id
    '   I/O buffer      byte array for data
    '   I/O dataLen     integer variable containing number of valid data bytes in buffer
    '
    '   returns:        1 = successful transfer
    '                   0 = unsuccessful transfer; caller should call EZGetLastError function
    
    
    Dim hDriverHandle As Long
    Dim result As Long
    Dim btc As EZUSB_BulkTransferControlType
    Dim pi As EZUSB_InterfaceInformationType
    Dim usbDD As EZUSB_DeviceDescriptorType
    Dim lBytesReturned As Long
    
    If Not (IsMissing(optDrvrName)) Then
        hDriverHandle = OpenDriver(optDrvrName)
    Else
        ' get a handle to the requested driver
        hDriverHandle = OpenDriver(mvarDriverName)
    End If
    
    If hDriverHandle > 0 Then

        ' is ep_pair.hex loaded into the EZ-USB firmware?
        result = DeviceIoControl(hDriverHandle, IOCTL_Ezusb_GET_DEVICE_DESCRIPTOR, usbDD, Len(usbDD), usbDD, Len(usbDD), lBytesReturned, 0)
        
        If result = 0 Then: BulkXfer = result
        
        'VID and PID set up by firmware must match VID and PID specified by user
        If usbDD.iVendorID <> mvarVendorID And usbDD.iProductID <> mvarProductID Then
            If mvarVerboseIO = True Then
                MsgBox "Error at PID/VID", vbOKOnly, "Error"
            End If
            Exit Function
        
        End If
        
         ' get data about caller's pipe
        result = GetPipeInfo(pi, , hDriverHandle)
        
        If result = 0 Then
            If mvarVerboseIO = True Then
                MsgBox "Error at caller's pipe", vbOKOnly, "Error"
            End If
            Exit Function
        End If
        
        ' is caller's pipe legal?
        If pi.lNumberOfPipes <= Pipe Then
            If mvarVerboseIO = True Then
                MsgBox "Error Illegal Pipe", vbOKOnly, "Error"
            End If
            Exit Function
        Else ' put the pipe id into the BulkTransferControl structure
            btc.lPipeNum = Pipe
        End If
        
        ' determine the endpoint direction and do the device call
        If (pi.Pipes(Pipe).bEndpointAddress > 128) Then
            result = DeviceIoControl(hDriverHandle, IOCTL_EZUSB_BULK_READ, btc, Len(btc), XferBuff(0), XferBuffLen, XferBuffLen, 0)
        Else
            result = DeviceIoControl(hDriverHandle, IOCTL_EZUSB_BULK_WRITE, btc, Len(btc), XferBuff(0), XferBuffLen, XferBuffLen, 0)
        End If
        
         ' close the driver
        CloseHandle (hDriverHandle)
        
        BulkXfer = result
    
    Else
        If mvarVerboseIO = True Then
            MsgBox "Error bad driver", vbOKOnly, "Error"
        End If
    End If

End Function

Public Property Let DriverName(ByVal vData As String)
Attribute DriverName.VB_Description = "Returns the name of the driver used to access the currently selected device."
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.DriverName = 5
'    mvarDriverName = vData
    MsgBox "Sorry, this is a read only property!", vbInformation, "Can not set property value!"
End Property


Public Property Get DriverName() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.DriverName
    DriverName = mvarDriverName
End Property




Public Property Let ProductID(ByVal vData As Long)
Attribute ProductID.VB_Description = "Product ID for the USB Device to be used."
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.ProductID = 5
    mvarProductID = vData
End Property


Public Property Get ProductID() As Long
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.ProductID
    ProductID = mvarProductID
End Property



Public Property Let VendorID(ByVal vData As Long)
Attribute VendorID.VB_Description = "Vendor ID for USB Device should always be 0456 Hex which is Analog Devices' VendorID."
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.VendorID = 5
    mvarVendorID = vData
End Property


Public Property Get VendorID() As Long
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.VendorID
    VendorID = mvarVendorID
End Property



Public Property Let DeviceCount(ByVal vData As Integer)
Attribute DeviceCount.VB_Description = "The current number of devices in the device list."
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.DeviceCount = 5
'    mvarDeviceCount = vData
    MsgBox "Sorry, this is a read only property!", vbInformation, "Can not set property value!"
End Property


Public Property Get DeviceCount() As Integer
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.DeviceCount
    DeviceCount = mvarDeviceCount
End Property

'Selects a device from the device list, *note-Must call get devices first
'Input Values:
'HostAppID - The host application hwnd property.
'bSeize - True = Take control of the device indexed, False = Do not take control.
'Returns Values:
'-1 - Device is inuse
'0 - Unsuccessfull
'1  - Successfull, device selected

Public Function SelectDevice(ByVal Index As Integer, Optional HostAppID, Optional bSieze) As Integer
Attribute SelectDevice.VB_Description = "Selects a device in the device list."
    Dim HostHwnd As Long
    Dim sFirmwareVer As String
    Dim OldIndex As Integer 'Variable to store the old devices index
    Dim bSiezeDevice As Boolean
    
    If Not (IsMissing(bSieze)) Then
        If IsNumeric(bSieze) Then
            bSiezeDevice = CBool(bSieze)
        End If
    Else
        bSieze = False
    End If
    
    If Not (IsMissing(HostAppID)) Then
        If IsNumeric(HostAppID) Then
            'This HostId appears to be valid
            HostHwnd = CLng(HostAppID)
        Else
            'Invalid hostappid passed
            HostHwnd = 0
        End If
    End If
    
    'Get the old device index
    OldIndex = GetDeviceIndex(mvarDriverName)
    
    If Index <= mvarDeviceCount - 1 Then
        mvarDriverName = mvarDeviceList(Index)
        DevSelected = True
        SelectDevice = 1
        'Get the firmware version
        sFirmwareVer = GetFirmWareVersion(Index)
        If CDbl(sFirmwareVer) >= 0.3 Then 'And bSieze
            'Claim the device as yours
            SetHostID Index, HostHwnd
        End If
        
        'Free up the old evalboard
        If OldIndex <> -1 And Index <> OldIndex Then
            If CDbl(GetFirmWareVersion(OldIndex)) >= 0.3 Then ' And bSieze
                SetHostID OldIndex, 0
            End If
        End If
    Else
        'Return invalid device error
        SelectDevice = 0
        Exit Function
    End If
End Function

'Finds all EZ-USB devices with a VID that matches the VendorID Property and PID that
'matches the ProductID property
'Returns Values:
'-1 - Error getting device descriptor
'1  - Successfull, a device was found
'0  - Unsuccessfull, no devices were found
Public Function GetDevices() As Integer
    Dim Index As Integer
    Dim sDriverName As String
    Dim hDriver As Long
    Dim I2 As Integer
    Dim result As Long
    Dim usbDD As EZUSB_DeviceDescriptorType
    Dim lBytesReturned As Long
    Dim OldDrvSel As String
    Dim cntr As Integer
    Dim OldDrvFnd As Boolean
    
    OldDrvFnd = False
    
    'Initialize I2
    I2 = 0
    
    If DevSelected Then
        OldDrvSel = mvarDriverName
    End If
    
    For Index = 0 To MAX_USB_DEV_NUMBER - 1
        'Build the symbolic link to the device
        sDriverName = mvarUSBDevPrefix & "-" & Index
        hDriver = OpenDriver(sDriverName)
        If hDriver > 0 Then
            'Get the device desriptor
            result = DeviceIoControl(hDriver, IOCTL_Ezusb_GET_DEVICE_DESCRIPTOR, usbDD, Len(usbDD), usbDD, Len(usbDD), lBytesReturned, 0)

            If result = 1 Then
                'Test the vendor and Product ID's to make sure that they're correct
                If usbDD.iVendorID = mvarVendorID And usbDD.iProductID = mvarProductID Then
                    'Add the driver name to the list
                    mvarDeviceList(I2) = sDriverName
                    'Increment I2
                    I2 = I2 + 1
                End If
            Else
                'Return get device descriptor error
                GetDevices = -2
                mvarDeviceCount = I2 'Store the number of devices retrieved
                Exit Function
            End If
            'Close the driver
            CloseHandle hDriver
        End If
    Next
    GetDevices = I2
    mvarDeviceCount = I2 'Store the number of devices retrieved
    
    'Check to see if the old drivername that was being used is in the driver list
'    For cntr = 0 To mvarDeviceCount - 1
'        If mvarDeviceList(cntr) = OldDrvSel Then
'            OldDrvFnd = True
'            Exit For
'        End If
'    Next
    'If the old driver wasn't found in the driver list then clear the devslected flag and the drivername property
'    If OldDrvFnd = False Then
'        DevSelected = False
'        mvarDriverName = ""
'    End If
End Function

Private Sub Class_Initialize()
    'Initialize default values
    mvarVendorID = mdef_VendorID 'This is ADI's Vendor ID
    mvarProductID = mdef_ProductID
    mvarDriverName = mdef_DriverName
    mvarDeviceCount = mdef_DeviceCount
    mvarmvarVerboseIO = mdef_VerboseIO
    'Dimension the DeviceList array
    ReDim mvarDeviceList(0 To MAX_USB_DEV_NUMBER - 1)
    
    'By default use the EZSSP driver's device prefix
    mvarUSBDevPrefix = EZSSP_DevName
    
    'Check to see if the USB driver is installed
    USBDriverInstalled
End Sub

Function GetStringDescription(ByVal Index As Integer, sDescription As String) As Long

    '   retrieves string description from the usb device
    '
    '   IN  Index         index of the descriptor string to be retrieved
    '   OUT sDescription  returns the string description indexed by index
    '
    '   returns:        1 = successful call
    '                   0 = unsuccessful call
    Dim result As Long
    Dim hDriverHandle As Long
    Dim DescriptionLength As Long
    Dim strDesc As String
    Dim udtInBuff As GetStringDescriptorIn
    
    udtInBuff.Index = Index      'String index
    udtInBuff.LanguageId = &H409 'US English
    
    'Open the driver and get a handle
    hDriverHandle = OpenDriver(mvarDriverName)
    
    GetStringDescription = 0
    
    If hDriverHandle > 0 Then
    
        'Fill the string with null characters and
        'make it big enough for just about any string
        strDesc = String(255, vbNullChar)
        'Make the call to get the string
        result = DeviceIoControl(hDriverHandle, IOCTL_Ezusb_GET_STRING_DESCRIPTOR, udtInBuff, Len(udtInBuff), ByVal strDesc, 512, DescriptionLength, 0)
        
        'Fill the string with null characters to the length returned by
        'the previous call
        strDesc = String(DescriptionLength, vbNullChar)
        'Get the string descriptor
        result = DeviceIoControl(hDriverHandle, IOCTL_Ezusb_GET_STRING_DESCRIPTOR, udtInBuff, Len(udtInBuff), ByVal strDesc, 255, DescriptionLength, 0)
        
        If result = 1 Then
            'Massage out the data
            strDesc = Right(strDesc, Len(strDesc) - 2)
            strDesc = Replace(strDesc, vbNullChar, "")
            'Return the valid description string
            sDescription = strDesc
        Else
            'Return error
            sDescription = "ERROR"
        End If
        
        CloseHandle (hDriverHandle)
    End If
    
    GetStringDescription = result

End Function
Public Function GetFirmWareVersion(ByVal DeviceIndex As Integer) As String
    'This routine returns 2 bytes.  The first contains version Major
    'the second contains version minor.
    'Example = VerMajor.VerMinor = 1.9
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    Driver = mvarDeviceList(DeviceIndex)
    buf(0) = &H0
       
    'send 1 byte of data out on EP1OUT
    result = BulkXfer(0, buf, 1, Driver)  'DoBulkXfer(Driver, 0, buf, 1)
    
    If result <> 1 Then
        MsgBox "Error writing to device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = BulkXfer(1, Data, 2, Driver) 'DoBulkXfer(Driver, 1, Data, 2)
    If result <> 1 Then
        MsgBox "Error reading to device."
        Exit Function
    End If

    'Return the firmware version
    GetFirmWareVersion = CStr(Data(0)) & "." & CStr(Data(1))
End Function

'Gets the windows system directory
'Used to detect if usb is installed
Private Function GetWinSysDir() As String
    Dim sDirPath As String * 260
    Dim lPathLen As Long
    lPathLen = GetSystemDirectory(sDirPath, 260)
    GetWinSysDir = Left(sDirPath, lPathLen)
End Function

'Tests to see if the EZUSB driver is installed
Public Function USBDriverInstalled() As Boolean
    Dim sDriverFile As String
        
    If IsWinNT = True Then
        'Build a the path to where the driver will be copied
        sDriverFile = GetWinSysDir() & "\Drivers\" & mvarUSBDevPrefix & ".sys"
    Else
        'Build the path to where the driver will be copied
        sDriverFile = GetWindowsDir() & "\System32\Drivers\" & mvarUSBDevPrefix & ".sys"
    End If
    
    If FileExists(sDriverFile) Then
        'Set the property value
        mvarUSBDriverIsInstalled = True
        'Return true
        USBDriverInstalled = True
    Else
        'Set the property value
        mvarUSBDriverIsInstalled = False
        'Return false
        USBDriverInstalled = False
    End If
    
End Function
Private Function IsWinNT() As Boolean
    Dim myOS As OSVERSIONINFO

    myOS.dwOSVersionInfoSize = Len(myOS)
    GetVersionEx myOS
    IsWinNT = (myOS.dwPlatformId = VER_PLATFORM_WIN32_NT)
End Function

'This function will get the current directory where windows is installed
Private Function GetWindowsDir() As String
    Dim WinDir As String * 260
    Dim RetWinDir As String
    Dim TrimAmount As Long
    
    'Get the windows directory
    TrimAmount = GetWindowsDirectory(WinDir, 260)
    
    'Trim off all unneeded trailling characters
    RetWinDir = Left(WinDir, TrimAmount)
    
    'Return the directory
    GetWindowsDir = RetWinDir
End Function


Public Function IsConnected() As Boolean
    Dim cntr As Integer
    
    IsConnected = False
    
    'Get rescan the device list
    GetDevices
    
    'Search through the driver list to see if the driver we are using is avialiable
    For cntr = 0 To mvarDeviceCount - 1
        If GetDriverName(cntr) = mvarDriverName Then
            IsConnected = True
            'Stop looking for the device because it was found
            Exit For
        End If
    Next cntr
End Function

Public Function GetHostID(ByVal DeviceIndex As Integer, ByRef lValue As Long) As Integer
    'This subroutine sets the number of bytes that will be read back through
    'the GPIF interface in single byte Read Mode
    Dim buf(1) As Byte
    Dim result As Long
    Dim Data(4) As Byte
    Dim sDriverName As String
            
    'Get the driver name
    sDriverName = mvarDeviceList(DeviceIndex)
    
    buf(0) = &HE 'Firmware Command value for getting the HostId if it has been set.
    
    'send 1 byte of data out on EP1OUT
    result = BulkXfer(0, buf, 1, sDriverName)
    'If no errors then continue
    If result = 1 Then
        result = BulkXfer(1, Data, 4, sDriverName)
    End If

    If result = 1 Then
        'Now that the data has been recieved convert to a long
        lValue = MergeBytes2Long(Data(0), Data(1), Data(2), Data(3))
    End If

'    If result <> 1 Then
'        MsgBox "Error writing to device."
'        Exit Function
'    End If
    
    GetHostID = result

End Function

Public Function SetHostID(ByVal DeviceIndex As Integer, ByVal lHostID As Long) As Long
    'This subroutine sets the number of bytes that will be read back through
    'the GPIF interface in single byte Read Mode
    Dim buf(5) As Byte
    Dim result As Long
    Dim Data(2) As Byte
    Dim sDriverName As String
            
    'Get the driver name
    sDriverName = mvarDeviceList(DeviceIndex)
            
    buf(0) = &HD  'Command value
    buf(1) = GetByteFromLong(lHostID, 3)
    buf(2) = GetByteFromLong(lHostID, 2)
    buf(3) = GetByteFromLong(lHostID, 1)
    buf(4) = GetByteFromLong(lHostID, 0)
    
    'send 1 byte of data out on EP1OUT
    result = BulkXfer(0, buf, 5, sDriverName)
    
    'Return the result
    SetHostID = result
'    If result <> 1 Then
'        'MsgBox "Error writing to device."
'        'Exit Function
'    End If
End Function

'Returns the merged value of a
Private Function MergeBytes2Long(ByVal bByte3 As Byte, ByVal bByte2 As Byte, ByVal bByte1 As Byte, ByVal bByte0 As Byte) As Long
'    Dim sTempVal As String
'
'    'Build a hex string - seems to be the easiest way
'    sTempVal = Format(Hex(bByte3), "00") & Format(Hex(bByte2), "00") & Format(Hex(bByte1), "00") & Format(Hex(bByte0), "00")
        
    'Result = (bbyte3 * 256^3) + (bbyte2 * 256^2) + (bbyte1 * 256^1) + (bbyte0 * 256^0)
    MergeBytes2Long = (bByte3 * 16777216) + (bByte2 * 65536) + (bByte1 * 256) + bByte0
    'Convert that to a long value
    'MergeBytes2Long = CLng("&h" & sTempVal)
End Function


'Returns the byte indexed by iByteIndex from lValue
'Ex GetByteFromLong(&hFFABE1,1) would return &hAB
'Ex GetByteFromLong(&hFFABE1,4) would return 00
Private Function GetByteFromLong(ByVal lValue As Double, ByVal iByteIndex) As Byte
    If iByteIndex >= 0 And iByteIndex <= 3 Then
        GetByteFromLong = CByte(&HFF And Int(lValue / CLng(256 ^ iByteIndex)))
    Else
        GetByteFromLong = &H0
    End If
End Function

Private Sub Class_Terminate()
    Dim iDeviceIndex As Integer
    'A Device has been selected
    If DevSelected = True Or mvarDriverName <> mdef_DriverName Then
        'Free up the currently used device
        iDeviceIndex = GetDeviceIndex(mvarDriverName)
        If iDeviceIndex <> -1 Then
            'Check the firmware revision to make sure that it supports HostID storage
            If CDbl(GetFirmWareVersion(iDeviceIndex)) >= 0.3 Then
                'Clear the HostID, which releases the device
                SetHostID iDeviceIndex, 0
            End If
        End If
    End If
End Sub


'Forces the class to use the EZUSB GPD prefix for device detection and useage
Public Sub UseEZUSBDriver()
    mvarUSBDevPrefix = EZUSB_DevName
End Sub
