VERSION 1.0 CLASS
BEGIN
  MultiUse = 0   'False
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsAD9956EvBd"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
'*******************************************************
'* Constants                                           *
'*******************************************************
'Bit Number Constants for the signals on the
'parallel port's data port
'Buff1's Bit Designations
Const bnPS0_DUT1 = 0
Const bnPS0_DUT2 = 1
Const bnPS1_DUT1 = 2
Const bnPS1_DUT2 = 3
Const bnPS2_DUT1 = 4
Const bnPS2_DUT2 = 5
Const bnIOUpdate_DUT1 = 6
Const bnIOUpdate_DUT2 = 7

'Buff2's Bit Designations
Const bnSyncIO_DUT1 = 0
Const bnSyncIO_DUT2 = 1
Const bnReset_DUT1 = 2
Const bnReset_DUT2 = 3
Const bnSDIO = 4
Const bnSCLK = 5
Const bnCSB_DUT1 = 6
Const bnCSB_DUT2 = 7

'Buff3's Bit Designations
'Const bnSDIO = 0
'Const bnSCLK = 1
'Const bnCSB_DUT1 = 2
'Const bnCSB_DUT2 = 3

'Bit Number Constants for the signals on the
'parallel port's status port
Const bnSDO = 3
Const bnPLL_LOCK_SL = 4
Const bnPLL_LOCK_MA = 5
Const bnSCLK1 = 6

'Bit Number Constants for the signals on the
'parallel port's Control port
Const bnLatchBuff0 = 0
Const bnLatchBuff1 = 1
Const bnRB_Enable = 2
Const bnPLLLockSyncEnable = 3

'Bit Number Constants for the signals on the
'FX2s PortD's Pin
Const bnUSB_PS0_DUT1 = 0
Const bnUSB_PS1_DUT1 = 1
Const bnUSB_PS2_DUT1 = 2
Const bnUSB_IOUpdate_DUT1 = 3
Const bnUSB_PS0_DUT2 = 4
Const bnUSB_PS1_DUT2 = 5
Const bnUSB_PS2_DUT2 = 6
Const bnUSB_IOUpdate_DUT2 = 7

'Bit Number Constants for the signals on the
'FX2s PortA's Pin
Const bnUSB_USB_Status = 0
Const bnUSB_PLL_Lock_SL = 1
Const bnUSB_Reset_DUT1 = 2
Const bnUSB_SyncIO_DUT1 = 3
Const bnUSB_Reset_DUT2 = 4
Const bnUSB_SyncIO_DUT2 = 5
Const bnUSB_CSB_DUT1 = 6
Const bnUSB_CSB_DUT2 = 7

'Bit Number Constants for the signals on the
'FX2s PortB's Pin
Const bnUSB_SDIO = 0
Const bnUSB_SDO = 1
Const bnUSB_PLL_Lock_DUT1 = 2
Const bnUSB_PLL_Lock_DUT2 = 3

'Bit Number Constants for the signals on the
'FX2s CTL lines
Const bnUSB_SCLK = 0
Const bnUSB_CTL1 = 1
Const bnUSB_CTL2 = 2

'Evalboard USB Software Buffer
Public Enum evb9956USBEvBdBuffs
    evb56_USBPortD = 0
    evb56_USBPortA = 1
    evb56_USBCtl = 2
End Enum

'Delcare the LPTIO class
Public PPIO As clsLPTIO

'Enums
Public Enum RMA9956
    RMA9956_CFR1 = 0
    RMA9956_CFR2 = 1
    RMA9956_RDFTW = 2
    RMA9956_FDFTW = 3
    RMA9956_RSRR = 4
    RMA9956_FSRR = 5
    RMA9956_PCR0 = 6
    RMA9956_PCR1 = 7
    RMA9956_PCR2 = 8
    RMA9956_PCR3 = 9
    RMA9956_PCR4 = 10
    RMA9956_PCR5 = 11
    RMA9956_PCR6 = 12
    RMA9956_PCR7 = 13
    RMA9956_TR = 14
End Enum
Public Enum selDUTs_9956
    sd9956_Both = 0
    sd9956_DUT1 = 1
    sd9956_DUT2 = 2
End Enum
Public Enum rmv9956_RegMap
    rm9956_NewRegMapVals = 0
    rm9956_CurRegMapVals = 1
End Enum
Public Enum evbd56_SerMode
    evbd56_TwoWire = 0
    evbd56_ThreeWire = 1
End Enum
Public Enum evb56EvalBoardBuffs
    evb56_Buffer0 = 0
    evb56_Buffer1 = 1
End Enum

Public Enum evb56EvBdBuffs
    evb56_Buff0_PortD = 0
    evb56_Buff1_PortA = 1
    evb56_CTLUSB = 2
End Enum

Public Enum evbBits
    evbBit0 = 0
    evbBit1 = 1
    evbBit2 = 2
    evbBit3 = 3
    evbBit4 = 4
    evbBit5 = 5
    evbBit6 = 6
    evbBit7 = 7
End Enum

Public Enum adiBitValues
    abvHigh = 1
    abvLow = 0
End Enum

'local variable(s) to hold property value(s)
Private mvarAutoIOUpdate_DUT1 As Boolean 'local copy
Private mvarSDIO As adiBitValues 'local copy
Private mvarSDO As adiBitValues 'local copy
Private mvarSCLK As adiBitValues 'local copy
Private mvarIOSync_DUT1 As adiBitValues 'local copy
Private mvarIOUpdate_DUT1 As adiBitValues 'local copy
Private mvarRESET_DUT1 As adiBitValues 'local copy
Private mvarProfile0_DUT1 As adiBitValues 'local copy
Private mvarProfile1_DUT1 As adiBitValues 'local copy
Private mvarProfile2_DUT1 As adiBitValues 'local copy
Private mvarPLL_Lock_DUT1 As adiBitValues 'local copy
Private mvarAutoIOUpdate_DUT2 As Boolean 'local copy
Private mvarIOSync_DUT2 As adiBitValues 'local copy
Private mvarIOUpdate_DUT2 As adiBitValues 'local copy
Private mvarPLL_Lock_DUT2 As adiBitValues 'local copy
Private mvarProfile0_DUT2 As adiBitValues 'local copy
Private mvarProfile1_DUT2 As adiBitValues 'local copy
Private mvarProfile2_DUT2 As adiBitValues 'local copy
Private mvarRESET_DUT2 As adiBitValues 'local copy
Private mvarLSBFirst_DUT1 As Boolean 'local copy
Private mvarLSBFirst_DUT2 As Boolean 'local copy
Private mvarEnabled As Boolean 'local copy
Private mvarSerialIOMode_DUT1 As evbd56_SerMode 'local copy
Private mvarSerialIOMode_DUT2 As evbd56_SerMode 'local copy
Private mvarCSB_DUT1 As adiBitValues 'local copy
Private mvarCSB_DUT2 As adiBitValues 'local copy

'To fire this event, use RaiseEvent with the following syntax:
'RaiseEvent BeforeReset[(arg1, arg2, ... , argn)]
Public Event BeforeReset(ByVal DUT As selDUTs_9956)
'To fire this event, use RaiseEvent with the following syntax:
'RaiseEvent AfterReset[(arg1, arg2, ... , argn)]
Public Event AfterReset(ByVal DUT As selDUTs_9956)
'To fire this event, use RaiseEvent with the following syntax:
'RaiseEvent EvalBdFound[(arg1, arg2, ... , argn)]
Public Event EvalBdFound()
'To fire this event, use RaiseEvent with the following syntax:
'RaiseEvent BeforeRegUpdate[(arg1, arg2, ... , argn)]
Public Event BeforeRegUpdate(ByVal DUT As selDUTs_9956, ByVal RegMap As rmv9956_RegMap, ByVal RegMapLoc As RMA9956, ByVal Value As String)
'To fire this event, use RaiseEvent with the following syntax:
'RaiseEvent AfterRegUpdate[(arg1, arg2, ... , argn)]
Public Event AfterRegUpdate(ByVal DUT As selDUTs_9956, ByVal RegMap As rmv9956_RegMap, ByVal RegMapLoc As RMA9956, ByVal Value As String)

'These variables store the values last latched into the latches
'U5,U7,U8 on the Evaluation Board
Private evbBuffers(0 To 2) As Integer
Private evbBitVals(0 To 7) As Integer
Private RegLength(0 To 14) As Integer

'Buffer to store new and current register map values
'Syntax: Buffer(Dutnum: 0 or 1, RegAddr: 0 - 12) = Value
Private sRegMapValsNew(0 To 1, 0 To 14) As String
Private sRegMapVals(0 To 1, 0 To 14) As String
'Private sRegLength(0 To 14) As Integer
Private AddrToProfile(0 To 7) As Integer

'Local variables
Private OldReset_DUT1 As adiBitValues
Private OldReset_DUT2 As adiBitValues

'Used to detect changes in the IO Sync pin
Private OldIOSyncDUT1 As adiBitValues
Private OldIOSyncDUT2 As adiBitValues

'local variable(s) to hold property value(s)
Private mvarLatchBuff0 As adiBitValues 'local copy
Private mvarLatchBuff1 As adiBitValues 'local copy
Private mvarRBEnable As adiBitValues 'local copy
Private mvarPLLLock_SyncEnableBar As adiBitValues 'local copy

'local variable(s) to hold property value(s)
Private mvarSCLK1 As adiBitValues 'local copy
'Gets set when the evalboard is detected
'-1 - Unknown
'0  - LPT Interface Detected
'1  - USB Interface Detected
'local variable(s) to hold property value(s)
Private mvarPCInterface As Integer 'local copy
'local variable(s) to hold property value(s)
Private mvarDut2Detected As Boolean 'local copy
Private mvarDut1Detected As Boolean 'local copy
'local variable(s) to hold property value(s)
Private mvarUSBFirmwareRev As String 'local copy
Public Property Let USBFirmwareRev(ByVal vData As String)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.USBFirmwareRev = 5
    mvarUSBFirmwareRev = vData
End Property


Public Property Get USBFirmwareRev() As String
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.USBFirmwareRev
    USBFirmwareRev = mvarUSBFirmwareRev
End Property



Public Property Let Dut1Detected(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Dut1Detected = 5
    mvarDut1Detected = vData
End Property


Public Property Get Dut1Detected() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Dut1Detected
    Dut1Detected = mvarDut1Detected
End Property



Public Property Let Dut2Detected(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Dut2Detected = 5
    mvarDut2Detected = vData
End Property


Public Property Get Dut2Detected() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Dut2Detected
    Dut2Detected = mvarDut2Detected
End Property



Public Function USBFindEvalBD() As Integer
    'Get the devices
    USBFindEvalBD = clsEZUSBDev01.GetDevices()
    If USBFindEvalBD > 0 Then
        mvarPCInterface = 0
        RaiseEvent EvalBdFound
    End If
End Function

Public Property Let PCInterface(ByVal vData As Integer)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.PCInterface = 5
   mvarPCInterface = vData
End Property


Public Property Get PCInterface() As Integer
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.PCInterface
    PCInterface = mvarPCInterface
End Property



Public Property Let SCLK1(ByVal vData As adiBitValues)
'used when assigning an Object to the property, on the left side of a Set statement.
'Syntax: Set x.RSCLK = Form1
    'Set mvarSCLK1 = vData
End Property


Public Property Get SCLK1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.RSCLK
    'Read the status port
    PPIO.ReadPort ppStatusRegister
    'Get the value of the SCLK1 Bit
    mvarSCLK1 = PPIO.GetBitVal(ppaStatusRegister, bnSCLK1)
    'Return the value
    SCLK1 = mvarSCLK1
End Property




'Returns the active profile for the DUT specified by the input parameter DUT
Public Function GetActiveProfile(ByVal DUT As selDUTs_9956) As Integer
    Dim sProfileNum As String
    'Set the profile number
    Select Case DUT
        Case 2:
            sProfileNum = CStr(Profile2_DUT2) & CStr(Profile1_DUT2) & CStr(Profile0_DUT2)
        Case Else:
            sProfileNum = CStr(Profile2_DUT1) & CStr(Profile1_DUT1) & CStr(Profile0_DUT1)
    End Select
    
    GetActiveProfile = CInt(cbaseBinS2Dec(sProfileNum))
End Function
'DUT - 0 = Both, 1 = Master, 2 = Slave
'newProfile - 0 to 7
Public Sub SetActiveProfile(ByVal DUT As selDUTs_9956, ByVal newProfile As Integer)
    Dim sProfileNum As String
    Dim PrBit0Val As Long
    Dim PrBit1Val As Long
    Dim PrBit2Val As Long
    
    'Get the pin values from the profile supplied
    If newProfile And &H1 Then
        PrBit0Val = 1
    Else
        PrBit0Val = 0
    End If
    
    'Get the pin values from the profile supplied
    If newProfile And &H2 Then
        PrBit1Val = 1
    Else
        PrBit1Val = 0
    End If
    
    'Get the pin values from the profile supplied
    If newProfile And &H4 Then
        PrBit2Val = 1
    Else
        PrBit2Val = 0
    End If
    
    Select Case DUT
        Case 1:
            Profile0_DUT1 = PrBit0Val
            Profile1_DUT1 = PrBit1Val
            Profile2_DUT1 = PrBit2Val
        Case 2:
            Profile0_DUT2 = PrBit0Val
            Profile1_DUT2 = PrBit1Val
            Profile2_DUT2 = PrBit2Val
        Case Else:
            Profile0_DUT1 = PrBit0Val
            Profile1_DUT1 = PrBit1Val
            Profile2_DUT1 = PrBit2Val
            Profile0_DUT2 = PrBit0Val
            Profile1_DUT2 = PrBit1Val
            Profile2_DUT2 = PrBit2Val
    End Select
    
    WriteEvbBuffVal evb56_Buff0_PortD
    
'    Select Case mvarPCInterface
'        Case 0:
'            'Write the new values to PortD of the EZUSB FX2 Chip
'            USBWriteEvbBuffVal evb56_USBPortD
'        Case 1:
'        '    Strobe_Clock_D
'            PPWriteEvbBuffVal evb59Buff1
'        Case -1:
'
'    End Select
End Sub

Public Property Let PLLLock_SyncEnableBar(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.PLLLock_SyncEnableBar = 5
'    mvarPLLLock_SyncEnableBar = vData
    If mvarPCInterface = 1 Then
        If vData = abvHigh Then
            'Set the bit value of the control register
            PPIO.SetBitVal ppControlRegister, bnPLLLockSyncEnable, 0
        Else
            'Set the bit value of the control register
            PPIO.SetBitVal ppControlRegister, bnPLLLockSyncEnable, 1
        End If
        'Update the control register immediately
        EvBd.PPIO.WritePort ppControlRegister
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortA, bnUSB_PLL_Lock_SL, vData
    End If
End Property


Public Property Get PLLLock_SyncEnableBar() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.PLLLock_SyncEnableBar
'    Set PLLLock_SyncEnableBar = mvarPLLLock_SyncEnableBar
    If mvarPCInterface = 1 Then
        If PPIO.GetBitVal(ppControlRegister, bnPLLLockSyncEnable) Then
            PLLLock_SyncEnableBar = abvLow
        Else
            PLLLock_SyncEnableBar = abvHigh
        End If
    ElseIf mvarPCInterface = 0 Then
        PLLLock_SyncEnableBar = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_PLL_Lock_SL)
    End If
End Property



Public Property Let RB_Enable(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.RBEnable = 5
'    mvarRBEnable = vData
    If vData = abvHigh Then
        'Set the bit value of the control register
        PPIO.SetBitVal ppControlRegister, bnRB_Enable, 1
    Else
        'Set the bit value of the control register
        PPIO.SetBitVal ppControlRegister, bnRB_Enable, 0
    End If
    'Update the control register immediately
    EvBd.PPIO.WritePort ppControlRegister
End Property


Public Property Get RB_Enable() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.RBEnable
'    Set RBEnable = mvarRBEnable
    If PPIO.GetBitVal(ppControlRegister, bnRB_Enable) Then
        RBEnable = abvHigh
    Else
        RBEnable = abvLow
    End If
End Property



Public Property Let LatchBuff1(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.LatchBuff1 = 5
'    mvarLatchBuff1 = vData
    If vData = abvHigh Then
        'Set the bit value of the control register
        PPIO.SetBitVal ppControlRegister, bnLatchBuff1, 1
    Else
        'Set the bit value of the control register
        PPIO.SetBitVal ppControlRegister, bnLatchBuff1, 0
    End If
    'Update the control register immediately
    EvBd.PPIO.WritePort ppControlRegister
End Property


Public Property Get LatchBuff1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.LatchBuff1
'    Set LatchBuff1 = mvarLatchBuff1
    If PPIO.GetBitVal(ppControlRegister, bnLatchBuff1) Then
        LatchBuff1 = abvHigh
    Else
        LatchBuff1 = abvLow
    End If
End Property



Public Property Let LatchBuff0(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.LatchBuff0 = 5
'    mvarLatchBuff0 = vData
    If vData = abvHigh Then
        'Set the bit value of the control register
        PPIO.SetBitVal ppControlRegister, bnLatchBuff0, 0
    Else
        'Set the bit value of the control register
        PPIO.SetBitVal ppControlRegister, bnLatchBuff0, 1
    End If
    'Update the control register immediately
    EvBd.PPIO.WritePort ppControlRegister
End Property


Public Property Get LatchBuff0() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.LatchBuff0
    If PPIO.GetBitVal(ppControlRegister, bnLatchBuff0) Then
        LatchBuff0 = abvLow
    Else
        LatchBuff0 = abvHigh
    End If
End Property



Public Function GetRegLen(ByVal RegAddr As Integer) As Integer
'Used to get the length of a register
    GetRegLen = RegLength(RegAddr)
End Function



Public Property Let CSB_DUT2(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.CSB_DUT2 = 5
'    mvarCSB_DUT2 = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer1, bnCSB_DUT2, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortA, bnUSB_CSB_DUT2, vData
    End If
End Property


Public Property Get CSB_DUT2() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.CSB_DUT2
'    Set CSB_DUT2 = mvarCSB_DUT2
    If mvarPCInterface = 1 Then
        CSB_DUT2 = GetEvbBuffBitVal(evb56_Buffer1, bnCSB_DUT2)
    ElseIf mvarPCInterface = 0 Then
        CSB_DUT2 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_CSB_DUT2)
    End If
End Property



Public Property Let CSB_DUT1(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.CSB_DUT1 = 5
    If mvarPCInterface = 1 Then
        'Do it for Parallel Port
        SetEvbBuffBitVal evb56_Buffer1, bnCSB_DUT1, vData
    ElseIf mvarPCInterface = 0 Then
        'Do it for USB
        USBSetEvbBuffBitVal evb56_USBPortA, bnUSB_CSB_DUT1, vData
    End If
End Property


Public Property Get CSB_DUT1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.CSB_DUT1
    'Set CSB_DUT1 = mvarCSB_DUT1
    If mvarPCInterface = 1 Then
        CSB_DUT1 = GetEvbBuffBitVal(evb56_Buffer1, bnCSB_DUT1)
    ElseIf mvarPCInterface = 0 Then
        CSB_DUT1 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_CSB_DUT1)
    End If
End Property





'Sets the specified bit value to the specified buffer
Public Sub USBSetEvbBuffBitVal(ByVal Buff As evb9956USBEvBdBuffs, ByVal Bit As evbBits, ByVal Value As adiBitValues)
    If Value <> 0 Then
        'Set the bit
        evbBuffers(Buff) = evbBuffers(Buff) Or evbBitVals(Bit)
    Else
        'Clear the bit
        evbBuffers(Buff) = evbBuffers(Buff) And Not evbBitVals(Bit)
    End If
End Sub
'Returns the current bit value from the specified buffer
Public Function USBGetEvbBuffBitVal(ByVal Buff As evb9956USBEvBdBuffs, ByVal Bit As evbBits) As Integer
    'Test the bit
    If evbBuffers(Buff) And evbBitVals(Bit) Then
        'If a one the return 1
        USBGetEvbBuffBitVal = 1
    Else
        'If a zero then return 0
        USBGetEvbBuffBitVal = 0
    End If
End Function


'Sets the specified bit value to the specified buffer
Public Sub SetEvbBuffBitVal(ByVal Buff As evb56EvalBoardBuffs, ByVal Bit As evbBits, ByVal Value As adiBitValues)
    If Value <> 0 Then
        'Set the bit
        evbBuffers(Buff) = evbBuffers(Buff) Or evbBitVals(Bit)
    Else
        'Clear the bit
        evbBuffers(Buff) = evbBuffers(Buff) And Not evbBitVals(Bit)
    End If
End Sub
'Returns the current bit value from the specified buffer
Public Function GetEvbBuffBitVal(ByVal Buff As evb56EvalBoardBuffs, ByVal Bit As evbBits) As Integer
    'Test the bit
    If evbBuffers(Buff) And evbBitVals(Bit) Then
        'If a one the return 1
        GetEvbBuffBitVal = 1
    Else
        'If a zero then return 0
        GetEvbBuffBitVal = 0
    End If
End Function
'Returns the current value of the specified software buffer which should be the
'current hardware buffer value if SetBitVal,SetEvbBuffVal,and PPWriteEvbBuffVal
'are used exclusively
Public Function GetEvbBuffVal(ByVal Buff As evb56EvalBoardBuffs) As Integer
    'Return the requested information
    GetEvbBuffVal = evbBuffers(Buff)
End Function

'Sets the software buffer value specifed by RegVal
'To write the value from the software buffer to the hardware buffer call
'WriteEvbBuffVal()
Public Sub SetEvbBuffVal(ByVal Buff As evb56EvalBoardBuffs, ByVal BuffVal As Integer)
    'Set the register value
    evbBuffers(Buff) = BuffVal
End Sub
'Handles the USB and Parallel port writes
Public Sub WriteEvbBuffVal(ByVal Buff As evb56EvBdBuffs, Optional BuffVal As Variant)
    Select Case mvarPCInterface
        Case -1:
        Case 0:
            USBWriteEvbBuffVal Buff, BuffVal
        Case 1:
            PPWriteEvbBuffVal Buff, BuffVal
    End Select
End Sub
'Writes the value specified by buff to the software buffer and the hardware buffer
'specifed by evbBuffs.  If BuffVal is not passed then it writes the value currently
'in the software buffer.
'The write sequence is as follows
'1. Write the value to the dataport of the parallel port
'2. Latch the data into the proper hardware buffer on the eval board.
Public Sub PPWriteEvbBuffVal(ByVal Buff As evb56EvalBoardBuffs, Optional BuffVal As Variant)
    
    If IsMissing(BuffVal) Then
        'Write it to the parallel port
        PPIO.WritePort ppDataRegister, evbBuffers(Buff)
    Else
        'Set the register value
        evbBuffers(Buff) = BuffVal
        
        'Write it to the parallel port
        PPIO.WritePort ppDataRegister, BuffVal
    End If
    
    Select Case Buff
        Case evb56_Buffer0:
            'Latch the data into the evalboard buffer
            PPIO.StrobeLine ppControlRegister, bnLatchBuff0
        Case evb56_Buffer1:
            'Fire events here
            If (OldReset_DUT1 = abvLow And OldReset_DUT2 = abvLow) And (GetEvbBuffBitVal(evb56_Buffer1, bnReset_DUT1) = abvHigh And GetEvbBuffBitVal(evb56_Buffer1, bnReset_DUT2) = abvHigh) Then
                RaiseEvent BeforeReset(sd9956_Both)
                'Clear out the registermap
                ResetRegMaps sd9956_Both
            Else
                If OldReset_DUT1 = abvLow And GetEvbBuffBitVal(evb56_Buffer1, bnReset_DUT1) = abvHigh Then
                    RaiseEvent BeforeReset(sd9956_DUT1)
                    'Clear out the registermap
                    ResetRegMaps sd9956_DUT1
                End If
                If OldReset_DUT2 = abvLow And GetEvbBuffBitVal(evb56_Buffer1, bnReset_DUT2) = abvHigh Then
                    RaiseEvent BeforeReset(sd9956_DUT2)
                    'Clear out the registermap
                    ResetRegMaps sd9956_DUT2
                End If
            End If
            
            'Latch the data in
            PPIO.StrobeLine ppControlRegister, bnLatchBuff1
            
            If (OldReset_DUT1 = abvHigh And OldReset_DUT2 = abvHigh) And (GetEvbBuffBitVal(evb56_Buffer1, bnReset_DUT1) = abvLow And GetEvbBuffBitVal(evb56_Buffer1, bnReset_DUT2) = abvLow) Then
                'Reset the serial IO flags
                mvarSerialIOMode_DUT1 = evbd56_TwoWire
                mvarSerialIOMode_DUT2 = evbd56_TwoWire
                mvarLSBFirst_DUT1 = False
                mvarLSBFirst_DUT2 = False
                RaiseEvent AfterReset(sd9956_Both)
            Else
                If OldReset_DUT1 = abvHigh And GetEvbBuffBitVal(evb56_Buffer1, bnReset_DUT1) = abvLow Then
                    'Reset the serial IO flags
                    mvarSerialIOMode_DUT1 = evbd56_TwoWire
                    mvarLSBFirst_DUT1 = False
                    RaiseEvent AfterReset(sd9956_DUT1)
                End If
                If OldReset_DUT2 = abvHigh And GetEvbBuffBitVal(evb56_Buffer1, bnReset_DUT2) = abvLow Then
                    'Reset the serial IO flags
                    mvarSerialIOMode_DUT2 = evbd56_TwoWire
                    mvarLSBFirst_DUT2 = False
                    RaiseEvent AfterReset(sd9956_DUT2)
                End If
            End If
            
            'If the user is issuing an I/O Sync then set CFR2[7] is set to a 0
            If OldIOSyncDUT1 = abvLow And GetEvbBuffBitVal(evb56_Buffer1, bnSyncIO_DUT1) = abvHigh Then
                SetRegMapBitValue sd9956_DUT1, rm9956_NewRegMapVals, RMA9956_CFR2, 7, abvLow
                SetRegMapBitValue sd9956_DUT1, rm9956_CurRegMapVals, RMA9956_CFR2, 7, abvLow
            End If
            
            'If the user is issuing an I/O Sync then set CFR2[7] is set to a 0
            If OldIOSyncDUT2 = abvLow And GetEvbBuffBitVal(evb56_Buffer1, bnSyncIO_DUT2) = abvHigh Then
                SetRegMapBitValue sd9956_DUT2, rm9956_NewRegMapVals, RMA9956_CFR2, 7, abvLow
                SetRegMapBitValue sd9956_DUT2, rm9956_CurRegMapVals, RMA9956_CFR2, 7, abvLow
            End If
            
            'Set the old values
            OldReset_DUT1 = GetEvbBuffBitVal(evb56_Buffer1, bnReset_DUT1)
            OldReset_DUT2 = GetEvbBuffBitVal(evb56_Buffer1, bnReset_DUT2)
            
            'Get the value of the IOSync pin for each DUT
            OldIOSyncDUT1 = GetEvbBuffBitVal(evb56_Buffer1, bnSyncIO_DUT1)
            OldIOSyncDUT2 = GetEvbBuffBitVal(evb56_Buffer1, bnSyncIO_DUT2)
    End Select
End Sub
'Writes the value specified by buff to the software buffer and the EZ-USB IO Port
'specifed by evbBuffs.  If BuffVal is not passed then it writes the value currently
'in the software buffer.
Public Sub USBWriteEvbBuffVal(ByVal Buff As evb9956USBEvBdBuffs, Optional BuffVal As Variant)
    
    If Not IsMissing(BuffVal) Then
        'Set the register value
        evbBuffers(Buff) = BuffVal
    End If
    
    Select Case Buff
        Case evb56_USBPortA:
            'Fire events here
            If (OldReset_DUT1 = abvLow And OldReset_DUT2 = abvLow) And (USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT1) = abvHigh And USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT2) = abvHigh) Then
                RaiseEvent BeforeReset(sd9956_Both)
                'Clear out the registermap
                ResetRegMaps sd9956_Both
            Else
                If OldReset_DUT1 = abvLow And USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT1) = abvHigh Then
                    RaiseEvent BeforeReset(sd9956_DUT1)
                    'Clear out the registermap
                    ResetRegMaps sd9956_DUT1
                End If
                If OldReset_DUT2 = abvLow And USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT2) = abvHigh Then
                    RaiseEvent BeforeReset(sd9956_DUT2)
                    'Clear out the registermap
                    ResetRegMaps sd9956_DUT2
                End If
            End If
            
            'Write the data to the EZUSB-FX2 PortA
            SetPortAValue evbBuffers(Buff)
            
            If (OldReset_DUT1 = abvHigh And OldReset_DUT2 = abvHigh) And (USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT1) = abvLow And USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT2) = abvLow) Then
                'Reset the serial IO flags
                mvarSerialIOMode_DUT1 = evbd56_TwoWire
                mvarSerialIOMode_DUT2 = evbd56_TwoWire
                mvarLSBFirst_DUT1 = False
                mvarLSBFirst_DUT2 = False
                RaiseEvent AfterReset(sd9956_Both)
            Else
                If OldReset_DUT1 = abvHigh And USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT1) = abvLow Then
                    'Reset the serial IO flags
                    mvarSerialIOMode_DUT1 = evbd56_TwoWire
                    mvarSerialIOMode_DUT2 = evbd56_TwoWire
                    mvarLSBFirst_DUT1 = False
                    mvarLSBFirst_DUT2 = False
                    RaiseEvent AfterReset(sd9956_DUT1)
                End If
                If OldReset_DUT2 = abvHigh And USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT2) = abvLow Then
                    'Reset the serial IO flags
                    mvarSerialIOMode_DUT1 = evbd56_TwoWire
                    mvarSerialIOMode_DUT2 = evbd56_TwoWire
                    mvarLSBFirst_DUT1 = False
                    mvarLSBFirst_DUT2 = False
                    RaiseEvent AfterReset(sd9956_DUT2)
                End If
            End If
            
            'If the user is issuing an I/O Sync then set CFR2[7] is set to a 0
            If OldIOSyncDUT1 = abvLow And USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_SyncIO_DUT1) = abvHigh Then
                SetRegMapBitValue sd9956_DUT1, rm9956_NewRegMapVals, RMA9956_CFR2, 7, abvLow
                SetRegMapBitValue sd9956_DUT1, rm9956_CurRegMapVals, RMA9956_CFR2, 7, abvLow
            End If
            
            'If the user is issuing an I/O Sync then set CFR2[7] is set to a 0
            If OldIOSyncDUT2 = abvLow And USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_SyncIO_DUT2) = abvHigh Then
                SetRegMapBitValue sd9956_DUT2, rm9956_NewRegMapVals, RMA9956_CFR2, 7, abvLow
                SetRegMapBitValue sd9956_DUT2, rm9956_CurRegMapVals, RMA9956_CFR2, 7, abvLow
            End If
            
            'Set the old values
            OldReset_DUT1 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT1)
            OldReset_DUT2 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT2)
        
            'Get the value of the IOSync pin for each DUT
            OldIOSyncDUT1 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_SyncIO_DUT1)
            OldIOSyncDUT2 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_SyncIO_DUT2)
        Case evb56_USBPortD:
            'Write the data to the EZUSB-FX2 PortA
            SetPortDValue evbBuffers(Buff)
        
        Case evb56_USBCtl:
            'Write the value to the EZ-USB FX2 Chip
            SetCtlValues evbBuffers(Buff)
    End Select
End Sub
Public Sub SetRegMapBitValue(ByVal DUT As selDUTs_9956, ByVal RegMap As rmv9956_RegMap, ByVal RegAddress As RMA9956, ByVal BitNum As Integer, ByVal Value As adiBitValues)
    Dim RegVal As String
    Dim BitVal As String
    Dim RegLen As Integer
    
    'Add 1 the bit number
    BitNum = BitNum
    
    If RegLength(RegAddress) > BitNum Then
        If RegMap = rm9956_NewRegMapVals Then
            'Get the current value of the register
            RegVal = sRegMapValsNew(DUT - 1, RegAddress)
            BitVal = CStr(Value)
            RegLen = RegLength(RegAddress)
            'Set the new bit value
            sRegMapValsNew(DUT - 1, RegAddress) = Left(RegVal, RegLen - BitNum - 1) & BitVal & Right(RegVal, BitNum)
        Else
            'Get the current value of the register
            RegVal = sRegMapVals(DUT - 1, RegAddress)
            BitVal = CStr(Value)
            RegLen = RegLength(RegAddress)
            'Set the new the bit value
            sRegMapVals(DUT - 1, RegAddress) = Left(RegVal, RegLen - BitNum - 1) & BitVal & Right(RegVal, BitNum)
        End If
    Else
        MsgBox "The BIT being addressed does not exist in the addressed register location!", vbCritical, "clsAD9956EvBd.SetRegMapBitVal - Ivalid Parameter: BitNum"
    End If
End Sub
'Returns a single bit value from the register map
Public Function GetRegMapBitValue(ByVal DUT As selDUTs_9956, ByVal RegMap As rmv9956_RegMap, ByVal RegAddress As RMA9956, ByVal BitNum As Integer) As adiBitValues
    Dim BitValue As String
    If RegLength(RegAddress) > BitNum Then
        If RegMap = rm9956_NewRegMapVals Then
            'Return the bit value
            BitValue = Mid(sRegMapValsNew(DUT - 1, RegAddress), RegLength(RegAddress) - BitNum, 1)
        Else
            'Return the bit value
            BitValue = Mid(sRegMapVals(DUT - 1, RegAddress), RegLength(RegAddress) - BitNum, 1)
        End If
        
        'Return the value that was retrieved
        If BitValue = "1" Then
            GetRegMapBitValue = abvHigh
        Else
            GetRegMapBitValue = abvLow
        End If
    Else
        MsgBox "The BIT being addressed does not exist in the addressed register location!", vbCritical, "clsAD9956EvBd.GetRegMapBitVal - Ivalid Parameter: BitNum"
    End If
End Function

Public Property Let Enabled(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Enabled = 5
    mvarEnabled = vData
End Property


Public Property Get Enabled() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Enabled
    Enabled = mvarEnabled
End Property



Public Function PPSerialRead(ByVal DUT As selDUTs_9956, ByVal RegAddress As RMA9956) As String
    Dim sInstructByte As String
    Dim cntr As Integer
    Dim NumBytes As Integer
    Dim sRetStr As String
    Dim OldProfile As Long
    
    'Only work if the object is enabled
    If mvarEnabled = True Then
        'Get the number of bytes sent
        NumBytes = GetRegLen(RegAddress) / 8
        'validate the dut
        If DUT = 1 Or DUT = 2 Then
            'Validate the register address
            If RegAddress >= 0 And RegAddress <= &HE Then
                'If reading back from one of the RSCW use the profile pins to address
                If RegAddress >= &H6 And RegAddress <= &HD Then
                    'Store the current profile setting
                    OldProfile = GetActiveProfile(DUT)
                    'Set the proper profile to address the right profile control register
                    SetActiveProfile DUT, RegAddress - 6
                End If
                'Set the proper profile for the address selected
'                Select Case RegAddress
'                    Case &H6
'                        SetActiveProfile DUT, 1
'                    Case &H7
'                        SetActiveProfile DUT, 2
'                    Case &H8
'                        SetActiveProfile DUT, 3
'                    Case &HA
'                        'Fake out the part by addressing register 09 H because
'                        'Register 0AH won't read back properly for some reason
'                        If Not IsMissing(ARAAR9) Then
'                            If ARAAR9 = 0 Then
'                                RegAddress = &HA 'Reading Address 0AH
'                            Else
'                                RegAddress = &H9 'Reading Address 09H
'                            End If
'                        Else
'                            RegAddress = &H9 'Reading Address 09H
'                        End If
'                        'The profile pins actualy address the Register
'                        SetActiveProfile DUT, 4
'                End Select
                
                'Build the instruction byte
                sInstructByte = "1000" & cbaseDec2Bin(RegAddress, 4)
                
                'Set SCLK low before csb goes low so that we will know its
                'state
                SCLK = abvHigh
                PPWriteEvbBuffVal evb56_Buffer1

                'Now take the appropriate the CSB line high
                Select Case DUT
                    Case 1
                        CSB_DUT1 = abvLow
                
                        'Check to see if the part is currently in LSB First Mode
                        If LSBFirst_DUT1 Then
                            'Rearrange the instruction byte into LSB First format
                            sInstructByte = FlipString(sInstructByte)
                        End If
                    Case 2
                        CSB_DUT2 = abvLow
                
                        'Check to see if the part is currently in LSB First Mode
                        If LSBFirst_DUT2 Then
                            'Rearrange the instruction byte into LSB First format
                            sInstructByte = FlipString(sInstructByte)
                        End If
                End Select
                PPWriteEvbBuffVal evb56_Buffer1
               
                'Take readback enable low
                RB_Enable = abvLow
'                PPWriteEvbBuffVal evb56_Buffer1
                
                'Send the Instruction Byte first
                For cntr = 1 To Len(sInstructByte)
                    'Set SDI to the proper value
                    SDIO = CInt(Mid(sInstructByte, cntr, 1))
                    'Latch the data into the AD9858
                    PPWriteEvbBuffVal evb56_Buffer1
'                    If cntr <> Len(sInstructByte) Then
                        'Take SCLK Low
                        SCLK = abvLow
                        'Latch the data into the AD9858
                        PPWriteEvbBuffVal evb56_Buffer1
'                    End If
                    'Take SCLK High
                    SCLK = abvHigh
                    'Latch the data into the AD9858
                    PPWriteEvbBuffVal evb56_Buffer1
                Next cntr
                
                'Now take the RB_Enable line high or low if needed
                Select Case DUT
                    Case 1
                        If SerialIOMode_DUT1 = evbd56_TwoWire Then
                            'Set read back enable high
                            RB_Enable = abvHigh
                        Else
                            'Make sure its low or
                            RB_Enable = abvLow
                        End If
                    Case 2
                        If SerialIOMode_DUT2 = evbd56_TwoWire Then
                            'Set read back enable high
                            RB_Enable = abvHigh
                        Else
                            'Make sure its low or
                            RB_Enable = abvLow
                        End If
                End Select
                'Clock_F
                            
                'Loop through, reading the data back
                For cntr = 0 To ((NumBytes * 8) - 1)
                    'Latch the data into the AD995X
                    SCLK = abvLow
                    PPWriteEvbBuffVal evb56_Buffer1
                    'Get a bit from the eval board
                    sRetStr = sRetStr & CStr(SDO)
                    'Set sclk high
                    SCLK = abvHigh
                    PPWriteEvbBuffVal evb56_Buffer1
                Next cntr
                
                'Now return the CSB line high
                Select Case DUT
                    Case 1
                        CSB_DUT1 = abvHigh
                        
                        'If in 2 Wire mode set RB_Enable Low again
                        If SerialIOMode_DUT1 = TwoWire Then
                            'Set read back enable low
                            RB_Enable = abvLow
                            PPWriteEvbBuffVal evb56_Buffer1
                        End If
                    Case 2
                        CSB_DUT2 = abvHigh
                        
                        'If in 2 Wire mode set RB_Enable Low again
                        If SerialIOMode_DUT1 = TwoWire Then
                            'Set read back enable low
                            RB_Enable = abvLow
                            PPWriteEvbBuffVal evb56_Buffer1
                        End If
                End Select
                PPWriteEvbBuffVal evb56_Buffer1
                
                'Take the sclk line low again
                SCLK = abvLow
                PPWriteEvbBuffVal evb56_Buffer1
                                    
                If DUT = 2 Then
                    'Check to see if the part is currently in LSB First Mode
                    If LSBFirst_DUT2 Then
                        'Rearrange the instruction byte into LSB First format
                        sRetStr = FlipString(sRetStr)
                    End If
                Else
                    'Check to see if the part is currently in LSB First Mode
                    If LSBFirst_DUT1 Then
                        'Rearrange the instruction byte into LSB First format
                        sRetStr = FlipString(sRetStr)
                    End If
                End If
                
                If RegAddress >= &H6 And RegAddress <= &HD Then
                    'Restore the current profile setting
                    SetActiveProfile DUT, OldProfile
                End If
                
                'Return the data string received
                PPSerialRead = sRetStr
            Else
                'The data isn't valid or the address isn't valid
                If RegAddress < 0 Or RegAddress > &HE Then
                    MsgBox "Error: Invalid address = " & Address & ".", vbApplicationModal, "Error: Sub SerialLoad"
                End If
                
                If NumBytes = (Len(Data) / 8) Then
                    MsgBox "Error: Invalid data = " & Data & ".", vbApplicationModal, "Error: Sub SerialLoad"
                End If
            End If
        Else
            MsgBox "You can only read from one dut at a time.", vbApplicationModal & vbCritical, "SerialRead()"
        End If
    End If
End Function

Public Sub PPSerialLoad(ByVal DUT As selDUTs_9956, ByVal RegAddress As RMA9956, ByVal Data As String)
    Dim sInstructByte As String
    Dim sData As String
    Dim cntr As Integer
    Dim NumBytes As Integer
    
    'Only work if the object is enabled
    If mvarEnabled = True Then
        'Get the number of bytes sent
        NumBytes = GetRegLen(RegAddress) / 8
        
        'If writing to both DUTs make sure that both are in the same IOMode
        If (DUT <> 1 And DUT <> 2) And (LSBFirst_DUT1 <> LSBFirst_DUT2) Then
            'LSBFirst mode must be the same on both DUTs
            MsgBox "Error: To write to both DUT's simultaniously the LSB First bit must be the same for both DUTs.", vbApplicationModal, "Error: SUB Serial Load"
        Else
            'If the number of bytes to send is different than the number of bytes
            'present in the data passed then exit the sub
            If (NumBytes = (Len(Data) / 8)) And (RegAddress >= 0 And RegAddress <= &HE) Then
                
                'Build the instruction byte
                sInstructByte = "0000" & cbaseDec2Bin(RegAddress, 4)
                sData = Data
                
                'Set SCLK Low before csb goes low so that we will know its
                'state
                SCLK = abvLow
                PPWriteEvbBuffVal evb56_Buffer1
                
                'First take the CSB line low and check for LSB Frist Mode
                Select Case DUT
                    Case 1
                        CSB_DUT1 = abvLow
                        'Check to see if the part is currently in LSB First Mode
                        If LSBFirst_DUT1 Then
                            'Rearrange the instruction byte into LSB First format
                            sInstructByte = FlipString(sInstructByte)
                            'Rearrange the data into LSB First format
                            sData = FlipString(sData)
                        End If
                    Case 2
                        CSB_DUT2 = abvLow
                        'Check to see if the part is currently in LSB First Mode
                        If LSBFirst_DUT2 Then
                            'Rearrange the instruction byte into LSB First format
                            sInstructByte = FlipString(sInstructByte)
                            'Rearrange the data into LSB First format
                            sData = FlipString(sData)
                        End If
                    Case Else
                        CSB_DUT1 = abvLow
                        CSB_DUT2 = abvLow
                        'Assume that DUT1 and DUT2 are set the same and check for
                        'LSB First mode on DUT1
                        If LSBFirst_DUT1 Then
                            'Rearrange the instruction byte into LSB First format
                            sInstructByte = FlipString(sInstructByte)
                            'Rearrange the data into LSB First format
                            sData = FlipString(sData)
                        End If
                End Select
                'Strobe the Clock_F line latching in the CSB Lines
                PPWriteEvbBuffVal evb56_Buffer1
                
                'Build the final data string to be sent to the AD9956
                sData = sInstructByte & sData
                
                'Take readback enable low
'                RB_Enable = abvLow
                
                'Loop through the data
                For cntr = 1 To Len(sData)
                    'Set SDIO to the proper value
                    SDIO = CInt(Mid(sData, cntr, 1))
                    'Take SCLK Low
                    SCLK = abvLow
                    'Strobe the Clock_F line latching in the data
                    PPWriteEvbBuffVal evb56_Buffer1
                    
                    'Latch the data into the AD9956
                    SCLK = abvHigh
                    'Strobe the Clock_F line latching in the data
                    PPWriteEvbBuffVal evb56_Buffer1
                    
                    'Strobe the Clock_F line latching in the data
'                    Strobe_Clock_F
                    'Take SCLK Low
'                    SCLK = abvLow
'                    PPWriteEvbBuffVal evb59Buff3
                Next cntr
                        
                'Return SCLK Low
                SCLK = abvLow
                PPWriteEvbBuffVal evb56_Buffer1
                
                'Now return the CSB line high
                Select Case DUT
                    Case 1
                        CSB_DUT1 = abvHigh
                    Case 2
                        CSB_DUT2 = abvHigh
                    Case Else
                        CSB_DUT1 = abvHigh
                        CSB_DUT2 = abvHigh
                End Select
                'Strobe the Clock_F line latching in the CSB Lines
'                Strobe_Clock_F
                PPWriteEvbBuffVal evb56_Buffer1
                
    '                'Always return SCLK to a High when done just incase the user
    '                SCLK = abvHigh
    '                'Strobe the Clock_F line latching in the data
    '                Strobe_Clock_F
                
                'Now check to see
                Select Case DUT
                    Case 1
                        'Now Check to see if they put the part into LSB First or 2 or 3 Wire Mode
                        If RegAddress = 0 Then
                            If Left(Right(Data, 16), 1) = "1" Then
                                'They sent the LSBFirst Bit
                                mvarLSBFirst_DUT1 = True
                            Else
                                'They Sent MSB First Mode
                                mvarLSBFirst_DUT1 = False
                            End If
                            If Left(Right(Data, 15), 1) = "1" Then
                                'They sent the SDIO Input Only Bit so they want 3 Wire Mode
                                mvarSerialIOMode_DUT1 = evbd56_ThreeWire
                            Else
                                'They want 2 wire mode
                                mvarSerialIOMode_DUT1 = evbd56_TwoWire
                            End If
                        End If
                        'Automatically do a frequency update if the option is true
                        If mvarAutoIOUpdate_DUT1 = True Then
                            IOUpdate_DUT1 = abvHigh
                            PPWriteEvbBuffVal evb56_Buffer0
                            IOUpdate_DUT1 = abvLow
                            PPWriteEvbBuffVal evb56_Buffer0
                        End If
                        
                        'Store the value written to the register in a buffer
'                        sRegMapVals(0, Address) = Data

                    Case 2
                        'Now Check to see if they put the part into LSB First or 2 or 3 Wire Mode
                        If RegAddress = 0 Then
                            If Left(Right(Data, 16), 1) = "1" Then
                                'They sent the LSBFirst Bit
                                mvarLSBFirst_DUT2 = True
                            Else
                                'They Sent MSB First Mode
                                mvarLSBFirst_DUT2 = False
                            End If
                            If Left(Right(Data, 15), 1) = "1" Then
                                'They sent the SDIO Input Only Bit so they want 3 Wire Mode
                                mvarSerialIOMode_DUT2 = evbd56_ThreeWire
                            Else
                                'They want 2 wire mode
                                mvarSerialIOMode_DUT2 = evbd56_TwoWire
                            End If
                        End If
                        'Automatically do a frequency update if the option is true
                        If mvarAutoIOUpdate_DUT2 = True Then
                            IOUpdate_DUT2 = abvHigh
                            PPWriteEvbBuffVal evb56_Buffer0
                            IOUpdate_DUT2 = abvLow
                            PPWriteEvbBuffVal evb56_Buffer0
                        End If
                        
                        'Store the value written to the register in a buffer
'                        sRegMapVals(1, Address) = Data
                    Case Else
                        'Now Check to see if they put the part into LSB First or 2 or 3 Wire Mode
                        If RegAddress = 0 Then
                            If Left(Right(Data, 16), 1) = "1" Then
                                'They sent the LSBFirst Bit
                                mvarLSBFirst_DUT1 = True
                                mvarLSBFirst_DUT2 = True
                            Else
                                'They Sent MSB First Mode
                                mvarLSBFirst_DUT1 = False
                                mvarLSBFirst_DUT2 = False
                            End If
                            If Left(Right(Data, 15), 1) = "1" Then
                                'They sent the SDIO Input Only Bit so they want 3 Wire Mode
                                mvarSerialIOMode_DUT1 = evbd56_ThreeWire
                                mvarSerialIOMode_DUT2 = evbd56_ThreeWire
                            Else
                                'They want 2 wire mode
                                mvarSerialIOMode_DUT1 = evbd56_TwoWire
                                mvarSerialIOMode_DUT2 = evbd56_TwoWire
                            End If
                        End If
                        
                        If mvarAutoIOUpdate_DUT1 And mvarAutoIOUpdate_DUT2 Then
                            'Fud both at the same time
                            IOUpdate_DUT1 = abvHigh
                            IOUpdate_DUT2 = abvHigh
                            PPWriteEvbBuffVal evb56_Buffer0
                            IOUpdate_DUT1 = abvLow
                            IOUpdate_DUT2 = abvLow
                            PPWriteEvbBuffVal evb56_Buffer0
                        Else
                            'Automatically do a frequency update if the option is true
                            If mvarAutoIOUpdate_DUT1 = True Then
                                IOUpdate_DUT1 = abvHigh
                                PPWriteEvbBuffVal evb56_Buffer0
                                IOUpdate_DUT1 = abvLow
                                PPWriteEvbBuffVal evb56_Buffer0
                            End If
                            'Automatically do a frequency update if the option is true
                            If mvarAutoIOUpdate_DUT2 = True Then
                                IOUpdate_DUT2 = abvHigh
                                PPWriteEvbBuffVal evb56_Buffer0
                                IOUpdate_DUT2 = abvLow
                                PPWriteEvbBuffVal evb56_Buffer0
                            End If
                        End If
                        
                        'sRegMapVals(1, Address) = Data
                End Select
                'Store the value written to the register in a buffer
                EvBd.SetRegMapValue DUT, rm9956_CurRegMapVals, RegAddress, Data
            Else
                'The data isn't valid or the address isn't valid
                If RegAddress < 0 Or RegAddress > &HE Then
                    MsgBox "Error: Invalid address = " & RegAddress & ".", vbApplicationModal, "Error: Sub SerialLoad"
                End If
                
                If NumBytes = (Len(Data) / 8) Then
                    MsgBox "Error: Invalid data = " & Data & ".", vbApplicationModal, "Error: Sub SerialLoad"
                End If
            End If
        End If
    End If
End Sub


Public Property Let SerialIOMode_DUT2(ByVal vData As evbd56_SerMode)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SerialIOMode_DUT2 = 5
    mvarSerialIOMode_DUT2 = vData
End Property


Public Property Get SerialIOMode_DUT2() As evbd56_SerMode
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SerialIOMode_DUT2
    SerialIOMode_DUT2 = mvarSerialIOMode_DUT2
End Property



Public Property Let SerialIOMode_DUT1(ByVal vData As evbd56_SerMode)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SerialIOMode_DUT1 = 5
    mvarSerialIOMode_DUT1 = vData
End Property


Public Property Get SerialIOMode_DUT1() As evbd56_SerMode
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SerialIOMode_DUT1
    SerialIOMode_DUT1 = mvarSerialIOMode_DUT1
End Property




Public Property Let LSBFirst_DUT2(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.LSBFirst_DUT2 = 5
    mvarLSBFirst_DUT2 = vData
End Property


Public Property Get LSBFirst_DUT2() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.LSBFirst_DUT2
    LSBFirst_DUT2 = mvarLSBFirst_DUT2
End Property



Public Property Let LSBFirst_DUT1(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.LSBFirst_DUT1 = 5
    mvarLSBFirst_DUT1 = vData
End Property


Public Property Get LSBFirst_DUT1() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.LSBFirst_DUT1
    LSBFirst_DUT1 = mvarLSBFirst_DUT1
End Property



Public Sub ResetRegMaps(ByVal DUT As selDUTs_9956)
        
    Select Case DUT
        Case sd9956_Both:
    
            'Initialize the registermaps to their default states
            sRegMapValsNew(0, 0) = String(RegLength(0), "0")
            sRegMapValsNew(0, 1) = "0000000000000000011110001111111100000111"
            sRegMapValsNew(0, 2) = String(RegLength(2), "0")
            sRegMapValsNew(0, 3) = String(RegLength(3), "0")
            sRegMapValsNew(0, 4) = String(RegLength(4), "0")
            sRegMapValsNew(0, 5) = String(RegLength(5), "0")
            sRegMapValsNew(0, 6) = String(RegLength(6), "0")
            sRegMapValsNew(0, 7) = String(RegLength(7), "0")
            sRegMapValsNew(0, 8) = String(RegLength(8), "0")
            sRegMapValsNew(0, 9) = String(RegLength(9), "0")
            sRegMapValsNew(0, 10) = String(RegLength(10), "0")
            sRegMapValsNew(0, 11) = String(RegLength(11), "0")
            sRegMapValsNew(0, 12) = String(RegLength(12), "0")
            sRegMapValsNew(0, 13) = String(RegLength(13), "0")
            sRegMapValsNew(0, 14) = "00100000010101100001100100000000"
            'String(RegLength(14), "0")
        
            'Initialize the registermaps to their default states
            sRegMapValsNew(1, 0) = String(RegLength(0), "0")
            sRegMapValsNew(1, 1) = "0000000000000000011110001111111100000111"
            sRegMapValsNew(1, 2) = String(RegLength(2), "0")
            sRegMapValsNew(1, 3) = String(RegLength(3), "0")
            sRegMapValsNew(1, 4) = String(RegLength(4), "0")
            sRegMapValsNew(1, 5) = String(RegLength(5), "0")
            sRegMapValsNew(1, 6) = String(RegLength(6), "0")
            sRegMapValsNew(1, 7) = String(RegLength(7), "0")
            sRegMapValsNew(1, 8) = String(RegLength(8), "0")
            sRegMapValsNew(1, 9) = String(RegLength(9), "0")
            sRegMapValsNew(1, 10) = String(RegLength(10), "0")
            sRegMapValsNew(1, 11) = String(RegLength(11), "0")
            sRegMapValsNew(1, 12) = String(RegLength(12), "0")
            sRegMapValsNew(1, 13) = String(RegLength(13), "0")
            sRegMapValsNew(1, 14) = "00100000010101100001100100000000"
            'String(RegLength(14), "0")
        
            'Initialize the registermaps to their default states
            sRegMapVals(0, 0) = String(RegLength(0), "0")
            sRegMapVals(0, 1) = "0000000000000000011110001111111100000111"
            sRegMapVals(0, 2) = String(RegLength(2), "0")
            sRegMapVals(0, 3) = String(RegLength(3), "0")
            sRegMapVals(0, 4) = String(RegLength(4), "0")
            sRegMapVals(0, 5) = String(RegLength(5), "0")
            sRegMapVals(0, 6) = String(RegLength(6), "0")
            sRegMapVals(0, 7) = String(RegLength(7), "0")
            sRegMapVals(0, 8) = String(RegLength(8), "0")
            sRegMapVals(0, 9) = String(RegLength(9), "0")
            sRegMapVals(0, 10) = String(RegLength(10), "0")
            sRegMapVals(0, 11) = String(RegLength(11), "0")
            sRegMapVals(0, 12) = String(RegLength(12), "0")
            sRegMapVals(0, 13) = String(RegLength(13), "0")
            sRegMapVals(0, 14) = "00100000010101100001100100000000"
            'String(RegLength(14), "0")
        
            'Initialize the registermaps to their default states
            sRegMapVals(1, 0) = String(RegLength(0), "0")
            sRegMapVals(1, 1) = "0000000000000000011110001111111100000111"
            sRegMapVals(1, 2) = String(RegLength(2), "0")
            sRegMapVals(1, 3) = String(RegLength(3), "0")
            sRegMapVals(1, 4) = String(RegLength(4), "0")
            sRegMapVals(1, 5) = String(RegLength(5), "0")
            sRegMapVals(1, 6) = String(RegLength(6), "0")
            sRegMapVals(1, 7) = String(RegLength(7), "0")
            sRegMapVals(1, 8) = String(RegLength(8), "0")
            sRegMapVals(1, 9) = String(RegLength(9), "0")
            sRegMapVals(1, 10) = String(RegLength(10), "0")
            sRegMapVals(1, 11) = String(RegLength(11), "0")
            sRegMapVals(1, 12) = String(RegLength(12), "0")
            sRegMapVals(1, 13) = String(RegLength(13), "0")
            sRegMapVals(1, 14) = "00100000010101100001100100000000"
            'String(RegLength(14), "0")

        Case sd9956_DUT1:
            'Initialize the registermaps to their default states
            sRegMapValsNew(0, 0) = String(RegLength(0), "0")
            sRegMapValsNew(0, 1) = "0000000000000000011110001111111100000111"
            sRegMapValsNew(0, 2) = String(RegLength(2), "0")
            sRegMapValsNew(0, 3) = String(RegLength(3), "0")
            sRegMapValsNew(0, 4) = String(RegLength(4), "0")
            sRegMapValsNew(0, 5) = String(RegLength(5), "0")
            sRegMapValsNew(0, 6) = String(RegLength(6), "0")
            sRegMapValsNew(0, 7) = String(RegLength(7), "0")
            sRegMapValsNew(0, 8) = String(RegLength(8), "0")
            sRegMapValsNew(0, 9) = String(RegLength(9), "0")
            sRegMapValsNew(0, 10) = String(RegLength(10), "0")
            sRegMapValsNew(0, 11) = String(RegLength(11), "0")
            sRegMapValsNew(0, 12) = String(RegLength(12), "0")
            sRegMapValsNew(0, 13) = String(RegLength(13), "0")
            sRegMapValsNew(0, 14) = "00100000010101100001100100000000"
            'String(RegLength(14), "0")
            
            'Initialize the registermaps to their default states
            sRegMapVals(0, 0) = String(RegLength(0), "0")
            sRegMapVals(0, 1) = "0000000000000000011110001111111100000111"
            sRegMapVals(0, 2) = String(RegLength(2), "0")
            sRegMapVals(0, 3) = String(RegLength(3), "0")
            sRegMapVals(0, 4) = String(RegLength(4), "0")
            sRegMapVals(0, 5) = String(RegLength(5), "0")
            sRegMapVals(0, 6) = String(RegLength(6), "0")
            sRegMapVals(0, 7) = String(RegLength(7), "0")
            sRegMapVals(0, 8) = String(RegLength(8), "0")
            sRegMapVals(0, 9) = String(RegLength(9), "0")
            sRegMapVals(0, 10) = String(RegLength(10), "0")
            sRegMapVals(0, 11) = String(RegLength(11), "0")
            sRegMapVals(0, 12) = String(RegLength(12), "0")
            sRegMapVals(0, 13) = String(RegLength(13), "0")
            sRegMapVals(0, 14) = "00100000010101100001100100000000"
            'String(RegLength(14), "0")
    
        Case sd9956_DUT2:
            'Initialize the registermaps to their default states
            sRegMapValsNew(1, 0) = String(RegLength(0), "0")
            sRegMapValsNew(1, 1) = "0000000000000000011110001111111100000111"
            sRegMapValsNew(1, 2) = String(RegLength(2), "0")
            sRegMapValsNew(1, 3) = String(RegLength(3), "0")
            sRegMapValsNew(1, 4) = String(RegLength(4), "0")
            sRegMapValsNew(1, 5) = String(RegLength(5), "0")
            sRegMapValsNew(1, 6) = String(RegLength(6), "0")
            sRegMapValsNew(1, 7) = String(RegLength(7), "0")
            sRegMapValsNew(1, 8) = String(RegLength(8), "0")
            sRegMapValsNew(1, 9) = String(RegLength(9), "0")
            sRegMapValsNew(1, 10) = String(RegLength(10), "0")
            sRegMapValsNew(1, 11) = String(RegLength(11), "0")
            sRegMapValsNew(1, 12) = String(RegLength(12), "0")
            sRegMapValsNew(1, 13) = String(RegLength(13), "0")
            sRegMapValsNew(1, 14) = "00100000010101100001100100000000"
            'String(RegLength(14), "0")
            
            'Initialize the registermaps to their default states
            sRegMapVals(1, 0) = String(RegLength(0), "0")
            sRegMapVals(1, 1) = "0000000000000000011110001111111100000111"
            sRegMapVals(1, 2) = String(RegLength(2), "0")
            sRegMapVals(1, 3) = String(RegLength(3), "0")
            sRegMapVals(1, 4) = String(RegLength(4), "0")
            sRegMapVals(1, 5) = String(RegLength(5), "0")
            sRegMapVals(1, 6) = String(RegLength(6), "0")
            sRegMapVals(1, 7) = String(RegLength(7), "0")
            sRegMapVals(1, 8) = String(RegLength(8), "0")
            sRegMapVals(1, 9) = String(RegLength(9), "0")
            sRegMapVals(1, 10) = String(RegLength(10), "0")
            sRegMapVals(1, 11) = String(RegLength(11), "0")
            sRegMapVals(1, 12) = String(RegLength(12), "0")
            sRegMapVals(1, 13) = String(RegLength(13), "0")
            sRegMapVals(1, 14) = "00100000010101100001100100000000"
            'String(RegLength(14), "0")
    End Select
End Sub
'If the user select's both duts they will only get dut1
Public Function GetRegMapValue(ByVal DUT As selDUTs_9956, ByVal RegMap As rmv9956_RegMap, ByVal RegAddr As RMA9956) As String
    Select Case DUT
        Case sd9956_Both:
            If RegMap = rm9956_NewRegMapVals Then
                GetRegMapValue = sRegMapValsNew(0, RegAddr)
            Else
                GetRegMapValue = sRegMapVals(0, RegAddr)
            End If
        Case sd9956_DUT1, sd9956_DUT2:
            If RegMap = rm9956_NewRegMapVals Then
                GetRegMapValue = sRegMapValsNew(DUT - 1, RegAddr)
            Else
                GetRegMapValue = sRegMapVals(DUT - 1, RegAddr)
            End If
    End Select
End Function
'Sets a new regmap value in the softwares copy of the register map
Public Sub SetRegMapValue(ByVal DUT As selDUTs_9956, ByVal RegMap As rmv9956_RegMap, ByVal RegAddress As RMA9956, ByVal strValue As String)
    Select Case DUT
        Case sd9956_Both:
            If RegMap = rm9956_NewRegMapVals Then
                sRegMapValsNew(0, RegAddress) = strValue
                sRegMapValsNew(1, RegAddress) = strValue
            Else
                sRegMapVals(0, RegAddress) = strValue
                sRegMapVals(1, RegAddress) = strValue
            End If
        Case sd9956_DUT1, sd9956_DUT2:
            If RegMap = rm9956_NewRegMapVals Then
                sRegMapValsNew(DUT - 1, RegAddress) = strValue
            Else
                sRegMapVals(DUT - 1, RegAddress) = strValue
            End If
    End Select
    
End Sub





Public Sub FindEvalBd()
End Sub

Public Sub InitEvalBd()
    If mvarPCInterface = 0 Then
        'Setup the evalboard buffer values to default
        evbBuffers(0) = &H0  'USB PortD Values
        evbBuffers(1) = &HC2 'USB PortA Values - Chip Select High and PLL_Lock_SL High
        evbBuffers(2) = &H1 'USB Ctl values SCLK High
        
        'Write the default values out to the evalboard
        USBWriteEvbBuffVal evb56_USBPortA
        USBWriteEvbBuffVal evb56_USBPortD
        USBWriteEvbBuffVal evb56_USBCtl
    Else
        'Write out 0's to the parallel ports control and data registers
        PPIO.WritePort ppControlRegister, 0
        PPIO.WritePort ppDataRegister, 0
        
        'Setup the evalboard buffer values to default
        evbBuffers(0) = 0
        evbBuffers(1) = &HC0  'Chip Select High
        evbBuffers(2) = &H0   'USB Ctl values
        
        'Write the default values out to the evalboard
        PPWriteEvbBuffVal evb56_Buffer0
        PPWriteEvbBuffVal evb56_Buffer0
        PPWriteEvbBuffVal evb56_Buffer1
    End If
End Sub










Public Property Let RESET_DUT2(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.RESET_DUT2 = 5
'    mvarRESET_DUT2 = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer1, bnReset_DUT2, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortA, bnUSB_Reset_DUT2, vData
    End If
End Property


Public Property Get RESET_DUT2() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.RESET_DUT2
'    Set RESET_DUT2 = mvarRESET_DUT2
    If mvarPCInterface = 1 Then
        RESET_DUT2 = GetEvbBuffBitVal(evb56_Buffer1, bnReset_DUT2)
    ElseIf mvarPCInterface = 0 Then
        RESET_DUT2 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT2)
    End If
End Property



Public Property Let Profile2_DUT2(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Profile2_DUT2 = 5
'    mvarProfile2_DUT2 = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer0, bnPS2_DUT2, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortD, bnUSB_PS2_DUT2, vData
    End If
End Property


Public Property Get Profile2_DUT2() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Profile2_DUT2
    'Set Profile2_DUT2 = mvarProfile2_DUT2
    If mvarPCInterface = 1 Then
        Profile2_DUT2 = GetEvbBuffBitVal(evb56_Buffer0, bnPS2_DUT2)
    ElseIf mvarPCInterface = 0 Then
        Profile2_DUT2 = USBGetEvbBuffBitVal(evb56_USBPortD, bnUSB_PS2_DUT2)
    End If
End Property



Public Property Let Profile1_DUT2(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Profile1_DUT2 = 5
'    mvarProfile1_DUT2 = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer0, bnPS1_DUT2, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortD, bnUSB_PS1_DUT2, vData
    End If
End Property


Public Property Get Profile1_DUT2() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Profile1_DUT2
'    Set Profile1_DUT2 = mvarProfile1_DUT2
    If mvarPCInterface = 1 Then
        Profile1_DUT2 = GetEvbBuffBitVal(evb56_Buffer0, bnPS1_DUT2)
    ElseIf mvarPCInterface = 0 Then
        Profile1_DUT2 = USBGetEvbBuffBitVal(evb56_USBPortD, bnUSB_PS1_DUT2)
    End If
End Property



Public Property Let Profile0_DUT2(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Profile0_DUT2 = 5
    'mvarProfile0_DUT2 = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer0, bnPS0_DUT2, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortD, bnUSB_PS0_DUT2, vData
    End If
End Property


Public Property Get Profile0_DUT2() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Profile0_DUT2
    'Set Profile0_DUT2 = mvarProfile0_DUT2
    If mvarPCInterface = 1 Then
        Profile0_DUT2 = GetEvbBuffBitVal(evb56_Buffer0, bnPS0_DUT2)
    ElseIf mvarPCInterface = 0 Then
        Profile0_DUT2 = USBGetEvbBuffBitVal(evb56_USBPortD, bnUSB_PS0_DUT2)
    End If
End Property



Public Property Let PLL_Lock_DUT2(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.IRQ_DUT2 = 5
'    mvarPLL_Lock_DUT2 = vData
End Property


Public Property Get PLL_Lock_DUT2() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.IRQ_DUT2
'    Set PLL_Lock_DUT2 = mvarPLL_Lock_DUT2
    Dim PortBVal As Byte
    
    If mvarPCInterface = 1 Then
        PPIO.ReadPort ppStatusRegister 'Read a byte from the status register
        PLL_Lock_DUT1 = PPIO.GetBitVal(ppaStatusRegister, bnPLL_LOCK_SL)  'Get the bit value
    ElseIf mvarPCInterface = 0 Then
        PortBVal = GetPortBValue()
        PLL_Lock_DUT1 = GetBitVal(PortBVal, bnUSB_PLL_Lock_DUT2)
    End If
End Property



Public Property Let IOUpdate_DUT2(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.IOUpdate_DUT2 = 5
'    mvarIOUpdate_DUT2 = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer0, bnIOUpdate_DUT2, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortD, bnUSB_IOUpdate_DUT2, vData
    End If
End Property


Public Property Get IOUpdate_DUT2() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.IOUpdate_DUT2
'    Set IOUpdate_DUT2 = mvarIOUpdate_DUT2
    If mvarPCInterface = 1 Then
        IOUpdate_DUT2 = GetEvbBuffBitVal(evb56_Buffer0, bnIOUpdate_DUT2)
    ElseIf mvarPCInterface = 0 Then
        IOUpdate_DUT2 = USBGetEvbBuffBitVal(evb56_USBPortD, bnUSB_IOUpdate_DUT2)
    End If
End Property



Public Property Let SyncIO_DUT2(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.IOSync_DUT2 = 5
    'mvarIOSync_DUT2 = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer1, bnSyncIO_DUT2, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortA, bnUSB_SyncIO_DUT2, vData
    End If
End Property


Public Property Get SyncIO_DUT2() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.IOSync_DUT2
    'Set IOSync_DUT2 = mvarIOSync_DUT2
    If mvarPCInterface = 1 Then
        SyncIO_DUT2 = GetEvbBuffBitVal(evb56_Buffer1, bnSyncIO_DUT2)
    ElseIf mvarPCInterface = 0 Then
        SyncIO_DUT2 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_SyncIO_DUT2)
    End If
End Property



Public Property Let AutoIOUpdate_DUT2(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.AutoIOUpdate_DUT2 = 5
    mvarAutoIOUpdate_DUT2 = vData
    'SetEvbBuffBitVal evb56_Buffer1, bnIOUpdate_DUT2, vData
End Property


Public Property Get AutoIOUpdate_DUT2() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.AutoIOUpdate_DUT2
    AutoIOUpdate_DUT2 = mvarAutoIOUpdate_DUT2 'GetEvbBuffBitVal(evb56_Buffer1, bnIOUpdate_DUT2)

    '
End Property

Function GetBitVal(ByVal Value As Byte, ByVal Bit As evbBits) As Byte
    'Return the value of the bit requested
    GetBitVal = CByte(Value And CByte(evbBitVals(Bit)))
End Function
Function SetBitVal(ByVal Value As Byte, ByVal Bit As evbBits, ByVal BitVal As adiBitValues) As Byte
    If BitVal = abvHigh Then
        SetBitVal = CByte(Value Or CByte(evbBitVals(Bit)))
    Else
        SetBitVal = CByte(Value And CByte(Not evbBitVals(Bit)))
    End If
End Function


Public Property Let PLL_Lock_DUT1(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.IRQ_DUT1 = 5
'    mvarPLL_Lock_DUT1 = vData
End Property


Public Property Get PLL_Lock_DUT1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.IRQ_DUT1
Dim PortBVal As Byte

    If mvarPCInterface = 1 Then
        PPIO.ReadPort ppStatusRegister 'Read a byte from the status register
        PLL_Lock_DUT1 = PPIO.GetBitVal(ppaStatusRegister, bnPLL_LOCK_MA)   'Get the bit value
    ElseIf mvarPCInterface = 0 Then
        PortBVal = GetPortBValue()
        PLL_Lock_DUT1 = GetBitVal(PortBVal, bnUSB_PLL_Lock_DUT1)
    End If
End Property






Public Property Let Profile2_DUT1(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Profile2 = 5
'    mvarProfile2 = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer0, bnPS2_DUT1, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortD, bnUSB_PS2_DUT1, vData
    End If
End Property


Public Property Get Profile2_DUT1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Profile2
'    Set Profile2 = mvarProfile2
    If mvarPCInterface = 1 Then
        Profile2_DUT1 = GetEvbBuffBitVal(evb56_Buffer0, bnPS2_DUT1)
    ElseIf mvarPCInterface = 0 Then
        Profile2_DUT1 = USBGetEvbBuffBitVal(evb56_USBPortD, bnUSB_PS2_DUT1)
    End If
End Property



Public Property Let Profile1_DUT1(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Profile1 = 5
    'mvarProfile1 = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer0, bnPS1_DUT1, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortD, bnUSB_PS1_DUT1, vData
    End If
End Property


Public Property Get Profile1_DUT1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Profile1
    'Set Profile1 = mvarProfile1
    If mvarPCInterface = 1 Then
        Profile1_DUT1 = GetEvbBuffBitVal(evb56_Buffer0, bnPS1_DUT1)
    ElseIf mvarPCInterface = 0 Then
        Profile1_DUT1 = USBGetEvbBuffBitVal(evb56_USBPortD, bnUSB_PS1_DUT1)
    End If
End Property



Public Property Let Profile0_DUT1(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.Profile0 = 5
'    mvarProfile0 = vData
    'Set Profile0 = mvarProfile0
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer0, bnPS0_DUT1, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortD, bnUSB_PS0_DUT1, vData
    End If
End Property


Public Property Get Profile0_DUT1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.Profile0
    'Set Profile0 = mvarProfile0
    If mvarPCInterface = 1 Then
        Profile0_DUT1 = GetEvbBuffBitVal(evb56_Buffer0, bnPS0_DUT1)
    ElseIf mvarPCInterface = 0 Then
        Profile0_DUT1 = USBGetEvbBuffBitVal(evb56_USBPortD, bnUSB_PS0_DUT1)
    End If
End Property



Public Property Let RESET_DUT1(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.RESET = 5
'    mvarRESET_DUT2 = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer1, bnReset_DUT1, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortA, bnUSB_Reset_DUT1, vData
    End If
End Property


Public Property Get RESET_DUT1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.RESET
'    Set Reset = mvarReset
    If mvarPCInterface = 1 Then
        RESET_DUT1 = GetEvbBuffBitVal(evb56_Buffer1, bnReset_DUT1)
    ElseIf mvarPCInterface = 0 Then
        RESET_DUT1 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_Reset_DUT1)
    End If
End Property



Public Property Let IOUpdate_DUT1(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.IOUpdate = 5
'    mvarIOUpdate = vData
    If mvarPCInterface Then
        SetEvbBuffBitVal evb56_Buffer0, bnIOUpdate_DUT1, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortD, bnUSB_IOUpdate_DUT1, vData
    End If
End Property


Public Property Get IOUpdate_DUT1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.IOUpdate
'    Set IOUpdate = mvarIOUpdate
    If mvarPCInterface = 1 Then
        IOUpdate_DUT1 = GetEvbBuffBitVal(evb56_Buffer0, bnIOUpdate_DUT1)
    ElseIf mvarPCInterface = 0 Then
        IOUpdate_DUT1 = USBGetEvbBuffBitVal(evb56_USBPortD, bnUSB_IOUpdate_DUT1)
    End If
End Property



Public Property Let SyncIO_DUT1(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.IOSync = 5
    'mvarIOSYNC = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer1, bnSyncIO_DUT1, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBPortA, bnUSB_SyncIO_DUT1, vData
    End If
End Property


Public Property Get SyncIO_DUT1() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.IOSync
    'Set IOSYNC = mvarIOSYNC
    If mvarPCInterface = 1 Then
        SyncIO_DUT1 = GetEvbBuffBitVal(evb56_Buffer1, bnSyncIO_DUT1)
    ElseIf mvarPCInterface = 0 Then
        SyncIO_DUT1 = USBGetEvbBuffBitVal(evb56_USBPortA, bnUSB_SyncIO_DUT1)
    End If
End Property



Public Property Let SCLK(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SCLK = 5
'    mvarSCLK = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer1, bnSCLK, vData
    ElseIf mvarPCInterface = 0 Then
        USBSetEvbBuffBitVal evb56_USBCtl, bnUSB_SCLK, vData
        USBWriteEvbBuffVal evb56_USBCtl
    End If
End Property


Public Property Get SCLK() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SCLK
'    Set SCLK = mvarSCLK
    If mvarPCInterface = 1 Then
        SCLK = GetEvbBuffBitVal(evb56_Buffer1, bnSCLK)
    ElseIf mvarPCInterface = 0 Then
        SCLK = USBGetEvbBuffBitVal(evb56_USBCtl, bnUSB_SCLK)
    End If
End Property



Public Property Let SDO(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SDO = 5
'    mvarSDO = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer1, bnSDO, vData
    Else
    End If
End Property


Public Property Get SDO() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SDO
'    Set SDO = mvarSDO
    Dim StatusRegVal As Integer
    
    If mvarPCInterface = 1 Then
        StatusRegVal = PPIO.ReadPort(ppStatusRegister) 'Read a byte from the status register
        SDO = PPIO.GetBitVal(ppaStatusRegister, bnSDO) 'Get the bit value
    ElseIf mvarPCInterface = 0 Then
        StatusRegVal = GetPortBValue 'Read from PortB of the EZUSB FX2 chip
        SDO = GetBitVal(CByte(StatusRegVal), bnUSB_SDO) 'Get the bit value
    End If
End Property



Public Property Let SDIO(ByVal vData As adiBitValues)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.SDIO = 5
'    mvarSDIO = vData
    If mvarPCInterface = 1 Then
        SetEvbBuffBitVal evb56_Buffer1, bnSDIO, vData
    Else
    End If
End Property


Public Property Get SDIO() As adiBitValues
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.SDIO
'    Set SDIO = mvarSDIO
    If mvarPCInterface = 1 Then
        SDIO = GetEvbBuffBitVal(evb56_Buffer1, bnSDIO)
    Else
    End If
End Property



Public Property Let AutoIOUpdate_DUT1(ByVal vData As Boolean)
'used when assigning a value to the property, on the left side of an assignment.
'Syntax: X.AutoIOUpdate = 5
    mvarAutoIOUpdate_DUT1 = vData
'    SetEvbBuffBitVal evb56_Buffer1, bnIOUpdate_DUT1, vData

End Property


Public Property Get AutoIOUpdate_DUT1() As Boolean
'used when retrieving value of a property, on the right side of an assignment.
'Syntax: Debug.Print X.AutoIOUpdate
    AutoIOUpdate_DUT1 = mvarAutoIOUpdate_DUT1
'    AutoIOUpdate_DUT1 = GetEvbBuffBitVal(evb56_Buffer1, bnIOUpdate_DUT1)
End Property



'Flips a string - used to flip the data in lsb first mode
Public Function FlipString(ByVal MyStr As String) As String
    Dim cntr As Integer
    For cntr = Len(MyStr) To 1 Step -1
        FlipString = FlipString & Mid(MyStr, cntr, 1)
    Next cntr
End Function

Private Sub Class_Initialize()
    Dim cntr As Integer
        
    'Setup the lptio class
    Set PPIO = New clsLPTIO
    
    'Initialize the bitvals array
    For cntr = 0 To 7
        evbBitVals(cntr) = 2 ^ cntr
    Next cntr
    
    'Setup the evaluation board buffers values
    evbBuffers(0) = 0
    evbBuffers(1) = &H0
    evbBuffers(2) = &H0
     
'    evbUSBBuffers(0) = &HC0 'PortA[7:0] Values - 11000000b
'    evbUSBBuffers(1) = &H0  'PortD[7:0] Values
'    evbUSBBuffers(2) = &H0  'CTL[2:0] Values
'
    'Setup the Register Length Lookup table
    RegLength(0) = 32
    RegLength(1) = 40
    RegLength(2) = 24
    RegLength(3) = 24
    RegLength(4) = 16
    RegLength(5) = 16
    RegLength(6) = 64
    RegLength(7) = 64
    RegLength(8) = 64
    RegLength(9) = 64
    RegLength(10) = 64
    RegLength(11) = 64
    RegLength(12) = 64
    RegLength(13) = 64
    RegLength(14) = 32

    'Initialize the register map values
    ResetRegMaps sd9956_Both
    
    'Initialize default values
    mvarAutoIOUpdate_DUT1 = True
    mvarAutoIOUpdate_DUT2 = True
    
    mvarPCInterface = -1 'Means Unknown
End Sub

Private Sub Class_Terminate()
    'Set the lptio class equal to nothing
    Set PPIO = Nothing
End Sub
'Looks for the eval board on the LPT port and selects the LPT port it found it on
Public Function PPFindEvalBD() As Boolean
    Dim NumOfLPTs As Integer
    Dim evalbdfnd As Boolean
    Dim cntr As Integer
    
    evalbdfnd = False
    
    'Get the number of LPT ports to test
    NumOfLPTs = frmLPTSelect.LPTGetPortCount
    
    For cntr = 0 To NumOfLPTs - 1
        'Select the next lptport to test
        frmLPTSelect.LPTSelectPort cntr
        'Initialize the evalboard buffers
        InitEvalBd
        
        'Take SCLK low
        SCLK = abvLow
        PPWriteEvbBuffVal evb56_Buffer1
                
        'Read back the value of SCLK through the SCLK1 property
        If SCLK1 = abvLow Then
            SCLK = abvHigh
            PPWriteEvbBuffVal evb56_Buffer1
            'Test the second value written
            If SCLK1 = abvHigh Then
                evalbdfnd = True
                Exit For 'Break out of the for loop
            Else
                evalbdfnd = False
            End If
        Else
            evalbdfnd = False
        End If
    Next cntr

    'Set the PCInterface value to Parallel Port Control as default
    mvarPCInterface = 1
    If evalbdfnd Then
        RaiseEvent EvalBdFound
    End If
    
    'Return the evalbdfnd value
    PPFindEvalBD = evalbdfnd
End Function


Public Function GetFirmWareVersion() As String
    'This routine returns 2 bytes.  The first contains version Major
    'the second contains version minor.
    'Example = VerMajor.VerMinor = 1.9
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    Driver = clsEZUSBDev01.DriverName
    buf(0) = &H0
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1) 'DoBulkXfer(Driver, 0, buf, 1)
    
    If result <> 1 Then
        MsgBox "Error writing to device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 2) 'DoBulkXfer(Driver, 1, Data, 2)
    If result <> 1 Then
        MsgBox "Error reading to device."
        Exit Function
    End If

    'Return the firmware version
    GetFirmWareVersion = CStr(Data(0)) & "." & CStr(Data(1))
End Function

Public Function SetPortAValue(ByVal Value As Byte) As Boolean
    'This routine sets the value applied to PortA's pins on the EZUSB FX2 chip
    'Returns - True if successfull, False if unsuccessfull
    'Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H1 'Comand value for Writing PortA Value
    buf(1) = Value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        MsgBox "Error setting PortA value."
        SetPortAValue = False
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
'    result = DoBulkXfer(Driver, 1, Data, 1)
    If result <> 1 Then
        MsgBox "Error setting PortA value."
        SetPortAValue = False
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetPortAValue = True
    Else
        SetPortAValue = False
    End If
End Function

Public Function GetPortAValue() As Byte
    'This routine returns the value of PortA from the EZUSB-FX2 chip
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &H2
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    If result <> 1 Then
        MsgBox "Error writing to device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error reading to device."
        Exit Function
    End If

    'Return the firmware version
    GetPortAValue = Data(0)
End Function

Public Function GetCtlValues()
    'This routine returns 1 byte.  Which represents the current
    'state of the GPIF Ctl lines
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &H6
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    If result <> 1 Then
        MsgBox "Error writing to device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error reading from device."
        Exit Function
    End If

    'Return the value
    GetCtlValues = Data(0)
End Function


Public Function SetCtlValues(ByVal Value As Byte) As Boolean
    'This routine sets the value of the control lines
    'Value = Value to be set to the GPIFIDLECTL register on the EzUSB FX2 chip.
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H5 'Comand value for Writing CTL Values
    buf(1) = Value
       
    'send 2 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        MsgBox "Error writing device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error reading device."
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetCtlValues = True
    Else
        SetCtlValues = False
    End If
End Function

Public Sub SetRdBackByteCnt(ByVal Value As Integer)
    'This subroutine sets the number of bytes that will be read back through
    'the GPIF interface in single byte Read Mode
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &H7 'Command value for setting single read byte count mode.
    buf(1) = MSB(Value)
    buf(2) = lsb(Value)
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 3)
    If result <> 1 Then
        MsgBox "Error writing to device."
        Exit Sub
    End If

End Sub
Public Function SetHostID(ByVal lHostID As Long) As Long
    'This subroutine sets the number of bytes that will be read back through
    'the GPIF interface in single byte Read Mode
    Dim buf(5) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    buf(0) = &HD  'Command value
    buf(1) = GetByteFromLong(lHostID, 3)
    buf(2) = GetByteFromLong(lHostID, 2)
    buf(3) = GetByteFromLong(lHostID, 1)
    buf(4) = GetByteFromLong(lHostID, 0)
    
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 5)
    
    'Return the result
    SetHostID = result
'    If result <> 1 Then
'        'MsgBox "Error writing to device."
'        'Exit Function
'    End If
End Function
Public Function GetHostID(ByRef lValue As Long) As Integer
    'This subroutine sets the number of bytes that will be read back through
    'the GPIF interface in single byte Read Mode
    Dim buf(1) As Byte
    Dim result As Long
    Dim Data(4) As Byte
            
    buf(0) = &HE 'Command value for setting single read byte count mode.
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    'If no errors then continue
    If result = 1 Then
        result = clsEZUSBDev01.BulkXfer(1, Data, 4)
    End If

    If result = 1 Then
        'Now that the data has been recieved convert to a long
        lValue = MergeBytes2Long(Data(0), Data(1), Data(2), Data(3))
    End If

'    If result <> 1 Then
'        MsgBox "Error writing to device."
'        Exit Function
'    End If
    
    GetHostID = result

End Function

Public Sub SetRdBackMode(ByVal Value As Boolean)
    'This subroutine sets the readback mode of the firmware
    'Value = true  - Single byte read mode enabled
    'Value = false - Single byte read mode disabled
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H4 'Command value for setting single read byte count mode.
    If Value = True Then
        buf(1) = 1
    Else
        buf(1) = 0
    End If
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        MsgBox "Error setting single readback mode."
        Exit Sub
    End If
End Sub

Public Function SetPortBValue(ByVal Value As Byte) As Boolean
    'This routine sets the value applied to PortA's pins on the EZUSB FX2 chip
    'Returns - True if successfull, False if unsuccessfull
    'Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &HA  'Comand value for Writing PortA Value
    buf(1) = Value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        MsgBox "Error setting PortB value."
        SetPortBValue = False
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error setting PortB value."
        SetPortBValue = False
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetPortBValue = True
    Else
        SetPortBValue = False
    End If
End Function

Public Function GetPortBValue() As Byte
    'This routine returns the value of PortB
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H9
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    If result <> 1 Then
        MsgBox "Error writing device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error reading device.."
        Exit Function
    End If

    'Return the value.
    GetPortBValue = Data(0)
End Function

Public Sub ResetFirmware()
    'Resets the firmware

    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &H8 'Command value to reset the firmware and evaluation board.
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDevice.BulkXfer(0, buf, 1)
    If result <> 1 Then
        'MsgBox "Error writing device."
        Exit Sub
    End If
End Sub

'Converts sStr into a byte array
Private Function Str2ByteArray(ByVal sStr As String) As Byte()
    Dim i As Integer
    Dim barray() As Byte

    ReDim barray(0 To Len(sStr) - 1)

    'Convert to a byte buffer
    For i = 0 To Len(sStr) - 1
        barray(i) = CByte(Mid(sStr, i + 1, 1))
    Next

    Str2ByteArray = barray
End Function

'Converts sStr into a byte array
Private Function ByteArray2Str(barray() As Byte) As String
    Dim i As Integer
    Dim sStr As String

    'Convert to a string
    For i = 0 To UBound(barray)
        sStr = sStr & CStr(barray(i))
    Next

    ByteArray2Str = sStr
End Function
Private Function MSB(ByVal iVal As Integer) As Byte
    MSB = CByte(Fix(iVal / 256))
End Function

Private Function lsb(ByVal iVal As Integer) As Byte
    lsb = CByte(Fix(iVal And &HFF))
End Function

Public Function SetPortDValue(ByVal Value As Byte) As Boolean
    'This routine sets the value of port D to the value of "Value"
    'Input - Value: the value to be applied to the port d pins
    'Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &HC  'Comand value for Writing PortD Value
    buf(1) = Value
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 2)
    If result <> 1 Then
        'MsgBox "Error setting PortD value."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error setting PortD value."
        Exit Function
    End If

    If Data(0) = buf(1) Then
        SetPortDValue = True
    Else
        SetPortDValue = False
    End If
End Function

Public Function GetPortDValue() As Byte
    'This routine returns the value of PortA
    Dim Driver As String
    Dim buf(2) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
'    Driver = USBDrvName
    buf(0) = &HB
       
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 1)
    If result <> 1 Then
        'MsgBox "Error writing device."
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
    If result <> 1 Then
        MsgBox "Error reading device."
        Exit Function
    End If

    'Return PortD's value
    GetPortDValue = Data(0)
End Function

Public Function USBGetEvbBuffVal(ByVal Buff As evb9956USBEvBdBuffs) As Integer
    'Return the requested information
    USBGetEvbBuffVal = evbBuffers(Buff)
End Function

Public Sub USBSerialLoad(ByVal DUT As selDUTs_9956, ByVal RegAddress As RMA9956, ByVal Data As String)
    Dim buffer() As Byte
    Dim result As Long
    Dim i As Integer
    Dim lDataLen As Long
    Dim sDriverName As String
    Dim Checker As String
    Dim sData As String
    Dim NumBytes As Integer
    
    Dim sInstructByte As String
    
'    If RegAddress = RMA9956_TR Then
'        ReDim buffer(0 To Len(Data) + 7 - 5) As Byte
'    Else
        ReDim buffer(0 To Len(Data) + 7) As Byte
'    End If
    
    'Only work if the object is enabled
    If mvarEnabled = True Then
        
        'Make sure that sclk is high before starting the transfer
        If EvBd.SCLK = abvLow Then
            'Make it high again
            EvBd.SCLK = abvHigh
            EvBd.USBWriteEvbBuffVal evb56_USBCtl
        End If
        
        'Build the instruction byte string
        'If writing to both DUTs make sure that both are in the same IOMode
        If (DUT <> 1 And DUT <> 2) And (LSBFirst_DUT1 <> LSBFirst_DUT2) Then
            'LSBFirst mode must be the same on both DUTs
            MsgBox "Error: To write to both DUT's simultaniously the LSB First bit must be the same for both DUTs.", vbApplicationModal, "Error: SUB Serial Load"
        Else
            'Get the number of bytes sent
            NumBytes = GetRegLen(RegAddress) / 8
            
            'If the number of bytes to send is different than the number of bytes
            'present in the data passed then exit the sub
            If (NumBytes = (Len(Data) / 8)) And (RegAddress >= 0 And RegAddress <= &HE) Then
                'Build the instruction byte
                sInstructByte = "000" & cbaseDec2Bin(RegAddress, 5)
                'Copy the data into a buffer where it can be manipulated preserving the origional data
                sData = Data
                
                'If it is the test register then trim off the 5 bits
'                If RegAddress = RMA9956_TR Then
'                    SData = Right(SData, Len(SData) - 5)
'                End If
                
                'First take the CSB line low and check for LSB Frist Mode
                Select Case DUT
                    Case 1
                        CSB_DUT1 = abvLow
                        'Check to see if the part is currently in LSB First Mode
                        If LSBFirst_DUT1 Then
                            'Rearrange the instruction byte into LSB First format
                            sInstructByte = FlipString(sInstructByte)
                            'Rearrange the data into LSB First format
                            sData = FlipString(sData)
                        End If
                    Case 2
                        CSB_DUT2 = abvLow
                        'Check to see if the part is currently in LSB First Mode
                        If LSBFirst_DUT2 Then
                            'Rearrange the instruction byte into LSB First format
                            sInstructByte = FlipString(sInstructByte)
                            'Rearrange the data into LSB First format
                            sData = FlipString(sData)
                        End If
                    Case Else
                        CSB_DUT1 = abvLow
                        CSB_DUT2 = abvLow
                        'Assume that DUT1 and DUT2 are set the same and check for
                        'LSB First mode on DUT1
                        If LSBFirst_DUT1 Then
                            'Rearrange the instruction byte into LSB First format
                            sInstructByte = FlipString(sInstructByte)
                            'Rearrange the data into LSB First format
                            sData = FlipString(sData)
                        End If
                End Select
                'Set CSB low
                USBWriteEvbBuffVal evb56_USBPortA
                
                'Build the serial stream
                sData = sInstructByte & sData
                
                'Convert to a byte buffer
                For i = 0 To Len(sData) - 1
                    buffer(i) = CByte(Mid(sData, i + 1, 1))
                Next
                
                'Get the length of the data to be sent
                lDataLen = Len(sData)
                
                result = clsEZUSBDev01.BulkXfer(ezWrite, buffer, lDataLen)
                
                'Now return the CSB line high
                Select Case DUT
                    Case 1
                        CSB_DUT1 = abvHigh
                    Case 2
                        CSB_DUT2 = abvHigh
                    Case Else
                        CSB_DUT1 = abvHigh
                        CSB_DUT2 = abvHigh
                End Select
                'Write the values to PortA of the FX2 Chip
                USBWriteEvbBuffVal evb56_USBPortA
                
                'Now check to see
                Select Case DUT
                    Case 1
                        'Now Check to see if they put the part into LSB First or 2 or 3 Wire Mode
                        If RegAddress = 0 Then
                            If Left(Right(Data, 16), 1) = "1" Then
                                'They sent the LSBFirst Bit
                                mvarLSBFirst_DUT1 = True
                            Else
                                'They Sent MSB First Mode
                                mvarLSBFirst_DUT1 = False
                            End If
                            If Left(Right(Data, 15), 1) = "1" Then
                                'They sent the SDIO Input Only Bit so they want 3 Wire Mode
                                mvarSerialIOMode_DUT1 = evbd56_ThreeWire
                            Else
                                'They want 2 wire mode
                                mvarSerialIOMode_DUT1 = evbd56_TwoWire
                            End If
                        End If
                        'Automatically do a frequency update if the option is true
                        If mvarAutoIOUpdate_DUT1 = True Then
                            IOUpdate_DUT1 = abvHigh
                            USBWriteEvbBuffVal evb56_USBPortD
                            IOUpdate_DUT1 = abvLow
                            USBWriteEvbBuffVal evb56_USBPortD
                        End If
                        
                    Case 2
                        'Now Check to see if they put the part into LSB First or 2 or 3 Wire Mode
                        If RegAddress = 0 Then
                            If Left(Right(Data, 16), 1) = "1" Then
                                'They sent the LSBFirst Bit
                                mvarLSBFirst_DUT2 = True
                            Else
                                'They Sent MSB First Mode
                                mvarLSBFirst_DUT2 = False
                            End If
                            If Left(Right(Data, 15), 1) = "1" Then
                                'They sent the SDIO Input Only Bit so they want 3 Wire Mode
                                mvarSerialIOMode_DUT2 = evbd56_ThreeWire
                            Else
                                'They want 2 wire mode
                                mvarSerialIOMode_DUT2 = evbd56_TwoWire
                            End If
                        End If
                        'Automatically do a frequency update if the option is true
                        If mvarAutoIOUpdate_DUT2 = True Then
                            IOUpdate_DUT2 = abvHigh
                            USBWriteEvbBuffVal evb56_USBPortD
                            IOUpdate_DUT2 = abvLow
                            USBWriteEvbBuffVal evb56_USBPortD
                        End If
                        
                    Case Else
                        'Now Check to see if they put the part into LSB First or 2 or 3 Wire Mode
                        If RegAddress = 0 Then
                            If Left(Right(Data, 16), 1) = "1" Then
                                'They sent the LSBFirst Bit
                                mvarLSBFirst_DUT1 = True
                                mvarLSBFirst_DUT2 = True
                            Else
                                'They Sent MSB First Mode
                                mvarLSBFirst_DUT1 = False
                                mvarLSBFirst_DUT2 = False
                            End If
                            If Left(Right(Data, 15), 1) = "1" Then
                                'They sent the SDIO Input Only Bit so they want 3 Wire Mode
                                mvarSerialIOMode_DUT1 = evbd56_ThreeWire
                                mvarSerialIOMode_DUT2 = evbd56_ThreeWire
                            Else
                                'They want 2 wire mode
                                mvarSerialIOMode_DUT1 = evbd56_TwoWire
                                mvarSerialIOMode_DUT2 = evbd56_TwoWire
                            End If
                        End If
                        
                        If mvarAutoIOUpdate_DUT1 And mvarAutoIOUpdate_DUT2 Then
                            'Fud both at the same time
                            IOUpdate_DUT1 = abvHigh
                            IOUpdate_DUT2 = abvHigh
                            USBWriteEvbBuffVal evb56_USBPortD
                            IOUpdate_DUT1 = abvLow
                            IOUpdate_DUT2 = abvLow
                            USBWriteEvbBuffVal evb56_USBPortD
                        Else
                            'Automatically do a frequency update if the option is true
                            If mvarAutoIOUpdate_DUT1 = True Then
                                IOUpdate_DUT1 = abvHigh
                                USBWriteEvbBuffVal evb56_USBPortD
                                IOUpdate_DUT1 = abvLow
                                USBWriteEvbBuffVal evb56_USBPortD
                            End If
                            'Automatically do a frequency update if the option is true
                            If mvarAutoIOUpdate_DUT2 = True Then
                                IOUpdate_DUT2 = abvHigh
                                USBWriteEvbBuffVal evb56_USBPortD
                                IOUpdate_DUT2 = abvLow
                                USBWriteEvbBuffVal evb56_USBPortD
                            End If
                        End If
                        
                End Select
                'Store the value written to the register in a buffer
                SetRegMapValue DUT, rm9956_CurRegMapVals, RegAddress, Data
                
                If result <> 1 Then: MsgBox "Error Writing to Board", vbOKOnly, "Error": Exit Sub
            Else
                'The data isn't valid or the address isn't valid
                If RegAddress < 0 Or RegAddress > &HE Then
                    MsgBox "Error: Invalid address = " & RegAddress & ".", vbApplicationModal, "Error: Sub USBSerialLoad"
                End If
                
                If NumBytes = (Len(Data) / 8) Then
                    MsgBox "Error: Invalid data = " & Data & ".", vbApplicationModal, "Error: Sub USBSerialLoad"
                End If
            End If
        End If
    End If
End Sub

Public Function USBSerialRead(ByVal DUT As selDUTs_9956, ByVal RegAddress As RMA9956) As String
    Dim buffer() As Byte
    Dim result As Long
    Dim i As Integer
    Dim IDataLen As Long
    Dim RDataLen As Long
    Dim sDriverName As String
    Dim ReturnBuff() As Byte
    Dim OldProfile As Integer
    Dim sRetStr As String
    Dim MaskVal As Byte 'Used to mask out either SDO or SDIO from the returned data
    
    Dim sInstructByte As String
    
    'Only work if the object is enabled
    If mvarEnabled = True Then
        If DUT = 1 Or DUT = 2 Then
            'Validate the register address
            If RegAddress >= 0 And RegAddress <= &HE Then
                'If reading back from one of the RSCW use the profile pins to address
                If RegAddress >= &H6 And RegAddress <= &HD Then
                    'Store the current profile setting
                    OldProfile = GetActiveProfile(DUT)
                    'Set the proper profile to address the right profile control register
                    SetActiveProfile DUT, RegAddress - 6
                End If
                
                'Build the instruction byte string
                sInstructByte = "100" & cbaseDec2Bin(RegAddress, 5)
                
                'Get the number of bits to read
                RDataLen = GetRegLen(RegAddress)
                
                'Number of bytes to write instruction byte
                IDataLen = Len(sInstructByte)
                'Setup a buffer to receive data into
                ReDim ReturnBuff(0 To RDataLen - 1) As Byte
                
                'Set number of bytes to read
                SetRdBackByteCnt RDataLen
                
                'Make sure that SCLK is High
                If SCLK = abvLow Then
                    SCLK = abvHigh
                    USBWriteEvbBuffVal evb56_USBCtl
                End If

                'Now take the appropriate the CSB line Low
                Select Case DUT
                    Case 1
                        CSB_DUT1 = abvLow
                
                        'Check to see if the part is currently in LSB First Mode
                        If LSBFirst_DUT1 Then
                            'Rearrange the instruction byte into LSB First format
                            sInstructByte = FlipString(sInstructByte)
                        End If
                    Case 2
                        CSB_DUT2 = abvLow
                
                        'Check to see if the part is currently in LSB First Mode
                        If LSBFirst_DUT2 Then
                            'Rearrange the instruction byte into LSB First format
                            sInstructByte = FlipString(sInstructByte)
                        End If
                End Select
                    
                'Convert the binary string into a bytearray for sending via the USB
                buffer() = Str2ByteArray(sInstructByte)
                
                USBWriteEvbBuffVal evb56_USBPortA
                
                'Write the instruction byte
                result = clsEZUSBDev01.BulkXfer(ezWrite, buffer, IDataLen)
                If result <> 1 Then
                    MsgBox "Error Writing to Board", vbOKOnly, "Error"
                    Exit Function
                End If
                
                'This line actually reads back the data into the EP8 Fifo and readys
                'it for readback by the PC using the Bulk Transfer below
                'Set the firmware in readback mode
                SetRdBackMode True
                
                'Readback the register value
                result = clsEZUSBDev01.BulkXfer(ezRead, ReturnBuff, RDataLen)
                If result <> 1 Then
                    MsgBox "Error Reading From Board", vbOKOnly, "Error"
                    Exit Function
                End If
                
                'Disable readback mode
                SetRdBackMode False
                
                'Now return the CSB line high
                Select Case DUT
                    Case 1:
                        CSB_DUT1 = abvHigh
                        'Setup the bitmask for the returned data
                        If mvarSerialIOMode_DUT1 = evbd56_ThreeWire Then
                            MaskVal = evbBitVals(bnUSB_SDO)
                        Else
                            MaskVal = evbBitVals(bnUSB_SDIO)
                        End If
                    Case 2:
                        CSB_DUT2 = abvHigh
                        'Setup the bitmask for the returned data
                        If mvarSerialIOMode_DUT2 = evbd56_ThreeWire Then
                            MaskVal = evbBitVals(bnUSB_SDO)
                        Else
                            MaskVal = evbBitVals(bnUSB_SDIO)
                        End If
                End Select
                USBWriteEvbBuffVal evb56_USBPortA

                'Mask out the proper bit Bit0 = SDIO, Bit1 = SDO-ThreeWireMode
                For i = 0 To RDataLen - 1
                    If ReturnBuff(i) And MaskVal Then
                        ReturnBuff(i) = 1
                    Else
                        ReturnBuff(i) = 0
                    End If
                Next i
                
                'Convert the byte array "ReturnBuff" to a binary string
                sRetStr = ByteArray2Str(ReturnBuff)
                
                If DUT = 2 Then
                    'Check to see if the part is currently in LSB First Mode
                    If LSBFirst_DUT2 Then
                        'Rearrange the instruction byte into LSB First format
                        sRetStr = FlipString(sRetStr)
                    End If
                Else
                    'Check to see if the part is currently in LSB First Mode
                    If LSBFirst_DUT1 Then
                        'Rearrange the instruction byte into LSB First format
                        sRetStr = FlipString(sRetStr)
                    End If
                End If
                
                'If reading back from one of the RSCW use the profile pins to address
                If RegAddress >= &H6 And RegAddress <= &HD Then
                    'Set the proper profile to address the right profile control register
                    SetActiveProfile DUT, OldProfile
                End If
                
                'Return the cleaned up data to the user
                USBSerialRead = sRetStr
            Else
                'Display an error message
                'The data isn't valid or the address isn't valid
                If RegAddress < 0 Or RegAddress > &HE Then
                    MsgBox "Error: Invalid address = " & Address & ".", vbApplicationModal, "Error: Sub SerialLoad"
                End If
                
                If NumBytes = (Len(Data) / 8) Then
                    MsgBox "Error: Invalid data = " & Data & ".", vbApplicationModal, "Error: Sub SerialLoad"
                End If
            End If
        Else
            'Display an error message
            MsgBox "You can only read from one dut at a time.", vbApplicationModal & vbCritical, "SerialRead()"
        End If
    End If
End Function


Public Sub SerialLoad(ByVal DUT As selDUTs_9956, ByVal RegAddress As RMA9956, ByVal Data As String)
    Select Case mvarPCInterface
        Case -1:
        Case 0:
            USBSerialLoad DUT, RegAddress, Data
        Case 1:
            PPSerialLoad DUT, RegAddress, Data
    End Select
End Sub

Public Function SerialRead(ByVal DUT As selDUTs_9956, ByVal RegAddress As RMA9956) As String
    Select Case mvarPCInterface
        Case -1:
        Case 0:
            SerialRead = USBSerialRead(DUT, RegAddress)
        Case 1:
            SerialRead = PPSerialRead(DUT, RegAddress)
    End Select
End Function

'Detects the evalboard duts attached to the master eval board
'Returns
'DUT1Detected - Returns true if DUT1 is detected
'DUT2Detected - Returns true if DUT2 is detected
Public Function DetectDUTs(ByRef Dut1Det As Boolean, ByRef Dut2Det As Boolean)
    Dim cntr As Integer
    Dim CFRReadVal As String
    
    Const CFR2Default = "0000000000000000011110001111111100000111"
    Const IDRegVal = "00100000010101100001100100000000"

    'Reset Both Duts
    ResetDUT sd9956_Both
    
    'Read CFR2 from the DUT
    CFRReadVal = SerialRead(sd9956_DUT1, RMA9956_CFR2)
    If CFRReadVal = CFR2Default Then
        Dut1Det = True
        mvarDut1Detected = True
    Else
        Dut1Det = False
        mvarDut1Detected = False
    End If
    
    'Read CFR2 from the DUT
    CFRReadVal = SerialRead(sd9956_DUT2, RMA9956_CFR2)
    If CFRReadVal = CFR2Default Then
        mvarDut2Detected = True
        Dut2Det = True
    Else
        Dut2Det = False
        mvarDut2Detected = False
    End If

    'If previous test passed then do the next
    If Dut1Det = True Then
        'Read CFR2 from the DUT
        CFRReadVal = SerialRead(sd9956_DUT1, RMA9956_TR)
        If CFRReadVal = IDRegVal Then
            Dut1Det = True
            mvarDut1Detected = True
        Else
            Dut1Det = False
            mvarDut1Detected = False
        End If
    End If
    
    'If previous test passed then do the next
    If Dut2Det = True Then
        'Read CFR2 from the DUT
        CFRReadVal = SerialRead(sd9956_DUT2, RMA9956_TR)
        If CFRReadVal = IDRegVal Then
            Dut2Det = True
            mvarDut2Detected = True
        Else
            Dut2Det = False
            mvarDut2Detected = False
        End If
    End If
End Function
'Resets the dut or duts defined by dutnum
Public Sub ResetDUT(ByVal DUTNum As selDUTs_9956)
    Select Case DUTNum
        Case sd9956_Both
            'Reset Both DUTs
            EvBd.RESET_DUT1 = abvLow
            EvBd.RESET_DUT2 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
                    
            EvBd.RESET_DUT1 = abvHigh
            EvBd.RESET_DUT2 = abvHigh
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
            
            EvBd.RESET_DUT1 = abvLow
            EvBd.RESET_DUT2 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
        Case sd9956_DUT1
            EvBd.RESET_DUT1 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
            
            EvBd.RESET_DUT1 = abvHigh
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
            
            EvBd.RESET_DUT1 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
        Case sd9956_DUT2
            EvBd.RESET_DUT2 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
            
            EvBd.RESET_DUT2 = abvHigh
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
            
            EvBd.RESET_DUT2 = abvLow
            EvBd.WriteEvbBuffVal evb56_Buff1_PortA
    End Select
End Sub

'Returns the byte indexed by iByteIndex from lValue
'Ex GetByteFromLong(&hFFABE1,1) would return &hAB
'Ex GetByteFromLong(&hFFABE1,4) would return 00
Private Function GetByteFromLong(ByVal lValue As Double, ByVal iByteIndex) As Byte
    If iByteIndex >= 0 And iByteIndex <= 3 Then
        GetByteFromLong = CByte(&HFF And Int(lValue / (256 ^ iByteIndex)))
    Else
        GetByteFromLong = &H0
    End If
End Function
'Returns the merged value of a
Private Function MergeBytes2Long(ByVal bByte3 As Byte, ByVal bByte2 As Byte, ByVal bByte1 As Byte, ByVal bByte0 As Byte) As Long
    Dim sTempVal As String
    
    'Build a hex string - seems to be the easiest way
    sTempVal = Format(Hex(bByte3), "00") & Format(Hex(bByte2), "00") & Format(Hex(bByte1), "00") & Format(Hex(bByte0), "00")
        
    'Result = (bbyte3 * 256^3) + (bbyte2 * 256^2) + (bbyte1 * 256^1) + (bbyte0 * 256^0)
    'MergeBytes2Long = (bByte3 * 16777216) + (bByte2 * 65536) + (bByte1 * 256) + bByte0
    'Convert that to a long value
    MergeBytes2Long = CLng("&h" & sTempVal)
End Function

Public Function USBSetAutoProfileSwitching_DUT1(ByVal EndProfile As Byte, ByVal CntrStopVal As Integer) As Boolean
    'This function will setup the firmware to loop through the profiles of dut1
    'Returns - True if successfull, False if unsuccessfull
    Dim buf(4) As Byte
    Dim result As Long
    Dim Data(2) As Byte
            
    'Driver = USBDrvName
    buf(0) = &HF 'Comand value for Setting Up the Auto Profile Switching
    buf(1) = EndProfile
    buf(2) = MSB(CntrStopVal)
    buf(3) = lsb(CntrStopVal)
    
    'send 1 byte of data out on EP1OUT
    result = clsEZUSBDev01.BulkXfer(0, buf, 4)
    If result <> 1 Then
'        MsgBox "Error setting PortA value."
        USBSetAutoProfileSwitching_DUT1 = False
        Exit Function
    End If
    
    'read 1 byte back on EP1IN
    result = clsEZUSBDev01.BulkXfer(1, Data, 1)
'    result = DoBulkXfer(Driver, 1, Data, 1)
    If result <> 1 Then
'        MsgBox "Error setting PortA value."
        USBSetAutoProfileSwitching_DUT1 = False
        Exit Function
    End If

    If Data(0) = 1 Then
        USBSetAutoProfileSwitching_DUT1 = True
    Else
        USBSetAutoProfileSwitching_DUT1 = False
    End If
End Function

'Determines if the silicon is 1st Silicon or 2nd Silicon
'by checking a functionality change in the silicon or defualt registermap values
'1st Silicon - The project chip silicon.
'2nd Silicon - First full mask set.
'Returns
'1 - First silicon detected
'2 - Second silicon detected
Public Function GetSiliconInfo(ByVal DUTNum As selDUTs_9956) As Long
    Dim RFResetEnable As Long
    Dim sTempCFR2 As String
    
    'Get the current value of the bit to be modified
    RFResetEnable = GetRegMapBitValue(DUTNum, rm9956_CurRegMapVals, RMA9956_CFR2, 7)
    
    If RFResetEnable = 0 Then
        'If the RFDividerResetEnable bit hasn't been set then do so
        SetRegMapBitValue DUTNum, rm9956_NewRegMapVals, RMA9956_CFR2, 7, abvHigh
        SerialLoad DUTNum, RMA9956_CFR2, GetRegMapValue(DUTNum, rm9956_NewRegMapVals, RMA9956_CFR2)
    End If
    
    'Pulse the SyncIO Pin
    If DUTNum = sd9956_DUT2 Then
        SyncIO_DUT1 = abvHigh
        WriteEvbBuffVal evb56_Buff1_PortA
        SyncIO_DUT1 = abvLow
        WriteEvbBuffVal evb56_Buff1_PortA
    Else
        SyncIO_DUT2 = abvHigh
        WriteEvbBuffVal evb56_Buff1_PortA
        SyncIO_DUT2 = abvLow
        WriteEvbBuffVal evb56_Buff1_PortA
    End If
    
    'Read the value back from the DUT
    sTempCFR2 = SerialRead(DUTNum, RMA9956_CFR2)
    'Set the value of the register
    SetRegMapValue DUTNum, rm9956_CurRegMapVals, RMA9956_CFR2, sTempCFR2
    
    'Check to see if the RFDividerResetEnable bit has been cleared
    If GetRegMapBitValue(DUTNum, rm9956_CurRegMapVals, RMA9956_CFR2, 7) = 0 Then
        GetSiliconInfo = 2
    Else
        GetSiliconInfo = 1
    End If
    
    'Reset the registers the way they were
    SerialLoad DUTNum, RMA9956_CFR2, sTempCFR2
    SetRegMapValue DUTNum, rm9956_NewRegMapVals, RMA9956_CFR2, sTempCFR2
End Function
