Attribute VB_Name = "Utility"
Option Explicit
'Win API functions
'Used to lock a window
Public Declare Function LockWindowUpdate Lib "user32" (ByVal hwndLock As Long) As Long

'Public Declare Function OpenProcess Lib "kernel32" _
'       (ByVal dwDesiredAccess As Long, _
'       ByVal bInheritHandle As Long, _
'       ByVal dwProcessId As Long) As Long

Public Declare Function WinHelp Lib "user32" Alias "WinHelpA" (ByVal hwnd As Long, ByVal lpHelpFile As String, ByVal wCommand As Long, ByVal dwData As Long) As Long
Public Const HELP_COMMAND = &H102&
Public Const HELP_CONTENTS = &H3&
Public Const HELP_CONTEXT = &H1
Public Const HELP_CONTEXTPOPUP = &H8&
Public Const HELP_FORCEFILE = &H9&
Public Const HELP_HELPONHELP = &H4
Public Const HELP_INDEX = &H3
Public Const HELP_KEY = &H101
Public Const HELP_MULTIKEY = &H201&
Public Const HELP_PARTIALKEY = &H105&
Public Const HELP_QUIT = &H2
Public Const HELP_SETCONTENTS = &H5&
Public Const HELP_SETINDEX = &H5
Public Const HELP_SETWINPOS = &H203&
Public Const HELPMSGSTRING = "commdlg_help"
Public Const HELP_TAB = &HF&

Public Declare Function GetExitCodeProcess Lib "kernel32" _
       (ByVal hProcess As Long, lpExitCode As Long) As Long

Const PROCESS_QUERY_INFORMATION = &H400

Public Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long

Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Public Const SW_HIDE = 0
Public Const SW_SHOWMAXIMIZED = 3
Public Const SW_SHOWMINIMIZED = 2
Public Const SW_SHOWNORMAL = 1
Public Const SW_SHOWNA = 8
Public Const SW_SHOWMINNOACTIVE = 7

'Finds the executable associated with a file
Public Declare Function FindExecutable Lib "shell32.dll" Alias "FindExecutableA" (ByVal lpFile As String, ByVal lpDirectory As String, ByVal lpResult As String) As Long
Public Const ERROR_FILE_NOT_FOUND = 2&
Public Const ERROR_PATH_NOT_FOUND = 3&
Public Const ERROR_BAD_FORMAT = 11&

'Maximum path length
Public Const MAX_PATH = 260

'Gets windows directory
Declare Function GetWindowsDirectory Lib "kernel32" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long

Public Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long
Public Declare Function OpenIcon Lib "user32" (ByVal hwnd As Long) As Long
Public Declare Function SetForegroundWindow Lib "user32" (ByVal hwnd As Long) As Long
Public Declare Function GetForegroundWindow Lib "user32" () As Long
Public Declare Function IsIconic Lib "user32" (ByVal hwnd As Long) As Long

Public Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Public Const hWnd_NOTOPMOST = -2
Public Const HWND_TOP = 0
Public Const HWND_TOPMOST = -1
Public Const HWND_BOTTOM = 1
Public Const SWP_NOMOVE = &H2
Public Const SWP_NOSIZE = &H1
Public Const SWP_SHOWWINDOW = &H40
Public Const SWP_NOACTIVATE = &H10

Public Declare Function SetCapture Lib "user32" (ByVal hwnd As Long) As Long
Public Declare Function ReleaseCapture Lib "user32" () As Long

Private Declare Sub ExitWindowsDialog Lib "shell32.dll" Alias "#60" (ByVal hwnd As Long)

'
' Constant used with GetWindow() to obta
'     in handle
' to MDIForm's client space
'
Public Const GW_CHILD = 5
Public Declare Function GetWindow Lib "user32" (ByVal hwnd As Long, ByVal wCmd As Long) As Long
Public Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Public Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal hdc As Long) As Long
Public Declare Function GetClientRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Public Type RECT
        Left As Long
        TOp As Long
        Right As Long
        Bottom As Long
End Type

Public Declare Function BitBlt Lib "gdi32" ( _
   ByVal hdcDest As Long, ByVal XDest As Long, _
   ByVal YDest As Long, ByVal nWidth As Long, _
   ByVal nHeight As Long, ByVal hDCSrc As Long, _
   ByVal XSrc As Long, ByVal YSrc As Long, ByVal dwRop As Long) _
   As Long

Public Const NOTSRCCOPY = &H330008 ' dest = (NOT source)
Public Const NOTSRCERASE = &H1100A6 ' dest = (NOT src) AND (NOT dest)
Public Const BLACKNESS = &H42 ' dest = BLACK
Public Const DSTINVERT = &H550009 ' dest = (NOT dest)
Public Const MERGECOPY = &HC000CA ' dest = (source AND pattern)
Public Const MERGEPAINT = &HBB0226 ' dest = (NOT source) OR dest
Public Const PATCOPY = &HF00021 ' dest = pattern
Public Const PATINVERT = &H5A0049 ' dest = pattern XOR dest
Public Const PATPAINT = &HFB0A09 ' dest = DPSnoo
Public Const SRCAND = &H8800C6 ' dest = source AND dest
Public Const SRCCOPY = &HCC0020 ' dest = source
Public Const SRCERASE = &H440328 ' dest = source AND (NOT dest )
Public Const SRCINVERT = &H660046 ' dest = source XOR dest
Public Const SRCPAINT = &HEE0086 ' dest = source OR dest
Public Const WHITENESS = &HFF0062  ' dest = WHITE

'Used to make modeless forms
Public Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Public Const WS_OVERLAPPED = &H0&

'**********************************************************
'Windows API/Global Declarations for :Win95DirectoryPrompt
'**********************************************************
Public Type BROWSEINFOTYPE
    hOwner As Long
    pidlRoot As Long
    pszDisplayName As String
    lpszTitle As String
    ulFlags As Long
    lpfn As Long
    lParam As Long
    iImage As Long
End Type
Public Const BIF_RETURNONLYFSDIRS = 1
'Public Const MAX_PATH = 260

Public Declare Sub CoTaskMemFree Lib "ole32.dll" (ByVal hMem As Long)

Public Declare Function lstrcat Lib "kernel32" Alias "lstrcatA" _
    (ByVal lpString1 As String, ByVal lpString2 As String) As Long

Public Declare Function SHBrowseForFolder Lib "shell32" _
    (lpbi As BROWSEINFOTYPE) As Long

Public Declare Function SHGetPathFromIDList Lib "shell32" _
    (ByVal pidList As Long, ByVal lpBuffer As String) As Long

Public Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (pDest As Any, pSource As Any, ByVal dwLength As Long)

Public Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long

Public Const WM_USER = &H400

Public Const BFFM_SETSELECTIONA As Long = (WM_USER + 102)
Public Const BFFM_SETSELECTIONW As Long = (WM_USER + 103)
Public Declare Function LocalAlloc Lib "kernel32" (ByVal uFlags As Long, ByVal uBytes As Long) As Long
Public Declare Function LocalFree Lib "kernel32" (ByVal hMem As Long) As Long
Public Const LPTR = (&H0 Or &H40)

'Used by DisableMinButton
Public Const MF_BYPOSITION = &H400&
Public Declare Function GetSystemMenu Lib "user32" (ByVal hwnd As Long, ByVal bRevert As Long) As Long
Public Declare Function RemoveMenu Lib "user32" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal wFlags As Long) As Long

Private Declare Function GetVersionEx Lib "kernel32" Alias "GetVersionExA" (ByRef lpVersionInformation As OSVERSIONINFO) As Long

'**************************************
'Windows API/Global Declarations for :Ch
'     anging priority
'**************************************
Private Const NORMAL_PRIORITY_CLASS = &H20
Private Const IDLE_PRIORITY_CLASS = &H40
Private Const HIGH_PRIORITY_CLASS = &H80
Private Const REALTIME_PRIORITY_CLASS = &H100
Private Const PROCESS_DUP_HANDLE = &H40


Private Declare Function OpenProcess Lib "kernel32" (ByVal dwDesiredAccess As Long, _
    ByVal bInheritHandle As Long, ByVal dwProcessId As Long) As Long


Private Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long


Private Declare Function GetCurrentProcessId Lib "kernel32" () As Long


Private Declare Function SetPriorityClass& Lib "kernel32" (ByVal hProcess As Long, _
    ByVal dwPriorityClass As Long)


'Used by IsWinNT
Public Type OSVERSIONINFO
        dwOSVersionInfoSize As Long 'Set to 148
        dwMajorVersion As Long
        dwMinorVersion As Long
        dwBuildNumber As Long
        dwPlatformId As Long
        szCSDVersion As String * 128      '  Maintenance string for PSS usage
End Type

Public Const VER_PLATFORM_WIN32_NT = 2
Public Const VER_PLATFORM_WIN32_WINDOWS = 1
Public Const VER_PLATFORM_WIN32s = 0
'End Used by IsWinNT

'Call this for
'XP THEMED FORMS
Public Type INITCOMMONCONTROLSEX_TYPE
    dwSize As Long
    dwICC As Long
End Type

Public Declare Function InitCommonControlsEx Lib "comctl32.dll" (lpInitCtrls As _
    INITCOMMONCONTROLSEX_TYPE) As Long
Public Const ICC_INTERNET_CLASSES = &H800
'XP Themeing

'Used for ChangePriority()
Public Const WM_SETREDRAW = &HB

'Lock a windows 2000/XP machine
Public Declare Sub LockWorkStation Lib "user32.dll" ()
'Tests a window handle to determine if it is a valid handle
Public Declare Function IsWindow Lib "user32" (ByVal hwnd As Long) As Long


'Adds support for xp themes
Public Sub EnableXPThemes()
        
    On Error GoTo ErrorHandler:
    
    Dim comctls As INITCOMMONCONTROLSEX_TYPE  ' identifies the control to register
    Dim retval As Long                        ' generic return value
    With comctls
        .dwSize = Len(comctls)
        .dwICC = ICC_INTERNET_CLASSES
    End With
    retval = InitCommonControlsEx(comctls)
    
    'Exit the function
    Exit Sub
    
ErrorHandler:
    'Avoid a crash by doing nothing
    
End Sub

'Gets the Proccess ID for your program
Public Function GetPID() As Long
    GetPID = GetCurrentProcessId()
End Function


Public Function IsWinNT() As Boolean
    Dim myOS As OSVERSIONINFO

    myOS.dwOSVersionInfoSize = Len(myOS)
    GetVersionEx myOS
    IsWinNT = (myOS.dwPlatformId = VER_PLATFORM_WIN32_NT)
End Function


'Allows the user to browse for a folder and returns the path
'Public Function BrowseForFolder(hWndOwner As Long, sPrompt As String) As String
'    Dim iNull As Integer
'    Dim lpIDList As Long
'    Dim lResult As Long
'    Dim sPath As String
'    Dim udtBI As BrowseInfo
'
'
'    With udtBI
'        .hWndOwner = hWndOwner
'        .lpszTitle = lstrcat(sPrompt, "")
'        .ulFlags = BIF_RETURNONLYFSDIRS
'    End With
'    lpIDList = SHBrowseForFolder(udtBI)
'
'
'    If lpIDList Then
'        sPath = String$(MAX_PATH, 0)
'        lResult = SHGetPathFromIDList(lpIDList, sPath)
'        Call CoTaskMemFree(lpIDList)
'        iNull = InStr(sPath, vbNullChar)
'
'
'        If iNull Then
'            sPath = Left$(sPath, iNull - 1)
'        End If
'    End If
'    BrowseForFolder = sPath
'End Function
Public Function BrowseForFolder(hWndOwner As Long, sPrompt As String, selectedPath As String) As String
    Dim Browse_for_folder As BROWSEINFOTYPE
    Dim itemID As Long
    Dim selectedPathPointer As Long
    Dim tmpPath As String * 256
    With Browse_for_folder
        .hOwner = hWndOwner ' Window Handle
        .lpszTitle = sPrompt 'lstrcat(sPrompt, "") ' Dialog Title
        .lpfn = FunctionPointer(AddressOf BrowseCallbackProcStr) ' Dialog callback function that preselectes the folder specified
        selectedPathPointer = LocalAlloc(LPTR, Len(selectedPath) + 1) ' Allocate a string
        CopyMemory ByVal selectedPathPointer, ByVal selectedPath, Len(selectedPath) + 1 ' Copy the path to the string
        .lParam = selectedPathPointer ' The folder to preselect
    End With
    itemID = SHBrowseForFolder(Browse_for_folder) ' Execute the BrowseForFolder API
    If itemID Then
        If SHGetPathFromIDList(itemID, tmpPath) Then ' Get the path for the selected folder in the dialog
            BrowseForFolder = Left$(tmpPath, InStr(tmpPath, vbNullChar) - 1) ' Take only the path without the nulls
        End If
        Call CoTaskMemFree(itemID) ' Free the itemID
    End If
    Call LocalFree(selectedPathPointer) ' Free the string from the memory
End Function
'Needed for "BrowseForFolder" function to work properly
Public Function BrowseCallbackProcStr(ByVal hwnd As Long, ByVal uMsg As Long, ByVal lParam As Long, ByVal lpData As Long) As Long
If uMsg = 1 Then
    Call SendMessage(hwnd, BFFM_SETSELECTIONA, True, ByVal lpData)
End If
End Function
'Needed for "BrowseForFolder" function to work properly
Public Function FunctionPointer(FunctionAddress As Long) As Long
FunctionPointer = FunctionAddress
End Function

'Put this code in MouseMove event. In this example, I put a CommandButton on a
'form with the name Command1

'Private Sub Command1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'Static CtrMov As Boolean
'With Command1 'Change this 'Command1' to your control name
'    If (X < 0) Or (Y < 0) Or (X > .Width) Or (Y > .Height) Then
'        ReleaseCapture
'        CtrMov = False
'
'        'Put here your code to LostMouseFocus
'        'For example:
'        Me.Print "LostMouseFocus"
'
'    Else
'        SetCapture .hwnd
'        If CtrMov = False Then
'            CtrMov = True
'
'            'Put here your code to GetMouseFocus
'            'For example:
'            Me.Print "GetMouseFocus"
'
'        End If
'    End If
'End With
'End Sub

'Gets a profile string from the specified ini file
Public Function GetPPString(ByVal AppName As String, ByVal KeyName As String, ByVal DefaultVal As String, ByVal iniFileName As String) As String
    Dim ReturnString As String
    Dim PPString As String * 200
    Dim PPStringLen As Long
    
    'Get the private profile string
    PPStringLen = GetPrivateProfileString(AppName, KeyName, DefaultVal, PPString, 199, iniFileName)

    'Trim off the trailing 0's and null character
    ReturnString = Left(PPString, PPStringLen)
    
    'Return the corrected string
    GetPPString = ReturnString
End Function

'This function will return True if the file exists and False if it doesn't
Public Function FileExists(file As String) As Boolean
    If Dir(file) = "" Then
        FileExists = False
    Else
        FileExists = True
    End If
End Function

'Runs a program and waits for it to end
Public Function RunShell(CmdLine$, Optional WinVisible As Variant) As Long
    Dim hProcess As Long
    Dim ProcessId As Long
    Dim exitCode As Long
    Dim WinType As Long
    
    If WinVisible = True Then
        WinType = vbNormalFocus
    Else
        WinType = vbHide
    End If
    
    ProcessId& = Shell(CmdLine$, WinType)
    
    hProcess& = OpenProcess(PROCESS_QUERY_INFORMATION, False, ProcessId&)

    Do
        Call GetExitCodeProcess(hProcess&, exitCode&)

        DoEvents
    Loop While exitCode& > 0

    RunShell = exitCode
End Function

'This function will dither a blue background on the
'form passed to it.
Public Sub DitherForm(vForm As Form)
    Dim oldScaleHeight As Long
    Dim OldScaleMode As Long
    
    Dim intLoop As Integer
    
    'Store the old form value
    oldScaleHeight = vForm.ScaleHeight
    OldScaleMode = vForm.ScaleMode
    
    vForm.DrawStyle = vbInsideSolid
    vForm.DrawMode = vbCopyPen
    vForm.ScaleMode = vbPixels
    vForm.DrawWidth = 2
    vForm.ScaleHeight = 256
    For intLoop = 0 To 255
        vForm.Line (0, intLoop)-(Screen.Width, intLoop - 1), RGB(0, 0, 255 - intLoop), B
    Next intLoop
    
    'Restore the old form values
    vForm.ScaleMode = OldScaleMode
    vForm.ScaleHeight = oldScaleHeight
    
End Sub

'Returns the drive that the application is running on
'If error occurs then returns "Not Found"
'Ex: "C:"
Public Function GetAppDrive() As String
    Dim endstr As Integer
    'Get the position of the ":" in the app path
    endstr = InStr(1, App.path, ":")
    
    'If a colin was found in the app path then truncate there
    If endstr <> 0 Then
        GetAppDrive = Left(App.path, endstr)
    Else
        GetAppDrive = "Not Found"
    End If
End Function

Public Function AddBackSlash2Path(ByVal path As String) As String
    'If there is no "\" character in the path then add it
    If Right(path, 1) <> "\" Then
        AddBackSlash2Path = path & "\"
    Else 'Nothing needs to be done
        AddBackSlash2Path = path
    End If
End Function

'This function uses the API function ShellExecute to run a program or document
Public Function ShellOpenEx(ByVal FilePath As String, ByVal DirPath As String, ByVal Parms As String, ByVal ShowType As Long) As Boolean
    Dim RetValue As Long
    Dim ShowValues(0 To 6) As Long
    ShowValues(0) = SW_HIDE
    ShowValues(1) = SW_SHOWNORMAL
    ShowValues(2) = SW_SHOWMINIMIZED
    ShowValues(3) = SW_SHOWMAXIMIZED
    ShowValues(4) = SW_SHOWNA
    ShowValues(5) = SW_SHOWNA
    ShowValues(6) = SW_SHOWMINNOACTIVE
    
    If ShowType < 0 Or ShowType > 6 Then
        MsgBox "ShellOpen: Bad Argument", vbCritical + vbApplicationModal
        Exit Function
    End If
    
    If ShowType = 5 Then
        MsgBox "ShellOpenEx(): Bad Argument", vbCritical + vbApplicationModal
        Exit Function
    End If
    
    'Shell the application
    RetValue = ShellExecute(mdiMain.hwnd, "Open", FilePath, Parms, DirPath, ShowValues(ShowType))
    
    If RetValue > 32 Then
        ShellOpenEx = True
    Else
        ShellOpenEx = False
    End If
End Function

'Gets the associated program with a file
'Returns Executable file associated with the file passed or vbNullstring
'if the function fails
Public Function GetExecutable(ByVal FileStr As String, ByVal DirStr As String) As String
    Dim ResultStr As String * MAX_PATH
    Dim retval As Long
    
    'Use the api to get the associated program
    retval = FindExecutable(FileStr, DirStr, ResultStr)
    
    If retval < 32 Then
        GetExecutable = vbNullString
    Else
        'Trim the string at the first null char and return it
        GetExecutable = Left(ResultStr, InStr(1, ResultStr, vbNullChar) - 1)
    End If
End Function

Public Function GetAssociatedEXE(ByVal FileExt As String) As String
    Dim ResultStr As String * MAX_PATH
    Dim retval As Long
    Dim FileNum As Integer
    Dim TestFile As String
    
    'Define a temp file
    TestFile = "~TF23872." & FileExt
    
    'Create a dummy file
    FileNum = FreeFile
    
    'Open the file
    Open "C:\" & TestFile For Output As #FileNum
    'Write something in it
    Print #FileNum, "TestFile"
    'Close the file
    Close #FileNum
    
    'Use the api to get the associated program
    retval = FindExecutable(TestFile, "C:\", ResultStr)
    
    If retval < 32 Then
        'Return a NullString
        GetAssociatedEXE = vbNullString
    Else
        'Trim the string at the first null char and return it
        GetAssociatedEXE = Left(ResultStr, InStr(1, ResultStr, vbNullChar) - 1)
    End If
    
    'Delete the test file
    Kill "C:\" & TestFile
End Function

'This function will get the current directory where windows is installed
Public Function GetWindowsDir() As String
    Dim WinDir As String * MAX_PATH
    Dim RetWinDir As String
    Dim TrimAmount As Long
    
    'Get the windows directory
    TrimAmount = GetWindowsDirectory(WinDir, MAX_PATH)
    
    'Trim off all unneeded trailling characters
    RetWinDir = Left(WinDir, TrimAmount)
    
    'Return the directory
    GetWindowsDir = RetWinDir
End Function


'Makes a window topmost or normal
Sub MakeTopMost(ByVal fForm As Form, ByVal Topmost As Boolean)
    Dim flags As Long
    Dim zPos As Long
    
    'Setup the default flags value
    flags = SWP_NOMOVE Or SWP_NOSIZE
    
    'Set the zPos value
    If Topmost Then
        zPos = HWND_TOPMOST
    Else
        zPos = hWnd_NOTOPMOST
    End If
    
    Call SetWindowPos(fForm.hwnd, zPos, 0, 0, 0, 0, flags)
End Sub
'Formats a number in engineering format
Function EngFormat(ByVal num As Variant) As String
    Dim dStr As String
    Dim ePow As Integer
    Dim numTmp As Variant

    numTmp = num
    
    If num >= 1 Then
        Do
            numTmp = numTmp / 10
            ePow = ePow + 1
        Loop Until numTmp < 1
        
        ePow = ePow - 1
        numTmp = numTmp * 10
    Else
    End If
End Function

'This function makes a form modeless
Function MakeFormModeless(ByVal myForm As Form, ByVal PrntHwnd As Long) As Long
    MakeFormModeless = SetWindowLong(myForm.hwnd, -8, PrntHwnd)
End Function

'Draws a 3D border around a control
'BorderType = 1  -  Border is sunken
'BorderType = 0  -  Border is raised
Public Sub vbDrawSimpleBorder(ByVal MyCtrl As Control, ByVal ParentCtrl As Object, ByVal BorderType As Long)
    Dim PX1 As Long 'One pixel on the x axis
    Dim PY1 As Long 'One pixel on the y axis
    
    PX1 = Screen.TwipsPerPixelX
    PY1 = Screen.TwipsPerPixelY
    
    With MyCtrl
        'Draw a raised or sunken border
        If BorderType Then
            ParentCtrl.ForeColor = vb3DHighlight
        Else
            ParentCtrl.ForeColor = vb3DShadow
        End If
        'Draw the line along the top of the control
        ParentCtrl.Line (.Left - PX1, .TOp - PY1)-(.Left + .Width + 1 * PX1, .TOp - PY1)
        'Draw the line along the left of the control
        ParentCtrl.Line (.Left - PX1, .TOp - PY1)-(.Left - PX1, .TOp + .Height + PY1)
        'Draw a raised or sunken border
        If BorderType Then
            ParentCtrl.ForeColor = vb3DShadow
        Else
            ParentCtrl.ForeColor = vb3DHighlight
        End If
        'Draw the line along the bottom of the control
        ParentCtrl.Line (.Left, .TOp + .Height)-(.Left + .Width + 1 * PX1, .TOp + .Height)
        'Draw the line along the right of the control
        ParentCtrl.Line (.Left + .Width, .TOp)-(.Left + .Width, .TOp + .Height)
    End With
End Sub

'Inserts a character every N'th character counted
'str   - Input string
'sChar - Character to Insert
'N     - Number of input string characters between character inserts
Function InsertChars(ByVal Str As String, ByVal sChar As String, ByVal N As Integer)
    Dim cntr As Integer
    Dim sCharCntr As Integer
    Dim sOutString As String
    
    sCharCntr = 1
    For cntr = 1 To Len(Str)
        sOutString = sOutString & Mid(Str, cntr, 1)
        If sCharCntr = N Then
            sOutString = sOutString & sChar
            sCharCntr = 1
        Else
            sCharCntr = sCharCntr + 1
        End If
    Next cntr
    'Return the output string
    InsertChars = sOutString
End Function

'Public Sub Delay()
'    Dim cntr As Double
'    Dim TimeStart As Single
'
'    'Initialize the counter
'    cntr = 0
'    'Get the number of seconds elapsed since midnight
'    TimeStart = Timer
'    Do
'        DoEvents
'    Loop While Timer() < TimeStart + 0.5
'
'End Sub

'Delays program execution by the DelayTime
'Input:  DelayTime - Time to delay in Seconds (1ms Resolution in WinNT, 55ms Resolution in Win95)
Public Sub Delay(ByVal DelayTime As Single, Optional NoDoEvents)
    Dim Start As Single
    Dim OldTimerVal As Single
    Dim EndTime As Single
    Dim DelayCntr As Long 'used to make sure that
    
    Start = Timer       'Set start time.
    OldTimerVal = Start 'Set the current timer val
    'Calculate the end time
    EndTime = Start + DelayTime
    
    'Setup the delay cntr
    DelayCntr = 0
    
    Do
        'Check for midnight
        If Timer < OldTimerVal Then
            EndTime = EndTime - OldTimerVal
            DelayCntr = 1000 'It is past midnight so refresh the OldTimerVal
        End If
        
        If DelayCntr >= 1000 Then
            OldTimerVal = Timer 'Get the current timer value
            DelayCntr = 0 'Reset the counter
        End If
           
        'Increment the delay counter
        DelayCntr = DelayCntr + 1
        
        'If the user enters any value for nodoevents
        If IsMissing(NoDoEvents) Then
            DoEvents   ' Yield to other processes.
        Else
        End If
    Loop While Timer < EndTime
End Sub

'Checks to see if a form is loaded using the forms collection
Public Function IsLoaded(FormName As String) As Boolean
    Dim cntr As Integer
    For cntr = 0 To Forms.Count - 1
        If (Forms(cntr).Name = FormName) Then
            IsLoaded = True
            Exit For
        End If
    Next
End Function

Public Sub DisableMinimizeButton(lhWnd As Long)
    Dim hSystemMenu As Long
    hSystemMenu = GetSystemMenu(lhWnd, 0)
    Call RemoveMenu(hSystemMenu, 3, MF_BYPOSITION)
End Sub

'Attempts to make a mdichild form modal for the program
Public Sub MakeMDIModal(frmMForm As Form, ByVal bEnable As Boolean)
    Dim cntr As Integer
    bEnable = Not bEnable
    'Start the counter at 2 because Forms(1) is the main mdi form
    For cntr = 2 To Forms.Count - 1
        'Disable all forms but the MainMDI and the Child to be Modalized
        If Forms(cntr).hwnd <> frmMForm.hwnd Then
            If bEnable = False Then
                Forms(cntr).Tag = Forms(cntr).Tag & CStr(Forms(cntr).Enabled)
            End If
            Forms(cntr).Enabled = bEnable
            If bEnable = True Then
                Forms(cntr).Tag = Left(Forms(cntr).Tag, Len(Forms(cntr).Tag) - 4)
            End If
        End If
    Next cntr
End Sub
'Extracts the filename out of a path
Public Function GetFileName(ByVal sPath As String) As String
    Dim CurStrLoc As Integer
    Dim LastLoc
    
    CurStrLoc = InStr(1, sPath, "\")
    Do
        LastLoc = CurStrLoc
        CurStrLoc = InStr(CurStrLoc + 1, sPath, "\")
    Loop While CurStrLoc <> 0
    
    GetFileName = Mid(sPath, LastLoc + 1, Len(sPath) - LastLoc + 1)
End Function

'Changes the priority of a process
Sub ChangePriority(dwPriorityClass As Long)
    Dim hProcess&
    Dim Ret&, pid&
    pid = GetCurrentProcessId() ' get my proccess id
    ' get a handle to the process
    hProcess = OpenProcess(PROCESS_DUP_HANDLE, True, pid)


    If hProcess = 0 Then
        Err.Raise 2, "ChangePriority", "Unable To open the source process"
        Exit Sub
    End If
    ' change the priority
    Ret = SetPriorityClass(hProcess, dwPriorityClass)
    ' Close the source process handle
    Call CloseHandle(hProcess)


    If Ret = 0 Then
        Err.Raise 4, "ChangePriority", "Unable To close source handle"
        Exit Sub
    End If
End Sub

'Locks a control so it wont be redrawn until unlocked
Public Function LockControl(objX As Object, cLock As Boolean)

   Dim i As Long
   
   If cLock Then
      ' Enable the Redraw flag for the specified window, and repaint
      Call SendMessage(objX.hwnd, WM_SETREDRAW, True, 0)
      objX.Refresh
   Else
      ' Disable the Redraw flag for the specified window
      Call SendMessage(objX.hwnd, WM_SETREDRAW, False, 0)
   End If

End Function

'Returns true if the passed control is an control array
'Returns false if the passed control is an control array
Public Function IsControlArray(ByVal ctrl As Control) As Boolean
    Dim Value As Integer
    
    On Error GoTo ErrorHandler
    
    Value = ctrl.Index
    
    IsControlArray = True
    
    Exit Function
ErrorHandler:
    'Err.Number
    Select Case Err.Number
        Case 343:
            IsControlArray = False
    End Select
End Function

'Returns true if the passed control has the container property
'Returns false if the passed control has the continer property
Public Function HasContainerProp(ByVal ctrl As Control) As Boolean
    Dim Value As Integer
    
    On Error GoTo ErrorHandler
    
    Value = ctrl.Container
    
    HasContainerProp = True
    
    Exit Function
ErrorHandler:
    'Err.Number
    Select Case Err.Number
        Case 343:
            HasContainerProp = False
    End Select
End Function

Public Sub EnableFrame(inFrame As Frame, ByVal Enble As Boolean)
    Dim CtrlCntr As Integer
    Dim IndxCntr As Integer
    
    For CtrlCntr = 0 To inFrame.Parent.Controls.Count - 1
        'If inframe is a control array make sure to only disable
        'the controls in the proper control array element
        If IsControlArray(inFrame) Then
            If inFrame.Parent.Controls(CtrlCntr).Name <> "ImageList1" Then
                If TypeOf inFrame.Parent.Controls(CtrlCntr).Container Is Frame Then
                    If IsControlArray(inFrame.Parent.Controls(CtrlCntr).Container) Then
                        If inFrame.Parent.Controls(CtrlCntr).Container.Index = inFrame.Index And _
                           inFrame.Parent.Controls(CtrlCntr).Container.Name = inFrame.Name Then
                            inFrame.Parent.Controls(CtrlCntr).Enabled = Enble
                        End If
                    End If
                End If
            End If
'        Else
'            If inFrame.Parent.Controls(CtrlCntr).Container.Name = inFrame.Name Then
'                inFrame.Parent.Controls(CtrlCntr).Enabled = Enble
'            End If
        End If
    Next CtrlCntr
End Sub

Public Function GetWindowsVersion() As String

    Dim OSInfo As OSVERSIONINFO
    Dim Ret As Integer
    OSInfo.dwOSVersionInfoSize = 148
    OSInfo.szCSDVersion = Space$(128)
    Ret = GetVersionEx(OSInfo)

    With OSInfo

        Select Case .dwPlatformId
            Case 1
                If .dwMinorVersion < 10 Then
    
                    If .dwBuildNumber = 950 Then
                        GetWindowsVersion = "Windows 95"
                    ElseIf .dwBuildNumber > 950 Or .dwBuildNumber <= 1080 Then
                        GetWindowsVersion = "Windows 95 SP1"
                    Else
                        GetWindowsVersion = "Windows 95 OSR2"
                    End If
    
                ElseIf .dwMinorVersion = 10 Then
    
                    If .dwBuildNumber = 1998 Then
                        GetWindowsVersion = "Windows 98"
                    ElseIf .dwBuildNumber > 1998 Or .dwBuildNumber < 2183 Then
                        GetWindowsVersion = "Windows 98 SP1"
                    ElseIf .dwBuildNumber >= 2183 Then
                        GetWindowsVersion = "Windows 98 SE"
                    End If
    
                Else
                    GetWindowsVersion = "Windows ME"
                End If

            Case 2
                If .dwMajorVersion = 3 Then
                    GetWindowsVersion = "Windows NT 3.51"
                ElseIf .dwMajorVersion = 4 Then
                    GetWindowsVersion = "Windows NT 4.0"
                ElseIf .dwMajorVersion = 5 Then
    
                    If .dwMinorVersion = 0 Then
                        GetWindowsVersion = "Windows 2000"
                    Else
                        GetWindowsVersion = "Windows XP"
                    End If
    
                End If

            Case 3
                If .dwMajorVersion = 1 Then
                    GetWindowsVersion = "Windows CE 1.0"
                ElseIf .dwMajorVersion = 2 Then
    
                    If .dwMinorVersion = 0 Then
                        GetWindowsVersion = "Windows CE 2.0"
                    Else
                        GetWindowsVersion = "Windows CE 2.1"
                    End If
    
                Else
                    GetWindowsVersion = "Windows CE 3.0"
                End If
    
            Case Else
                GetWindowsVersion = "Unable To get Windows Version"
        End Select

End With

End Function

