VERSION 5.00
Begin VB.Form frmEditOutFreq 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Edit Output Frequency"
   ClientHeight    =   2415
   ClientLeft      =   2760
   ClientTop       =   3750
   ClientWidth     =   6615
   Icon            =   "EditOutF.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2415
   ScaleWidth      =   6615
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.VScrollBar vscDecTWVal 
      Height          =   435
      Left            =   260
      Max             =   -1
      Min             =   1
      TabIndex        =   15
      Top             =   360
      Width           =   200
   End
   Begin VB.TextBox txtOutputFreqVal 
      Alignment       =   1  'Right Justify
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   480
      MaxLength       =   14
      MultiLine       =   -1  'True
      TabIndex        =   0
      Text            =   "EditOutF.frx":000C
      ToolTipText     =   "Enter the desired frequency in MHz."
      Top             =   360
      Width           =   2895
   End
   Begin VB.Frame fraTunningWord 
      Caption         =   "Tuning Word Values"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   120
      TabIndex        =   9
      Top             =   975
      Width           =   6375
      Begin VB.TextBox txtTW 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   5
         Left            =   120
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   17
         Text            =   "EditOutF.frx":001D
         ToolTipText     =   "Enter the binary value of the tuning word you want."
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtTW 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   4
         Left            =   1080
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   16
         Text            =   "EditOutF.frx":0026
         ToolTipText     =   "Enter the binary value of the tuning word you want."
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtTW 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   3
         Left            =   2040
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   6
         Text            =   "EditOutF.frx":002F
         ToolTipText     =   "Enter the binary value of the tuning word you want."
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtTW 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   2
         Left            =   3000
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   5
         Text            =   "EditOutF.frx":0038
         ToolTipText     =   "Enter the binary value of the tuning word you want."
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtTW 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   1
         Left            =   3960
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   4
         Text            =   "EditOutF.frx":0041
         ToolTipText     =   "Enter the binary value of the tuning word you want."
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtTW 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Index           =   0
         Left            =   4920
         MaxLength       =   8
         MultiLine       =   -1  'True
         TabIndex        =   3
         Text            =   "EditOutF.frx":004A
         ToolTipText     =   "Enter the binary value of the tuning word you want."
         Top             =   840
         Width           =   975
      End
      Begin VB.TextBox txtTWHex 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   4560
         MaxLength       =   12
         MultiLine       =   -1  'True
         TabIndex        =   2
         Text            =   "EditOutF.frx":0053
         ToolTipText     =   "Enter the hexidecimal value of the tuning word you want."
         Top             =   360
         Width           =   735
      End
      Begin VB.TextBox txtTWDec 
         Alignment       =   1  'Right Justify
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   240
         MaxLength       =   15
         MultiLine       =   -1  'True
         TabIndex        =   1
         Text            =   "EditOutF.frx":0062
         ToolTipText     =   "Enter the decimal value of the tuning word you want."
         Top             =   360
         Width           =   1335
      End
      Begin VB.Label lblAutoSizeHex 
         Alignment       =   1  'Right Justify
         AutoSize        =   -1  'True
         BorderStyle     =   1  'Fixed Single
         Caption         =   " 000000000000"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   4620
         TabIndex        =   20
         Top             =   135
         Visible         =   0   'False
         Width           =   675
      End
      Begin VB.Label lblAutoSizeDec 
         Alignment       =   1  'Right Justify
         AutoSize        =   -1  'True
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-00000000"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   600
         TabIndex        =   19
         Top             =   135
         Visible         =   0   'False
         Width           =   975
      End
      Begin VB.Label lblHex 
         BackStyle       =   0  'Transparent
         Caption         =   "Hex"
         Height          =   255
         Index           =   1
         Left            =   5400
         TabIndex        =   12
         Top             =   360
         Width           =   375
      End
      Begin VB.Label lblTWBin 
         Alignment       =   1  'Right Justify
         BackStyle       =   0  'Transparent
         Caption         =   "Bin"
         Height          =   195
         Left            =   5880
         TabIndex        =   11
         Top             =   840
         Width           =   315
      End
      Begin VB.Label lblDec 
         Caption         =   "Dec"
         Height          =   255
         Left            =   1680
         TabIndex        =   10
         Top             =   360
         Width           =   375
      End
   End
   Begin VB.CommandButton CancelButton 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   5280
      TabIndex        =   8
      Top             =   600
      Width           =   1215
   End
   Begin VB.CommandButton OKButton 
      Caption         =   "OK"
      Height          =   375
      Left            =   5280
      TabIndex        =   7
      Top             =   120
      Width           =   1215
   End
   Begin VB.Label lblAutoSizeOutFreq 
      AutoSize        =   -1  'True
      BorderStyle     =   1  'Fixed Single
      Caption         =   "-000.0000000000000"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   420
      Left            =   480
      TabIndex        =   18
      Top             =   525
      Visible         =   0   'False
      Width           =   2910
   End
   Begin VB.Shape shpOKHilight 
      BorderWidth     =   3
      Height          =   375
      Left            =   5280
      Top             =   120
      Width           =   1215
   End
   Begin VB.Label lblMhz 
      Alignment       =   1  'Right Justify
      Caption         =   "MHz"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3480
      TabIndex        =   14
      Top             =   420
      Width           =   615
   End
   Begin VB.Label Label1 
      Caption         =   "Frequency:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   480
      TabIndex        =   13
      Top             =   120
      Width           =   1935
   End
End
Attribute VB_Name = "frmEditOutFreq"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private CancelHit As Boolean
Private OldValue As String
Private EditTbox As TextBox
Private TWDecVal As Variant
'Private OutputFreqVal As String
Private OKHit As Boolean
Private NegValues As Boolean
Private DecDigits As Integer
Private DecFormatStr As String  'Format string for decimal value
Private HexDigits As Integer    'Number of Hex Digits
Private OutFFStr As String      'Output Frequency Format String

Private TWBits As Integer 'The number of Tunning word bits passed to the dialog box
Private SysClk As Double 'Value passed to the dialog box for the system clock

Private sDecSep As String
Private iDecSep As Integer
Private sNegSign As String
Private iNegSign As Integer

Private Const LOCALE_SNEGATIVESIGN = &H51
Private Const LOCALE_SPOSITIVESIGN = &H50
Private Const LOCALE_SDECIMAL = &HE
Private Declare Function GetUserDefaultLCID Lib "kernel32" () As Long
Private Declare Function ApiGetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long

Private Declare Function SetWindowPos Lib "user32" (ByVal hWnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Private Const hWnd_NOTOPMOST = -2
Private Const HWND_TOP = 0
Private Const HWND_TOPMOST = -1
Private Const HWND_BOTTOM = 1
Private Const SWP_NOMOVE = &H2
Private Const SWP_NOSIZE = &H1
Private Const SWP_SHOWWINDOW = &H40
Private Const SWP_NOACTIVATE = &H10

Private Sub CancelButton_Click()
    'Cancel was hit
    OKHit = False
    'Hide the form
    Me.Hide
End Sub

Private Sub Form_Unload(Cancel As Integer)
    OKHit = False
    'Release the pointer to the textbox being edited
    Set EditTbox = Nothing
End Sub

Private Sub lblBigLength_Click()

End Sub

Private Sub OKButton_Click()
    'Ok button hit
    OKHit = True
    
    'Hide the form
    Me.Hide
End Sub

Private Sub OKButton_GotFocus()
    'Hide the hilight box
    shpOKHilight.Visible = False
End Sub

Private Sub OKButton_LostFocus()
    'Show the hilight box
    shpOKHilight.Visible = True
End Sub

Private Sub txtOutputFreqVal_GotFocus()
    SelectAllTxt txtOutputFreqVal
End Sub

Private Sub txtOutputFreqVal_KeyPress(KeyAscii As Integer)
    Dim cncl As Boolean
    Dim DecSepPos As Integer

    'Filter out all keys but the ones that are needed
    KeyAscii = NumericKeysFilter(KeyAscii)
    If NegValues = False Then
        KeyAscii = PlusMinusKeysFilter(KeyAscii)
    End If
    Select Case KeyAscii
        Case 69, 101: 'Alpha key
            KeyAscii = 0
        Case iDecSep 'Decimal Seperator
            If InStr(1, txtOutputFreqVal.Text, sDecSep) And InStr(1, txtOutputFreqVal.SelText, sDecSep) = 0 Then
                KeyAscii = 0
            End If
        Case 13: 'Enter key hit
            KeyAscii = 0
            'Validate the text box
'            txtOutpuFreqVal_Validate Cncl
            txtOutputFreqVal_Validate cncl
        Case Else 'Only a passable key was pressed
            'Get the position of the decimal seperator
            DecSepPos = InStr(1, txtOutputFreqVal.Text, sDecSep)
            
            If txtOutputFreqVal.SelStart < DecSepPos And DecSepPos < 4 Then
                If IsPrintable(KeyAscii) Then
'                    'Adjust the maximum length
'                    Select Case DecSepPos
'                        Case 2:
'                            txtOutputFreqVal.MaxLength = 16
'                        Case 3:
'                            txtOutputFreqVal.MaxLength = 17
'                        Case Else:
'                            txtOutputFreqVal.MaxLength = 18
'                    End Select
                    If DecSepPos < 4 Then
                        txtOutputFreqVal.MaxLength = Len(txtOutputFreqVal.Text) + 1
                    End If
                Else
'                    Select Case DecSepPos
'                        Case 2:
'                            txtOutputFreqVal.MaxLength = 16
'                        Case 3:
'                            txtOutputFreqVal.MaxLength = 17
'                        Case Else
'                            txtOutputFreqVal.MaxLength = 18
'                    End Select
                End If
            End If

    End Select

End Sub

Private Sub UpdateTW(ByVal Value As Variant)
    Dim TWBin As String
    Dim OutFreqval As Variant
    Dim NegVal As Boolean
    Dim PosValue As Variant
    Dim DecSepPos As Integer
        
    If NegValues Then
        'If the value is negative then set a flag
        If Value < 0 Then
            NegVal = True
            'Get absolute value
            PosValue = Abs(Value)
        End If
                
        'Output frequency textbox
        If Not (ActiveControl Is txtOutputFreqVal) Then
            'Ajust the maximum length of the textbox
            AdjustOFTboxLen Value
                        
            If NegVal Then
                'Update this box because it is not currently active
                OutFreqval = DecTW2CarrierFreq(PosValue, SysClk, TWBits) 'Calc with the Pos value
                OutFreqval = -OutFreqval 'Negatize the output frequency
                txtOutputFreqVal.Text = FormatOutFreq(OutFreqval, TWBits)
            Else
                'Update this box because it is not currently active
                OutFreqval = DecTW2CarrierFreq(Value, SysClk, TWBits)
            
                txtOutputFreqVal.Text = FormatOutFreq(OutFreqval, TWBits)
            End If
            
        End If
        
        'Decimal value textbox
        If Not (ActiveControl Is txtTWDec) Then
            txtTWDec.Text = Format(Value, DecFormatStr)
        End If
        
        'Hex textbox
        If Not (ActiveControl Is txtTWHex) Then
            'Update this box because it is not currently active
            txtTWHex.Text = cbaseSignedDec2Hex(Value, HexDigits)
            txtTWHex.Refresh
        End If
    Else
        'Output frequency textbox
        If Not (ActiveControl Is txtOutputFreqVal) Then
            'Ajust the maximum length of the textbox
            AdjustOFTboxLen Value
            
            'Update this box because it is not currently active
            OutFreqval = DecTW2CarrierFreq(Value, SysClk, TWBits)
            
            txtOutputFreqVal.Text = FormatOutFreq(OutFreqval, TWBits, SysClk)
        End If
        
        'Decimal value textbox
        If Not (ActiveControl Is txtTWDec) Then
            txtTWDec.Text = Format(Value, DecFormatStr)
        End If
        
        'Hex textbox
        If Not (ActiveControl Is txtTWHex) Then
            'Update this box because it is not currently active
            txtTWHex.Text = cbaseHex(Value, HexDigits)
            txtTWHex.Refresh
        End If
    End If
        
    'Generate a binary string representing the tunning word
    TWBin = cbaseDec2Bin(Value, TWBits)
    
    'Binary TextBoxes
    If Not (ActiveControl Is txtTW(0)) Then
        txtTW(0).Text = Mid(TWBin, 41, 8)
    End If
    
    If Not (ActiveControl Is txtTW(1)) Then
        txtTW(1).Text = Mid(TWBin, 33, 8)
    End If
    
    If Not (ActiveControl Is txtTW(2)) Then
        txtTW(2).Text = Mid(TWBin, 25, 8)
    End If
    
    If Not (ActiveControl Is txtTW(3)) Then
        txtTW(3).Text = Mid(TWBin, 17, 8)
    End If

    If Not (ActiveControl Is txtTW(4)) Then
        txtTW(4).Text = Mid(TWBin, 9, 8)
    End If

    If Not (ActiveControl Is txtTW(5)) Then
        txtTW(5).Text = Mid(TWBin, 1, 8)
    End If

End Sub

Public Sub ShowEditDialog(ByRef Tbox As TextBox, ByVal Title As String, ByVal EOFSysClk As Variant, ByVal TWBitRes As Integer, Optional SignedVals)
'    Dim OldOutputVal As String
'    Dim TWDecVal As Variant
    Dim OldLeft As Single
    Dim OldTop As Single
    Dim cntr As Integer
    
    'Get the locale specific information
    sDecSep = GetLocaleInfo(LOCALE_SDECIMAL)
    iDecSep = Asc(sDecSep)
    sNegSign = GetLocaleInfo(LOCALE_SNEGATIVESIGN)
    iNegSign = Asc(sNegSign)
    
    TWBits = TWBitRes
    
    Load frmEditOutFreq
    
    'Get the format string
    OutFFStr = GetOutFreqFormatStr(TWBits, EOFSysClk)
    
    'Calculate the format
    DecDigits = Len(CStr((2 ^ TWBits) - 1))
    DecFormatStr = String(DecDigits, "0")
    HexDigits = TWBits / 4
    
    'Rearrange the form controls
    Select Case TWBits / 8
        Case 6:
            'Resize the frame
'            fraTunningWord.Width = 6375
            txtTWDec.Left = 1200
            lblAutoSizeDec.Left = 1200
            lblDec.Left = 1560
            lblAutoSizeHex.Left = 4620
            txtTWHex.Left = 4560
            lblHex(1).Left = 5400
'            OKButton.Move 4680, OKButton.Top
'            shpOKHilight.Move 4680, OKButton.Top
'            CancelButton.Move 4680, CancelButton.Top
'            frmEditOutFreq.Width = 6705
        Case 5:
            'Resize the frame
            fraTunningWord.Width = 5775
            txtTWDec.Left = 120
            lblAutoSizeDec.Left = 930
            lblDec.Left = 1560
            lblAutoSizeHex.Left = 4020
            txtTWHex.Left = 2760
            lblHex(1).Left = 4080
            OKButton.Move 4680, OKButton.Top
            shpOKHilight.Move 4680, OKButton.Top
            CancelButton.Move 4680, CancelButton.Top
            frmEditOutFreq.Width = 6105
        Case 4:
            'Resize the frame
            fraTunningWord.Width = 4575
            txtTWDec.Left = 120
            lblAutoSizeDec.Left = 570
            lblDec.Left = 1560
            txtTWHex.Left = 2760
            lblAutoSizeHex.Left = 3060
            lblHex(1).Left = 4080
            OKButton.Move 4680, OKButton.Top
            shpOKHilight.Move 4680, OKButton.Top
            CancelButton.Move 4680, CancelButton.Top
            frmEditOutFreq.Width = 6105
        Case 3:
            'Resize the frame
            fraTunningWord.Width = 3615
            txtTWDec.Left = 120
            lblAutoSizeDec.Left = 120
            lblDec.Left = 1200
            txtTWHex.Left = 2040
            lblAutoSizeHex.Left = 2160
            lblHex(1).Left = 3120
            OKButton.Left = 3840
            shpOKHilight.Left = 3840
            CancelButton.Left = 3840
            frmEditOutFreq.Width = 5265
        Case 2:
            'Resize the frame
            fraTunningWord.Width = 3615
            txtTWDec.Left = 120
            lblAutoSizeDec.Left = 120
            lblDec.Left = 1200
            txtTWHex.Left = 2040
            lblAutoSizeHex.Left = 2160
            lblHex(1).Left = 3120
            OKButton.Left = 3840
            shpOKHilight.Left = 3840
            CancelButton.Left = 3840
            frmEditOutFreq.Width = 5265
        Case 1:
            'Resize the frame
            fraTunningWord.Width = 3615
            txtTWDec.Left = 120
            lblAutoSizeDec.Left = 120
            lblDec.Left = 1200
            txtTWHex.Left = 2040
            lblAutoSizeHex.Left = 2160
            lblHex(1).Left = 3120
            OKButton.Left = 3840
            shpOKHilight.Left = 3840
            CancelButton.Left = 3840
            frmEditOutFreq.Width = 5265
    End Select
    
    'Set the max length for the textboxes
    txtTWHex.MaxLength = HexDigits
    
    'Resize the textboxes to fit the data
    lblAutoSizeOutFreq.Caption = " -00" & OutFFStr
    txtOutputFreqVal.Width = lblAutoSizeOutFreq.Width
    'Move the units label
    lblMHz.Left = txtOutputFreqVal.Left + txtOutputFreqVal.Width
    
    lblAutoSizeDec.Caption = " -" & DecFormatStr
    txtTWDec.Move lblAutoSizeDec.Left, txtTWDec.Top, lblAutoSizeDec.Width
    lblDec.Move txtTWDec.Left + txtTWDec.Width + 120
    
    
    lblAutoSizeHex.Caption = " ." & String(HexDigits, "A")
    txtTWHex.Move lblAutoSizeHex.Left, txtTWHex.Top, lblAutoSizeHex.Width
    lblHex(1).Move txtTWHex.Left + txtTWHex.Width + 120
    
    'Hide Binary Textboxes that aren't used
    For cntr = (5 - TWBits / 8) To 0 Step -1
        txtTW(cntr).Visible = False
    Next cntr
    
    cntr = (5 - TWBits / 8) + 1
    lblTWBin.Left = txtTW(cntr).Left + txtTW(cntr).Width
    
    'Check to see if the user passed a "handle negative values" flag of true
    If IsMissing(SignedVals) Then
        NegValues = False
        txtTWDec.MaxLength = 17
    Else
        If SignedVals = True Then
            NegValues = True
            txtTWDec.MaxLength = 18
        Else
            NegValues = False
            txtTWDec.MaxLength = 17
        End If
    End If
    
    SysClk = CDec(EOFSysClk)
    
    'Set the title of the dialog
    frmEditOutFreq.Caption = Title
    
    'Store the value to be edited
    Set EditTbox = Tbox
    
    If Tbox.Tag = "" Then
        'Get the decimal tunning word value
        TWDecVal = 0
    Else
        'Get the decimal tunning word value
        TWDecVal = Tbox.Tag
    End If
    
    'Adjust the length of the output frequency textbox to match the value
    AdjustOFTboxLen TWDecVal
    
    'Setup the textbox to the initial value
    If Tbox.Text = "" Then
        txtOutputFreqVal.Text = FormatOutFreq(0, TWBits)
    Else
        txtOutputFreqVal.Text = FormatOutFreq(DecTW2CarrierFreq(TWDecVal, EOFSysClk, TWBitRes), TWBits, EOFSysClk)
    End If
    
    'Show the window off the screen so that it isn't seen yet
    Call SetWindowPos(Me.hWnd, hWnd_NOTOPMOST, -500, -500, 0, 0, SWP_NOSIZE + SWP_SHOWWINDOW + SWP_NOACTIVATE)
    'Set the focus to the output text box
    txtOutputFreqVal.SetFocus
    Me.Visible = False
    
    'Update the other textboxes
    UpdateTW (TWDecVal)
    
    'Move the form back
    Me.Top = OldTop
    Me.Left = OldLeft
    
    'Show as modal
    Me.Show 1
    
    If OKHit = True Then
        'Ok was hit
        Tbox.Tag = txtTWDec.Text 'OutputFreqVal
        Tbox.Text = txtOutputFreqVal.Text
    Else
        If Tbox.Tag = "" Then
            Tbox.Tag = "0"
        End If
    End If
    
    'Unload the dialog
    Unload Me
End Sub

Private Sub txtOutputFreqVal_LostFocus()
'    Dim cncl As Boolean
'    txtOutputFreqVal_Validate (cncl)
'    If cncl Then
'        txtOutputFreqVal.SetFocus
'    End If
End Sub

Private Sub txtOutputFreqVal_Validate(Cancel As Boolean)
    Dim OutFreqval As Double
    Dim NegVal As Boolean
    Dim DecSepPos As Integer
    
    'If it is a null string then enter 0 as the default
    If txtOutputFreqVal.Text = "" Then
        txtOutputFreqVal.Text = FormatOutFreq(0, TWBits)
    End If
    
    'Format the string properly
    If IsNumeric(txtOutputFreqVal.Text) Then
        'Check to see if a negative number was entered
        If Left(txtOutputFreqVal.Text, 1) = sNegSign Then
            NegVal = True
        End If
        
        'Convert it to a double
        OutFreqval = Abs(CDbl(txtOutputFreqVal.Text))
        
        If OutFreqval >= CDbl(SysClk) Then  ' CDbl(frmMain.txtExtClockFreq.Text)
            'MsgBox "The DDS output frequency should not exceed  the system clock.", vbApplicationModal + vbExclamation + vbOKOnly, "Output Frequency to High!!!"
            'OutFreqval = CDbl(EditOutFreqSysClk) * 0.4
            OutFreqval = DecTW2CarrierFreq((2 ^ TWBits) - 1, SysClk, TWBits)
            'Cancel = True
        End If
        
        'Calculate the decimal tuning word
        TWDecVal = CalculateDecTuningWord(OutFreqval, SysClk, TWBits)
        
        'Convert it to a double
        OutFreqval = CDbl(DecTW2CarrierFreq(TWDecVal, SysClk, TWBits))
        
        'Make the values negative
        If NegVal = True Then
            TWDecVal = -TWDecVal
            OutFreqval = -OutFreqval
        End If
                
        'Ajust the maximum length of the textbox
        AdjustOFTboxLen TWDecVal
        
        'Format and display the output frequency
        txtOutputFreqVal.Text = FormatOutFreq(OutFreqval, TWBits, SysClk)
                
        'Update the other textboxes
        UpdateTW (TWDecVal)
        
        '
        OKButton.SetFocus
    End If
    
End Sub

Private Sub txtTW_GotFocus(Index As Integer)
    'Select all of the text in the textbox
    SelectAllTxt txtTW(Index)
End Sub

Private Sub txtTW_KeyPress(Index As Integer, KeyAscii As Integer)
    Dim cncl As Boolean
    
    'Filter out all keys but for the 0 and 1 keys
    KeyAscii = BinKeysFilter(KeyAscii)
    
    Select Case KeyAscii
        Case 13:
            KeyAscii = 0
            txtTW_Validate Index, cncl
    End Select
    

End Sub

Private Sub txtTW_Validate(Index As Integer, Cancel As Boolean)
    Dim TWBinVal As Variant
    Dim sTWBinVal As String
    
    'Fill any missing digits in with Zeros
    txtTW(Index).Text = String(8 - Len(txtTW(Index).Text), "0") & txtTW(Index).Text
        
        
    'If something non numeric is entered then zero the control
    If Not IsNumeric(txtTW(Index).Text) Then
        txtTW(Index).Text = Format(0, DecFormatStr)
    End If
    
    'If we need to handle negative values then use a different
    If NegValues Then
        TWBinVal = cbaseSignedBinS2Dec(txtTW(5).Text & txtTW(4).Text & txtTW(3).Text & txtTW(2).Text & txtTW(1).Text & txtTW(0).Text)
    Else
        'Get the value of the textbox
        TWBinVal = cbaseBinS2Dec(txtTW(5).Text & txtTW(4).Text & txtTW(3).Text & txtTW(2).Text & txtTW(1).Text & txtTW(0).Text)
    End If
    
'    If TWBinVal <= (2 ^ 32) - 1 Then
'        'Display the new value
'        txtTW(Index).Text = Format(TWBinVal, "0000000000")
'    Else
'        MsgBox "The decimal value of the Tunning Word should not exceed 4294967295"
'        TWBinVal = 0
'        txtTW(Index).Text = Format(TWBinVal, "0000000000")
'        Cancel = True
'    End If
'
    'Record the proper output frequency value
    'OutputFreqVal = DecTW2CarrierFreq(TWDecVal, TWBits, CLng(frmMain.txtIntClockFreq.Text))
    
    'Update the other textboxes
    UpdateTW (TWBinVal)
End Sub

Private Sub txtTWDec_GotFocus()
    'Select all of the text in the textbox
    SelectAllTxt txtTWDec
End Sub

Private Sub txtTWDec_KeyPress(KeyAscii As Integer)
    Dim cncl As Boolean
    'Filter out keys that arn't needed
    KeyAscii = iNumericKeysFilter(KeyAscii)
    If NegValues = False Then
        KeyAscii = PlusMinusKeysFilter(KeyAscii)
    End If
    
    Select Case KeyAscii
'        Case 46:
'            KeyAscii = 0
        Case 13:
            KeyAscii = 0
            txtTWDec_Validate cncl
    End Select
End Sub

Private Sub txtTWDec_Validate(Cancel As Boolean)
    Dim TWDecVal As Variant
    Dim NegVal As Boolean
    
    'If something non numeric is entered then zero the control
    If Not IsNumeric(txtTWDec.Text) Then
        txtTWDec.Text = Format(0, DecFormatStr)
    End If
    
    'Check to see if the number is negative
'    If Left(txtTWDec.Text, 1) = sNegSign Then
'        NegVal = True
'    End If
    
    'Get the value of the textbox
    TWDecVal = CDec(txtTWDec.Text)
    
    If TWDecVal <= (2 ^ TWBits) - 1 Then
        'Display the new value
        txtTWDec.Text = Format(TWDecVal, DecFormatStr)
    Else
        'MsgBox "The decimal value of the Tunning Word should not exceed 4294967295"
        TWDecVal = 0
        txtTWDec.Text = Format(TWDecVal, DecFormatStr)
        Cancel = True
    End If
    
    'Record the proper output frequency value
    'OutputFreqVal = DecTW2CarrierFreq(TWDecVal, TWBits, CLng(frmMain.txtIntClockFreq.Text))
    
    'Update the other textboxes
    UpdateTW (TWDecVal)
End Sub

Private Sub txtTWHex_GotFocus()
    'Select all of the text in the textbox
    SelectAllTxt txtTWHex
End Sub

Private Sub txtTWHex_KeyPress(KeyAscii As Integer)
    Dim cncl As Boolean
        
    'Filter out all unwanted keys
    KeyAscii = HexKeysFilter(KeyAscii)
    
    If KeyAscii = 13 Then
        'Throw the key away
        KeyAscii = 0
        
        '
        txtTWHex_Validate cncl
    End If
End Sub

Private Sub txtTWHex_Validate(Cancel As Boolean)
    Dim TWHexVal As Variant
        
    TWHexVal = CDec(0)
    'If something non numeric is entered then zero the control
'    If Not IsNumeric(txtTWHex.Text) Then
'        txtTWHex.Text = cbaseHex(0, 8)
'    End If
    
    If NegValues Then
        'Get the decimal value of the hex text box
        TWHexVal = cbaseSignedHex2Dec(txtTWHex.Text)
    Else
        'Get the decimal value of the hex text box
        TWHexVal = cbaseHexStr2Dec(txtTWHex.Text)
    End If
    
    If TWHexVal <= (2 ^ TWBits) - 1 Then
        If NegValues Then
            'Display the new value
            txtTWHex.Text = cbaseSignedDec2Hex(TWHexVal, HexDigits)
        Else
            'Display the new value
            txtTWHex.Text = cbaseHex(TWHexVal, HexDigits)
        End If
    Else
        MsgBox "The hex value of the Tunning Word should not exceed FFFFFFFFFFFF"
        TWHexVal = 0
        txtTWHex.Text = cbaseHex(TWHexVal, HexDigits)
        Cancel = True
    End If
    
    'Update the other textboxes
    UpdateTW (TWHexVal)
End Sub

Private Sub vscDecTWVal_Change()
    Dim MinIncVal As Variant
    Dim NewVal As Variant
    Dim MaxVal As Variant
    Dim MinVal As Variant
    
    
    If vscDecTWVal.Value <> 0 Then
        'Setup the maximum and minimum values
        If NegValues Then
            MaxVal = CDec(2 ^ (TWBits - 1))
            MinVal = CDec(-MaxVal + 1)
        Else
            MaxVal = CDec(2 ^ TWBits)
            MinVal = CDec(0)
        End If
        
        If vscDecTWVal.Value = -1 Then
            
            'Calulate the new value
            NewVal = CDec(txtTWDec.Text) - 1
            
            'If the new value is valid then update the other controls
            If NewVal >= MinVal Then
                UpdateTW NewVal
            End If
            
            vscDecTWVal.Value = 0
        End If
        
        If vscDecTWVal.Value = 1 Then
            
            'Calulate the new value
            NewVal = CDec(txtTWDec.Text) + 1
            
            'If the new value is valid then update the other controls
            If NewVal <= MaxVal - 1 Then
                UpdateTW NewVal
            End If
            
            vscDecTWVal.Value = 0
        End If
    End If
End Sub

'Sets the length of the output frequency textbox
Private Sub AdjustOFTboxLen(ByVal TWDecVal As Variant)
    Dim DecSepPos As Integer
    Dim OutFreqval As Double
    Dim OutFreqValLen As Integer
    
    'Calculate the output frequency value
    OutFreqval = CDbl(DecTW2CarrierFreq(TWDecVal, SysClk, TWBits))
    
    'Adjust the length of the output frequency textbox
    OutFreqValLen = Len(OutFFStr)
    
    'Get the decimal position
    DecSepPos = InStr(1, FormatOutFreq(OutFreqval, TWBits), sDecSep)
    If NegValues = False Then
        'Adjust the maximum length
        Select Case DecSepPos
            Case 2:
                txtOutputFreqVal.MaxLength = OutFreqValLen
            Case 3:
                txtOutputFreqVal.MaxLength = OutFreqValLen + 1
            Case Else:
                txtOutputFreqVal.MaxLength = OutFreqValLen + 2
        End Select
    Else
        'Adjust the maximum length
        Select Case DecSepPos
            Case 3:
                txtOutputFreqVal.MaxLength = OutFreqValLen + 1
            Case 4:
                txtOutputFreqVal.MaxLength = OutFreqValLen + 2
            Case Else:
                txtOutputFreqVal.MaxLength = OutFreqValLen + 3
        End Select
    End If
End Sub
'Returns the decimal seperator in either ascii code or
'the character
Private Function GetDecSeparator(ByVal RetAsciiCode As Boolean) As Variant
    If RetAsciiCode Then
        GetDecSeparator = Asc(Mid(Format(0, "Fixed"), 2, 1))
    Else
        GetDecSeparator = Mid(Format(0, "Fixed"), 2, 1)
    End If
End Function

Private Function GetLocaleInfo(ByVal LCType As Long) As String
    Dim retval As String
    Dim SLen As Long
    Dim lLCID As Long
    
    'Get the length the string needs to be
    SLen = ApiGetLocaleInfo(lLCID, LCType, retval, 0)
    
    'Resize the string
    retval = String(SLen, vbNull)
    
    'Get the Locale Info requested
    SLen = ApiGetLocaleInfo(lLCID, LCType, retval, SLen)
    
    If SLen <> 0 Then
        GetLocaleInfo = Left(retval, Len(retval) - 1)
    Else
        GetLocaleInfo = ""
    End If
End Function

