// Copyright (c) 2008 Analog Devices, Inc. All rights reserved.
module usb_interface
(	
	input arst,

	// USB side
	input USB_IFCLK,
	input USB_CTL0,
	input USB_CTL1,
	input USB_CTL2,
	
	output USB_RDY0,
	output USB_RDY1,
	
	inout [15:0] USB_D,

	// FPGA side
	input clk,
	input c_to_usb_stop,
	input c_to_usb_cts,
	input c_to_usb_rts,
	input [15:0] c_to_usb_D,
	
	output [15:0] usb_cmd,
	output usb_to_c_start,
	output usb_to_c_rts,
	output usb_to_c_stop,
	output usb_to_c_cts,
	output [15:0] usb_to_c_D
);

	wire [15:0] USB_D_in;
	wire [15:0] USB_D_out;
	
	// tri state buffer for bidirectional data bus
	assign USB_D = ~USB_CTL2 ? USB_D_out : 16'bzzzz_zzzz_zzzz_zzzz;
	assign USB_D_in = ~USB_CTL2 ? 16'bxxxx_xxxx_xxxx_xxxx : USB_D;

	// Receiver module
	usb_rx usb_rx1
	(
		.arst                     ( arst ),
		
		//write side (usb side)
		.wr_clk                   ( USB_IFCLK ),
		.wr_en                    ( ~USB_CTL0 ),
		.wr_D                     ( USB_D_in ),
		
		.wr_ready                 ( USB_RDY1 ),
		
		//read side (fpga side)
		.rd_clk                   ( clk ),
		.rd_en                    ( c_to_usb_cts ),
		.c_to_usb_stop            ( c_to_usb_stop ),
		
		.usb_to_c_start           ( usb_to_c_start ),
		.rd_ready                 ( usb_to_c_rts ),
		.usb_to_c_stop            ( usb_to_c_stop ),
		.cmd                      ( usb_cmd ),
		.rd_D                     ( usb_to_c_D )
	);
	
	usb_tx usb_tx1
	(
		.arst                     ( arst ),
			
		//write side (usb side)
		.wr_clk                   ( clk ),
		.wr_en                    ( c_to_usb_rts ),
		.c_to_usb_stop            ( c_to_usb_stop ),
		.cmd                      ( usb_cmd ),
		.wr_D                     ( c_to_usb_D ),
		
		.wr_ready                 ( usb_to_c_cts ),
		
		//read side (fpga side)
		.rd_clk                   ( USB_IFCLK ),
		.rd_en                    ( ~USB_CTL1 ),
		
		.rd_ready                 ( USB_RDY0 ),
		.rd_D                     ( USB_D_out )
	);
	
endmodule