module parallel_rx(
	input arst,
	
	// Parallel signals
	
	// Data input from CPLD
	input [15:0] PPI_D,
	
	// Interface Clock
	input PPI_CLK,
	
	// Frame Synchr 
	input PPI_FSI,
	input PPI_FSI2, // nDRDY
	input PPI_FSI3, 
		
	output reg ppi_data_valid,
	output reg [31:0] ppi_data,	
	input rx_enable
	
);

	reg 		new_data;
	reg [31:0]  data;
	reg 		data_ok;

	reg PPI_FSI_reg;
	reg PPI_FSI2_reg;
	reg PPI_FSI3_reg; 
	reg [15:0] PPI_D_reg;
	
	always@( posedge PPI_CLK )
	begin
		PPI_FSI_reg <= PPI_FSI;
		PPI_FSI2_reg <= PPI_FSI2;
		PPI_FSI3_reg <= PPI_FSI3; 
		PPI_D_reg <= PPI_D;
	end
	

	always@( posedge PPI_CLK, posedge arst )
	begin
	
		if ( arst )
		begin
			new_data <= 1'b0;
			data <= 32'h0;	
			ppi_data_valid <= 1'b0;
			ppi_data <= 32'h0;		
			data_ok <= 1'b0;
		end
		else
		begin
		
							
			if ( ~PPI_FSI2_reg )
			begin
				new_data <= 1'b1;										
			end
			
						
			if ( new_data )
			begin
				// nDRDY enable
				if ( ~PPI_FSI_reg & ~PPI_FSI3_reg)
				begin
					// First MSB 16 bits
					data[31:16] <= PPI_D_reg; 						
				end
				else if ( ~PPI_FSI_reg & PPI_FSI3_reg)
				begin
					// LSB + Status

					data[15:0] <= PPI_D_reg;	
					data_ok <= 1'b1;												
					new_data <= 1'b0;
				end						
			end						
			
					
			if ( data_ok )
			begin
				ppi_data_valid <= 1'b1;
				ppi_data <= data;
				data_ok <= 1'b0;
			end
			else
			begin				
				ppi_data_valid <= 1'b0;
			end
			
		end
	end



endmodule
