module parallel 
(

	// Parallel signals
	input RXINPUT,
	
	inout PAR_D0,
	inout PAR_D1,
	inout PAR_D2,
	inout PAR_D3,
	inout PAR_D4,
	inout PAR_D5,
	inout PAR_D6,
	inout PAR_D7,
	inout PAR_D8,
	inout PAR_D9,
	inout PAR_D10,
	inout PAR_D11,
	inout PAR_D12,
	inout PAR_D13,
	inout PAR_D14,
	inout PAR_D15,
	
	output PAR_CS0,
	output PAR_RD,
	output PAR_WR,
	
);

endmodule


module gpio_controller
(
	input arst,
	input clk,
		
	// usb signals
	input en,
	input usb_to_c_start,
	input usb_to_c_stop,
	input usb_to_c_cts,
	input usb_to_c_rts,
	input [15:0] usb_to_c_D,
	
	output c_to_usb_busy,
	output reg c_to_usb_stop,
	output reg c_to_usb_cts,
	output reg c_to_usb_rts,
	output [15:0] c_to_usb_D,
	
	// GPIO signals
	output CLKOUT,
	output TMR0,
	
	inout GPIO0,
	inout GPIO1,
	inout GPIO2,
	inout GPIO3__TMR1,
	inout GPIO4,
	inout GPIO5,
	inout GPIO6,
	inout GPIO7
);

	parameter 
		wait_for_start      = 3'b000,
		decision            = 3'b001,
		usb_stop            = 3'b010,
		gpio_update_state   = 3'b011,
		gpio_read_state     = 3'b100;
	
	reg [2:0] CLKOUT_reg;
	reg [7:0] gpio_output_en;
	reg [7:0] GPIO_out;
	reg [7:0] GPIO_in;
	reg gpio_update;
	
	reg [2:0] state;
	reg [2:0] next_state;
	
	assign c_to_usb_D = { 8'b0, GPIO_in };
	assign c_to_usb_busy = 1'b0;

	assign GPIO7 = gpio_output_en[7] ? GPIO_out[7] : 1'bz;
	assign GPIO6 = gpio_output_en[6] ? GPIO_out[6] : 1'bz;
	assign GPIO5 = gpio_output_en[5] ? GPIO_out[5] : 1'bz;
	assign GPIO4 = gpio_output_en[4] ? GPIO_out[4] : 1'bz;
	
	assign GPIO3__TMR1 = gpio_output_en[3] ? GPIO_out[3] : 1'bz;
	
	assign GPIO2 = gpio_output_en[2] ? GPIO_out[2] : 1'bz;
	assign GPIO1 = gpio_output_en[1] ? GPIO_out[1] : 1'bz;
	assign GPIO0 = gpio_output_en[0] ? GPIO_out[0] : 1'bz;
	
	assign CLKOUT = CLKOUT_reg[2];
	
	assign TMR0 = GPIO2;
	
		
	
	
	
	always@( posedge clk, posedge arst )
	begin
		if( arst )
		begin
			
			state <= wait_for_start;
			CLKOUT_reg <= 3'b0;
			gpio_output_en <= 8'b0;
			GPIO_out <= 8'b0;
			GPIO_in <= 8'b0;
			
		end
		else
		begin
			
			state <= next_state;
			
			CLKOUT_reg <= CLKOUT_reg + 3'b1;
			
			GPIO_in <= { GPIO7, GPIO6, GPIO5, GPIO4, GPIO3__TMR1, GPIO2, GPIO1,
				GPIO0 };
			
			if( gpio_update )
			begin
				case( usb_to_c_D[11:8] )
					4'b0100: gpio_output_en <= usb_to_c_D[7:0];       //output en
					4'b0000: GPIO_out <= usb_to_c_D[7:0];             //load
					4'b0001: GPIO_out <= ~usb_to_c_D[7:0] & GPIO_out; //clr
					4'b0010: GPIO_out <= usb_to_c_D[7:0] | GPIO_out;  //set
					4'b0011: GPIO_out <= usb_to_c_D[7:0] ^ GPIO_out;  //tgl
					default: ;
				endcase
			end
			
		end
	end
	
	always@( * )
	begin
		
		c_to_usb_stop = 1'b0;
		c_to_usb_cts = 1'b0;
		c_to_usb_rts = 1'b0;
		gpio_update = 1'b0;
		next_state = state;
		
		case( state )
			
			wait_for_start: begin
				if( en & usb_to_c_start )
					next_state = decision;
			end
			
			decision: begin
				if( usb_to_c_stop )
					next_state = usb_stop;
				else if( usb_to_c_rts & usb_to_c_cts )
					case( usb_to_c_D[15:12] )
						4'b0001: next_state = gpio_update_state;
						4'b0010: next_state = gpio_read_state;
						default: next_state = usb_stop;
					endcase
				else
					next_state = decision;
			end
			
			usb_stop: begin
				c_to_usb_stop = 1'b1;
				if( usb_to_c_stop )
					next_state = wait_for_start;
				else
					next_state = usb_stop;
			end
			
			gpio_update_state: begin
				c_to_usb_cts = 1'b1;
				gpio_update = 1'b1;
				next_state = decision;
			end
			
			gpio_read_state: begin
				c_to_usb_cts = 1'b1;
				c_to_usb_rts = 1'b1;
				next_state  = decision;
			end
			
		endcase
	end

endmodule