// Copyright (c) 2008 Analog Devices, Inc. All rights reserved.
module mem_block
(
	wr_clk,
	wr_en,
	wr_A,
	wr_D,
	rd_clk,
	rd_en,
	rd_A,
	rd_D
);

	parameter A_width = 8;
	
	input wr_clk;
	input wr_en;
	input [A_width-1:0] wr_A;
	input [15:0] wr_D;
	input rd_clk;
	input rd_en;
	input [A_width-1:0] rd_A;
	output [15:0] rd_D;
	
`ifdef NO_RAM
	
	reg [15:0] mem [0:(1<<A_width)-1];
	
	reg [A_width-1:0] rd_A_reg;
	reg [15:0] rd_D_reg;
	
	always@( posedge wr_clk )
		if( wr_en )
			mem[wr_A] <= wr_D;
	
	always@( posedge rd_clk )
		if( rd_en )
		begin
			rd_A_reg <= rd_A;
			rd_D_reg <= mem[rd_A_reg];
		end
	
	assign rd_D = rd_D_reg;
	
`else
	
	dual_port_ram dualram
	(
		.data      ( wr_D ),
		.wrclock   ( wr_clk ),
		.wrclocken ( 1'b1 ),
		.wren      ( wr_en ),
		.wraddress ( wr_A ),
				
		.rdclock   ( rd_clk ),
		.rdclocken ( rd_en ),
		.rdaddress ( rd_A ),
		
		.q         ( rd_D )
	);
	
`endif

endmodule