// Copyright (c) 2008 Analog Devices, Inc. All rights reserved.
module controller1
(
	input arst,
	input clk,
	
	// usb signals
	input en,
	input [7:0] usb_cmd,
	input usb_to_c_start,
	input usb_to_c_stop,
	input usb_to_c_cts,
	input usb_to_c_rts,
	input [15:0] usb_to_c_D,
	
	output c_to_usb_busy,
	output reg c_to_usb_stop,
	output c_to_usb_cts,
	output c_to_usb_rts,
	output [15:0] c_to_usb_D
	
	// SDRAM signals
	
	// io signals
);
	assign { c_to_usb_rts, c_to_usb_cts } =
		{2{ en & ( usb_cmd == 8'b1 ) & usb_to_c_rts & usb_to_c_cts }};
	assign c_to_usb_busy = 1'b0;
	assign c_to_usb_D = usb_to_c_D;
	
	always@( posedge clk, posedge arst )
		if( arst )
			c_to_usb_stop <= 1'b0;
		else
			if( usb_to_c_start )
				c_to_usb_stop <= 1'b0;
			else
				c_to_usb_stop <= usb_to_c_stop;
endmodule