// Copyright (c) 2008 Analog Devices, Inc. All rights reserved.
module clocks_and_reset
(
	input USB_CLKOUT,
	input USB_PA1,
	output arst,
	output clk,
	output clk_en_80M,
	output clk_en_2M5,
	output flashing_led	
);	
	reg [25:0] clk_counter;
	wire pll1_locked;
	
	
`ifdef NO_PLL
	assign pll1_locked = 1'b1;
	assign clk = USB_CLKOUT;		
`else
	pll1 inst_pll1
	(
		.inclk0( USB_CLKOUT ),
		.c0( clk ),		
		.locked( pll1_locked )
	);
`endif
		
	// arst
	assign arst = ~USB_PA1 | ~pll1_locked;

	// clk counter
	always@( posedge clk, posedge arst )
		if( arst )
			clk_counter <= 26'b0;
		else
			clk_counter <= clk_counter + 26'b1;
			
	// clock enables
	assign clk_en_80M = clk_counter[0];
	assign clk_en_2M5 = ( clk_counter[5:0] == 6'b000001 );
	
	assign flashing_led = clk_counter[25];
	
endmodule