// Copyright (c) 2008 Analog Devices, Inc. All rights reserved.

// bus signals
`define start     19
`define busy      19
`define stop      18
`define cts       17
`define rts       16
`define D         15:0

module CED1(
	input USB_CLKOUT,
	output LED_D15,
	output LED_IO,
	output LED_TRANSFER,
	output LED_FPGA_OK,
	//output LED_USB_PA3,
	
	// USB uC
	input USB_IFCLK,
	input USB_CTL0,
	input USB_CTL1,
	input USB_CTL2,
	input USB_PA1,
	input USB_PA2,
	output USB_RDY0,
	output USB_RDY1,
	inout [15:0] USB_D,
	
	// POWER SUPPLY CONTROL
	output PWR_EN_REG_CLK,
	output nPWR_I2C_CS,
	output nPWR_I2C_RD,
	output nPWR_I2C_WR,
	output [1:0] PWR_I2C_A,
	inout [7:0] PWR_D,
	
	// SRAM
	output nSRAM_CE1,
	output nSRAM_WE,
	output nSRAM_OE,
	output [20:0] SRAM_A,
	inout [15:0] SRAM_D,
	
	// 96 way connector
	
	// Parallel
	input mclk,
	output nRESET,
	output nCS,
	output nRD_WR,
	output nSYNC,
	input nDRDY,
	
	inout [15:0] PARD,
		
	// SPI
	output SPI_SEL1,
	output SPI_MOSI,
	output SPI_SCK,
	
	// SPI to ground
	output SPI_MISO,
	output nSPI_SS,
	output I2C_SDA,
	output I2C_SCK	
	
);

	wire arst;
	wire clk;
	wire clk_en_80M;
	wire clk_en_2M5;
	wire flashing_led;
	
	wire [15:0] usb_cmd;
	wire [19:0] usb_to_c;
	wire [19:0] c_to_usb;
	wire [19:0] c0_to_usb;
	wire [19:0] c1_to_usb;
	wire [19:0] c2_to_usb;
	wire [19:0] c3_to_usb;
	wire [19:0] c_to_io;
	wire [19:0] io_to_c;
	
	
	wire spi_clk;

	wire [21:0] n_samples;
	
	assign LED_D15 = nSRAM_CE1;
	assign LED_IO = USB_RDY1;
	assign LED_TRANSFER = USB_RDY0;
	assign LED_FPGA_OK = USB_PA2 ? flashing_led : 1'b1;	
	
	assign SPI_SEL1 = 1'b0;
	assign SPI_MOSI = 1'b0;
	assign SPI_SCK = 1'b0;
	assign SPI_MISO = 1'b0;
	assign nSPI_SS = 1'b0;
	assign I2C_SDA = 1'b0;
	assign I2C_SCK = 1'b0;
	
	

	clocks_and_reset  clks_arst
	(
		.USB_CLKOUT               ( USB_CLKOUT ),
		.USB_PA1                  ( USB_PA1 ),
		
		.arst                     ( arst ),
		.clk                      ( clk ),
		.clk_en_80M               ( clk_en_80M ),
		.clk_en_2M5               ( clk_en_2M5 ),
		.flashing_led             ( flashing_led )		
	);
	
	
	usb_interface  usb
	(
		.arst                     ( arst ),
		
		//USB uC signals
		.USB_IFCLK                ( USB_IFCLK ),
		.USB_CTL0                 ( USB_CTL0 ),
		.USB_CTL1                 ( USB_CTL1 ),
		.USB_CTL2                 ( USB_CTL2 ),
		
		.USB_RDY0                 ( USB_RDY0 ),
		.USB_RDY1                 ( USB_RDY1 ),
		
		.USB_D                    ( USB_D ),
		
		//controler signals
		.clk                      ( clk ),		
		.c_to_usb_stop            ( c_to_usb[`stop] ),
		.c_to_usb_cts             ( c_to_usb[`cts] ),
		.c_to_usb_rts             ( c_to_usb[`rts] ),
		.c_to_usb_D               ( c_to_usb[`D] ),
		
		.usb_cmd                  ( usb_cmd ),
		.usb_to_c_start           ( usb_to_c[`start] ),
		.usb_to_c_stop            ( usb_to_c[`stop] ),
		.usb_to_c_cts             ( usb_to_c[`cts] ),
		.usb_to_c_rts             ( usb_to_c[`rts] ),
		.usb_to_c_D               ( usb_to_c[`D] )
	);
	
	
	mux_usb_c  mux_usb_c
	(
		.controller_select        ( usb_cmd[9:8] ),
		.c0_to_usb                ( c0_to_usb ),
		.c1_to_usb                ( c1_to_usb ),
		.c2_to_usb                ( c2_to_usb ),
		.c3_to_usb                ( c3_to_usb ),
		.c_to_usb                 ( c_to_usb )
	);
	
	
	controller0  c0
	(
		.arst                     ( arst ),
		.clk                      ( clk ),
			
		// usb signals
		.en                       ( usb_cmd[9:8] == 2'b00 ),
		.usb_cmd                  ( usb_cmd[7:0] ),
		.usb_to_c_start           ( usb_to_c[`start] ),
		.usb_to_c_stop            ( usb_to_c[`stop] ),
		.usb_to_c_cts             ( usb_to_c[`cts] ),
		.usb_to_c_rts             ( usb_to_c[`rts] ),
		.usb_to_c_D               ( usb_to_c[`D] ),
		
		.c_to_usb_busy            ( c0_to_usb[`busy] ),
		.c_to_usb_stop            ( c0_to_usb[`stop] ),
		.c_to_usb_cts             ( c0_to_usb[`cts] ),
		.c_to_usb_rts             ( c0_to_usb[`rts] ),
		.c_to_usb_D               ( c0_to_usb[`D] ),
		
		// SRAM signals	
		.nSRAM_CE1                ( nSRAM_CE1 ),
		.nSRAM_WE                 ( nSRAM_WE ),
		.nSRAM_OE                 ( nSRAM_OE ),
		.SRAM_A                   ( SRAM_A ),
		.SRAM_D                   ( SRAM_D ),
		
		// io signals
		.io_to_c_busy             ( io_to_c[`busy] ),
		.io_to_c_stop             ( io_to_c[`stop] ),
		.io_to_c_cts              ( io_to_c[`cts] ),
		.io_to_c_rts              ( io_to_c[`rts] ),
		.io_to_c_D                ( io_to_c[`D] ),
		
		.c_to_io_start            ( c_to_io[`start] ),
		.c_to_io_stop             ( c_to_io[`stop] ),
		.c_to_io_cts              ( c_to_io[`cts] ),
		.c_to_io_rts              ( c_to_io[`rts] ),
		.c_to_io_D                ( c_to_io[`D] ),
		
		.n_samples		          ( n_samples )
		
	);
	
	
	controller1  c1
	(
		.arst                     ( arst ),
		.clk                      ( clk ),
						
		// usb signals
		.en                       ( usb_cmd[9:8] == 2'b01 ),
		.usb_cmd                  ( usb_cmd[7:0] ),
		.usb_to_c_start           ( usb_to_c[`start] ),
		.usb_to_c_stop            ( usb_to_c[`stop] ),
		.usb_to_c_cts             ( usb_to_c[`cts] ),
		.usb_to_c_rts             ( usb_to_c[`rts] ),
		.usb_to_c_D               ( usb_to_c[`D] ),
		
		.c_to_usb_busy            ( c1_to_usb[`busy] ),
		.c_to_usb_stop            ( c1_to_usb[`stop] ),
		.c_to_usb_cts             ( c1_to_usb[`cts] ),
		.c_to_usb_rts             ( c1_to_usb[`rts] ),
		.c_to_usb_D               ( c1_to_usb[`D] )
		
		// SDRAM signals
		
		// io signals
	);
	
	
	gpio_controller  c2
	(
		.arst                     ( arst ),
		.clk                      ( clk ),
		
		// usb signals
		.en                       ( usb_cmd[9:8] == 2'b10 ),
		.usb_to_c_start           ( usb_to_c[`start] ),
		.usb_to_c_stop            ( usb_to_c[`stop] ),
		.usb_to_c_cts             ( usb_to_c[`cts] ),
		.usb_to_c_rts             ( usb_to_c[`rts] ),
		.usb_to_c_D               ( usb_to_c[`D] ),
		
		.c_to_usb_busy            ( c2_to_usb[`busy] ),
		.c_to_usb_stop            ( c2_to_usb[`stop] ),
		.c_to_usb_cts             ( c2_to_usb[`cts] ),
		.c_to_usb_rts             ( c2_to_usb[`rts] ),
		.c_to_usb_D               ( c2_to_usb[`D] )
				
		// GPIO signals			
	);
	
	
	power_controller  c3
	(
		.arst                     ( arst ),
		.clk                      ( clk ),
		.clk_en_2M5               ( clk_en_2M5 ),
		
		// usb signals
		.en                       ( usb_cmd[9:8] == 2'b11 ),
		.usb_cmd                  ( usb_cmd[0] ),
		//.usb_to_c_start           ( usb_to_c[`start] ),
		.usb_to_c_stop            ( usb_to_c[`stop] ),
		.usb_to_c_cts             ( usb_to_c[`cts] ),
		.usb_to_c_rts             ( usb_to_c[`rts] ),
		.usb_to_c_D               ( usb_to_c[`D] ),
		
		.c_to_usb_busy            ( c3_to_usb[`busy] ),
		.c_to_usb_stop            ( c3_to_usb[`stop] ),
		.c_to_usb_cts             ( c3_to_usb[`cts] ),
		.c_to_usb_rts             ( c3_to_usb[`rts] ),
		.c_to_usb_D               ( c3_to_usb[`D] ),
		
		// POWER SUPPLY CONTROL signals
		.PWR_EN_REG_CLK           ( PWR_EN_REG_CLK ),
		.nPWR_I2C_CS              ( nPWR_I2C_CS ),
		.nPWR_I2C_RD              ( nPWR_I2C_RD ),
		.nPWR_I2C_WR              ( nPWR_I2C_WR ),
		.PWR_I2C_A                ( PWR_I2C_A ),
		
		.PWR_D                    ( PWR_D )
	);
	
	parallel_new io3
	(
		.arst                     ( arst ),
		.clk                      ( clk ),
		
		.usb_cmd				  ( usb_cmd[7:0] ),
		
		// controller signals
		.c_to_io_start            ( c_to_io[`start] ),
		.c_to_io_stop             ( c_to_io[`stop] ),
		.c_to_io_cts              ( c_to_io[`cts] ),
		.c_to_io_rts              ( c_to_io[`rts] ),
		.c_to_io_D                ( c_to_io[`D] ),
		
		.io_to_c_busy             ( io_to_c[`busy] ),
		.io_to_c_stop             ( io_to_c[`stop] ),
		.io_to_c_cts              ( io_to_c[`cts] ),
		.io_to_c_rts              ( io_to_c[`rts] ),
		.io_to_c_D                ( io_to_c[`D] ),
		
		// Parallel signals
		.mclk					   ( mclk ),
		.nRESET					   ( nRESET ),
	    .nCS					   ( nCS ),
		.nRD_WR					   ( nRD_WR ),
		.nSYNC					   ( nSYNC ),
		.nDRDY					   ( nDRDY ),
		.PARD					   ( PARD ),
		
		.n_samples                ( n_samples )
	
	);



endmodule

