.module/ram/abs=0    AD7490;       /* define the program module */
{
program reads samples from AD7490 using Monitor Program MFBNEW5b 
verified working not yet
}

.CONST  Sport1_Autobuf_Ctrl=    0x3fef;
.CONST  Sport1_Rfsdiv=          0x3ff0;
.CONST  Sport1_Sclkdiv=         0x3ff1;
.CONST  Sport1_Ctrl_Reg=        0x3ff2;
.CONST  Sport0_Autobuf_Ctrl=    0x3ff3;
.CONST  Sport0_Rfsdiv=          0x3ff4;
.CONST  Sport0_Sclkdiv=         0x3ff5;
.CONST  Sport0_Ctrl_Reg=        0x3ff6;
.CONST  Sport0_TX_Channels0=    0x3ff7;
.CONST  Sport0_TX_Channels1=    0x3ff8;
.CONST  Sport0_RX_Channels0=    0x3ff9;
.CONST  Sport0_RX_Channels1=    0x3ffa;
.CONST  Tscale_Reg=             0x3ffb;
.CONST  Tcount_Reg=             0x3ffc;
.CONST  Tperiod_Reg=            0x3ffd;
.CONST  DM_Wait_Reg=            0x3ffe;
.CONST  Sys_Ctrl_Reg=           0x3fff;
.CONST  BDMA_ctrl=              0x3fe3;
.CONST  BWCOUNT=                0x3fe4;
.CONST  BEAD=                   0x3fe2;
.CONST  BIAD=                   0X3FE1;


{monitor registers }
.Const FLAG	=0x03FDF;
.Const BYTE	=0x03FDE;
.Const CODES	=0x03FDD;
.Const STORE	=0x03FDC;
.Const BYTE1	=0x03FDB;
.Const WORD1	=0x03FDA;
.Const BYTE2	=0x03FD9;
.Const LATCH	=0x03FD8;
.Const VERSION	=0x03FD7;
.Const STACK1	=0x03FD6;
.Const STACK2	=0x03FD5;
.Const STACK3	=0x03FD4;
.Const RegValue	=0x03FD3;
.Const ShadowValue=0x03FD1;
.Const NumberofChannels=0x3fd2;


/* interrupt vector table */
        jump START;nop; nop; nop;/* jump over interrupt vectors */
        rti; rti; rti; rti;      /* IRQ2 interrupt */ 
        rti; rti; rti; rti;      /* IRQL1 interrupt */ 
        rti; rti; rti; rti;      /* IRQL0 interrupt */ 
        rti; rti; rti; rti;      /* SPORT0 TX interrupt */ 
        rti; rti; rti; rti;      /* SPORT0 RX interrupt */ 
        jump ResetBoard; rti; rti; rti;      /* IRQE interrupt (Reset)*/        
        rti; rti; rti; rti;      /* BDMA interrupt */ 
        rti; rti; rti; rti;      /* SPORT1 TX (IRQ1) interrupt */ 
        rti; rti; rti; rti;      /* SPORT1 RX (IRQ0) interrupt */ 
        rti; rti; rti; rti; 		/* TIMER interrupt */ 
        rti; rti; rti; rti;      /* POWER DOWN interrupt */ 


START: {program starts here}
      				

        
        	set fl0;set fl2;
		ax0=0; dm(numberofchannels)=ax0;
		dmovlay=1;
	  	ax0=0x124f; dm(0x3ffe)=ax0; {1 wait state for all} 

        	ax0=1; dm(sport0_sclkdiv)=ax0;  {10MHz SCLK}
        	ax0=0x7ecf; dm(sport0_ctrl_reg)=ax0; {set up the SPORT}
        	ax0=0x1800; dm(sys_ctrl_reg)=ax0; {enable the SPORT}
        	icntl=0x04;     {IRQ2 is edge sensitive}
        	imask=0x10; mstat=0;             {IRQE interrupt, no timer}
		ifc=0xFF; {clear all pending interrupts}
		
		ax0=0x0000; dm(RegValue)=ax0;
		{set all default values to be 0}

GetCommand:
        	I4=0x302C; Call (I4); {call readcommandstring function}
        	Ay1=3; ax0=dm(byte2);   ar=ax0-ay1;if eq jump WriteToLatch;
		Ay1=7; ax0=dm(byte2);	ar=ax0-ay1;if eq jump TakeSamples;
        	Ay1=8; ax0=dm(byte2);   ar=ax0-ay1;if eq jump ResetBoard;
        	Ay1=9; ax0=dm(byte2);   ar=ax0-ay1;if eq jump WriteReg;       
        	Ay1=23; ax0=dm(byte2);   ar=ax0-ay1;if eq jump AutoShutdown;
        	Ay1=24; ax0=dm(byte2);   ar=ax0-ay1;if eq jump AutoStandby;    	
        	Ay1=25; ax0=dm(byte2);   ar=ax0-ay1;if eq jump SetNumberOfChannels;   
        	Ay1=26; ax0=dm(byte2);   ar=ax0-ay1;if eq jump SampleSequence;   
 		Ay1=27; ax0=dm(byte2);   ar=ax0-ay1;if eq jump Shadowregister;   
 	
		jump getcommand; {command not recognised}

WriteToLatch:
		ax0=dm(byte1); dm(latch)=ax0; io(0x100)=ax0;
		jump getcommand;

ResetBoard:
		AX0=8;  DM(BDMA_CTRL)=AX0;
		AX0=0;  DM(BIAD)=AX0;
            	DM(BEAD)=AX0;   
		AX0=32; DM(BWCOUNT)=AX0;        
		rti;

TakeSamples:
        	{calculate number of samples to be uploaded}
        	se=dm(byte1); si=256; sr=lshift si(lo); dm(codes)=sr0;



BeginSampling:	Ax0=dm(word1);	dm(tcount_reg)=ax0; dm(tperiod_reg)=ax0;
		Ax0=0; dm(tscale_reg)=ax0;	{timer set up}
        	ar=dm(codes);
		ay1=1;
        	I0=0; m0=1; l0=0; 
        	Imask=0x11; mstat=0x20; {enable timer and Rx0 interrupt}
		ax1= {dm(RegValue)} 0x0000;

		idle;		{wait for timer}
		tx0=ax1;	{start a conversion}



SampleLoop:  	
		idle;		{wait for timer}
		ax0=rx0;
		ax1 =0xb000;		{read immediately}
		tx0=ax1;
		dm(i0,m0)=ax0;	
		ar=ar-ay1;		
		If ne jump SampleLoop;
		Jump AllSamplesTaken;

AutoShutdown:
        	{calculate number of samples to be uploaded}
        	se=dm(byte1); si=256; sr=lshift si(lo); dm(codes)=sr0;

		Ax0=dm(word1);	dm(tcount_reg)=ax0; dm(tperiod_reg)=ax0;
		Ax0=0; dm(tscale_reg)=ax0;	{timer set up}
        	Ar=8591;ay1=1;
        	I0=0; m0=1; l0=0;
        	Imask=0x31; mstat=0x20; {enable timer and Rx0 interrupt}

SampleLoop1:  	se=12; si=dm(regvalue); sr=lshift si(lo); ax0=sr0;
		{si=ax0; se=10; sr=lshift si(lo);}
		idle;
		tx0=sr0;
		idle;
		ax0=rx0;
		cntr=80; do wakeuploop until ce;
wakeuploop:	nop;		{wait for part to wake up - 5uS}

		ax0=dm(RegValue); {transmit autoshutdown command}
		tx0=ax0;
		idle;		{wait for RX0 interrupt}
		ax0=rx0;	{read valid conversion result}
		dm(i0,m0)=ax0;
		Ar=ar-ay1;
		If ne jump SampleLoop1;
		Jump AllSamplesTaken;
AutoStandby:
        	{calculate number of samples to be uploaded}
        	se=dm(byte1); si=256; sr=lshift si(lo); dm(codes)=sr0;

		Ax0=dm(word1);	dm(tcount_reg)=ax0; dm(tperiod_reg)=ax0;
		Ax0=0; dm(tscale_reg)=ax0;	{timer set up}
        	Ar=8591;ay1=1;
        	I0=0; m0=1; l0=0;
        	Imask=0x31; mstat=0x20; {enable timer and Rx0 interrupt}

SampleLoop2:  	se=12; si=dm(regvalue); sr=lshift si(lo); ax0=sr0;{ax0=dm(regvalue); ay1=0xf5ff;}
		{si=ax0; se=10; sr=lshift si(lo);}{ar=ax0 and ay1;}
		{ax0=ar;}
		idle;
		tx0=sr0;
		idle;
		ax0=rx0;
		{dm(i0,m0)=ax0;}
		cntr =70; do wakeuploop2 until ce;
		

wakeuploop2:	nop;
		
		ax0=dm(RegValue); {transmit autoshutdown command}
		tx0=ax0;
		idle;		{wait for RX0 interrupt}
		ax0=rx0;	{read valid conversion result}
		dm(i0,m0)=ax0;
		Ar=ar-ay1;
		If ne jump SampleLoop2;

AllSamplesTaken:
		{all samples taken}
        	imask=0x10; mstat=0; {turn off interrupt and timer }
        	reset fl2;      {turn off led to indicate all samples taken}


ShowReadySignal:
		i4=0x3074; call(i4); {tell PC we are ready to upload data}


StartUpload:
		i0=0000; ay1=1;
        	ar=dm(codes);

DoNext:
		ax0=dm(i0,m0); 
		dm(store)=ax0; {store word to be transferred}
        	i4=0x30DB; call (i4); {upload_word}
		ar=ar-ay1;
		if ne jump DoNext;

		{all data transferred-wait for next instruction}
        	set fl2;
		ax0=0; dm(numberofchannels)=ax0;
        	jump GetCommand;


WriteReg:	{write a value to the control register}
		ax0=dm(word1);
		tx0=ax0;
		dm(RegValue)=ax0;
		jump GetCommand;


ShadowRegister:	{write a value to the ShadowRegister register}
		ax0=dm(word1);
		tx0=ax0;
		dm(ShadowValue)=ax0;
		jump GetCommand;


SetNumberOfChannels:
		ax0=dm(byte1); dm(NumberofChannels)=ax0;
		jump getcommand;
			



Samplesequence:
        	{calculate number of samples to be uploaded}
        	se=dm(byte1); si=256; sr=lshift si(lo); dm(codes)=sr0;


		Ax0=dm(word1);	dm(tcount_reg)=ax0; dm(tperiod_reg)=ax0;
		Ax0=0; dm(tscale_reg)=ax0;	{timer set up}

		ax0=dm(RegValue); {get stored register value}
		ay1= 0;{0x7fff}
		ar=ax0 and ay1; {make WRITE=0, there is no need to write during sequence read}
		ay0=ar;

        	I0=0; m0=1; l0=0;

		ar=dm(codes);	{number of samples per channel}		
		dm(stack1)=ar;	{temporarily store code count}




        	Imask=0x31; mstat=0x20; {enable timer and Rx0 interrupt}
sampleloop3:
		idle;	{wait for timer interrupt}
		ar=dm(NumberofChannels);
		ay1=1;

GetNextChannel:
			{now loop until sample sequence is complete}
			tx0=ay0;	{transmit WRITE=0}
			idle;		{wait for RXint}
			ax0=rx0;
			dm(i0,m0)=ax0;	{store sample}		
			ar=ar-ay1;
			if ne jump GetNextChannel;



		ar=dm(stack1); {restore number of samples to take}
		ar=ar-1;	{decrease sample count}
		dm(stack1)=ar;	{and store it again}
		If ne jump SampleLoop3;


		{sampling finished}
		imask=0;
		{set Codes as total number of samples taken}
		ax0=dm(numberofchannels); 
                mstat=0x10;	{integer mode}
		my0=ax0;
                mr=sr0 * my0 (UU);
		dm(codes)=mr0;	
		Jump AllSamplesTaken;

		







{		ax0=dm(numberofchannels); }
{		ar=pass ax0;}
{		if eq jump beginsampling;}
		{sampling more than 1 channel}
{                mstat=0x10;	}{integer mode}
{		my0=ax0;}
{                mr=sr0 * my0 (UU);}
{		dm(codes)=mr0;}

.endmod;

