/*!
LTC4155: Dual-Input Power Manager / 3.5A Li-Ion Battery Charger with I²C Control and USB OTG

@verbatim
The LTC®4155 is a 15 watt I²C controlled power manager with PowerPath™ instant-
on operation, high efficiency switching battery charging and USB compatibility.
The LTC4155 seamlessly manages power distribution from two 5V sources, such as a
USB port and a wall adapter, to a single-cell rechargeable Lithium-Ion/Polymer
battery and a system load.
@endverbatim

http://www.linear.com/product/LTC4155

http://www.linear.com/product/LTC4155#demoboards


Copyright 2018(c) Analog Devices, Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
 - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
 - Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in
   the documentation and/or other materials provided with the
   distribution.
 - Neither the name of Analog Devices, Inc. nor the names of its
   contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.
 - The use of this software may or may not infringe the patent rights
   of one or more patent holders.  This license does not release you
   from the requirement that you obtain separate licenses from these
   patent holders to use this software.
 - Use of the software either in source or binary form, must be run
   on or directly connected to an Analog Devices Inc. component.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL ANALOG DEVICES BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, INTELLECTUAL PROPERTY RIGHTS, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Generated on: 2016-01-19
*/


/*! @file
 *  @ingroup LTC4155
 *  @brief LTC4155 library file defining data conversion macros and constants used
 *  by LTC4155.c
 *
 *
 *  This file contains macros and constants which can be used to represent real-world
 *  values in the source code, with automatic compile-time conversion to LTC4155
 *  internal register scaling.
 *
 *  Passing runtime variables to these macros should be avoided as it will likely result
 *  in runtime calculations accompanied by associated processor loading and memory usage.
 */

#ifndef LTC4155_FORMATS_H_
#define LTC4155_FORMATS_H_

/*! @name Format Definitions
 *  Constants used by the macros below to convert from real world to LTC4155 referenced numbers.
 */
/*! @name Constants used in real world conversion macros below
 */
#define LTC4155_KSPAN 0.006162
#define LTC4155_KOFFSET 0.1127
#define LTC4155_RNTCBIAS 10000.0
#define LTC4155_RNTCSER 0.0
#define LTC4155_R150 302.36
#define LTC4155_R145 334.88
#define LTC4155_R140 371.77
#define LTC4155_R135 413.73
#define LTC4155_R130 461.60
#define LTC4155_R125 516.36
#define LTC4155_R120 579.17
#define LTC4155_R115 651.44
#define LTC4155_R110 734.86
#define LTC4155_R105 831.46
#define LTC4155_R100 943.67
#define LTC4155_R95 1074.48
#define LTC4155_R90 1227.51
#define LTC4155_R85 1407.18
#define LTC4155_R80 1618.94
#define LTC4155_R75 1869.50
#define LTC4155_R70 2167.17
#define LTC4155_R65 2522.30
#define LTC4155_R60 2947.82
#define LTC4155_R55 3459.99
#define LTC4155_R50 4079.35
#define LTC4155_R45 4831.94
#define LTC4155_R40 5751.02
#define LTC4155_R35 6879.27
#define LTC4155_R30 8271.77
#define LTC4155_R25 10000.00
#define LTC4155_R20 12157.35
#define LTC4155_R15 14866.53
#define LTC4155_R10 18289.86
#define LTC4155_R5 22643.44
#define LTC4155_R0 28217.00
#define LTC4155_Rm5 35401.63
#define LTC4155_Rm10 44729.13
#define LTC4155_Rm15 56927.91
#define LTC4155_Rm20 73003.30
#define LTC4155_Rm25 94353.48
#define LTC4155_Rm30 122938.33
#define LTC4155_Rm35 161527.01
#define LTC4155_Rm40 214063.67
/*! @name Use the macros below to convert from real world to LTC4155 referenced numbers.
 */
/*! Convert from °C to the Thermistor ADC Reading. */
#define LTC4155_NTCS0402E3103FLT(x) (\
__LTC4155_BETWEEN_INCLUSIVE__((-40), (-35), x) ? __LTC4155_LINE__((-40), (-35), (((LTC4155_Rm40 + LTC4155_RNTCSER) / (LTC4155_Rm40 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_Rm35 + LTC4155_RNTCSER) / (LTC4155_Rm35 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((-35), (-30), x) ? __LTC4155_LINE__((-35), (-30), (((LTC4155_Rm35 + LTC4155_RNTCSER) / (LTC4155_Rm35 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_Rm30 + LTC4155_RNTCSER) / (LTC4155_Rm30 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((-30), (-25), x) ? __LTC4155_LINE__((-30), (-25), (((LTC4155_Rm30 + LTC4155_RNTCSER) / (LTC4155_Rm30 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_Rm25 + LTC4155_RNTCSER) / (LTC4155_Rm25 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((-25), (-20), x) ? __LTC4155_LINE__((-25), (-20), (((LTC4155_Rm25 + LTC4155_RNTCSER) / (LTC4155_Rm25 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_Rm20 + LTC4155_RNTCSER) / (LTC4155_Rm20 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((-20), (-15), x) ? __LTC4155_LINE__((-20), (-15), (((LTC4155_Rm20 + LTC4155_RNTCSER) / (LTC4155_Rm20 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_Rm15 + LTC4155_RNTCSER) / (LTC4155_Rm15 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((-15), (-10), x) ? __LTC4155_LINE__((-15), (-10), (((LTC4155_Rm15 + LTC4155_RNTCSER) / (LTC4155_Rm15 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_Rm10 + LTC4155_RNTCSER) / (LTC4155_Rm10 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((-10), (-5), x) ? __LTC4155_LINE__((-10), (-5), (((LTC4155_Rm10 + LTC4155_RNTCSER) / (LTC4155_Rm10 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_Rm5 + LTC4155_RNTCSER) / (LTC4155_Rm5 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((-5), (0), x) ? __LTC4155_LINE__((-5), (0), (((LTC4155_Rm5 + LTC4155_RNTCSER) / (LTC4155_Rm5 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R0 + LTC4155_RNTCSER) / (LTC4155_R0 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((0), (5), x) ? __LTC4155_LINE__((0), (5), (((LTC4155_R0 + LTC4155_RNTCSER) / (LTC4155_R0 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R5 + LTC4155_RNTCSER) / (LTC4155_R5 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((5), (10), x) ? __LTC4155_LINE__((5), (10), (((LTC4155_R5 + LTC4155_RNTCSER) / (LTC4155_R5 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R10 + LTC4155_RNTCSER) / (LTC4155_R10 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((10), (15), x) ? __LTC4155_LINE__((10), (15), (((LTC4155_R10 + LTC4155_RNTCSER) / (LTC4155_R10 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R15 + LTC4155_RNTCSER) / (LTC4155_R15 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((15), (20), x) ? __LTC4155_LINE__((15), (20), (((LTC4155_R15 + LTC4155_RNTCSER) / (LTC4155_R15 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R20 + LTC4155_RNTCSER) / (LTC4155_R20 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((20), (25), x) ? __LTC4155_LINE__((20), (25), (((LTC4155_R20 + LTC4155_RNTCSER) / (LTC4155_R20 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R25 + LTC4155_RNTCSER) / (LTC4155_R25 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((25), (30), x) ? __LTC4155_LINE__((25), (30), (((LTC4155_R25 + LTC4155_RNTCSER) / (LTC4155_R25 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R30 + LTC4155_RNTCSER) / (LTC4155_R30 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((30), (35), x) ? __LTC4155_LINE__((30), (35), (((LTC4155_R30 + LTC4155_RNTCSER) / (LTC4155_R30 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R35 + LTC4155_RNTCSER) / (LTC4155_R35 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((35), (40), x) ? __LTC4155_LINE__((35), (40), (((LTC4155_R35 + LTC4155_RNTCSER) / (LTC4155_R35 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R40 + LTC4155_RNTCSER) / (LTC4155_R40 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((40), (45), x) ? __LTC4155_LINE__((40), (45), (((LTC4155_R40 + LTC4155_RNTCSER) / (LTC4155_R40 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R45 + LTC4155_RNTCSER) / (LTC4155_R45 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((45), (50), x) ? __LTC4155_LINE__((45), (50), (((LTC4155_R45 + LTC4155_RNTCSER) / (LTC4155_R45 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R50 + LTC4155_RNTCSER) / (LTC4155_R50 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((50), (55), x) ? __LTC4155_LINE__((50), (55), (((LTC4155_R50 + LTC4155_RNTCSER) / (LTC4155_R50 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R55 + LTC4155_RNTCSER) / (LTC4155_R55 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((55), (60), x) ? __LTC4155_LINE__((55), (60), (((LTC4155_R55 + LTC4155_RNTCSER) / (LTC4155_R55 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R60 + LTC4155_RNTCSER) / (LTC4155_R60 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((60), (65), x) ? __LTC4155_LINE__((60), (65), (((LTC4155_R60 + LTC4155_RNTCSER) / (LTC4155_R60 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R65 + LTC4155_RNTCSER) / (LTC4155_R65 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((65), (70), x) ? __LTC4155_LINE__((65), (70), (((LTC4155_R65 + LTC4155_RNTCSER) / (LTC4155_R65 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R70 + LTC4155_RNTCSER) / (LTC4155_R70 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((70), (75), x) ? __LTC4155_LINE__((70), (75), (((LTC4155_R70 + LTC4155_RNTCSER) / (LTC4155_R70 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R75 + LTC4155_RNTCSER) / (LTC4155_R75 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((75), (80), x) ? __LTC4155_LINE__((75), (80), (((LTC4155_R75 + LTC4155_RNTCSER) / (LTC4155_R75 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R80 + LTC4155_RNTCSER) / (LTC4155_R80 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((80), (85), x) ? __LTC4155_LINE__((80), (85), (((LTC4155_R80 + LTC4155_RNTCSER) / (LTC4155_R80 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R85 + LTC4155_RNTCSER) / (LTC4155_R85 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((85), (90), x) ? __LTC4155_LINE__((85), (90), (((LTC4155_R85 + LTC4155_RNTCSER) / (LTC4155_R85 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R90 + LTC4155_RNTCSER) / (LTC4155_R90 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((90), (95), x) ? __LTC4155_LINE__((90), (95), (((LTC4155_R90 + LTC4155_RNTCSER) / (LTC4155_R90 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R95 + LTC4155_RNTCSER) / (LTC4155_R95 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((95), (100), x) ? __LTC4155_LINE__((95), (100), (((LTC4155_R95 + LTC4155_RNTCSER) / (LTC4155_R95 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R100 + LTC4155_RNTCSER) / (LTC4155_R100 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((100), (105), x) ? __LTC4155_LINE__((100), (105), (((LTC4155_R100 + LTC4155_RNTCSER) / (LTC4155_R100 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R105 + LTC4155_RNTCSER) / (LTC4155_R105 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((105), (110), x) ? __LTC4155_LINE__((105), (110), (((LTC4155_R105 + LTC4155_RNTCSER) / (LTC4155_R105 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R110 + LTC4155_RNTCSER) / (LTC4155_R110 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((110), (115), x) ? __LTC4155_LINE__((110), (115), (((LTC4155_R110 + LTC4155_RNTCSER) / (LTC4155_R110 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R115 + LTC4155_RNTCSER) / (LTC4155_R115 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((115), (120), x) ? __LTC4155_LINE__((115), (120), (((LTC4155_R115 + LTC4155_RNTCSER) / (LTC4155_R115 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R120 + LTC4155_RNTCSER) / (LTC4155_R120 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((120), (125), x) ? __LTC4155_LINE__((120), (125), (((LTC4155_R120 + LTC4155_RNTCSER) / (LTC4155_R120 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R125 + LTC4155_RNTCSER) / (LTC4155_R125 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((125), (130), x) ? __LTC4155_LINE__((125), (130), (((LTC4155_R125 + LTC4155_RNTCSER) / (LTC4155_R125 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R130 + LTC4155_RNTCSER) / (LTC4155_R130 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((130), (135), x) ? __LTC4155_LINE__((130), (135), (((LTC4155_R130 + LTC4155_RNTCSER) / (LTC4155_R130 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R135 + LTC4155_RNTCSER) / (LTC4155_R135 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((135), (140), x) ? __LTC4155_LINE__((135), (140), (((LTC4155_R135 + LTC4155_RNTCSER) / (LTC4155_R135 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R140 + LTC4155_RNTCSER) / (LTC4155_R140 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((140), (145), x) ? __LTC4155_LINE__((140), (145), (((LTC4155_R140 + LTC4155_RNTCSER) / (LTC4155_R140 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R145 + LTC4155_RNTCSER) / (LTC4155_R145 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : \
__LTC4155_BETWEEN_INCLUSIVE__((145), (150), x) ? __LTC4155_LINE__((145), (150), (((LTC4155_R145 + LTC4155_RNTCSER) / (LTC4155_R145 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), (((LTC4155_R150 + LTC4155_RNTCSER) / (LTC4155_R150 + LTC4155_RNTCSER + LTC4155_RNTCBIAS) - LTC4155_KOFFSET) / LTC4155_KSPAN), x) : -1)
/*! NTC ADC format. Refer to datasheet to convert to voltage/temperature. */
#define LTC4155_ADC(x) __LTC4155_LINE__((LTC4155_KOFFSET), (LTC4155_KOFFSET + 1/LTC4155_KSPAN), (0), (1), x)
/*! @name Private macros for use by formats above.
 */
#define __LTC4155_LINE__(x0,x1,y0,y1,x) (uint8_t)((y0) + ((y1) - (y0))/((x1) - (x0)) * ((x) - (x0)) + 0.5)
#define __LTC4155_BETWEEN_INCLUSIVE__(x0,x1,x) (((x) > (x0) && (x) < (x1)) || (x) == (x0) || (x) == (x1) ? 1 : 0)


#endif /* LTC4155_FORMATS_H_ */
