% Copyright (c) 2014, Analog Devices Inc. 
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are
% met:
%
% 1. Redistributions of source code must retain the above copyright
% notice, this list of conditions and the following disclaimer.
%
% 2.Redistributions in binary form must reproduce the above copyright notice,
% this list of conditions and the following disclaimer in the documentation
% and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its
% contributors may be used to endorse or promote products derived from this
% software without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

function interface_obj = QueryInterface(key)

msg = ['<queryinterface />'];

response = ProcessMessage(msg, key);

% Find 'in' element and get attributes
idx = strfind(response, '<in ') + 4;
s_in_attr = response(idx:end);
idx = strfind(s_in_attr, '/>') - 1;
s_in_attr = s_in_attr(1:idx);

% Find in.domain
idx = strfind(s_in_attr, 'domain="') + 8;
s_in_domain = s_in_attr(idx:end);
idx = strfind(s_in_domain, '"') - 1;
in.domain = s_in_domain(1:idx);

% Find in.unit
idx = strfind(s_in_attr, 'unit="') + 6;
s_in_unit = s_in_attr(idx:end);
idx = strfind(s_in_unit, '"') - 1;
in.unit = s_in_unit(1:idx);

% Find in.is_complex
idx = strfind(s_in_attr, 'is_complex="') + 12;
s_in_is_complex = s_in_attr(idx:end);
idx = strfind(s_in_is_complex, '"') - 1;
in.is_complex = strcmp(s_in_is_complex(1:idx), 'true');

% Find in.fin
idx = strfind(s_in_attr, 'fin="') + 5;
s_in_fin = s_in_attr(idx:end);
idx = strfind(s_in_fin, '"') - 1;
in.fin = str2double(s_in_fin(1:idx));

% Find 'out' element and get attributes
idx = strfind(response, '<out ') + 5;
s_out_attr = response(idx:end);
idx = strfind(s_out_attr, '/>') - 1;
s_out_attr = s_out_attr(1:idx);

% Find in.domain
idx = strfind(s_out_attr, 'domain="') + 8;
s_out_domain = s_out_attr(idx:end);
idx = strfind(s_out_domain, '"') - 1;
out.domain = s_out_domain(1:idx);

% Find in.unit
idx = strfind(s_out_attr, 'unit="') + 6;
s_out_unit = s_out_attr(idx:end);
idx = strfind(s_out_unit, '"') - 1;
out.unit = s_out_unit(1:idx);

% Find in.is_complex
idx = strfind(s_out_attr, 'is_complex="') + 12;
s_out_is_complex = s_out_attr(idx:end);
idx = strfind(s_out_is_complex, '"') - 1;
out.is_complex = strcmp(s_out_is_complex(1:idx), 'true');

% Find out.fout
idx = strfind(s_out_attr, 'fout="') + 6;
s_out_fin = s_out_attr(idx:end);
idx = strfind(s_out_fin, '"') - 1;
out.fout = str2double(s_out_fin(1:idx));

interface_obj.in = in;
interface_obj.out = out;

% Calculate ratio between output and input data rates
interface_obj.r = out.fout / in.fin;
