% Copyright (c) 2014, Analog Devices Inc. 
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are
% met:
%
% 1. Redistributions of source code must retain the above copyright
% notice, this list of conditions and the following disclaimer.
%
% 2.Redistributions in binary form must reproduce the above copyright notice,
% this list of conditions and the following disclaimer in the documentation
% and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its
% contributors may be used to endorse or promote products derived from this
% software without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

function io = Configure(fclk, spectrumCenter, extJitter, key)

% Create a configuration for this simulation
cfg = AD9680_Configuration();

% Determine the mode of operation depending on the cfg settings
mode = cfg.mode;

% Set the current mode for the device
SetMode(mode, key);

% Set the GLOBAL sampling rate and input frequency
SetProperty('GLOBAL', 'fclk', num2str(fclk), key);
SetProperty('GLOBAL', 'tessitura', num2str(spectrumCenter), key);

% Set the RMS external jitter
SetProperty('settings', 'extjitter', num2str(extJitter), key);

% Setup the DDC and NCO if enabled
if (~strcmp(cfg.mode,'mode1'))
    SetProperty('ddc', 'm', num2str(cfg.ddc_m), key);
    SetProperty('ddc', 'gain', num2str(cfg.ddc_gain), key);
    SetProperty('nco', 'freq', num2str(cfg.nco_freq), key);
    SetProperty('nco', 'phaseoff', num2str(cfg.nco_phase), key);
end

io = QueryInterface(key);