% Copyright (c) 2014, Analog Devices Inc. 
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are
% met:
%
% 1. Redistributions of source code must retain the above copyright
% notice, this list of conditions and the following disclaimer.
%
% 2.Redistributions in binary form must reproduce the above copyright notice,
% this list of conditions and the following disclaimer in the documentation
% and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its
% contributors may be used to endorse or promote products derived from this
% software without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

function cfg = AD9680_Configuration()

% Modes of Operation
cfg.mode = 'mode1';    % ADC Only
%cfg.mode = 'mode2';    % Real ADC + DDC
%cfg.mode = 'mode3';    % Complex ADC + DDC
%cfg.mode = 'mode4';    % Real ADC + DDC + Complex-to-Real
%cfg.mode = 'mode5';    % Complex ADC + DDC + Complex-to-Real

% Set mode specific properties
if (strcmp(cfg.mode, 'mode1'))
    % No properties to set
elseif (strcmp(cfg.mode, 'mode2') || strcmp(cfg.mode, 'mode3'))
    cfg.ddc_m = 2;          % DDC Decimation {2,4,8,16}
    cfg.ddc_gain = 0;       % DDC Gain {0,6} (in dB)
    cfg.nco_freq = 2.5e8;   % NCO Frequency [0,fclk] (in Hz)
    cfg.nco_phase = 0;      % NCO Phase [0,360] (in deg)
else % (strcmp(cfg.mode, 'mode4') || strcmp(cfg.mode, 'mode5'))
    cfg.ddc_m = 1;          % DDC Decimation {1,2,4,8}
    cfg.ddc_gain = 0;       % DDC Gain {0,6} (in dB)
    cfg.nco_freq = 2.5e8;   % NCO Frequency [0,fclk] (in Hz)
    cfg.nco_phase = 0;      % NCO Phase [0,360] (in deg)
end
  







