% Copyright (c) 2014, Analog Devices Inc. 
% All rights reserved.
% 
% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are
% met:
%
% 1. Redistributions of source code must retain the above copyright
% notice, this list of conditions and the following disclaimer.
%
% 2.Redistributions in binary form must reproduce the above copyright notice,
% this list of conditions and the following disclaimer in the documentation
% and/or other materials provided with the distribution.
%
% 3. Neither the name of the copyright holder nor the names of its
% contributors may be used to endorse or promote products derived from this
% software without specific prior written permission.
%
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

function key = ImportPMF(filename)

% Check to see if the library is loaded already
if (~libisloaded('MOTIF'))
    dllpath = [pwd '/MOTIF.dll'];
    if ~exist(dllpath, 'file')
        dllpath = [pwd '/MOTIF/MOTIF.dll'];
        if ~exist(dllpath, 'file')
            uiwait(msgbox('Warning: cannot locate MOTIF.dll'));
            return;
        end
    end
    
    headerpath = [pwd '/MOTIF.h'];
    if ~exist(headerpath, 'file')
        headerpath = [pwd '/MOTIF/MOTIF.h'];
        if ~exist(headerpath, 'file')
            uiwait(msgbox('Warning: cannot locate MOTIF.h'));
            return;
        end
    end    
    
    loadlibrary(dllpath, headerpath, 'alias', 'MOTIF');
end

% Load the PMF into memory
key = calllib('MOTIF', 'ImportPMF', filename);