/*
Copyright (c) 2013, Linear Technology Corp.(LTC)
All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of Linear Technology Corp.
*/

//`timescale 1ns / 1ps
//module 'sneaker_port' converts SPI serial data into parallel
//GMH
//September 11, 2014  RevA

module sneaker_port(WRIN_I2C, 
					SDI_I2C, 
					SCK_I2C, 
			sneaker_port_out
							);					
   input WRIN_I2C;	   											// capture starts on falling edge
   input SDI_I2C;    												// input from sneaker port
   input SCK_I2C;														// data is clocked on rising edge		
   output [15:0] sneaker_port_out;  							// 16-bit output  swaps order of bits 
   reg 		[15:0] sneaker_port_out;
	reg		[15:0] sneaker_port_temp;
   wire 		WRIN_I2C;		 
   wire 		SDI_I2C;
   wire 		SCK_I2C;
		
			always @(posedge SCK_I2C) begin//
			if (WRIN_I2C==0)begin///
			sneaker_port_temp <= {SDI_I2C,sneaker_port_temp[15:1]};										
		end ///										
		end //
			always @ (posedge WRIN_I2C)sneaker_port_out <= sneaker_port_temp;
			
		
	endmodule
	