/*
Copyright (c) 2013, Linear Technology Corp.(LTC)
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of Linear Technology Corp.
*/
																		//`timescale 1ns / 1ps
																		//module 'serial_io' generates patterns for SPI signals, reads serial LTC2512 data and converts it to parallel using Altera MAX 10
																		//GMH
																		//April 5, 2016  RevA

module serial_io(master_clk_a, 
								mosi, 
								miso, 
								data_latch, 
								sck, 
								conv, 
								aux0, 
								dout, 
								mcd_a,
								SEL_32_40L,
								sneaker_port_out,
								WRIN_I2C,
								DRDYL_33,
								SDOB,
								sckb,
								AorB,
								doutb,
								BUSY,
								vari,
								tp1,
								tp2,
								tp3,
								tp4,
								tp5,
								sneaker_port_out2,
								mode);
								
   input master_clk_a;	   									// external clock in
   input mcd_a;    												// mcd is a delayed version of master_clk
	input SEL_32_40L;												// selects 24bit or 32bit format 1=24, 0=32 from sneaker_port
	input miso;														// sdoa to MAX 10 (serial data from ADC)
	input	SDOB;														// SDOB to MAX 10
	input [15:0] sneaker_port_out;							// 11-bit word from sneaker_port, sets divide ratio and AorB
	input [15:0]	sneaker_port_out2;						// 14-bit word from sneaker_port2, sets OSR when variable OSR filter is used not used for 2512
	input	WRIN_I2C;												// WRIN_I2C=0 write to sneaker_port, WRIN_I2C=1 read ADC
	input	DRDYL_33;												// On falling edge ready to configure filter
	input	BUSY;														// On falling edge ready to clock out SDOB
	output vari;													// variable OSR 1=on 0=off not used for 2512
   output mosi;			  										// sdi to adc (some parts may not use this line)
   output data_latch;											// latches data into cpld   (active high)
   output sck;														// gated version of external clock in
	output sckb;													// gated version of external clock in
   output conv;													// convert or CS to ADC
   output aux0;  													// aux output   
	output AorB;													// chooses A or B output of DUT based on PScope GUI
   output 	[53:0] dout;										// 54-bit deserialized data from ADC only up to 32 bits used for 2512
	output   [53:0] doutb;										// deserialized data from SDOB
	output   tp1;													//tp1-tp5 are testpoints sent to top level
	output   tp2;
	output   tp3;
	output	tp4;
	output   tp5;
	output	[2:0]mode;											//mode is sent to top level as diagnostic
	
	reg		[2:0]	mode;
   reg 		[63:0] aux0_shift;
   reg 		[63:0] conv_shift;
   reg 		[63:0] data_latch_shift;
   reg 		[63:0] delay_shift;												
   reg 		[63:0] mosi_shift;
   reg 		[63:0] sck_shift;
	reg		[63:0] sckb_shift;
   reg 		[53:0] dout;	
	reg		[53:0] doutb;
   reg 		[7:0] delay;
   reg 		[6:0] clk_counter;
	reg 		reset_pulse;
   wire 		aux0;		 
   wire 		data_latch;
   wire 		master_clk_a;
	assign 	master_clk= master_clk_a & reset_pulse;
   wire 		mcd_a;
	assign	mcd= mcd_a & reset_pulse;
	wire		SEL_32_40L;
   wire 		miso;
	wire		SDOB;
   wire 		mosi;
   wire 		sck;
	wire		sckb;
	wire		AorB;
	wire		[15:0] sneaker_port_out;
	wire		[15:0] sneaker_port_out2;
	wire		[15:0] sp_data2;
	assign sp_data2[0]=sneaker_port_out2[15];				//sneakerport data has MSB in LSB position
	assign sp_data2[1]=sneaker_port_out2[14];				//this flips everything back where it belongs
	assign sp_data2[2]=sneaker_port_out2[13];
	assign sp_data2[3]=sneaker_port_out2[12];
	assign sp_data2[4]=sneaker_port_out2[11];
	assign sp_data2[5]=sneaker_port_out2[10];
	assign sp_data2[6]=sneaker_port_out2[9];
	assign sp_data2[7]=sneaker_port_out2[8];
	assign sp_data2[8]=sneaker_port_out2[7];
	assign sp_data2[9]=sneaker_port_out2[6];
	assign sp_data2[10]=sneaker_port_out2[5];
	assign sp_data2[11]=sneaker_port_out2[4];
	assign sp_data2[12]=sneaker_port_out2[3];
	assign sp_data2[13]=sneaker_port_out2[2];
	assign sp_data2[14]=sneaker_port_out2[1];
	assign sp_data2[15]=sneaker_port_out2[0];
	wire		WRIN_I2C;
	wire		DRDYL_33;
	wire		BUSY;
	reg 		[23:0] miso_def;
	reg 		[63:0] mosi_def;
	wire		fast;													//fast=1 distributed read, fast=0 normal read
	wire		fast_gate;  										//fast_gate=1 enable sck, fast_gate=0 disable sck, fast_gate ored with gate_enD
	wire		fast_gateV;
	reg 		[63:0] data_latch_def;
	reg 		[63:0] sck_def;
	reg		[63:0] sckb_def;
	reg 		[63:0] conv_def;
	reg 		[63:0] aux0_def;
	reg 		[63:0] delay_def;
	reg 		gate;
	reg		gateb;
	wire     gate_enW;											//enable gate on rising edge of WRIN_I2C
	wire		gate_enD;											//enable gate on rising edge of !DRDYL_33
	wire		gate_enD1;
	wire		gate_enD2;
	wire		gate_enD3;
	wire		gate_enD4;
	wire		gate_enD5;
	wire		gate_enD6;
	wire		gate_enD7;
	wire		gate_enD8;
	wire		gate_enD9;
	
	wire		gate_enDfv1;
	wire		gate_enDfv2;
	wire		gate_enDfv3;
	wire		gate_enDfv4;
	wire		gate_enDfv5;
	
	reg		gate_enD10;											//if OSR=8 for distributed read always enable SCK and SDI
	reg		gate_enV_reset;									//reset gate_enV when conv_count is reset
	wire		gate_enV_stretch;									//stretch the gate_enV pulse
	reg		gate_enV;											//enable gate if conv_count hits 1 vari=1 and fast=0
	reg		gate_enV1;											//trigger for gate when vari=1 and fast=1
	wire		gate_enb;											//enable gateb on rising edge of !BUSY
	wire		[7:0] delay_time;
   wire		[6:0] max_clk_cnt;
	wire gate_dly_1;												//
	wire gate_dly_2;												//
	wire gate_dly_3;												//
	wire gate_dly_4;
	wire gate_dly_5;
	wire gate_dly_6;
	wire gate_dly_7;
	wire gate1;
	wire gate3;
	wire gate2;
	wire gate4;
	wire gate5;
	wire gate6;
	wire gate7;
	assign gate1=gate_dly_1;
	assign gate2=gate_dly_2;
	assign gate3=gate_dly_3;
	assign gate4=gate_dly_4;
	assign gate5=gate_dly_5;
	assign gate6=gate_dly_6;
	assign gate7=gate_dly_7;
	wire gateb_dly_1;												//
	wire gateb_dly_2;												//
	wire gateb_dly_3;												//
	wire gateb1;
	wire gateb3;
	wire gateb2;
	assign gateb1=gateb_dly_1;
	assign gateb2=gateb_dly_2;
	assign gateb3=gateb_dly_3;
	reg mosi_gate;													//mosi_gate=1 send new mosi, mosi_gate=0 mosi stays low
	reg gate_data_latch;
	assign fast = sneaker_port_out[4];						//distributed read
	//added 10/6/15    ///////////////////////////////////////////////////////////////////////////////////////////////////
	wire [13:0]conv_count;
	reg test;
	//assign master_count = 14'b0000000000101;				//was 14'b00000001100011
	reg rp;
	wire [13:0]master_reset;
	
	
	always @(posedge master_clk) begin
		if (conv_count==0) test <= 1;							//when conv_count hits 0 test =1
		else test <=0;												//otherwise test=0
	end

		always @ (master_reset)	begin	
			if (master_reset >=3) begin
			reset_pulse <=0;
			rp<=0;
			end
		if (master_reset ==2) begin							//when master_reset counts down to 2 rp=1
		reset_pulse<= 0;
		rp<=1;
		end
		if (master_reset <=1) begin							//when master_reset counts down to 1 reset_pulse =1
		reset_pulse <=1;
		rp<=0;
		end		
		end
		//////////////////////////////////////////////////////////////////////////////////////		new code 10/14/15
		assign tp1=sneaker_port_out[7];
		assign tp2=sneaker_port_out[8];
		assign tp3=sneaker_port_out[9];
		assign tp4=sneaker_port_out[10];
		assign tp5=sneaker_port_out[11];
		
		
		
		//////////////////////////////////////////////////////////////////////////////////////// end new code 10/14/15
		
		counter_14bit counter_14bit_inst2 	(.aload					(!WRIN_I2C),							//rising edge of WRIN_I2C starts master reset counter
														.clock					(master_clk_a & (master_reset >1)),//count every master_clk if master_reset greater than 1
														.data						(14'b0000001100101),						//master_count is number of master_clk pulses from WRIN_I2C to master_reset
														.q							(master_reset)							//master_reset is signal to start activity
														);
	
		counter_14bit	counter_14bit_inst 	(.aload 					( (rp)|(test & conv) ),				//load sneaker_port_out2 if master_reset counts down to 2 or if master_count and conv are high
														.clock 					( conv ),								//count every conversion
														.data 					( sp_data2 ),							//OSR from sneaker_port_out2 flipped
														.q 						( conv_count )							//when zero, a gate signal needs to be generated
														);

		
		
			always @ (conv_count or rp or fast or vari) begin
			
		if ((fast & vari) == 1) begin
		if (conv_count ==14'b00000000000000 ) gate_enV1 <=1; //gate trigger for variable filter and distributed read 
		else gate_enV1 <=0;
		end
		
		if ((!fast & vari) ==1)begin
		if (conv_count ==14'b00000000000001 ) gate_enV <=1; //gate trigger for variable filter and not distributed read 
		else gate_enV <=0;
		end
		
		if (rp==1) begin
		gate_enV1 <=0;
		gate_enV <=0;
		end
		
		end
		
//end added 10/6/15  ///////////////////////////////////////////////////////////////////////////////////////////////////////


assign AorB = sneaker_port_out[15];							//if AorB=1 read SDOA, if AorB=0 read SDOB

reg vari;
always @ (AorB or SEL_32_40L or fast or vari) begin
	if (AorB==0) begin//
	
	mode<= 3'b000;
	mosi_def <= 64'H0000000000000000 | {sneaker_port_out[14:11],sneaker_port_out[10:5],5'b01000};	//b15 of sneaker_port_out is AorB, bits 0 thru 4 are unused	

	
																		//		normal with CM SDOB </
																		//											57 clks
																		//   counts per delay	max clk count 		# of channels 	# of bits 
																		//   b16-b23(max 255)	b9-b15(max 127)	b5-b8(max 16)	b0-b4 (max 32)
																		//				30							28			    1		  		   22  14bits + 8CM bits	   
          miso_def <= 24'H1D3635;    						//  0001 1101			0011 	011			0 001 	   1 0101   	                               												      
 //       mosi_def <= 64'H0000000000000000;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000        	                               
    data_latch_def <= 64'H0000000002000000;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0010 0000 0000 0000 0000 0000 0000	   	           	                               
           sck_def <= 64'H0000000001FFFFF8;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0001 1111 1111 1111 1111 1111 1000  
			 sckb_def <= 64'H0000000001FFFFF8;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0001 1111 1111 1111 1111 1111 1000
          conv_def <= 64'H0000000003FFFFFC;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0011 1111 1111 1111 1111 1111 1100 	   	    	          	                           
          aux0_def <= 64'H0000000000000001;				//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0001
         delay_def <= 64'H0000000000000002;      		//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0010 
	end//
	else begin//
	
	case (sneaker_port_out[14:12])
   3'b111 : vari <=1;
   
  default : vari <=0;
endcase
	if (SEL_32_40L==1)begin////
	if (fast==0)begin/////
	
 mosi_def <= 64'H0000000000000000 | {sneaker_port_out[14:11],sneaker_port_out[10:5],5'b01000};	//b15 of sneaker_port_out is AorB, bits 0 thru 4 are unused	
	mode<= 3'b001;
	
																		//		normal no verify SDOA </
																		//											57 clks
																		//   counts per delay	max clk count 		# of channels 	# of bits 
																		//   b16-b23(max 255)	b9-b15(max 127)	b5-b8(max 16)	b0-b4 (max 32)
																		//				30							28			    1		  		   24	   
          miso_def <= 24'H1D3637;    						//  0001 1101			0011 	011			0 001 	   1 0111   	                               												      
 //       mosi_def <= 64'H0000000000000000;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000        	                               
    data_latch_def <= 64'H0000000008000000;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 1000 0000 0000 0000 0000 0000 0000	   	           	                               
           sck_def <= 64'H0000000007FFFFF8;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0111 1111 1111 1111 1111 1111 1000  
			 sckb_def <= 64'H0000000007FFFFF8;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0111 1111 1111 1111 1111 1111 1000
          conv_def <= 64'H000000000FFFFFFC;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 1111 1111 1111 1111 1111 1111 1100 	   	    	          	                           
          aux0_def <= 64'H0000000000000001;				//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0001
         delay_def <= 64'H0000000000000002;      		//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0010 	

end/////

else begin/////


mosi_def <= 64'H0000000000000000 | {sneaker_port_out[14:11],6'b000000,sneaker_port_out[10:5],5'b01000};	//b15 of sneaker_port_out is AorB, bits 0 thru 4 are unused
if (sneaker_port_out[10:7]	== 4'b0000)	begin//////
gate_enD10 <= 1;
end		//////														
else begin//////
gate_enD10 <=0;
end	//////		
mode<= 3'b010;														//				normal no verify distributed read SDOA </
																		//											156 clks/4 39clks/cycle 
																		//   counts per delay	max clk count 		# of channels 	# of bits 
																		//   b16-b23(max 255)	b9-b15(max 127)	b5-b8(max 16)	b0-b4 (max 32)
																		//						30					40			    1		  		   24	   
          miso_def <= 24'H1D4E37;    						//  0001 1101			0100 	111			0 001 	   1 0111   	                               												      
 //       mosi_def <= 64'H0000000000000000;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000        	                               
    data_latch_def <= 64'H0000008000000000;    			//  0000 0000 0000 0000 0000 0000 1000 0000 0000 0000 0000 0000 0000 0000 0000 0000	   	           	                               
           sck_def <= 64'H0000007E1F87E1F8;    			//  0000 0000 0000 0000 0000 0000 0111 1110 0001 1111 1000 0111 1110 0001 1111 1000  
			 sckb_def <= 64'H0000007E1F87E1F8;    			//  0000 0000 0000 0000 0000 0000 0111 1110 0001 1111 1000 0111 1110 0001 1111 1000
          conv_def <= 64'H000000FF3FCFF3FC;    			//  0000 0000 0000 0000 0000 0000 1111 1111 0011 1111 1100 1111 1111 0011 1111 1100 	   	    	          	                           
          aux0_def <= 64'H0000000000000001;				//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0001
         delay_def <= 64'H0000000080200802;      		//  0000 0000 0000 0000 0000 0000 0000 0000 1000 0000 0010 0000 0000 1000 0000 0010 		
	end/////
	
	end ////
	else begin////
	
	if (vari==1)begin/////	
	
	if (fast==0)begin//////
mode<= 3'b011;																					//not used for 2512
mosi_def <= 64'H0000000000000000 | {sneaker_port_out[14:5],5'b01000};	//b15 of sneaker_port_out is AorB, bits 0 thru 4 are unused
																		//		variable OSR No Distributed Read SDOA
																		//											114 clks /cycle
																		//   counts per delay	max clk count 		# of channels 	# of bits 
																	   //   b16-b23(max 255)	b9-b15(max 127)	b5-b8(max 16)	b0-b4 (max 32)
																	   //				55							60			    1		  		   54	   
          miso_def <= 24'H36763F;    					   //  0011 0110			0111 	011			0 001 	   1 1111   	                               												      
 //       mosi_def <= 64'H0000000000000000;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000        	                               
    data_latch_def <= 64'H0C00000000000000;    			//  0000 1100 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000	   	           	                               
           sck_def <= 64'H01FFFFFFFFFFFFF8;    			//  0000 0001 1111 1111 1111 1111 1111 1111 1111 1111 1111 1111 1111 1111 1111 1000  
			 sckb_def <= 64'H01FFFFFFFFFFFFF8;    			//  0000 0001 1111 1111 1111 1111 1111 1111 1111 1111 1111 1111 1111 1111 1111 1000
          conv_def <= 64'H03FFFFFFFFFFFFFC;    			//  0000 0011 1111 1111 1111 0111 1111 1111 1111 1111 1111 1111 1111 1111 1111 1100 	   	    	          	                           
          aux0_def <= 64'H0000000000000001;				//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0001
         delay_def <= 64'H0000000000000002;      		//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0010 
	
	end//////
	
	else begin//////
	
mosi_def <= 64'H0000000000000000 | {sneaker_port_out[14:5],3'b010};	//b15 of sneaker_port_out is AorB, bits 0 thru 4 are unused
if (sp_data2	== 16'b0000000000000000)	begin///////
gate_enD10 <= 1;
end		///////														
else begin///////
gate_enD10 <=0;
end	///////																//not used for 2512
mode<= 3'b100;														//		Variable OSR Distributed Read SDOA
																		//											180 clks/4=45clks/cycle
																		//   counts per delay	max clk count 		# of channels 	# of bits 
																	   //   b16-b23(max 255)	b9-b15(max 127)	b5-b8(max 16)	b0-b4 (max 32)
																	   //				30							64			    1		  		   54	   
          miso_def <= 24'H1D7E3F;    					   //  0001 1101			0111 	111			0 001 	   1 1111   	                               												      
 //       mosi_def <= 64'H0000000000000000;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000        	                               
    data_latch_def <= 64'HC000000000000000;    			//  1100 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000	   	           	                               
           sck_def <= 64'H1FFE7FFE7FFE7FFE;    			//  0001 1111 1111 1110 0111 1111 1111 1110 0111 1111 1111 1110 0111 1111 1111 1110  
			 sckb_def <= 64'H1FFE7FFE7FFE7FFE;    			//  0001 1111 1111 1110 0111 1111 1111 1110 0111 1111 1111 1110 0111 1111 1111 1110
          conv_def <= 64'H7FFE7FFE7FFE7FFE;    			//  0111 1111 1111 1110 0111 1111 1111 1110 0111 1111 1111 1110 0111 1111 1111 1110 	   	    	          	                           
          aux0_def <= 64'H0000000000000001;				//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0001
         delay_def <= 64'H0001000100010001;      		//  0000 0000 0000 0001 0000 0000 0000 0001 0000 0000 0000 0001 0000 0000 0000 0001

  end//////
	
	end/////
	else begin/////		
	
	
	if (fast==0) begin//////
mode<= 3'b101;
mosi_def <= 64'H0000000000000000 | {sneaker_port_out[14:5],5'b01000};	//b15 of sneaker_port_out is AorB, bits 0 thru 4 are unused	
																		//		Normal with Verify No Distributed Read SDOA
																		//											66 clks/cycle </
																		//   counts per delay	max clk count 		# of channels 	# of bits 
																	   //   b16-b23(max 255)	b9-b15(max 127)	b5-b8(max 16)	b0-b4 (max 32)
																	   //				30							37			    1		  		   32	   
          miso_def <= 24'H1D483F;    					   //  0001 1101			0100 	100			0 001 	   1 1111   	                               												      
 //       mosi_def <= 64'H0000000000000000;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000        	                               
    data_latch_def <= 64'H0000001000000000;    			//  0000 0000 0000 0000 0000 0000 0001 0000 0000 0000 0000 0000 0000 0000 0000 0000	   	           	                               
           sck_def <= 64'H00000007FFFFFFF8;    			//  0000 0000 0000 0000 0000 0000 0000 0111 1111 1111 1111 1111 1111 1111 1111 1000  
			 sckb_def <= 64'H00000007FFFFFFF8;    			//  0000 0000 0000 0000 0000 0000 0000 0111 1111 1111 1111 1111 1111 1111 1111 1000
          conv_def <= 64'H0000000FFFFFFFFC;    			//  0000 0000 0000 0000 0000 0000 0000 1111 1111 1111 1111 1111 1111 1111 1111 1100 	   	    	          	                           
          aux0_def <= 64'H0000000000000001;				//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0001
         delay_def <= 64'H0000000000000002;      		//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0010 


end//////

else begin//////


	
mosi_def <= 64'H0000000000000000 | {sneaker_port_out[14],5'b00000,sneaker_port_out[13:5],5'b01000};
if (sneaker_port_out[10:7]	== 4'b0000)	begin///////
gate_enD10 <= 1;
end		///////														
else begin///////
gate_enD10 <=0;
end	///////
mode<= 3'b110;
																		//		Normal with Verify and Distributed Read SDOA </
																		//											176 clks/4 44clks/cycle
																		//   counts per delay	max clk count 		# of channels 	# of bits 
																	   //   b16-b23(max 255)	b9-b15(max 127)	b5-b8(max 16)	b0-b4 (max 32)
																	   //				34							44			    1		  		   32	   
          miso_def <= 24'H21563F;    					   //  0010 0001			0101 	011			0 001 	   1 1111   	                               												      
 //       mosi_def <= 64'H0000000000000000;    			//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000        	                               
    data_latch_def <= 64'H0000080000000000;    			//  0000 0000 0000 0000 0000 1000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000	   	           	                               
           sck_def <= 64'H000007F8FF1FE3FC;    			//  0000 0000 0000 0000 0000 0111 1111 1000 1111 1111 0001 1111 1110 0011 1111 1100  
			 sckb_def <= 64'H000007F8FF1FE3FC;    			//  0000 0000 0000 0000 0000 0111 1111 1000 1111 1111 0001 1111 1110 0011 1111 1100
          conv_def <= 64'H00000FFDFFBFF7FE;    			//  0000 0000 0000 0000 0000 1111 1111 1101 1111 1111 1011 1111 1111 0111 1111 1110 	   	    	          	                           
          aux0_def <= 64'H0000000000000001;				//  0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0000 0001
         delay_def <= 64'H0000000200400801;      		//  0000 0000 0000 0000 0000 0000 0000 0010 0000 0000 0100 0000 0000 1000 0000 0001 

end//////

			
	end 	/////		

	end	////
	
	end///
	
	end//
	
	
	
	assign max_clk_cnt =  miso_def[15:9];					// maximum count before clk_counter is reset	(max 127)     
	assign delay_time =  miso_def[23:16];					// number of master_clks to wait if delay goes high (max 255)
	assign data_latch = data_latch_shift[0] & gate_data_latch & mcd;	   //	was data_latch_shift[0] & gate &!sck								   						
	assign mosi = (mosi_shift[0]& gate /*& (mosi_gate | fast_gate)*/);	//	mosi is gated by gate and mosi_gate	
	assign aux0 = aux0_shift[0];
	assign sck = (sck_shift[0]& mcd & gate & AorB);		//	sck is gated by gate	and !AorB
	assign sckb = (sck_shift[0]& mcd & gateb & !AorB);	//	sck is gated by gateb and AorB
	wire 	 conv;
	assign conv = !(conv_shift[0]);
	
   initial begin //
   delay <= 0;															
   clk_counter <= 7'b0000000;									// initialize counter loop   
   aux0_shift<= 64'H0000000000000000;
   conv_shift<= 64'H0000000000000000;
   data_latch_shift<= 64'H0000000000000000;
   delay_shift<= 64'H0000000000000000;
   mosi_shift<= 64'H0000000000000000;
   sck_shift<= 64'H0000000000000000;
	sckb_shift<= 64'H0000000000000000;
   dout<= 54'b000000000000000000000000000000000000000000000000000000;	
   doutb<= 54'b000000000000000000000000000000000000000000000000000000;	
   end //

	
																				
	dff dff_gate_dly_1(.d(1'b0),.clk(mcd), .clrn(WRIN_I2C), .prn(!gate), .q(gate_dly_1));			//	stretches gate signal 
	dff dff_gate_dly_2(.d(gate1),.clk(mcd), .clrn(WRIN_I2C), .prn(!gate), .q(gate_dly_2));			// for 8 conv cycles to
	dff dff_gate_dly_3(.d(gate2),.clk(mcd), .clrn(WRIN_I2C), .prn(!gate), .q(gate_dly_3));			// pass the SCK pulses for
	dff dff_gate_dly_4(.d(gate3),.clk(mcd), .clrn(WRIN_I2C), .prn(!gate), .q(gate_dly_4));			//	distributed read 
	dff dff_gate_dly_5(.d(gate4),.clk(mcd), .clrn(WRIN_I2C), .prn(!gate), .q(gate_dly_5));			//
	dff dff_gate_dly_6(.d(gate5),.clk(mcd), .clrn(WRIN_I2C), .prn(!gate), .q(gate_dly_6));			//
	dff dff_gate_dly_7(.d(gate6),.clk(mcd), .clrn(WRIN_I2C), .prn(!gate), .q(gate_dly_7));			//
	
	dff dff_gateb_dly_1(.d(1'b0),.clk(mcd), .clrn(WRIN_I2C), .prn(!gateb), .q(gateb_dly_1));		//	stretches gateb signal 
	dff dff_gateb_dly_2(.d(gateb1),.clk(mcd), .clrn(WRIN_I2C), .prn(!gateb), .q(gateb_dly_2));	//
	dff dff_gateb_dly_3(.d(gateb2),.clk(mcd), .clrn(WRIN_I2C), .prn(!gateb), .q(gateb_dly_3));	//
	
	always @(AorB)begin
	if (AorB==0)begin
	gate_data_latch <= gateb3;
	end
	else begin
	gate_data_latch <= gate3;				//was gate7
	end
	end
	
	reg v3, v4, op2;
	always @(posedge mcd) begin								//on rising edge of DRDYL_33, op2 goes high for 1 mcd cycle
	v3 <= DRDYL_33;//10/01/15 was DRDYL_33
	v4 <= v3;
	op2 <= v3 & ~v4;
	end


	reg v1, v2, op;
	always @(posedge mcd) begin								//on rising edge of conv, op pulses high for 1 mcd cycle
	v1 <= conv;
	v2 <= v1;
	op <= v1 & ~v2;
	end
	dff dff_gate_enW(.d(1'b1), .clk( WRIN_I2C), .clrn(!op), .prn(1'b1), .q(gate_enW));
	dff dff_gate_enD(.d(1'b1), .clk(!DRDYL_33&~fast&~vari), .clrn(op ~^ rp), .prn(1'b1), .q(gate_enD)); //gate signal for normal operation
	dff dff_gate_enD1(.d(1'b1), .clk(!DRDYL_33 & fast&~vari), .clrn(gate_enD5 ~^ rp), .prn(1'b1), .q(gate_enD1));	//gate signal for normal operation and distributed read
	dff dff_gate_enDfv(.d(1'b1), .clk(gate_enV1 & fast&vari), .clrn(gate_enDfv6 ~^ rp), .prn(1'b1), .q(gate_enDfv)); // gate signal for variable filter and distributed read
	dff dff_gate_enD2(.d(gate_enD1), .clk(!BUSY), .clrn(gate_enD5 ~^ rp), .prn(1'b1), .q(gate_enD2)); // delays data latch
	dff dff_gate_enD3(.d(gate_enD2), .clk(!BUSY), .clrn(gate_enD5 ~^ rp), .prn(1'b1), .q(gate_enD3)); // signal up to 4
	dff dff_gate_enD4(.d(gate_enD3), .clk(!BUSY), .clrn(gate_enD5 ~^ rp), .prn(1'b1), .q(gate_enD4)); //conv cycles for
	dff dff_gate_enD5(.d(gate_enD4), .clk(!BUSY), .clrn(gate_enD5 ~^ rp), .prn(1'b1), .q(gate_enD5)); // distributed read
	dff dff_gate_enD6(.d(gate_enD5), .clk(!BUSY), .clrn(gate_enD5 ~^ rp), .prn(1'b1), .q(gate_enD6));
	dff dff_gate_enD7(.d(gate_enD6), .clk(!BUSY), .clrn(gate_enD5 ~^ rp), .prn(1'b1), .q(gate_enD7));
	dff dff_gate_enD8(.d(gate_enD7), .clk(!BUSY), .clrn(gate_enD5 ~^ rp), .prn(1'b1), .q(gate_enD8));
	dff dff_gate_enD9(.d(gate_enD8), .clk(!BUSY), .clrn(gate_enD5 ~^ rp), .prn(1'b1), .q(gate_enD9)); 
	
	dff dff_gate_enDfv2(.d(gate_enDfv), .clk(!BUSY), .clrn(gate_enDfv6 ~^ rp), .prn(1'b1), .q(gate_enDfv2));
	dff dff_gate_enDfv3(.d(gate_enDfv2), .clk(!BUSY), .clrn(gate_enDfv6 ~^ rp), .prn(1'b1), .q(gate_enDfv3));
	dff dff_gate_enDfv4(.d(gate_enDfv3), .clk(!BUSY), .clrn(gate_enDfv6 ~^ rp), .prn(1'b1), .q(gate_enDfv4));
	dff dff_gate_enDfv5(.d(gate_enDfv4), .clk(!BUSY), .clrn(gate_enDfv6 ~^ rp), .prn(1'b1), .q(gate_enDfv5));
	dff dff_gate_enDfv6(.d(gate_enDfv5), .clk(!BUSY), .clrn(gate_enDfv6 ~^ rp), .prn(1'b1), .q(gate_enDfv6));
	
	dff dff_gate_enb(.d(1'b1), .clk(!BUSY), .clrn(!op), .prn(1'b1), .q(gate_enb));	

	assign fast_gate= gate_enD1 | gate_enD2 | gate_enD3 | gate_enD4 | gate_enD10;
	assign fast_gateV = gate_enDfv | gate_enDfv2 | gate_enDfv3 | gate_enDfv4 | gate_enD10;
	
	always @ ( conv) begin
	if (conv==0)begin
	gate <=  (gate_enD&~vari&~fast)|(fast_gate &~vari & fast)| (gate_enV & vari &~fast)|(vari & fast & fast_gateV);		//gate =1 if DRDYL_33 goes low or conv_count hits 0 or WRIN_I2C goes high
	gateb <= gate_enb;											//gateb =1 on falling edge of BUSY if gate_enb=1
	end
	else begin
	gate <= 1'b0;
	gateb <= 1'b0;
	end
	
	end
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////	
always @(posedge master_clk or  negedge WRIN_I2C) 		//everything happens on pos edge of master clk or neg edge of WRIN_I2C or neg edge DRDYL_33
   if (WRIN_I2C==0)begin//
	clk_counter <= max_clk_cnt;			  					//if WRIN_I2C=0 reset clk_counter and strings
	data_latch_shift <= data_latch_def;						
	conv_shift <= conv_def;
	mosi_shift <= mosi_def;
	sck_shift <= sck_def;
	sckb_shift <= sckb_def;
	aux0_shift <= aux0_def;
	delay_shift <= delay_def;
	delay<=0;														//added 11/11/15
   end//
else begin/// if master_clk=1
      if 	(delay_shift[0]==1)begin	//// 										
	     if (delay<delay_time)begin	/////									 
		  delay <= delay +1'b1; 											
	     end	/////															
	   else begin/////		if delay >=delay_time											
		if(delay == delay_time) begin//////							
			clk_counter <= clk_counter-1'b1;							
			data_latch_shift <= data_latch_shift >> 1;				
		   conv_shift <= conv_shift >> 1 ;							
			mosi_shift <= mosi_shift >> 1;							
			sck_shift <= sck_shift >> 1;	
			sckb_shift <= sckb_shift >> 1;
			aux0_shift <= aux0_shift >> 1;							
			delay_shift <= delay_shift >> 1;						
		   delay <= 0;												
		end //////													
	end /////															
 end////																
else begin////			if delay_shift=0											
	if (clk_counter > 0) begin /////		  							
		clk_counter <= clk_counter - 1'b1;		  						
		data_latch_shift <= data_latch_shift >> 1;
		conv_shift <= conv_shift >> 1 ;
		mosi_shift <= mosi_shift >> 1;
		sck_shift <= sck_shift >> 1;
		sckb_shift <= sckb_shift >> 1;
		aux0_shift <= aux0_shift >> 1;
		delay_shift <= delay_shift >>1;	
		
	 end /////	
	 else begin ///// if clk_counter=0
		   clk_counter <= max_clk_cnt;			  			//if clk_counter=0 reset clk_counter 
			data_latch_shift <= data_latch_def;						
			conv_shift <= conv_def;
			mosi_shift <= mosi_def;
			sck_shift <= sck_def;
			sckb_shift <= sckb_def;
			aux0_shift <= aux0_def;
			delay_shift <= delay_def;												 			  
	end /////
end////           
end///		
													
always @(posedge sck) begin //								// sck is not inverted from master clk

			dout <= {dout[52:0],miso};							// latch data bit, place in proper location of dout
			
end //

always @(posedge sckb ) begin //								// sck is not inverted from master clk

			doutb <= {doutb[52:0],SDOB};						// latch data bit, place in proper location of dout
			
end //


endmodule