/*
Copyright (c) 2013, Linear Technology Corp.(LTC)
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of Linear Technology Corp.
*/
																						//DC2289A Verilog code for LTC2512
																						//1/29/16
																						//REV1
																						//GMH
`timescale 1ns / 1ps
module RevA
(
	CNVST_33,
	CLKIN,
	CLKOUT,
	SDOA,
	SCKA_33,
	RDLA,
	BUSY_33,
	DB0,
	DB1,
	DB2,
	DB3,
	DB4,
	DB5,
	DB6,
	DB7,
	DB8,
	DB9,
	DB10,
	DB11,
	DB12,
	DB13,
	DB14,
	DB15,
	DB16,
	DB17,
	DB18,
	DB19,
	DB20,
	DB21,
	DB22,
	DB23,
	DB24,
	DB25,
	DB26,
	DB27,
	DB28,
	DB29,
	DB30,
	DB31,
	SEL_32_40L,
	DC2026_DETECT,
	SCK_IN,
	SCK_OUT,
	WRIN_I2C,
	SDI_I2C,
	SCK_I2C,
	AUX0_I2C,
	AUX1_I2C,
	CS2_I2C,
	SDI2_I2C,
	SCK2_I2C,
	B32_40_I2C,
	DRDYL_33,
	SDI_33,
	RDLB,
	SDOB,
	SCKB_33,
	P0,
	P1,
	P2,
	P3,
	P4,
	P5,
	P6,
	P7,
	SYNC_33,
	PRE,
	MCLK,
	SEL0,
	SEL1
);
output		CNVST_33;
input       DC2026_DETECT;														// 1=DC890, 0=DC2026
input			SEL_32_40L;															// 1=24 bits, 0=32 bits jumper not used
input			CLKIN;
output		CLKOUT;
output		RDLA;
output		RDLB;
input			SDOA;
input			SDOB;
inout			SCKA_33;
inout			SCKB_33;
inout			SDI_33;
input       SCK_IN;
output      SCK_OUT;
input			BUSY_33;
input			DRDYL_33;
output			DB2;
output			DB3;
output			DB4;
output			DB5;
output			DB6;
output			DB7;
output			DB8;
output			DB9;
output			DB10;
output			DB14;
output			DB15;
output			DB16;
output			DB17;
output			DB0;
output			DB1;
output			DB11;
output			DB12;
output			DB13;
output         DB18;
output         DB19;
output			DB20;
output			DB21;
output			DB22;
output			DB23;
output			DB24;
output			DB25;
output			DB26;
output			DB27;
output			DB28;
output			DB29;
output			DB30;
output			DB31;
input				WRIN_I2C;
input				SDI_I2C;
input				SCK_I2C;
input				AUX0_I2C;
input				AUX1_I2C;
input				CS2_I2C;
input				SDI2_I2C;
input				SCK2_I2C;
input				B32_40_I2C;														// from sneaker_port 1=24bits, 0=32bits
output			P0;
output			P1;
output			P2;
output			P3;
output			P4;
output			P5;
output			P6;
output			P7;
inout         SYNC_33;
output			PRE;
input				MCLK;
output			SEL0;
output			SEL1;

assign PRE=1'b0; 																	//this is actually PREL bringing this pin high brings PRE on the LTC25XX low
parameter 	CLR = 1'b0,
				SET = 1'b1,
				ip = 1'b0;	
wire master_clk;
wire [53:0] dout;
wire [53:0] doutb;
wire AUXOUT;
wire [15:0] sneaker_port_out;
wire [15:0]	sneaker_port_out2;

wire mosi;
wire aux0;
wire conv;
wire data_latch;
wire master_clk_0 /* synthesis keep */;									// added to increase CNVSTL pulse to 20ns
wire master_clk_1 /* synthesis keep */;
wire master_clk_2 /* synthesis keep */;
wire master_clk_3 /* synthesis keep */;
wire master_clk_4 /* synthesis keep */;
wire master_clk_5 /* synthesis keep */;
wire master_clk_6 /* synthesis keep */;
wire master_clk_7 /* synthesis keep */;
wire master_clk_8 /* synthesis keep */;
wire master_clk_9 /* synthesis keep */;
wire master_out_0; //preserve
wire master_out_1; //preserve
wire master_out_2; //preserve
wire master_out_3; //preserve
wire master_out_4; //preserve
wire master_out_5; //preserve
wire master_out_6; //preserve
wire master_out_7; //preserve
wire master_out_8; //preserve
wire master_out_9; //preserve
wire master_clk_10 /* synthesis keep */;									// 
wire master_clk_11 /* synthesis keep */;
wire master_clk_12 /* synthesis keep */;
wire master_clk_13 /* synthesis keep */;
wire master_clk_14 /* synthesis keep */;
wire master_clk_15 /* synthesis keep */;
wire master_clk_16 /* synthesis keep */;
wire master_clk_17 /* synthesis keep */;
wire master_clk_18 /* synthesis keep */;
wire master_clk_19 /* synthesis keep */;
wire master_out_10; //preserve
wire master_out_11; //preserve
wire master_out_12; //preserve
wire master_out_13; //preserve
wire master_out_14; //preserve
wire master_out_15; //preserve
wire master_out_16; //preserve
wire master_out_17; //preserve
wire master_out_18; //preserve
wire master_out_19; //preserve
wire miso;
wire AorB;
wire sckb;
reg DB0;
reg DB1;
reg DB2;
reg DB3;
reg DB4;
reg DB5;														
reg DB6;
reg DB7;
reg DB8;
reg DB9;
reg DB10;
reg DB11;
reg DB12;
reg DB13;
reg DB14;
reg DB15;
reg DB16;
reg DB17;
reg DB18;
reg DB19;
reg DB20;
reg DB21;
reg DB22;
reg DB23;
reg DB24;
reg DB25;
reg DB26;
reg DB27;
reg DB28;
reg DB29;
reg DB30;
reg DB31;
wire P0;
wire P1;
wire P2;
wire P3;
wire P4;
wire P5;
wire P6;
wire P7;														
wire BUSY_33;
wire DRDYL_33;
wire CLKOUT;
wire clkout_latch;																//added 
wire MCLK;
wire gated_sck;
wire SCK_IN;
wire SCK_OUT;
wire sck;
wire B13;																			//not used
wire B14;
wire B15;
wire B16;
reg RDLA;
reg RDLB;
reg  d_latch_count;																//d_latch_count is for 40bit mode 0=DB31-DB0, 1=C7-C0 not used for 2512
wire CLK;
wire clken;
assign clken=1'b1;
wire vari;
wire		[15:0] sp_data2;
wire SEL0;
wire SEL1;
assign SEL0 = sneaker_port_out[10];
assign SEL1 = sneaker_port_out[9];
	assign sp_data2[0]=sneaker_port_out2[15];
	assign sp_data2[1]=sneaker_port_out2[14];
	assign sp_data2[2]=sneaker_port_out2[13];
	assign sp_data2[3]=sneaker_port_out2[12];
	assign sp_data2[4]=sneaker_port_out2[11];
	assign sp_data2[5]=sneaker_port_out2[10];
	assign sp_data2[6]=sneaker_port_out2[9];
	assign sp_data2[7]=sneaker_port_out2[8];
	assign sp_data2[8]=sneaker_port_out2[7];
	assign sp_data2[9]=sneaker_port_out2[6];
	assign sp_data2[10]=sneaker_port_out2[5];
	assign sp_data2[11]=sneaker_port_out2[4];
	assign sp_data2[12]=sneaker_port_out2[3];
	assign sp_data2[13]=sneaker_port_out2[2];
	assign sp_data2[14]=sneaker_port_out2[1];
	assign sp_data2[15]=sneaker_port_out2[0];
clkctrl1 cc1(.inclk(CLKIN),.ena(clken),.outclk(CLK));					//added 9/29/15

assign SCK_OUT = !SCK_IN;														//SCK_OUT is for debug only

																						//determines data output format; 32 or 40 bits, A or B output
																						//data is updated on rising edge of CLKOUT. User latches data on falling edge of CLKOUT
wire SYNC;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////							
	reg v1, v2, op;
	always @(posedge CLK) begin												//on rising edge of WRIN_I2C, op goes high for 1 CLK cycle
	v1 <= WRIN_I2C;
	v2 <= v1;
	op <= v1 & ~v2;
	end
	assign SYNC= op;
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////							
							
    always @(posedge data_latch )begin//	 								or AorB or B32_40_I2C or dout or doutb or d_latch_count								//latch data into PScope on the falling edge d_latch=CLKOUT
 
	   if (AorB==1) begin ///	 begin AorB=1								//A=1 SDOA, A=0 SDOB
			
	      if (B32_40_I2C==1) begin//// 										begin B32_40_I2C=1
					DB31 <= dout[23];
					DB30 <= dout[22];
					DB29 <= dout[21];
					DB28 <= dout[20];
					DB27 <= dout[19];
					DB26 <= dout[18];
					DB25 <= dout[17];
					DB24 <= dout[16];
					DB23 <= dout[15];
					DB22 <= dout[14];
					DB21 <= dout[13];
					DB20 <= dout[12];
				   DB19 <= dout[11];
				   DB18 <= dout[10];
					DB17 <= dout[9];
					DB16 <= dout[8];
					DB15 <= dout[7];
					DB14 <= dout[6];
					DB13 <= dout[5];
					DB12 <= dout[4];
					DB11 <= dout[3];
					DB10 <= dout[2];
					DB9 <= dout[1];
					DB8 <= dout[0];
					DB7 <= 0;
					DB6 <= 0;
					DB5 <= 0;
					DB4 <= 0;
					DB3 <= 0;
					DB2 <= 0;
					DB1 <= 0;
					DB0 <= 0;												// 24bit SDOA
		    end//// 				 end B32_40_I2C=1
			 else begin//// 		 begin B32_40_I2C=0
			 
			 
			 if (vari==1) begin 													//begin vari=1
			 
			 
			     case (d_latch_count)
			
			     1'b0: begin///// begin case=0
					DB31 <= dout[53];
					DB30 <= dout[52];
					DB29 <= dout[51];
					DB28 <= dout[50];
					DB27 <= dout[49];
					DB26 <= dout[48];
					DB25 <= dout[47];
					DB24 <= dout[46];
					DB23 <= dout[45];
					DB22 <= dout[44];
					DB21 <= dout[43];
					DB20 <= dout[42];
				   DB19 <= dout[41];
				   DB18 <= dout[40];
					DB17 <= dout[39];
					DB16 <= dout[38];
					DB15 <= dout[37];
					DB14 <= dout[36];
					DB13 <= dout[35];
					DB12 <= dout[34];
					DB11 <= dout[33];
					DB10 <= dout[32];
					DB9 <= dout[31];
					DB8 <= dout[30];
					DB7 <= dout[29];
					DB6 <= dout[28];
					DB5 <= dout[27];
					DB4 <= dout[26];
					DB3 <= dout[25];
					DB2 <= dout[24];
					DB1 <= dout[23];
					DB0 <= dout[22];												//data 54bit SDOA not used for 2512
					d_latch_count <=  1'b1;
		        end///// end case 0
		        1'b1: begin///// begin case=1
					DB31 <= dout[21];												//C7 Config starts here not used for 2512
					DB30 <= dout[20];												//C6
					DB29 <= dout[19];												//C5
					DB28 <= dout[18];												//C4
					DB27 <= dout[17];												//C3
					DB26 <= dout[16];												//C2
					DB25 <= dout[15];												//C1
					DB24 <= dout[14];												//C0
					DB23 <= dout[13];												//B13 OSR starts here
					DB22 <= dout[12];												//B12
					DB21 <= dout[11];												//B11
					DB20 <= dout[10];												//B10
				   DB19 <= dout[9];												//B9
				   DB18 <= dout[8];												//B8
					DB17 <= dout[7];												//B7
					DB16 <= dout[6];												//B6
					DB15 <= dout[5];												//B5
					DB14 <= dout[4];												//B4
					DB13 <= dout[3];												//B3
					DB12 <= dout[2];												//B2
					DB11 <= dout[1];												//B1
					DB10 <= dout[0];												//B0
					DB9 <= 1'b0;
					DB8 <= 1'b0;
					DB7 <= 1'b0;
					DB6 <= 1'b0;
					DB5 <= 1'b0;
					DB4 <= 1'b0;
					DB3 <= 1'b0;
					DB2 <= 1'b0;
					DB1 <= 1'b0;
					DB0 <= 1'b0;													// config and OSR info 54bit SDOA
					d_latch_count <= 1'b0;
			     end///// 			 end case 1
			     endcase 
			 
			 
			 end //end vari=1
			 else begin //			 begin vari=0
			 
			 
			 
			 
			 
			     case (d_latch_count)
			
			     1'b0: begin///// begin case=0
					DB31 <= dout[31];
					DB30 <= dout[30];
					DB29 <= dout[29];
					DB28 <= dout[28];
					DB27 <= dout[27];
					DB26 <= dout[26];
					DB25 <= dout[25];
					DB24 <= dout[24];
					DB23 <= dout[23];
					DB22 <= dout[22];
					DB21 <= dout[21];
					DB20 <= dout[20];
				   DB19 <= dout[19];
				   DB18 <= dout[18];
					DB17 <= dout[17];
					DB16 <= dout[16];
					DB15 <= dout[15];
					DB14 <= dout[14];
					DB13 <= dout[13];
					DB12 <= dout[12];
					DB11 <= dout[11];
					DB10 <= dout[10];
					DB9 <= dout[9];
					DB8 <= dout[8];
					DB7 <= dout[7];
					DB6 <= dout[6];
					DB5 <= dout[5];
					DB4 <= dout[4];
					DB3 <= dout[3];
					DB2 <= dout[2];
					DB1 <= dout[1];
					DB0 <= dout[0];												//data and config 32bit SDOA
					d_latch_count <=  1'b0;
		        end///// 			 end case 0
		        1'b1: begin///// begin case=1
					DB31 <= dout[7];
					DB30 <= dout[6];
					DB29 <= dout[5];
					DB28 <= dout[4];
					DB27 <= dout[3];
					DB26 <= dout[2];
					DB25 <= dout[1];
					DB24 <= dout[0];
					DB23 <= 1'b0;
					DB22 <= 1'b0;
					DB21 <= 1'b0;
					DB20 <= 1'b0;
				   DB19 <= 1'b0;
				   DB18 <= 1'b0;
					DB17 <= 1'b0;
					DB16 <= 1'b0;
					DB15 <= 1'b0;
					DB14 <= 1'b0;
					DB13 <= 1'b0;
					DB12 <= 1'b0;
					DB11 <= 1'b0;
					DB10 <= 1'b0;
					DB9 <= 1'b0;
					DB8 <= 1'b0;
					DB7 <= 1'b0;
					DB6 <= 1'b0;
					DB5 <= 1'b0;
					DB4 <= 1'b0;
					DB3 <= 1'b0;
					DB2 <= 1'b0;
					DB1 <= 1'b0;
					DB0 <= 1'b0;													// config info 40bit SDOA not used for 2512
					d_latch_count <= 1'b0;
			     end///// 			 end case 1
			     endcase
				  end  //			 end vari=0
				  
				  
				  
				  
			 end//// 				 end B32_40_I2C=0
			 
			 
			 
   end///							 end AorB=1
          else begin/// 		 begin AorB=0
					DB31 <= doutb[21];											//SDOB
					DB30 <= doutb[20];
					DB29 <= doutb[19];
					DB28 <= doutb[18];
					DB27 <= doutb[17];
					DB26 <= doutb[16];
					DB25 <= doutb[15];
					DB24 <= doutb[14];
					DB23 <= doutb[13];
					DB22 <= doutb[12];
					DB21 <= doutb[11];
					DB20 <= doutb[10];
				   DB19 <= doutb[9];
				   DB18 <= doutb[8];
					DB17 <= doutb[7];
					DB16 <= doutb[6];
					DB15 <= doutb[5];
					DB14 <= doutb[4];
					DB13 <= doutb[3];
					DB12 <= doutb[2];
					DB11 <= doutb[1];
					DB10 <= doutb[0];
					DB9 <= doutb[9];
					DB8 <= doutb[8];
					DB7 <= doutb[7];
					DB6 <= doutb[6];
					DB5 <= doutb[5];
					DB4 <= doutb[4];
					DB3 <= doutb[3];
					DB2 <= doutb[2];
					DB1 <= doutb[1];
					DB0 <= doutb[0];			
          end/// 					 end AorB=0
		
   end// 							 end posedge (data_latch)
 
	
assign master_clk = CLK;						  								
assign master_clk_0 = ~master_clk;
assign master_clk_1 = ~master_clk_0;
assign master_clk_2 = ~master_clk_1;
assign master_clk_3 = ~master_clk_2;
assign master_clk_4 = ~master_clk_3;
assign master_clk_5 = ~master_clk_4;
assign master_clk_6 = ~master_clk_5;
assign master_clk_7 = ~master_clk_6;
assign master_clk_8 = ~master_clk_7;
assign master_clk_9 = ~master_clk_8;

assign master_clk_10 = ~master_clk_9;
assign master_clk_11 = ~master_clk_10;
assign master_clk_12 = ~master_clk_11;
assign master_clk_13 = ~master_clk_12;
assign master_clk_14 = ~master_clk_13;
assign master_clk_15 = ~master_clk_14;
assign master_clk_16 = ~master_clk_15;
assign master_clk_17 = ~master_clk_16;
assign master_clk_18 = ~master_clk_17;
assign master_clk_19 = ~master_clk_18;

assign miso = SDOA;
assign CNVST_33 = ~conv ;	

always @(AorB or DC2026_DETECT or MCLK)	begin	//	

if (AorB == 1) begin///
if (DC2026_DETECT == 1)begin////
RDLA <= CLR;
RDLB <= SET;
end////
else begin////
RDLA <= CLR;
RDLB <= SET;
end////
end///

else begin///
if (DC2026_DETECT == 1)begin////
RDLA <= SET;
RDLB <= CLR;
end////
else begin////
RDLA <= MCLK;
RDLB <= SET;
end////
end///
end//
assign CLKOUT = data_latch;	
wire tp1;
wire tp2;
wire tp3;
wire tp4;
wire tp5;
wire [2:0]mode;

assign P0= mode[0];
assign P1= mode[1];
assign P2= mode[2];
assign P3= tp1;	
assign P4= tp2;	
assign P5= tp3;	
assign P6= tp4;	
assign P7= tp5;	
						

dff dff1(.d(1'b0), .clk(CLK), .clrn(1'b1), .prn(~data_latch), .q(clkout_latch));
dff dffmc0(.d(clkout_latch), .clk(master_clk_0), .clrn(1'b1), .prn(1'b1), .q(master_out_0));
dff dffmc1(.d(1'b0), .clk(master_clk_1), .clrn(1'b1), .prn(1'b1), .q(master_out_1));
dff dffmc2(.d(1'b0), .clk(master_clk_2), .clrn(1'b1), .prn(1'b1), .q(master_out_2));
dff dffmc3(.d(1'b0), .clk(master_clk_3), .clrn(1'b1), .prn(1'b1), .q(master_out_3));
dff dffmc4(.d(1'b0), .clk(master_clk_4), .clrn(1'b1), .prn(1'b1), .q(master_out_4));
dff dffmc5(.d(1'b0), .clk(master_clk_5), .clrn(1'b1), .prn(1'b1), .q(master_out_5));
dff dffmc6(.d(1'b0), .clk(master_clk_6), .clrn(1'b1), .prn(1'b1), .q(master_out_6));
dff dffmc7(.d(1'b0), .clk(master_clk_7), .clrn(1'b1), .prn(1'b1), .q(master_out_7));
dff dffmc8(.d(1'b0), .clk(master_clk_8), .clrn(1'b1), .prn(1'b1), .q(master_out_8));
dff dffmc9(.d(1'b0), .clk(master_clk_9), .clrn(1'b1), .prn(1'b1), .q(master_out_9));

dff dffmc10(.d(1'b0), .clk(master_clk_10), .clrn(1'b1), .prn(1'b1), .q(master_out_10));
dff dffmc11(.d(1'b0), .clk(master_clk_11), .clrn(1'b1), .prn(1'b1), .q(master_out_11));
dff dffmc12(.d(1'b0), .clk(master_clk_12), .clrn(1'b1), .prn(1'b1), .q(master_out_12));
dff dffmc13(.d(1'b0), .clk(master_clk_13), .clrn(1'b1), .prn(1'b1), .q(master_out_13));
dff dffmc14(.d(1'b0), .clk(master_clk_14), .clrn(1'b1), .prn(1'b1), .q(master_out_14));
dff dffmc15(.d(1'b0), .clk(master_clk_15), .clrn(1'b1), .prn(1'b1), .q(master_out_15));
dff dffmc16(.d(1'b0), .clk(master_clk_16), .clrn(1'b1), .prn(1'b1), .q(master_out_16));
dff dffmc17(.d(1'b0), .clk(master_clk_17), .clrn(1'b1), .prn(1'b1), .q(master_out_17));
dff dffmc18(.d(1'b0), .clk(master_clk_18), .clrn(1'b1), .prn(1'b1), .q(master_out_18));
dff dffmc19(.d(1'b0), .clk(master_clk_19), .clrn(1'b1), .prn(1'b1), .q(master_out_19));



										


										// takes care of serial to parallel of ADC
serial_io io_2(.master_clk_a	(master_clk_1),	   					//clk in from DCXXXX 020316 was master_clk_1
			.mosi	 	   			(mosi), 	   	   						//sdi to DUT 
			.miso	 	   			(miso), 	   	   						//sdoa from DUT	
			.data_latch				(data_latch), 								//when to grab data. updates on rising edge. PScope grabs on falling edge.
			.sck						(sck),		   							//scka to DUT 
			.conv	 	   			(conv),		   							//conv, inverted and fed to retiming circuit to generate DUT CONV
			.aux0	 	   			(aux0), 		   							//aux signal not used for all parts
			.dout	 	   			(dout),										//SDOA parallel data bits
			.mcd_a					(master_clk_0),							//delayed version of CLKIN 1/20/16 was master_clk_0
			.SEL_32_40L				(B32_40_I2C),								//select 24 or 32 bit format from sneaker_port 0=24bits, 1=32bits
			.sneaker_port_out 	(sneaker_port_out),						//data from sneaker_port
			.WRIN_I2C				(WRIN_I2C),									//WRIN_I2C=0 set Write sneakerport, WRIN_I2C=1 read ADC
			.DRDYL_33				(DRDYL_33),									//DRDYL_33 falling indicates data ready for SDOA and can configure ADC
			.SDOB						(SDOB),										//SDOB from DUT
			.sckb						(sckb),										//SCKB to DUT
			.AorB						(AorB),										//Choose A or B output, based on GUI from PScope 1=A, 0=B
			.doutb					(doutb),										//parallel data bits from SDOB
			.BUSY						(BUSY_33),									//falling edge of BUSY indicates SDOB ready
			.vari						(vari),										//variable OSR 1=yes, 0=no not used for 2512
			.tp1						(tp1),										//tp1-tp5 are test points from serial_io module
			.tp2						(tp2),
			.tp3						(tp3),
			.tp4						(tp4),
			.tp5						(tp5),
			.sneaker_port_out2	(sneaker_port_out2),						//sneaker_port_out2 contains variable OSR data for vari mode
			.mode						(mode)										//mode contains info on config of part 000=B, normal, no verify; 001=A, normal, no verify; 010=A, normal, no verify, DR; 011=A, vari OSR; 100=A, vari OSR, DR; 101=A, normal, verify; 110=A, normal, verify, DR 
			);
										//sneaker_port takes serial data from I2C port expander and makes it parallel
sneaker_port port1(.WRIN_I2C				(WRIN_I2C), 					//sneaker port update starts on falling edge of WRIN_I2C
					    .SDI_I2C				(SDI_I2C), 						//sneakerport serial data
					    .SCK_I2C				(SCK_I2C), 						//data clocked on rising edge of SCK_I2C
			          .sneaker_port_out	(sneaker_port_out)			//16-bit sneaker port data used to set divide ratio, AorB
						 );	
						 
										//sneaker_port takes serial data from I2C port expander and makes it parallel
sneaker_port port2(.WRIN_I2C				(CS2_I2C), 						//sneaker port update starts on falling edge of WRIN_I2C
					    .SDI_I2C				(SDI2_I2C), 					//sneakerport serial data
					    .SCK_I2C				(SCK2_I2C), 					//data clocked on rising edge of SCK_I2C
			          .sneaker_port_out	(sneaker_port_out2)			//16-bit sneaker port data not used for LTC2512
						 );	
						 
										//bidirio module used to create bidirectional IO port
bidirio d_bit_13(
		 .dout 	(B13),   														//   	dout.export
		 .din		(sck),    														//    din.export
		 .pad_io	(SCKA_33), 														// 	pad_io.export
		 .oe 		(DC2026_DETECT)     											//    oe.export
	);
						
bidirio d_bit_14(
		 .dout 	(B14),   														//   	dout.export
		 .din		(1'b0),    														//    din.export
		 .pad_io	(SDI_33), 														// 	pad_io.export
		 .oe 		(DC2026_DETECT)     											//    oe.export
	);
	
bidirio d_bit_15(
		 .dout 	(B15),   														//   	dout.export
		 .din		(sckb),    														//    din.export
		 .pad_io	(SCKB_33), 														// 	pad_io.export
		 .oe 		(DC2026_DETECT)     											//    oe.export
	);
 
bidirio d_bit_16(
		 .dout 	(B16),   														//   	dout.export
		 .din		(SYNC),    														//    din.export
		 .pad_io	(SYNC_33), 														// 	pad_io.export
		 .oe 		(DC2026_DETECT)     											//    oe.export
	);
endmodule
