/*
Copyright (c) 2013, Linear Technology Corp.(LTC)
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of Linear Technology Corp.
*/
//DC1925A Verilog code for LTC2378_20
//06/11/12
//REV1
//GMH
`timescale 1ns / 1ps
module RevA
(
	CNVST_33,
	CLK,
	CLKOUT,
	SDO,
	SCK_33,
	RD,
	BUSY_33,
	DB2,
	DB3,
	DB4,
	DB5,
	DB6,
	DB7,
	DB8,
	DB9,
	DB10,
	DB14,
	DB15,
	DB16,
	DB17,
	DB18,
	DB19,
	DB0,
	DB1,
	DB11,
	DB12,
	DB13,
	DC590_DETECT,
	SCK_IN,
	SCK_OUT
);
output			CNVST_33;
input           DC590_DETECT;
input			CLK;
output			CLKOUT;
output			RD;
input			SDO;
output			SCK_33;
input       SCK_IN;
output      SCK_OUT;
input			BUSY_33;
output			DB2;
output			DB3;
output			DB4;
output			DB5;
output			DB6;
output			DB7;
output			DB8;
output			DB9;
output			DB10;
output			DB14;
output			DB15;
output			DB16;
output			DB17;
output			DB0;
output			DB1;
output			DB11;
output			DB12;
output			DB13;
output         DB18;
output         DB19;
parameter 	CLR = 1'b0,
			SET = 1'b1,
			op = 1'b1,
			ip = 1'b0;	
wire master_clk;
wire [19:0] dout;
wire mosi;
wire aux0;
wire conv;
wire data_latch;
wire master_clk_0 /* synthesis keep */;											// added 02/25/09 to increase CNVSTL pulse to 20ns
wire master_clk_1 /* synthesis keep */;
wire master_clk_2 /* synthesis keep */;
wire master_clk_3 /* synthesis keep */;
wire master_clk_4 /* synthesis keep */;
wire master_clk_5 /* synthesis keep */;
wire master_clk_6 /* synthesis keep */;
wire master_clk_7 /* synthesis keep */;
wire master_clk_8 /* synthesis keep */;
wire master_clk_9 /* synthesis keep */;
wire master_out_0; //preserve
wire master_out_1; //preserve
wire master_out_2; //preserve
wire master_out_3; //preserve
wire master_out_4; //preserve
wire master_out_5; //preserve
wire master_out_6; //preserve
wire master_out_7; //preserve
wire master_out_8; //preserve
wire master_out_9; //preserve
wire master_clk_10 /* synthesis keep */;										// added 02/25/09
wire master_clk_11 /* synthesis keep */;
wire master_clk_12 /* synthesis keep */;
wire master_clk_13 /* synthesis keep */;
wire master_clk_14 /* synthesis keep */;
wire master_clk_15 /* synthesis keep */;
wire master_clk_16 /* synthesis keep */;
wire master_clk_17 /* synthesis keep */;
wire master_clk_18 /* synthesis keep */;
wire master_clk_19 /* synthesis keep */;
wire master_out_10; //preserve
wire master_out_11; //preserve
wire master_out_12; //preserve
wire master_out_13; //preserve
wire master_out_14; //preserve
wire master_out_15; //preserve
wire master_out_16; //preserve
wire master_out_17; //preserve
wire master_out_18; //preserve
wire master_out_19; //preserve
wire miso;
reg DB0;
reg DB1;
reg DB2;
reg DB3;
reg DB4;
reg DB5;														
reg DB6;
reg DB7;
reg DB8;
reg DB9;
reg DB10;
reg DB11;
reg DB12;
reg DB13;
reg DB14;
reg DB15;
reg DB16;
reg DB17;
reg DB18;
reg DB19;														
wire BUSY_33;
wire CLKOUT;
reg clkdiv2;
wire clkout_latch;																	//added 12/10/08
wire d_latch;
wire SCK_IN;
wire SCK_OUT;
wire numbits;
wire sck;
wire B13;
assign SCK_OUT = SCK_IN;
    always @(negedge d_latch )begin//	 										//07/06/12 was (posedge d_latch)      					    														
				   DB19 <= dout[19];
				   DB18 <= dout[18];
					DB17 <= dout[17];
					DB16 <= dout[16];
					DB15 <= dout[15];
					DB14 <= dout[14];
					DB13 <= dout[13];
					DB12 <= dout[12];
					DB11 <= dout[11];
					DB10 <= dout[10];
					DB9 <= dout[9];
					DB8 <= dout[8];
					DB7 <= dout[7];
					DB6 <= dout[6];
					DB5 <= dout[5];
					DB4 <= dout[4];
					DB3 <= dout[3];
					DB2 <= dout[2];
					DB1 <= dout[1];
					DB0 <= dout[0];														// 20bit
				
    end//

   
assign master_clk = CLK;						  								//02/24/09 was CLK   sck  output on serial_clk_out
assign master_clk_0 = ~master_clk;
assign master_clk_1 = ~master_clk_0;
assign master_clk_2 = ~master_clk_1;
assign master_clk_3 = ~master_clk_2;
assign master_clk_4 = ~master_clk_3;
assign master_clk_5 = ~master_clk_4;
assign master_clk_6 = ~master_clk_5;
assign master_clk_7 = ~master_clk_6;
assign master_clk_8 = ~master_clk_7;
assign master_clk_9 = ~master_clk_8;

assign master_clk_10 = ~master_clk_9;
assign master_clk_11 = ~master_clk_10;
assign master_clk_12 = ~master_clk_11;
assign master_clk_13 = ~master_clk_12;
assign master_clk_14 = ~master_clk_13;
assign master_clk_15 = ~master_clk_14;
assign master_clk_16 = ~master_clk_15;
assign master_clk_17 = ~master_clk_16;
assign master_clk_18 = ~master_clk_17;
assign master_clk_19 = ~master_clk_18;

assign miso = SDO;
assign CNVST_33 = ~conv ;					
assign RD = CLR ;
assign d_latch = data_latch ;

assign CLKOUT =  d_latch ;											// was ~conv

dff dff1(.d(0), .clk(CLK), .clrn(1), .prn(~data_latch), .q(clkout_latch));
dff dffmc0(.d(0), .clk(master_clk_0), .clrn(1), .prn(1), .q(master_out_0));
dff dffmc1(.d(0), .clk(master_clk_1), .clrn(1), .prn(1), .q(master_out_1));
dff dffmc2(.d(0), .clk(master_clk_2), .clrn(1), .prn(1), .q(master_out_2));
dff dffmc3(.d(0), .clk(master_clk_3), .clrn(1), .prn(1), .q(master_out_3));
dff dffmc4(.d(0), .clk(master_clk_4), .clrn(1), .prn(1), .q(master_out_4));
dff dffmc5(.d(0), .clk(master_clk_5), .clrn(1), .prn(1), .q(master_out_5));
dff dffmc6(.d(0), .clk(master_clk_6), .clrn(1), .prn(1), .q(master_out_6));
dff dffmc7(.d(0), .clk(master_clk_7), .clrn(1), .prn(1), .q(master_out_7));
dff dffmc8(.d(0), .clk(master_clk_8), .clrn(1), .prn(1), .q(master_out_8));
dff dffmc9(.d(0), .clk(master_clk_9), .clrn(1), .prn(1), .q(master_out_9));

dff dffmc10(.d(0), .clk(master_clk_10), .clrn(1), .prn(1), .q(master_out_10));
dff dffmc11(.d(0), .clk(master_clk_11), .clrn(1), .prn(1), .q(master_out_11));
dff dffmc12(.d(0), .clk(master_clk_12), .clrn(1), .prn(1), .q(master_out_12));
dff dffmc13(.d(0), .clk(master_clk_13), .clrn(1), .prn(1), .q(master_out_13));
dff dffmc14(.d(0), .clk(master_clk_14), .clrn(1), .prn(1), .q(master_out_14));
dff dffmc15(.d(0), .clk(master_clk_15), .clrn(1), .prn(1), .q(master_out_15));
dff dffmc16(.d(0), .clk(master_clk_16), .clrn(1), .prn(1), .q(master_out_16));
dff dffmc17(.d(0), .clk(master_clk_17), .clrn(1), .prn(1), .q(master_out_17));
dff dffmc18(.d(0), .clk(master_clk_18), .clrn(1), .prn(1), .q(master_out_18));
dff dffmc19(.d(0), .clk(master_clk_19), .clrn(1), .prn(1), .q(master_out_19));
									
serial_io io_2(.master_clk	(master_clk),	   					//clk in from DCXXXX
			.mosi	 	   	(mosi), 	   	   						//sdi to DUT not used for all parts
			.miso	 	   	(miso), 	   	   						//sdo from DUT	
			.data_latch		(data_latch), 								//when to grab data
			.sck		 		(sck),		   							//sck to DUT 
			.conv	 	   	(conv),		   							//conv or conv_gate to DUT
			.aux0	 	   	(aux0), 		   							//aux signal not used for all parts
			.dout	 	   	(dout),										//parallel data bits
			.mcd				(master_clk_2)							// was master_clk_15
			);

 maxii_io
 d_bit_13(.datain  (sck),												//serial_clk_out
         .oe  (DC590_DETECT),											//DC590_DETECT=1 SCK_33=sck, DC_590DETECT=0 SCK_33=HiZ
         .padio  (SCK_33),									
         .combout (B13));												//
 defparam d_bit_13.operation_mode = "bidir";
 

endmodule
