/*
Copyright (c) 2013, Linear Technology Corp.(LTC)
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of Linear Technology Corp.
*/
//`timescale 1ns / 1ps
//module 'serial_io' generates patterns for SPI signals, reads serial LTC2378_20 data and converts it to parallel using Altera MAXII
//GMH
//June 11, 2012  RevA
module serial_io(master_clk, 
								mosi, 
								miso, 
								data_latch, 
								sck, 
								conv, 
								aux0, 
								dout, 
								mcd);
								
   input master_clk;	   									// external clock in
   input mcd;    												// mcd is a delayed version of master_clk
	input miso;													// sdo to cpld (serial data from ADC)
	
   output mosi;			  									// sdi to adc (some parts may not use this line)
   output data_latch;										// latches data into cpld   (active high)
   output sck;													// gated version of external clock in
   output conv;												// convert or CS to ADC
   output aux0;  												// aux output   
   output 	[19:0] dout;									// 18-bit deserialized data from ADC
	
   reg 		[23:0] aux0_shift;
   reg 		[23:0] conv_shift;
   reg 		[23:0] data_latch_shift;
   reg 		[23:0] delay_shift;												
   reg 		[23:0] mosi_shift;
   reg 		[23:0] sck_shift;
   reg 		[19:0] dout;	  					
   reg 		[7:0] delay;
   reg 		[6:0] clk_counter;
	
   wire 		aux0;		 
   wire 		data_latch;
   wire 		master_clk;
   wire 		mcd;
   wire 		miso;
   wire 		mosi;
   wire 		sck;
	wire 		[23:0]miso_def;
	wire 		[23:0]mosi_def;
	wire 		[23:0]data_latch_def;
	wire 		[23:0]sck_def;
	wire 		[23:0]conv_def;
	wire 		[23:0]aux0_def;
	wire 		[23:0]delay_def;
	wire		[7:0] delay_time;
   wire		[6:0] max_clk_cnt;
	
//	always @( master_clk )begin
																	//   counts per delay	max clk count 		# of channels 	# of bits 
																	//   b16-b23(max 255)	b9-b15(max 127)	b5-b8(max 16)	b0-b4 (max 32)
																	//				58							23			    1		  		   20	   
 assign         miso_def = 24'H392C33;    					//  0011 1001			0010 	110			0 001 	   1 0011   	                               												      
  assign        mosi_def = 24'H000000;    					//  0000 0000 0000 0000 0000 0000        	                               
 assign   data_latch_def = 24'H200000;    					//  0010 0000 0000 0000 0000 0000	   	           	                               
 assign          sck_def = 24'H3FFFFC;    					//  0011 1111 1111 1111 1111 1100    	    	                               
 assign         conv_def = 24'HFFFFFC;    					//  1111 1111 1111 1111 1111 1100 	   	    	          	                           
  assign        aux0_def = 24'H000001;						   //  0000 0000 0000 0000 0000 0001
 assign        delay_def = 24'H000002;      					//  0000 0000 0000 0000 0000 0010 	    
//	end  
	
	assign max_clk_cnt =  miso_def[15:9];				// maximum count before clk_counter is reset	(max 127)     
	assign delay_time =  miso_def[23:16];				// number of master_clks to wait if delay goes high (max 255)
	assign data_latch = data_latch_shift[0];			//	7/6/12 was data_latch_shift[0]&!sck								   						
	assign mosi = mosi_shift[0];						
	assign aux0 = aux0_shift[0];
	assign sck = (sck_shift[0]& mcd);					//was master_clk		
	wire 	 conv;
	assign conv = !(conv_shift[0]);
	
   initial begin //
   delay <= 0;															
   clk_counter <= 7'b0000000;								// initialize counter loop   
   aux0_shift<= 24'H000000;
   conv_shift<= 24'H000000;
   data_latch_shift<= 24'H000000;
   delay_shift<= 24'H000000;
   mosi_shift<= 24'H000000;
   sck_shift<= 24'H000000;
   dout<= 20'b00000000000000000000;		    							      
   end //
 
always @(posedge master_clk)								// everything happens on neg edge of master clk
if 	(delay_shift[0]==1)begin	// 										
	if (delay<delay_time)begin	///									
		delay <= delay +1; 											
	end	///															
	else begin///													
		if(delay == delay_time) begin////							
			clk_counter <= clk_counter-1;							
			data_latch_shift <= data_latch_shift >> 1;				
		   conv_shift <= conv_shift >> 1 ;							
			mosi_shift <= mosi_shift >> 1;							
			sck_shift <= sck_shift >> 1;							
			aux0_shift <= aux0_shift >> 1;							
			delay_shift <= delay_shift >> 1;						
		   delay <= 0;												
		end ////													
	end ///															
end//																
else begin//														
	if (clk_counter > 0) begin ///		  							
		clk_counter <= clk_counter - 1;		  						
		data_latch_shift <= data_latch_shift >> 1;
		conv_shift <= conv_shift >> 1 ;
		mosi_shift <= mosi_shift >> 1;
		sck_shift <= sck_shift >> 1;
		aux0_shift <= aux0_shift >> 1;
		delay_shift <= delay_shift >>1;													
	 end ///	
	 else begin ///
		   clk_counter <= max_clk_cnt;			  		//if clk_counter=0 reset clk_counter 
			data_latch_shift <= data_latch_def;						
			conv_shift <= conv_def;
			mosi_shift <= mosi_def;
			sck_shift <= sck_def;
			aux0_shift <= aux0_def;
			delay_shift <= delay_def;												 			  
	end ///
end//																
always @(posedge sck) begin //							// sck is not inverted from master clk
			dout <= {dout[18:0],miso};						// latch data bit, place in proper location of dout
end //
endmodule