/*
Copyright (c) 2013, Linear Technology Corp.(LTC)
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of Linear Technology Corp.
*/
//GMH
//LTC2314 serial to parallel conversion using Altera MAXII or MAXV
//10/07/11
//14-bit
//My Documents/80/quartus/LTC2321/RevA.v
`timescale 1ps / 1ps
module RevA
(
	CNVST_33,
	CLK,
	CLKOUT,
	DB2,
	DB3,
	DB4,
	DB5,
	DB6,
	DB7,
	DB8,
	DB9,
	DB10,
	DB0,
	DB1,
	DB11,
	DB12,
	DB13,
	SDO,
	DC590_DETECT,
	B12_14L,
	sck);
output			CNVST_33;
input			   CLK;
input          SDO;
input          DC590_DETECT;
input				B12_14L;					//1=12-bit, 0=14-bit
output			CLKOUT;
output			DB2;						
output			DB3;
output			DB4;
output			DB5;
output			DB6;
output			DB7;
output			DB8;
output			DB9;
output			DB10;
output			DB0;
output			DB1;
output			DB11;
output			DB12;
output         DB13;
output         sck;
parameter 	   CLR = 1'b0,
			      SET = 1'b1,
			      op = 1'b1,
			      ip = 1'b0;	
wire master_clk;
wire [13:0] dout;																		

wire aux0;
wire conv;
wire sck;
wire data_latch;
wire data_latchl /* synthesis keep */;											
wire data_latcha /* synthesis keep */;											
wire miso;
reg DB0;
reg DB1;
reg DB2;
reg DB3;
reg DB4;
reg DB5;														
reg DB6;
reg DB7;
reg DB8;
reg DB9;
reg DB10;
reg DB11;
wire CLKOUT;
//wire d_latch;
wire sck_int;
wire CNVST_33_int;
wire B12_14L;
wire numbits;

    always @(posedge data_latch )begin//	 									//03/26/12 was (posedge data_latch)
					DB13 <= dout[13];													//DB13 and DB12 added 10/03/11
					DB12 <= dout[12];
					DB11 <= dout[11];													
					DB10 <= dout[10];
					DB9 <= dout[9];
					DB8 <= dout[8];
					DB7 <= dout[7];
					DB6 <= dout[6];
					DB5 <= dout[5];
					DB4 <= dout[4];
					DB3 <= dout[3];
					DB2 <= dout[2];
					DB1 <= dout[1];
					DB0 <= dout[0];													
    end//
  
assign master_clk = CLK;						  								
assign miso = SDO;
assign CNVST_33 =  conv;															
//assign d_latch =  data_latch;										
assign data_latcha = ~data_latchl;												
assign data_latchl = ~data_latch;												//data_latch is delayed to match dout
assign CLKOUT = data_latch;
assign numbits = B12_14L;														
									
serial_io io_2(.master_clk	(master_clk),	   								//clk in from DC1563
		
			.miso	 	   	(miso), 	   	   									//sdo from DUT	
			.data_latch		(data_latch), 											//when to grab data
			.sck		 	   (sck_int),		   									//sck to DUT 
			.conv	 	   	(conv),		   										//conv or conv_gate to DUT
			.aux0	 	   	(aux0), 		   										//aux signal not used for all parts
			.dout	 	   	(dout),													//parallel data bits
			.numbits			(numbits)												//number of bits 1=12, 0=14
			);
						
alt_outbuf_tri my_outbuf_tri (.i(sck_int), .oe(DC590_DETECT),.o(sck));

endmodule
