/*
Copyright (c) 2013, Linear Technology Corp.(LTC)
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of Linear Technology Corp.
*/
`timescale 1ps / 1ps
//module 'serial_io' generates patterns for SPI signals, reads serial ADC data and converts serial data to parallel for Altera MAXII or MAXV
//GMH
//January 13, 2012  RevA LTC2314 external conversion clock
//12/14-bit
//My Documents/80/quartus/LTC2314_14/RevA/serial_io2394.v
//
module serial_io(master_clk, miso, data_latch, sck, conv, aux0, dout, numbits);	 
   input master_clk;	   												// external clock in    										

   input miso;															   // sdo to cpld (serial data from ADC)
   output data_latch;													// latches data into cpld   (active high)
   output sck;															   // gated version of external clock in
   output conv;															// convert or CS to ADC
   output aux0;  														   // aux output not normally used   
   output [13:0] dout;													// 14-bit deserialized data from ADC
	input numbits;															// number of bits 1=12bits, 0=14bits
   reg [19:0]aux0_shift;
   reg [19:0]conv_shift;
   reg [19:0]data_latch_shift;
   reg [19:0]delay_shift;												
 
   reg [19:0]sck_shift;
   reg [13:0] dout;														  					
   reg [7:0] delay;
   reg [6:0] clk_counter;
   wire[7:0] delay_time;
   wire[6:0] max_clk_cnt;
   wire aux0;		 
   wire data_latch;
   wire master_clk;
   wire miso;
	wire numbits;
   wire conv;
   wire sck;
	wire master_clk_d1 /* synthesis keep */;
	wire master_clk_d2 /* synthesis keep */;
	wire master_clk_d3 /* synthesis keep */;
	wire master_clk_d4 /* synthesis keep */;
	wire master_clk_d5 /* synthesis keep */;
	wire master_clk_d6 /* synthesis keep */;
	wire master_clk_d7 /* synthesis keep */;
	wire master_clk_d8 /* synthesis keep */;
	assign master_clk_d1 = !master_clk;
	assign master_clk_d2 = !master_clk_d1;
	assign master_clk_d3 = !master_clk_d2;
	assign master_clk_d4 = !master_clk_d3;
	assign master_clk_d5 = !master_clk_d4;
	assign master_clk_d6 = !master_clk_d5;
	assign master_clk_d7 = !master_clk_d6;
	assign master_clk_d8 = !master_clk_d7;
																					//  numbits=1 12-bits
																					//  up to 4 16bit channels in 64bits. Increase to 144 to do 8 channels of 18bits
																					//  number of counts per delay, max clk count, number of channels, number of bits 
																					//   b16-b23(max 255)	   		b9-b15(max 127)  b5-b8(max 16)     b0-b4 (max 32)
																					//						00				 		18			   		    1		  		12	   
   parameter       miso_def =24'H00222B;    							// 0000 0000		   					0010 001		  		0 001 		 0 1011  	                               												      
   	                               
   parameter data_latch_def= 20'H08000;    							//  0000 1000 0000 0000 0000	   	           	                               
   parameter       sck_def = 20'H3FFFF;    							//  0011 1111 1111 1111 1111	   	    	                               
   parameter      conv_def = 20'H0FFFE;    							//  0000 1111 1111 1111 1110 	   	    	          	                           
   parameter       aux0_def =20'H00001;								//  0000 0000 0000 0000 0001
   parameter      delay_def =20'H00000;      		            //  0000 0000 0000 0000 0000



																					//  numbits=0 14-bits
																					//  up to 4 16bit channels in 64bits. Increase to 144 to do 8 channels of 18bits
																					//  number of counts per delay, max clk count, number of channels, number of bits 
																					//   b16-b23(max 255)	   		b9-b15(max 127)  b5-b8(max 16)     b0-b4 (max 32)
																					//						00				 		20			   			1				12	   
   parameter       miso_def14 =24'H00262B;  							// 0000 0000		   					0010 011		 		0 001 		  0 1011   	                               												      
           	                               
   parameter data_latch_def14= 20'H20000;  							//  0010 0000 0000 0000 0000	    	          	                               
   parameter       sck_def14 = 20'HFFFFF;  							//  1111 1111 1111 1111 1111	    	         	                               
   parameter      conv_def14 = 20'H3FFFE;  							//  0011 1111 1111 1111 1110 	   	 	          	                           
   parameter       aux0_def14 =20'H00001;	   						//  0000 0000 0000 0000 0001
   parameter      delay_def14 =20'H00000;       		         //  0000 0000 0000 0000 0000                      
 
	// decide if 12-bit or 14-bit
	assign max_clk_cnt = (numbits) ? miso_def[15:9] : miso_def14[15:9];	// maximum count before clk_counter is reset	(max 127)   
	assign num_bits = (numbits) ? miso_def[4:0] : miso_def14[4:0];			// number of bits	(max 32)  
	assign num_channels = (numbits) ? miso_def[8:5] : miso_def14[8:5];	// number of channels (max 16)	  
	assign delay_time = (numbits) ? miso_def[23:16] : miso_def14[23:16];	// number of master_clks to wait if delay goes high (max 255)
	
	

	assign data_latch = data_latch_shift[0] ;							// 03/28/12 was data_latch_shift[0] & sck;							   						
	assign aux0 = aux0_shift[0];
	assign sck = (sck_shift[0]& master_clk_d1);						// adjust phase between sck and master_clk	was !(sck_shift[0]&!master_clk)					
	assign conv = ~(conv_shift[0]);							      	// 10/07/11 was conv = ~(conv_shift[0]);
   	

   initial begin //
   delay <= 0;														
   clk_counter <= 7'b0000000;										   
   aux0_shift<= 20'H00000;
   conv_shift<= 20'H00000;
   data_latch_shift<= 20'H00000;
   delay_shift<= 20'H00000;
   
   sck_shift<= 20'H00000;
	
	// data_latch_shift = (numbits) ? data_latch_def : data_latch_def14;
	// aux0_shift = (numbits) ? aux0_def : aux0_def14;
	// sck_shift = (numbits) ? sck_def : sck_def14;
	// conv_shift = (numbits) ? conv_def : conv_def14;
	// delay_shift = (numbits) ? delay_def : delay_def14;
	
   dout<= 14'b00000000000000;		    							      
   end //
 
always @(negedge master_clk)												//1/12/12 was posedge everything happens on neg edge 
if (delay_shift[0]==1)begin	// 										
	if (delay<delay_time)begin	///										
		delay <= delay +1; 													
	end	///																	
	else begin///																
		if(delay == delay_time) begin////								
			clk_counter <= clk_counter-1;									
			data_latch_shift <= data_latch_shift >> 1;				
		   	conv_shift <= conv_shift >> 1 ;							

			sck_shift <= sck_shift >> 1;									
			aux0_shift <= aux0_shift >> 1;								
			delay_shift <= delay_shift >> 1;								
		    delay <= 0;														
		end ////																	
	end ///																		
end//																				
else begin//																	
	if (clk_counter > 0) begin ///		  							//if no delay or after delay, decrement clk_counter
			clk_counter <= clk_counter - 1;		  					//shift registers 1 bit
			data_latch_shift <= data_latch_shift >> 1;
			conv_shift <= conv_shift >> 1 ;

			sck_shift <= sck_shift >> 1;
			aux0_shift <= aux0_shift >> 1;
			delay_shift <= delay_shift >>1;													
	 end ///	
	 else begin ///
		    clk_counter <= max_clk_cnt;			  					//if clk_counter=0 reset clk_counter 
			
if (numbits==1) begin ////
			data_latch_shift <= data_latch_def;						
			conv_shift <= conv_def;
			
			sck_shift <= sck_def;
			aux0_shift <= aux0_def;
			delay_shift <= delay_def;											
		end	////	 			  
		else begin ////
			data_latch_shift <= data_latch_def14;					
			conv_shift <= conv_def14;
			
			sck_shift <= sck_def14;
			aux0_shift <= aux0_def14;
			delay_shift <= delay_def14;											
		end	 ////

			
	end ///
end//																
always @(negedge sck) begin //										
	dout <= {dout[12:0],miso};								    		//latch data bit, place in proper location of dout
end //
endmodule