/*********************************************************************

 Author        : Johnson Jiao            Johnson.Jiao@analog.com

 Date          : 1st April. 2008

 File          : XIRQ0_LED.c

 Hardware      : Applicable to ADuC702x rev H or I silicon
                 Currently targetting ADuC7026.

 Description   : Complement port 3 in a loop.
				 When XIRQ0 is pressed, complement P4.2	
				 It is used as application programm in IAP demo.

			    Two method to use RAM interrupt vector table:
				(1) use Build_INT_Vector_Table() function as depicted as below
			   (2) Project-->Options for Target 'IRQ0_LED'-->ASM
			    -->Conditional assembly control Symbols: Set RAM_INTVEC micro
												 
*********************************************************************/

#include <ADuC7026.h>					// 	Include ADuC7026 Header File

void IRQ_Handler(void) __irq;			//	IRQ Funtion Prototype 

void Build_INT_Vector_Table(void);                    

void main (void)  {

	IRQEN = XIRQ0_BIT;					//	Enable XIRQ0 in IRQEnable 
	GP4DAT = 0x04000000;				//	Configure P4.2 as output
	Build_INT_Vector_Table();
	REMAP = 0x01;                  	    //  Interrupt vector table in SRAM
	while(1)
	{
	}
                   
}

/********************************************************************/
/*                                                                  */
/*		Interrupt Service Rountine									*/
/*                                                                  */
/********************************************************************/

void IRQ_Handler() __irq
{
	GP4DAT ^= 0x00040000;				// Complement P4.2
	while(GP0DAT & 0x00010){}			// wait for XIRQ to be low again
	return ;
}

void Build_INT_Vector_Table()
{
	volatile unsigned long *Des_VEC, *SOU_VEC;
	int i;
  // Interrupt Vector Table in SRAM
	Des_VEC	= (unsigned long * )0x10000;
  // Interrupt Vector Table in Flash, please refer to Startup.s
  //     AREA   STARTUPCODE, CODE, AT 0x00081000
	SOU_VEC	= (unsigned long * )0x81000;

  // Copy the interrupt Vector Table from Flash to SRAM
  // for 16 instructions
	for (i = 0; i < 16; i++)
	{
		*Des_VEC = *SOU_VEC;
		*Des_VEC++;
		*SOU_VEC++;
	}
}
                    


