/***********************************************************************


 Author        : Johnson Jiao            Johnson.Jiao@analog.com

 Date          : 1st April. 2008

 File          : main.c

 Hardware      : Applicable to ADuC702x rev H or I silicon
                 Currently targetting ADuC7026.

 Description   : some function about UART

************************************************************************/
#include <ADuC7026.H>
#include "Flash.h"
#include "IRQ_FIQ.h"
#include "UART.h"
#include "main.h"

void InitUART(void);				// Baudrate of 115200
char hex2ascii(char toconv);        // HEX to ASCII
char ascii2hex(char toconv);		// ASCII to HEX
void senddata(char to_send);	    // send out one CHAR


void InitUART()
{
	// Setup tx & rx pins on SPM 0 and SPM 1
	GP1CON |= 0x011;
     // Start setting up UART at 115200bps:   41.78M/(32*DL*(M+N/2048))
   	COMCON0 = 0x080;			// Setting DLAB
   	COMDIV0 = 0x08;			// Set 8 to DL
   	COMDIV1 = 0x00;		    
	COMDIV2 = 0x8B55;       // Set 1 to M, Set 853 to N
   	COMCON0 = 0x007;			// Clearing DLAB
	COMIEN0 = 0x003;            // Enable RX and TX interrupt
}

char hex2ascii(char toconv) __ram
{
	if (toconv<0x0A) 
	{
		toconv += 0x30;
	}
	else 
	{
		toconv += 0x37;
	}	
	return (toconv);
}

char ascii2hex(char toconv) __ram
{
	if (toconv < 0x3A&& toconv > 0x2F)
	{
		toconv -= 0x30;
	}
	else if( toconv > 0x40 && toconv < 0x47)
	{
		toconv -= 0x37;
	}
	else
	{
		toconv -= 0x57;
	}
	return (toconv);
}

void senddata(char to_send) __ram	   // send out one CHAR
{
	while(!(0x020==(COMSTA0 & 0x020))){}
	COMTX = hex2ascii(to_send & 0x0F);
}

