/***********************************************************************


 Author        : Johnson Jiao            Johnson.Jiao@analog.com

 Date          : 1st April. 2008

 File          : main.c

 Hardware      : Applicable to ADuC702x rev H or I silicon
                 Currently targetting ADuC7026.

 Description   : some Functions about IRQ and FIQ

************************************************************************/
#include <ADuC7026.H>
#include "Flash.h"
#include "IRQ_FIQ.h"
#include "UART.h"
#include "main.h"

void IRQ_Handler() __irq;
void FIQ_Handler() __fiq;


void IRQ_Handler() __irq __ram
{
	unsigned char RX_temp1=0;
 	if( COMIID0 & 0x04 )                         // RX IRQ
    {
		if(Package[0]==0x0)						 // receive counter
		{
			RX_temp1 = ascii2hex(COMRX)<<4;
			while((COMIID0 & 0x04)!=0x04){}
			RX_temp1 += ascii2hex(COMRX);	 	// 0xXX
			Package[0] = RX_temp1;		
	 	}
		else  									// receive content in package
		{
			RX_temp1 = ascii2hex(COMRX)<<4;
			while((COMIID0 & 0x04)!=0x04){}
			RX_temp1 += ascii2hex(COMRX);	 	// 0xXX
			Package[Content_start] = RX_temp1;
			Content_start++;
			if(Package[0]==0xFF)
			{
				if(Content_start>0x100)
				{
					FullPackage = 0x0;
					Content_start = 0x1;
				}
			}
			else
			{
				if(Content_start>Package[0])
				{
					FullPackage = 0x1;
					Content_start = 0x1;
				}
			 }

		}
	}

}


void FIQ_Handler() __fiq 
{
 	if( COMIID0 & 0x04 )                         // RX
    {
		RX_Flag = ascii2hex(COMRX);
	 }

	if((FIQSTA & GP_TIMER_BIT)!= 0)	 		    // Timer1 FIQ?
	{
		GP4DAT ^= 0x00040000;					// Complement P4.2
		T1CLRI = 0;
		timeout = 0xAA;  						// Timeout
		T1CON &= 0xFFFFFF7F;				    // Disable
	} 				
}
