/********************************************************************************
 Author : CAC (China Applications Support Team) 

 Date :   May, 2014

 File name :  ADXL362test.c 

 Description :	 Setting ADXL362 in measurement mode
                 Read three axis acceleration data                 

 Hardware plateform : 	EVAL-ADuCM360MKZ and EVAL-ADXL362Z 
 
 Connection:
                 EVAL-ADuCM360MKZ       EVAL-ADXL362Z 
                               
                 P1.4:MISO,             MISO             
                 P1.5:SCLK,             SCLK                                                             
                 P1.6:MOSI,             MOSI
                 P1.7:GPIO as CS,       CS        
********************************************************************************/

#include <ADuCM360.h>

#include "UrtLib.h"
#include "ClkLib.h"
#include "WdtLib.h"
#include "IntLib.h"
#include "DioLib.h"
#include "SpiLib.h"

#include "ADXL362.h"
#include "ADuCM360Driver.h"

unsigned char DataBuffer[50];

/*******************************************************************
  @brief void PutAccelerationData(unsigned char *SendBuffer)
         send three axis acceleration data via UART
  @param
         unsigned char *SendBuffer: acceleration data to be sent 
  @return   
         none
         
*******************************************************************/
void PutAccelerationData(unsigned char *SendBuffer)
{
    unsigned int  SendValueTemp;
  
    SendValueTemp = SendBuffer[1];
    SendValueTemp = (SendValueTemp<<8)+SendBuffer[0];
    PutString("X-Axis: 0x");
    PutData(SendValueTemp,BIT16LENGTH);                       
    PutChar(0x0A);
  
    SendValueTemp = SendBuffer[3];
    SendValueTemp = (SendValueTemp<<8)+SendBuffer[2];
    PutString("Y-Axis: 0x");
    PutData(SendValueTemp,BIT16LENGTH);                       
    PutChar(0x0A);
  
    SendValueTemp = SendBuffer[5];
    SendValueTemp = (SendValueTemp<<8)+SendBuffer[4];
    PutString("Z-Axis: 0x");
    PutData(SendValueTemp,BIT16LENGTH);                       
    PutChar(0x0A);  
}

/*******************************************************************
  @brief int main(void)
         Setting ADXL362 in measurement mode
         Read three axis acceleration data
  @param
         none
  @return   
         none
  @connection
                 EVAL-ADuCM360MKZ       EVAL-ADXL362Z 
                               
                 P1.4:MISO,             MISO             
                 P1.5:SCLK,             SCLK                                                             
                 P1.6:MOSI,             MOSI
                 P1.7:GPIO as CS,       CS           
*******************************************************************/
int main (void)
{  
    unsigned int  ReadValueTemp;
  
    ADuCM360Initialise();        
    Delay1(10000);      //wait about 100ms                                            
    
    ReadValueTemp = ADXL362RegisterRead(XL362_DEVID_AD);     //Analog Devices device ID, 0xAD 
    PutString("Analog Devices device ID: 0x");
    PutData(ReadValueTemp,BIT8LENGTH);                       //send via UART
    PutChar(0x0A);
  
    ReadValueTemp = ADXL362RegisterRead(XL362_DEVID_MST);    //Analog Devices MEMS device ID, 0x1D
    PutString("Analog Devices MEMS device ID: 0x");
    PutData(ReadValueTemp,BIT8LENGTH);                       //send via UART
    PutChar(0x0A);  
  
    ReadValueTemp = ADXL362RegisterRead(XL362_PARTID);       //part ID, 0xF2
    PutString("Part ID: 0x");
    PutData(ReadValueTemp,BIT8LENGTH);                       //send via UART
    PutChar(0x0A);

    ADXL362RegisterWrite(XL362_FILTER_CTL,0x93);             //select 8g range
    //any changes to the registers before the POWER_CTL register (Register 0x00 to Register 0x2C) should be made with the device in standby   
    ADXL362RegisterWrite(XL362_POWER_CTL,0x02);              //select measurement mode
    Delay1(10000);
    ADXL362BurstRead(XL362_XDATA_L,6,DataBuffer);            //Read three axis acceleration data
    PutAccelerationData(DataBuffer);                          
    
    while(1)
    { 
    }
}


