// fiq.c
/********************************************************************/
/*                                                                  */
/*      FIQ ISR                                                     */
/*                                                                  */
/********************************************************************/

#include <ADuC7020.h>
#include "common.h"

unsigned char ucTxCnt = 0;
unsigned char ucRxCnt =0;
unsigned char ucEmptyCnt = 0;
unsigned char ucStopCnt =0;
unsigned char ucTestExtraRead = 0;
unsigned char ucFirstDataWrite = 0;

static BYTE byte_addr0 = 0x00;
static BYTE byte_addr2 = 0x00;
static BYTE wr_byte_addr0 = 0;
unsigned int  status = 0;
unsigned int  ucFIQstatus = 0;

extern unsigned char ucTxIntPending;

void delay(int); 

void delay (int length)
{
	while (length >0)
    	length--;
} 
  
void FIQ_Handler(void) __irq 
{

 	ucFIQstatus = FIQSTA;
	status = I2CSSTA; 


 //***** Slave RX *****
 if((status & 0x0008) == 0x0008)
 {                    // slave receiver interrupt
                          // first slave-receiver INT?
   if(i2c_first == TRUE){                          // first slave-receiver INT?
	   I2C0FSTA |= 0x100;
	   byte_addr0 = I2C0SRX;   // get byte address

	   wr_byte_addr0 = byte_addr0; 
	   I2C0STX = A0h[byte_addr0];	 // 2007 Uncommented
	   byte_addr0++;                
	   i2c_first = FALSE;
	   ucFirstDataWrite = 1;
 	}
   else
 	{
		if (ucFirstDataWrite == 1){
		 	 byte_addr0 -= 1;
		}
	    A0h[wr_byte_addr0] = I2CSRX;               // get byte data
	    I2C0FSTA |= 0x100;
	    byte_addr0 = I2C0SRX;   // get byte address
	    byte_addr0++;						   // increment address
		wr_byte_addr0++;
	    ucFirstDataWrite = 0;                           
     }
 }
	

	// Repeated Start Condition detect
/*	if((status & 0x2000) == 0x2000)		// Check bit 13
	{
		GP4SET = 0x00040000;
		i2c_first = TRUE;
		GP4CLR = 0x00040000;
           	
	}*/
    /// Stop Condition *****
    if((status & 0x0400) == 0x0400)
	{                   // STOP detect
  /*
	  I2C0CFG|=0x0800;	// Clock Stretch Enable 
    delay(500);	  
	I2C0CFG&=0xF7FF;	// Clock Stretch Disable
	*/
	  	i2c_first = TRUE;
		if (ucFirstDataWrite == 0)
		{
		 	I2C0CFG &= 0xFFFE;    // Switch slave off/on
		  	I2C0CFG |= 0x0001;
		}
		ucStopCnt++; 
		ucTxIntPending = 0;
			
    }
		//Slave Tx FIFO Empty
   	if((status & 0x0001) == 0x0001)//&& (ucTxIntPending == 0))
	{                    		 	
   	    I2C0STX = A0h[byte_addr0];                   // set TX data
   	    byte_addr0++;                               // increment byte address
    }   
	if ((status & 0x20) == 0x20)
	{
	  I2C0CFG &= 0xFFFE;    // Switch slave off/on
	  I2C0CFG |= 0x0001;
	  ucTxIntPending = 0; 	
	}  
  	    
    return;
}
