/***************************************************************************

 Author        : ADI - Apps                    www.analog.com/MicroConverter

 Date          : January 2007

 File          : I2C_Slave7020.c

 Hardware      : Applicable to ADuC702x rev H or I silicon
                 Currently targetting ADuC7020.

 Description   : I2C Slave	to demonstrate with I2C_Master.c
				 
				 In conjunction with the I2C_Master project and the I2CSerial.exe
application, this slave behaves as a 256byte EEPROM device.

Limitations:
	1)	  Current Application is limited to reading a maximum of 80bytes
		
***************************************************************************/
#define PLLKEY3		(*(volatile unsigned long *) 	0XFFFF041C)
#define PLLTST 		(*(volatile unsigned long *) 	0XFFFF0420)
#define PLLKEY4		(*(volatile unsigned long *) 	0XFFFF0424)
#include <ADuC7020.h>
#include "common.h"

BYTE A0h[512], A2h[256];
BYTE i2c_first = TRUE;
unsigned char ucPLLCON = 0;
unsigned char ucTxIntPending = 0;
unsigned char ucTxCnt = 0;
unsigned char ucRxCnt =0;
unsigned char ucEmptyCnt = 0;
unsigned char ucStopCnt =0;
unsigned char ucTestExtraRead = 0;
unsigned char ucFirstDataWrite = 0;
unsigned char ucPLLSTA = 0;

unsigned int byte_addr0 = 0x00;
static BYTE byte_addr2 = 0x00;
unsigned int wr_byte_addr0 = 0;
unsigned int  status = 0;
unsigned int  ucFIQstatus = 0;

extern unsigned char ucTxIntPending;

void delay(int); 
int main(void){

    int i;


	// GPIO configuration
    GP0CON = 0x10000000;                // P0.7(ECLK)
	GP0CON |= 0x10000000;
	GP0DAT = 0xF8000000;            // Configure  P0.3,P0.4 as outputs. P0.7 as ECLK
    GP1CON = 0x00000022;                // P1.0(SCL), P1.1(SDA)
    GP4DAT = 0x04000000;                // P4.2(GPO)

	ucPLLCON = PLLCON;
	PLLKEY3 = 0x6B;
	PLLTST |= 0x8C0;
	PLLKEY4 = 0xA9;
	POWKEY1 = 0x01;		  // Set Core clock frequency to 41.78Mhz
	POWCON = 0x00;
	POWKEY2 = 0xF4;	 
	delay(100);
	I2C0STX = 0xA0;
    // I2C configuration
    I2C0ID0 = 0xA0;                     // primary I2C address A0h
    I2C0CFG = 0x4001;                   // enable I2C slave, Stop IRQ, 

	ucPLLSTA = PLLSTA;
  	ucTxIntPending = 0;
    // Initialize table    
    for(i=0;i<512;i++){
        A0h[i]=i;
        A2h[i]=(255-i);
    }

    i2c_first = TRUE;

    FIQEN = 0x00000200;                  // enable I2C0SIRQ

    while(1){}

    return (0);
}


void delay (int length)
{
	while (length >0)
    	length--;
} 
  
void FIQ_Handler(void) __irq 
{

 	ucFIQstatus = FIQSTA;
	status = I2CSSTA; 


 //***** Slave RX *****
 if((status & 0x0008) == 0x0008)
 {                    // slave receiver interrupt
                          // first slave-receiver INT?
   if(i2c_first == TRUE){                          // first slave-receiver INT?
	   I2C0FSTA |= 0x100;
	   byte_addr0 = I2C0SRX;   // get byte address

	   wr_byte_addr0 = byte_addr0; 
	   I2C0STX = A0h[byte_addr0];	 // 2007 Uncommented
	   byte_addr0++;                
	   i2c_first = FALSE;
	   ucFirstDataWrite = 1;
 	}
   else
 	{
		if (ucFirstDataWrite == 1){
		 	 byte_addr0 -= 1;
		}
	    A0h[wr_byte_addr0] = I2CSRX;               // get byte data
	    I2C0FSTA |= 0x100;
	    byte_addr0 = I2C0SRX;   // get byte address
	    byte_addr0++;						   // increment address
		wr_byte_addr0++;
	    ucFirstDataWrite = 0;                           
     }
 }
	

	// Repeated Start Condition detect
/*	if((status & 0x2000) == 0x2000)		// Check bit 13
	{
		GP4SET = 0x00040000;
		i2c_first = TRUE;
		GP4CLR = 0x00040000;
           	
	}*/
    /// Stop Condition *****
    if((status & 0x0400) == 0x0400)
	{                   // STOP detect
  /*
	  I2C0CFG|=0x0800;	// Clock Stretch Enable 
    delay(500);	  
	I2C0CFG&=0xF7FF;	// Clock Stretch Disable
	*/
	  	i2c_first = TRUE;
		if (ucFirstDataWrite == 0)
		{
		 	I2C0CFG &= 0xFFFE;    // Switch slave off/on
		  	I2C0CFG |= 0x0001;
		}
		ucStopCnt++; 
		ucTxIntPending = 0;
			
    }
		//Slave Tx FIFO Empty
   	if((status & 0x0001) == 0x0001)//&& (ucTxIntPending == 0))
	{                    		 	
   	    I2C0STX = A0h[byte_addr0];                   // set TX data
   	    byte_addr0++;                               // increment byte address
    }   
	if ((status & 0x20) == 0x20)
	{
	  I2C0CFG &= 0xFFFE;    // Switch slave off/on
	  I2C0CFG |= 0x0001;
	  ucTxIntPending = 0; 	
	}  
  	    
    return;
}

