/***************************************************************************

 Author        : ADI - Apps                    www.analog.com/MicroConverter

 Date          : January 2007

 File          : I2C_Slave7020.c

 Hardware      : Applicable to ADuC702x rev H or I silicon
                 Currently targetting ADuC7020.

 Description   : I2C Slave	to demonstrate with I2C_Master.c
				 
				 In conjunction with the I2C_Master project and the I2CSerial.exe
application, this slave behaves as a 256byte EEPROM device.

Limitations:
	1)	  Current Application is limited to reading a maximum of 80bytes
		
***************************************************************************/

#include <ADuC7020.h>
#include "common.h"

BYTE A0h[512], A2h[256];
BYTE i2c_first = TRUE;
unsigned char ucPLLCON = 0;
unsigned char ucTxIntPending = 0;
int main(void){

    int i;


	// GPIO configuration
    GP0CON = 0x10000000;                // P0.7(ECLK)
    GP1CON = 0x00000022;                // P1.0(SCL), P1.1(SDA)
    GP4DAT = 0x04000000;                // P4.2(GPO)

	ucPLLCON = PLLCON;
	POWKEY1 = 0x01;		  // Set Core clock frequency to 41.78Mhz
	POWCON = 0x00;
	POWKEY2 = 0xF4;	 
	delay(100);
	I2C0STX = 0xA0;
    // I2C configuration
    I2C0ID0 = 0xA0;                     // primary I2C address A0h
    I2C0CFG = 0x4001;                   // enable I2C slave, Stop IRQ, 
  	ucTxIntPending = 0;
    // Initialize table    
    for(i=0;i<512;i++){
        A0h[i]=i;
        A2h[i]=(255-i);
    }

    i2c_first = TRUE;

    FIQEN = 0x00000200;                  // enable I2C0SIRQ

    while(1){}

    return (0);
}
