// fiq.c
/********************************************************************/
/*                                                                  */
/*      FIQ ISR                                                     */
/*                                                                  */
/********************************************************************/

#include <ADuC7020.h>
#include "common.h"

unsigned char ucTxCnt = 0;
unsigned char ucRxCnt =0;
unsigned char ucEmptyCnt = 0;
unsigned char ucStopCnt =0;
unsigned char ucTestExtraRead = 0;
unsigned char ucFirstDataWrite = 0;
extern unsigned char ucTxIntPending;
void delay(int); 

void delay (int length)
{
	while (length >0)
    	length--;
}
 void	FIQ_Handler(void) __irq
{

    static BYTE byte_addr0 = 0x00;
    static BYTE byte_addr2 = 0x00;
	static BYTE wr_byte_addr0 = 0;
    unsigned int status = I2CSSTA; 


 //***** Slave RX *****
 if((status & 0x0008) == 0x0008)
 {                    // slave receiver interrupt
                          // first slave-receiver INT?
   GP4SET = 0x00040000;
   if(i2c_first == TRUE){                          // first slave-receiver INT?
	  // I2C0STX = 0x99;
	   I2C0FSTA |= 0x100;
	   byte_addr0 = I2C0SRX;   // get byte address

	   wr_byte_addr0 = byte_addr0; 
//	   I2C0STX = A0h[byte_addr0];
	   byte_addr0++;                
	   i2c_first = FALSE;
	   GP4CLR = 0x00040000;
	   ucFirstDataWrite = 1;
 	}
   else
 	{
		if (ucFirstDataWrite == 1){
		 	 byte_addr0 -= 1;
		}
	    A0h[wr_byte_addr0] = I2CSRX;               // get byte data
	//	I2C0STX = 0x99;
	    I2C0FSTA |= 0x100;
	    byte_addr0 = I2C0SRX;   // get byte address
	 //   I2C0STX = A0h[byte_addr0];
	    byte_addr0++;						   // increment address
		wr_byte_addr0++;
	    ucFirstDataWrite = 0;                           
     }
 }
	

	// Repeated Start Condition detect
	if((status & 0x2000) == 0x2000)		// Check bit 13
	{
		i2c_first = TRUE;
 /*   GP4SET = 0x00040000;
		I2C0CFG|=0x0800;	// Clock Stretch Enable 
		
    delay(100);			// Replace with your Parser routine
		I2C0CFG&=0xF7FF;	// Clock Stretch Disable - Place this at the end of your parser routine
 */
		GP4CLR = 0x00040000;
           	
	}
    /// Stop Condition *****
    if((status & 0x0400) == 0x0400)
	{                   // STOP detect
  /*
	  I2C0CFG|=0x0800;	// Clock Stretch Enable 
    delay(500);	  
	I2C0CFG&=0xF7FF;	// Clock Stretch Disable
	*/
  	i2c_first = TRUE;
		ucStopCnt++; 
		ucTxIntPending = 0; 			
    }
		//Slave Tx FIFO Empty
   	if((status & 0x0001) == 0x0001)//&& (ucTxIntPending == 0))
	{                    // slave receiver intterupt		 	
		if((status&0x1800)==0)
		{                         // ID decode bit is 00?
   //    	    I2C0STX = A0h[byte_addr0];                   // set TX data
       	    byte_addr0++;                               // increment byte address
        }
	if ((status & 0x20) == 0x20)
	{
	  I2C0CFG &= 0xFFFE;    // Switch slave off/on
  	  I2C0CFG |= 0x0001;
 	  ucTxIntPending = 0; 	
	}  
  }	    
    return;
}
