//**************************************************************
// File         : RTDpwl.c
// Author       : Automatically generated using 'coefRTD.exe'
// Compiler     : intended for Keil C51
// Description  : Subroutines for linearization of RTD signals
//                using piecewise linear approximation method.
// More Info    : Details in application note AN-709, available
//                at....  http://www.analog.com/MicroConverter
//**************************************************************

// definitons....
#define TMIN (-200)  // = minimum temperature in degC
#define TMAX (850)  // = maximum temperature in degC
#define RMIN (18.5201)  // = input resistance in ohms at -200 degC
#define RMAX (390.481)  // = input resistance in ohms at 850 degC
#define NSEG 63  // = number of sections in table
#define RSEG 5.90414  // = (RMAX-RMIN)/NSEG = resistance RSEG in ohms of each segment

// lookup table....
const float code C_rtd[] = {-200.01,-186.275,-172.391,-158.364,-144.205,-129.92,-115.519,-101.01,-86.4003,-71.6975,-56.9082,-42.0382,-27.0925,-12.075,3.01142,18.1655,33.3881,48.6802,64.0427,79.4766,94.983,110.563,126.217,141.947,157.754,173.638,189.602,205.645,221.77,237.978,254.27,270.646,287.11,303.661,320.302,337.034,353.858,370.776,387.79,404.901,422.11,439.421,456.833,474.35,491.973,509.704,527.545,545.498,563.566,581.75,600.052,618.476,637.024,655.697,674.499,693.433,712.501,731.706,751.051,770.539,790.173,809.958,829.895,849.99};
// lookup table size:
//   = 63 linear sections
//   = 64 coefficients
//   = 256 bytes (4 bytes per floating point coefficient)

// linearization routine error band:  
//   = -0.00992131degC .. 0.00989609degC
// specified over measurement range -200degC .. 850degC

// _____________________________________________________________
// Temperature of RTD Function                             T_rtd
// input: r = resistance of RTD
// output: T_rtd() = corresponding temperature of RTD
// Calculates temperature of RTD as a function of resistance via
// a piecewise linear approximation method.

float T_rtd (float r) {
  float t;
  int i;
  i=(r-RMIN)/RSEG;       // determine which coefficients to use
  if (i<0)               // if input is under-range..
    i=0;                 // ..then use lowest coefficients
  else if (i>NSEG-1)     // if input is over-range..
    i=NSEG-1;            // ..then use highest coefficients
  t = C_rtd[i]+(r-(RMIN+RSEG*i))*(C_rtd[i+1]-C_rtd[i])/RSEG;
  return (t);
}

// _____________________________________________________________
// Resistance of RTD Function                              R_rtd
// input: t = temperature of RTD
// output: R_rtd() = corresponding resistance of RTD
// Calculates resistance of RTD as a function of temperature via
// a piecewise linear approximation method.

float R_rtd (float t) {
  float r;
  int i, adder;

  // set up initial values
  i = NSEG/2;           // starting value for 'i' index
  adder = (i+1)/2;      // adder value used in do loop

  // determine if input t is within range
  if (t<C_rtd[0])           // if input is under-range..
    i=0;                    // ..then use lowest coefficients
  else if (t>C_rtd[NSEG])   // if input is over-range..
    i=NSEG-1;               // ..then use highest coefficients

  // if input within range, determine which coefficients to use
  else do {
    if (C_rtd[i]>t)   i-=adder; // either decrease i by adder..
    if (C_rtd[i+1]<t) i+=adder; // ..or increase i by adder
    if (i<0)       i=0;         // make sure i is >=0..
    if (i>NSEG-1)  i=NSEG-1;    // ..and <=NSEG-1
    adder = (adder+1)/2;        // divide adder by two (rounded)
  } while ((C_rtd[i]>t)||(C_rtd[i+1]<t));   // repeat 'til done

  // compute final result
  r = RMIN+RSEG*i + (t-C_rtd[i])*RSEG/(C_rtd[i+1]-C_rtd[i]);

  return (r);
}

// _____________________________________________________________
// Minimum Temperature Function                         Tmin_rtd
// Returns minimum temperature specified by lookup table.
float Tmin_rtd () {
  return (TMIN);
}

// _____________________________________________________________
// Maximum Temperature Function                         Tmax_rtd
// Returns maximum temperature specified by lookup table.
float Tmax_rtd () {
  return (TMAX);
}

// _____________________________________________________________
// Minimum Resistance Function                          Rmin_rtd
// Returns minimum RTD resistance specified by lookup table.
float Rmin_rtd () {
  return (RMIN);
}

// _____________________________________________________________
// Maximum Resistance Function                          Rmax_rtd
// Returns maximum RTD resistance specified by lookup table.
float Rmax_rtd () {
  return (RMAX);
}
