/************************************************************************************************

 Author        : ADI - Apps            www.analog.com

 Date          : Feb 2010

 File          : TsensorUART.c

 Hardware      : ADuC7122

 Description   : This simple example demonstrates how to use a Thermistor basic sensor and 
                 display the temperature the result on a computer hyperterimal with a software UART (9600)
*************************************************************************************************/
// Bit Definitions
#define BIT0  0x01
#define BIT1  0x02
#define BIT2  0x04
#define BIT3  0x08
#define BIT4  0x10
#define BIT5  0x20
#define BIT6  0x40
#define BIT7  0x80
#define BIT8  0x100
#define BIT9  0x200
#define BIT10 0x400
#define BIT11 0x800
#define BIT12 0x1000
#define BIT13 0x2000
#define BIT14 0x4000
#define BIT15 0x8000


#include <ADuC7122.h>
#include "math.h"
#include "stdio.h"
#include "string.h"

void delay (int length);			    // delay function

volatile unsigned char bSendResultToUART = 0;	    // Flag used to indicate result ready to send to UART	
unsigned char szTemp[64] = "";		            	// Used to store result before printing to UART
unsigned char ucTxBufferEmpty  = 0;	            	// Used to indicate that the UART Tx buffer is empty
int szADCvalues;                   		    // Used to save the conversion value
int readend=0;                                      // Flag used to indicate that the convertion of 2 values is complete
int   i = 0;                                        // Loop variable in ISR
double Tempe=0;                                     // Variable that contains Sensor Temperature
double RT=0;                                         // Variable that contains the thermistor resistance
unsigned t2val_old;
int time=2000;
double voltage2=0;
double average=0;

int main(void)
{
    // local variables
    unsigned char nLen = 0;
    int j=0;
    
	// Configure CPU Clock for 41.78MHz, CD=0    

    POWKEY1 = 0x01;		            
    POWCON = 0x00;
    POWKEY2 = 0xF4; 
	
    // Initialize the UART for 9600-8-N
    
	GP1CON |= BIT0 + BIT4;           // Select UART functionality for P1.0/P1.1
    COMCON0 = BIT7;			        // Enable access to COMDIV registers
    COMDIV0 = 0x88;			        // Set baud rate to 9600.
    COMDIV1 = 0x00; 
    COMCON0 = BIT0 + BIT1;
    COMIEN0 = BIT0 + BIT1;	        // Enable UART interrupts when Rx full and Tx buffer empty.*/

    // setup interrupts
    
    IRQEN = BIT13 + BIT12;          // Enable UART interrupt source
    bSendResultToUART = 0;
  
    // setup ADC channel

    ADCCON = 0x20;	 				// power-on the ADC
    while (time >=0)	  	        // wait for ADC to be fully powered on
    time--;
    
    ADCCP = BIT1;                   // Enable temperature sensor ADC channel 0
    REFCON = 0x07;				    // internal 2.5V and 1.2V reference. 2.5V+1.2V on Vref pins. BUF_VREF = internal ref
    
									// ADCCON = software conv., single-ended, continous conv. enabled
    ADCCON = BIT2+BIT5+BIT7+BIT10+BIT11;	         
        
    //--------------------------------------------------------------------------------------------------//
    
    
    
// main while loop    
 while(1)
{ 
          
 if(readend==1)   //Wait for new ADC data and then calculate the Sensor temperature
    {
    	//RT=((4096/szADCvalues)-1)*4700;                   // Calcul of the thermistor resistance 
		RT=((4096/(double)szADCvalues)-1)*4700;
		j = 	szADCvalues;
        Tempe=298*3500/(log(4700/RT))                 // Calcul of the tempearure
                 /((3500/log(4700/RT))-298);
        Tempe=Tempe-273;                              // Convert temperature from degC to Kelvin                   
        bSendResultToUART = 1;                  //Result can be transmit to the UART
        readend=0;
     }

if (bSendResultToUART == 1)                 //Is there an ADC0 result ready for UART transmission?
     {

	bSendResultToUART = 0;
    
	sprintf ( (char*)szTemp, "ADuC7122 Temperature Measurement: \r\n\n");                         
	nLen = strlen((char*)szTemp);                 // Send the Received charachter to the UART 
     	for ( j = 0 ; j < nLen ; j++ )	         // loop to send String
   	   {
		COMTX = szTemp[j];
		ucTxBufferEmpty =0;
		while (ucTxBufferEmpty ==0);                                   
       }     
		
	
	
	sprintf ( (char*)szTemp, "Sensor Temperature : %3.2fdegC\r\n",Tempe);                         
	nLen = strlen((char*)szTemp);                 // Send the Received charachter to the UART 
     	for ( j = 0 ; j < nLen ; j++ )	         // loop to send String
   	   {
		COMTX = szTemp[j];
		ucTxBufferEmpty =0;
		while (ucTxBufferEmpty ==0);                                   
       }     
	
	sprintf ( (char*)szTemp, "ADC0 Result (hex) : %8lX,\r\n",szADCvalues );// Send the ADC0 Result to the UART                          
	nLen = strlen((char*)szTemp);                 // Send the Received charachter to the UART 
     	for ( j = 0 ; j < nLen ; j++ )	         // loop to send String
   	   {
		COMTX = szTemp[j];
		ucTxBufferEmpty =0;
		while (ucTxBufferEmpty ==0);                                    
       }     
	sprintf ( (char*)szTemp, "Thermistor value : %8.3fohms,\r\n\n\n",RT );// Send the thermistor resistence value to the UART                          
	nLen = strlen((char*)szTemp);                 // Send the Received charachter to the UART 
     	for ( j = 0 ; j < nLen ; j++ )	         // loop to send String
   	   {
		COMTX = szTemp[j];
		ucTxBufferEmpty =0;
		while (ucTxBufferEmpty ==0);                                    
       }     

        IRQEN|= BIT13;
        IRQEN|= BIT12;
     }  // end if (bSendResultToUART == 1)         

  delay(0x8FFFF);  
  delay(0x8FFFF);  
  delay(0x8FFFF);  
  delay(0x8FFFF);  
  delay(0x8FFFF);  
  delay(0x8FFFF);    	
 
} // end while
} // end main loop
 



    //--------------------------------------------------------------------------------------------------//

	// Interrupt Service Routine

 __irq void IRQ_Handler(void)
{
	unsigned long IRQSTATUS = 0;
	unsigned char ucCOMIID0 = 0;

	IRQSTATUS = IRQSTA;	                    // Read off IRQSTA register
	ucCOMIID0 = COMIID0;                    // Read the UART IRQ ID register
    if ((IRQSTATUS & BIT13) == BIT13)	    //UART interrupt source
	{
		if ((ucCOMIID0 & 0x2) == 0x2)	    // Transmit buffer empty
		{
		    ucTxBufferEmpty = 1;
		}
	}
	// ADC INTERRUPT
    if ((IRQSTATUS & BIT12) == BIT12) 		//If ADC0 interrupt source
	{
	    szADCvalues = (ADCDAT>>16);      // Read ADC conversion result 
        readend=1;                 		// Wait 2 values
        IRQCLR = BIT12;
	}
}

void delay (int length)
{
	while (length >0)
    	length--;
}


